/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.html;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseDateType;
import com.sas.datatypes.DateType;
import com.sas.servlet.tbeans.BaseCompositeTransformation;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.JavaScriptEventHandlerInterface;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.TemplateSupport;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.form.html.ComboBoxView;
import com.sas.servlet.tbeans.form.html.Image;
import com.sas.servlet.tbeans.form.html.TextEntry;
import com.sas.servlet.tbeans.html.Calendar;
import com.sas.servlet.tbeans.html.DatePickerPopupWindow;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.html.RB;
import com.sas.servlet.tbeans.models.JavaScriptNode;
import com.sas.servlet.tbeans.util.validators.DateStringValidator;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.servlet.util.ComponentSessionManager;
import com.sas.servlet.util.DateUtil;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.text.Message;
import com.sas.text.NLFormats;
import com.sas.util.DatePeriod;
import com.sas.util.DateTypes;
import com.sas.util.MapWithDefaults;
import com.sas.util.SimpleTemplate;
import com.sas.util.Strings;
import com.sas.util.Util;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.validators.ValidationInterface;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.MutableComboBoxModel;

@SASScope
public class DatePicker
extends BaseCompositeTransformation
implements JavaScriptEventHandlerInterface {
    private static final String RB_KEY = "DatePicker.";
    public static final String DEFAULT_AJAX_PALETTE_URL_TEMPLATE = "%BASE_AJAX_URL(%BASE_AJAX_URL)%AJAX_URL_SUFFIX(%AJAX_URL_SUFFIX)CLASS_PARAMETER=" + DatePicker.class.getName() + "&id=%id";
    public static final String DATEPICKER_CONTAINER_STYLE = "DATEPICKER_CONTAINER";
    public static final String DATEPICKER_TEXTENTRY_STYLE = "DATEPICKER_TEXTENTRY";
    public static final String DATEPICKER_TEXTENTRY_TD_STYLE = "DATEPICKER_TEXTENTRY_TD";
    public static final String DATEPICKER_NDATELABEL_STYLE = "DATEPICKER_NDATELABEL";
    public static final String DATEPICKER_N_TEXTENTRY_STYLE = "DATEPICKER_N_TEXTENTRY";
    public static final String DATEPICKER_HINT_LABEL_STYLE = "DATEPICKER_HINT_LABEL";
    public static final String DATEPICKER_COMBO_STYLE = "DATEPICKER_COMBO";
    public static final String DATEPICKER_LAST_ACCESS_LABEL_STYLE = "DATEPICKER_LAST_ACCESS_LABEL";
    public static final String DATEPICKER_LAUNCH_IMAGE_CELL_STYLE = "DATEPICKER_LAUNCH_IMAGE_CELL";
    private static final String DEFAULT_TEMPLATE_FILE_NAME = "DatePicker.html";
    public static final String CALENDAR_COMPONENT = "CALENDAR_COMPONENT";
    public static final String LAUNCH_CALENDAR_COMPONENT = "LAUNCH_CALENDAR_COMPONENT";
    public static final String TEXT_ENTRY_COMPONENT = "TEXT_ENTRY_COMPONENT";
    public static final String COMBO_COMPONENT = "COMBO_COMPONENT";
    public static final String N_DATE_LABEL_COMPONENT = "N_DATE_LABEL_COMPONENT";
    public static final String N_TEXTENTRY_COMPONENT = "N_TEXTENTRY_COMPONENT";
    public static final String HINT_LABEL_COMPONENT = "HINT_LABEL_COMPONENT";
    public static final String LAST_ACCESS_LABEL_COMPONENT = "LAST_ACCESS_LABEL_COMPONENT";
    private static HashMap defaultStyleMap;
    private MapWithDefaults componentStyleMap;
    private boolean enabled = true;
    private boolean relativeValuesIncluded = false;
    private boolean labelsVisible = false;
    private String title;
    private String onChange = null;
    private String onFocus = null;
    private String onBlur = null;
    private Calendar calendar = null;
    private Image launchImage = null;
    private TextEntry textEntry;
    private Date date = null;
    private TimeZone timezone = null;
    private ComboBoxView combo;
    private Label nDateLabel;
    private Label hintLabel;
    private Label lastAccessLabel;
    private TextEntry nTextEntry = null;
    private ComboBoxModel comboModel = null;
    private Object initialValue;
    private SimpleDateFormat dateFormat = null;
    private int defaultDateStylePattern = 1;
    private boolean validationEnabled = false;
    private DateStringValidator validator = null;
    private boolean isRelativeValuesAddedToModel = false;
    private SimpleTemplate ajaxURLTemplate;
    private SimpleTemplate ajaxPaletteURLTemplate;

    public DatePicker() {
        this(null);
    }

    public DatePicker(String Id) {
        if (Id == null) {
            this.setId(Util.getName((String)"date_picker"));
        } else {
            this.setId(Id);
        }
        this.setTemplateKey("Date_Picker");
        this.setObjectDataProperty("initialValue");
        this.componentStyleMap = new MapWithDefaults(DatePicker.getDefaultStyleMap());
        this.ajaxURLTemplate = new SimpleTemplate();
        this.ajaxURLTemplate.setTemplate(DateUtil.DEFAULT_AJAX_URL_RELATIVE_VALUE_TEMPLATE);
        this.ajaxURLTemplate.setValueDictionary(new HashMap());
        this.ajaxPaletteURLTemplate = new SimpleTemplate();
        this.ajaxPaletteURLTemplate.setTemplate(DEFAULT_AJAX_PALETTE_URL_TEMPLATE);
        this.ajaxPaletteURLTemplate.setValueDictionary(new HashMap());
        this.addComponents();
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        this.setDescription(RB.getStringResource("DatePicker.description.txt", locale));
    }

    private static Map getDefaultStyleMap() {
        if (defaultStyleMap == null) {
            defaultStyleMap = new HashMap();
            StyleInfo datePickerContainerStyle = new StyleInfo("DatePickerContainer");
            defaultStyleMap.put(DATEPICKER_CONTAINER_STYLE, datePickerContainerStyle);
            StyleInfo datePickerTextEntryStyle = new StyleInfo("DatePickerTextEntry");
            defaultStyleMap.put(DATEPICKER_TEXTENTRY_STYLE, datePickerTextEntryStyle);
            StyleInfo datePickerComboStyle = new StyleInfo("datePickerCombo");
            defaultStyleMap.put(DATEPICKER_COMBO_STYLE, datePickerComboStyle);
            StyleInfo datePickerHintLabelStyle = new StyleInfo("datePickerHintLabel");
            defaultStyleMap.put(DATEPICKER_HINT_LABEL_STYLE, datePickerHintLabelStyle);
            StyleInfo datePickerDateLabelStyle = new StyleInfo("datePickerDateLabel");
            defaultStyleMap.put(DATEPICKER_NDATELABEL_STYLE, datePickerDateLabelStyle);
            StyleInfo datePickerNTextEntryStyle = new StyleInfo("datePickerNTextEntry");
            defaultStyleMap.put(DATEPICKER_N_TEXTENTRY_STYLE, datePickerNTextEntryStyle);
            StyleInfo datePickerLastAccessLabelStyle = new StyleInfo("datePickerLastAccessLabel");
            defaultStyleMap.put(DATEPICKER_LAST_ACCESS_LABEL_STYLE, datePickerLastAccessLabelStyle);
            ImmutableStyleInfo datePickerLaunchImageCellStyle = new ImmutableStyleInfo("datePickerLaunchImageCell");
            defaultStyleMap.put(DATEPICKER_LAUNCH_IMAGE_CELL_STYLE, datePickerLaunchImageCellStyle);
        }
        return defaultStyleMap;
    }

    @Override
    public Map getStyleMap() {
        return this.componentStyleMap;
    }

    protected void addComponents() {
        if (this.getComponents().isEmpty()) {
            this.calendar = new Calendar(this.getId() + "_Calendar");
            this.setComponent(CALENDAR_COMPONENT, this.calendar);
            this.launchImage = new Image();
            this.launchImage.setId(this.getId() + "_LaunchImage");
            this.launchImage.setUseAsFormElement(false);
            this.launchImage.setTabIndex("0");
            this.setComponent(LAUNCH_CALENDAR_COMPONENT, this.launchImage);
            this.validator = new DateStringValidator();
            this.textEntry = new TextEntry();
            this.textEntry.setId(this.getId());
            this.textEntry.setStyleInfo((StyleInfo)this.getStyleMap().get(DATEPICKER_TEXTENTRY_STYLE));
            this.setComponent(TEXT_ENTRY_COMPONENT, this.textEntry);
            this.combo = new ComboBoxView();
            this.combo.setId(this.getId() + "_combo");
            this.combo.setStyleInfo((StyleInfo)this.getStyleMap().get(DATEPICKER_COMBO_STYLE));
            this.combo.setEditable(true);
            this.combo.setRenderUsingIFrame(true);
            this.combo.setRequest(this.getRequest());
            this.combo.getStyleMap().put("COMBOBOXVIEW_FRAME_SELECT", (StyleInfo)this.getStyleMap().get(DATEPICKER_COMBO_STYLE));
            this.setComponent(COMBO_COMPONENT, this.combo);
        }
    }

    @SASScope
    public void enableValidation() {
        this.validationEnabled = true;
    }

    @SASScope
    public ValidationInterface getValidator() {
        return this.validator;
    }

    protected void addNComponents() {
        this.nDateLabel = new Label();
        this.nDateLabel.setId(this.getId() + "_nDateLabel");
        this.nDateLabel.setStyleInfo((StyleInfo)this.getStyleMap().get(DATEPICKER_NDATELABEL_STYLE));
        this.nDateLabel.setRequest(this.getRequest());
        this.setComponent(N_DATE_LABEL_COMPONENT, this.nDateLabel);
        this.nTextEntry = new TextEntry();
        this.nTextEntry.setId(this.getId() + "_nte");
        this.nTextEntry.setStyleInfo((StyleInfo)this.getStyleMap().get(DATEPICKER_N_TEXTENTRY_STYLE));
        this.nTextEntry.setRequest(this.getRequest());
        this.nTextEntry.setCustomAttributes("autocomplete=\"OFF\"");
        this.setComponent(N_TEXTENTRY_COMPONENT, this.nTextEntry);
    }

    protected void addLabelComponents() {
        this.lastAccessLabel = new Label();
        this.lastAccessLabel.setId(this.getId() + "_lastAccessLabel");
        this.lastAccessLabel.setText(RB.getStringResource(RB_KEY, "lastAccessLabel.txt", this.getLocale()));
        this.lastAccessLabel.setStyleInfo((StyleInfo)this.getStyleMap().get(DATEPICKER_LAST_ACCESS_LABEL_STYLE));
        this.lastAccessLabel.setRequest(this.getRequest());
        this.setComponent(LAST_ACCESS_LABEL_COMPONENT, this.lastAccessLabel);
        this.hintLabel = new Label();
        this.hintLabel.setId(this.getId() + "_hintLabel");
        this.hintLabel.setText(RB.getStringResource(RB_KEY, "hintLabel.txt", this.getLocale()));
        this.hintLabel.setStyleInfo((StyleInfo)this.getStyleMap().get(DATEPICKER_HINT_LABEL_STYLE));
        this.hintLabel.setRequest(this.getRequest());
        this.setComponent(HINT_LABEL_COMPONENT, this.hintLabel);
    }

    @SASScope
    public ComboBoxModel getComboModel() {
        Locale locale = this.getLocale();
        if (this.comboModel == null) {
            this.comboModel = new DefaultComboBoxModel();
        }
        if (this.isRelativeValuesIncluded() && !this.isRelativeValuesAddedToModel) {
            JavaScriptNode todayNode = new JavaScriptNode();
            todayNode.setValue(new DatePeriod(DateTypes.DATE, locale).toString());
            todayNode.setText(RB.getStringResource(RB_KEY, "today.txt", this.getLocale()));
            JavaScriptNode yesterdayNode = new JavaScriptNode();
            yesterdayNode.setValue(new DatePeriod(DateTypes.DATE, 0, 0, 0, 0, -1, 0, 0, locale).toString());
            yesterdayNode.setText(RB.getStringResource(RB_KEY, "yesterday.txt", this.getLocale()));
            JavaScriptNode tomorrowNode = new JavaScriptNode();
            tomorrowNode.setValue(new DatePeriod(DateTypes.DATE, 0, 0, 0, 0, 1, 0, 0, locale).toString());
            tomorrowNode.setText(RB.getStringResource(RB_KEY, "tomorrow.txt", this.getLocale()));
            JavaScriptNode currDayLastYearNode = new JavaScriptNode();
            currDayLastYearNode.setValue(new DatePeriod(DateTypes.DATE, -1, 0, 0, 0, 0, 0, 0, locale).toString());
            currDayLastYearNode.setText(RB.getStringResource(RB_KEY, "currentDayLastYear.txt", this.getLocale()));
            JavaScriptNode currDayLastMonthNode = new JavaScriptNode();
            currDayLastMonthNode.setValue(new DatePeriod(DateTypes.DATE, 0, 0, -1, 0, 0, 0, 0, locale).toString());
            currDayLastMonthNode.setText(RB.getStringResource(RB_KEY, "currentDayLastMonth.txt", this.getLocale()));
            JavaScriptNode nDaysAgoNode = new JavaScriptNode();
            nDaysAgoNode.setValue("D-ND");
            nDaysAgoNode.setText(RB.getStringResource(RB_KEY, "nDaysAgo.txt", this.getLocale()));
            JavaScriptNode nDaysFromNowNode = new JavaScriptNode();
            nDaysFromNowNode.setValue("DND");
            nDaysFromNowNode.setText(RB.getStringResource(RB_KEY, "nDaysFromNow.txt", this.getLocale()));
            ((MutableComboBoxModel)this.comboModel).insertElementAt(todayNode, 0);
            ((MutableComboBoxModel)this.comboModel).insertElementAt(yesterdayNode, 1);
            ((MutableComboBoxModel)this.comboModel).insertElementAt(tomorrowNode, 2);
            ((MutableComboBoxModel)this.comboModel).insertElementAt(currDayLastYearNode, 3);
            ((MutableComboBoxModel)this.comboModel).insertElementAt(currDayLastMonthNode, 4);
            ((MutableComboBoxModel)this.comboModel).insertElementAt(nDaysAgoNode, 5);
            ((MutableComboBoxModel)this.comboModel).insertElementAt(nDaysFromNowNode, 6);
            this.isRelativeValuesAddedToModel = true;
        }
        return this.comboModel;
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        ImmutableStyleInfo launchImageCellStyle;
        StyleInfo textEntryContainerStyle;
        HashMap<String, String> dictionary;
        super.write(out);
        JavaScriptIncludeHandler.writeIncludes(out, "DATEPICKER", this.getRequest());
        ComponentSessionManager.getSessionManager(this.getRequest()).put(this.getId(), this);
        SimpleDateFormat tempFormat = this.getFormat() != null ? this.getFormat() : new SimpleDateFormat(NLFormats.getPattern((String)DateType.DEFAULT_INSTANCE.getDefaultFormatName(), (Locale)this.getLocale()), this.getLocale());
        this.validator.setFormat(tempFormat);
        if (this.getModel() != null || this.isRelativeValuesIncluded()) {
            this.combo.setModel(this.getComboModel());
            this.textEntry.setVisible(false);
            if (this.validationEnabled) {
                this.combo.setValidator(this.validator);
            }
        } else {
            this.combo.setVisible(false);
            if (this.validationEnabled) {
                this.validator.setValidationOnChange(true);
                this.textEntry.setValidator(this.validator);
            }
        }
        if (this.validator instanceof DateStringValidator) {
            this.validator.setContainerId("container_" + this.getId());
        }
        if (this.isLabelsVisible()) {
            this.addLabelComponents();
        }
        if (this.isRelativeValuesIncluded()) {
            this.addNComponents();
        }
        if ((dictionary = this.getTemplateDictionary()) == null) {
            dictionary = new HashMap<String, String>();
            this.setTemplateDictionary(dictionary);
        }
        dictionary.put("DATEPICKER_ID", this.getId());
        StyleInfo containerStyle = (StyleInfo)this.getStyleMap().get(DATEPICKER_CONTAINER_STYLE);
        if (containerStyle.getClassid() != null) {
            dictionary.put("DATEPICKER_CONTAINER_CLASS", containerStyle.getClassid());
        }
        if ((textEntryContainerStyle = (StyleInfo)this.getStyleMap().get(DATEPICKER_TEXTENTRY_TD_STYLE)) != null && textEntryContainerStyle.getClassid() != null) {
            dictionary.put("DATEPICKER_TEXTENTRY_TD_CLASS", containerStyle.getClassid());
        }
        if ((launchImageCellStyle = (ImmutableStyleInfo)this.getStyleMap().get(DATEPICKER_LAUNCH_IMAGE_CELL_STYLE)).getClassid() != null) {
            dictionary.put("DATEPICKER_LAUNCH_IMAGE_CELL_CLASS", launchImageCellStyle.getClassid());
        }
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
        if (this.isEnabled()) {
            this.launchImage.setImage(cpm.getImageURI("Calendar"));
        } else {
            this.launchImage.setImage(cpm.getImageURI("Calendar_Disabled"));
        }
        if (this.getTitle() != null) {
            dictionary.put("DATEPICKER_TITLE", this.getTitle());
        }
        this.launchImage.setOnClick("if(" + this.getId() + "_Obj.enabled==true) {" + this.getId() + "_Obj.toggleCalendarVisibility(event);}");
        this.launchImage.setOnKeyDown("if((" + this.getId() + "_Obj.enabled==true) && event.keyCode==13){" + this.getId() + "_Obj.toggleCalendarVisibility(event);}");
        this.textEntry.setOnKeyDown("if(" + this.getId() + "_Obj.enabled==true) {sas_DatePicker_checkAltDownArrow(event, '" + this.getId() + "_Obj.toggleCalendarVisibility(event);');}");
        if (this.getOnChange() != null) {
            this.textEntry.setOnChange(this.getOnChange());
            this.combo.setOnChange("sas_DatePicker_checkForNSelection(event, '" + this.getId() + "', '" + this.combo.getId() + "'); if(" + this.getId() + "_Obj.comboComponent.getSelectedIndex()==-1){" + this.getId() + "_Obj.hideNSelection();} if(document.getElementById('" + this.getId() + "_nte')==null){" + this.getOnChange() + ";} else if(" + this.getId() + "_Obj.comboComponent.getSelectedIndex()< 5 || " + this.getId() + "_Obj.comboComponent.getSelectedIndex() > 6){" + this.getOnChange() + ";}");
        } else {
            this.combo.setOnChange("sas_DatePicker_checkForNSelection(event, '" + this.getId() + "', '" + this.combo.getId() + "'); if(" + this.getId() + "_Obj.comboComponent.getSelectedIndex()==-1){" + this.getId() + "_Obj.hideNSelection();}");
        }
        if (this.getOnFocus() != null) {
            this.textEntry.setOnFocus(this.getOnFocus());
            this.combo.setOnFocus(this.getOnFocus());
            this.launchImage.setOnFocus(this.getOnFocus());
            this.launchImage.setTabIndex("0");
        }
        if (this.getOnBlur() != null) {
            this.textEntry.setOnBlur(this.getOnBlur());
            this.combo.setOnBlur(this.getOnBlur());
            this.launchImage.setOnBlur(this.getOnBlur());
            this.launchImage.setTabIndex("0");
        }
        TemplateSupport.writeTemplate(this, null, out);
        this.writeJavaScript(out);
    }

    private void writeJavaScript(PrintWriter out) {
        Map map = this.ajaxURLTemplate.getValueDictionary();
        map.put("BASE_AJAX_URL", this.getAJAXControllerURL());
        if (this.getAJAXControllerURL().indexOf("?") == -1) {
            map.put("AJAX_URL_SUFFIX", "?");
        } else {
            map.put("AJAX_URL_SUFFIX", "&");
        }
        map.put("id", this.getId());
        Map paletteMap = this.ajaxPaletteURLTemplate.getValueDictionary();
        paletteMap.put("BASE_AJAX_URL", this.getAJAXControllerURL());
        if (this.getAJAXControllerURL().indexOf("?") == -1) {
            paletteMap.put("AJAX_URL_SUFFIX", "?");
        } else {
            paletteMap.put("AJAX_URL_SUFFIX", "&");
        }
        paletteMap.put("id", this.getId());
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
        out.println(JavaScriptIncludeHandler.getStartScript());
        out.println("" + this.getId() + "_Obj = new sas_DatePicker('" + this.getId() + "');");
        out.println(this.getId() + "_Obj.setLaunchImage('" + cpm.getImageURI("Calendar") + "');\n");
        out.println(this.getId() + "_Obj.setLaunchImageDisabled('" + cpm.getImageURI("Calendar_Disabled") + "');\n");
        out.println(this.getId() + "_Obj.url = '" + this.ajaxURLTemplate.format() + "';\n");
        out.println(this.getId() + "_Obj.paletteCreated = false;\n");
        out.println(this.getId() + "_Obj.palette_url = '" + this.ajaxPaletteURLTemplate.format() + "';\n");
        if (this.getFormat() != null) {
            out.println(this.getId() + "_Obj.date_pattern = '" + Strings.escapeForJavaScript((String)this.getFormat().toPattern()) + "';\n");
        } else {
            SimpleDateFormat tempFormat = new SimpleDateFormat(NLFormats.getPattern((String)DateType.DEFAULT_INSTANCE.getDefaultFormatName(), (Locale)this.getLocale()), this.getLocale());
            out.println(this.getId() + "_Obj.date_pattern= '" + Strings.escapeForJavaScript((String)tempFormat.toPattern()) + "';\n");
        }
        DateType dataType = new DateType(this.timezone);
        DateFormat dateFormat = ((BaseDateType)dataType).getDateFormatter(null, this.getLocale());
        out.println(this.getId() + "_Obj.date_patternString = \"" + Strings.escapeForJavaScript((String)((SimpleDateFormat)dateFormat).toPattern()) + "\";\n");
        if (this.getOnChange() != null) {
            out.println(this.getId() + "_Obj.onChange=\"" + this.getOnChange() + "\";");
        }
        out.println(this.getId() + "_Obj.isValidationEnabled=" + this.validationEnabled + ";");
        if (this.getModel() != null || this.isRelativeValuesIncluded()) {
            out.println(this.getId() + "_Obj.setComboComponent(sas_getJavaScriptObject('" + this.combo.getId() + "'));");
            out.println(this.getId() + "_Obj.comboComponent.hiddenComponent.name=\"" + this.getId() + "\";");
            if (this.isRelativeValuesIncluded()) {
                out.println(this.getId() + "_Obj.setNDateLabel(document.getElementById('" + this.nDateLabel.getId() + "'), " + this.combo.getSelectedIndex() + ", null, '" + this.getId() + "');");
                out.println(this.getId() + "_Obj.setNComponent(document.getElementById('" + this.nTextEntry.getId() + "'));");
                out.println(this.getId() + "_Obj.invalidValueMessage = \"" + Message.format((String)RB.getStringResource(RB_KEY, "invalidValue.txt", this.getLocale()), (Object)this.getDescription()) + "\";");
                out.println(this.getId() + "_Obj.yearsAgoErrorMessage = \"" + RB.getStringResource(RB_KEY, "yearsAgoError.txt", this.getLocale()) + "\";");
                out.println(this.getId() + "_Obj.yearsFromNowErrorMessage = \"" + RB.getStringResource(RB_KEY, "yearsFromNowError.txt", this.getLocale()) + "\";");
            }
        } else {
            out.println(this.getId() + "_Obj.setComboComponent(document.getElementById('" + this.textEntry.getId() + "'));");
        }
        out.println(this.getId() + "_Obj.initialNValue = \"" + RB.getStringResource(RB_KEY, "initialNValue.txt", this.getLocale()) + "\";");
        if (this.isLabelsVisible()) {
            out.println(this.getId() + "_Obj.setLastAccessLabel(document.getElementById('" + this.lastAccessLabel.getId() + "'));");
            out.println(this.getId() + "_Obj.setHintLabel(document.getElementById('" + this.hintLabel.getId() + "'));");
        }
        if (this.isEnabled()) {
            out.println(this.getId() + "_Obj.enable();\n");
        } else {
            out.println(this.getId() + "_Obj.disable();\n");
        }
        if (this.getDate() != null || this.getInitialValue() != null) {
            SimpleDateFormat tempFormat = this.getFormat() != null ? this.getFormat() : new SimpleDateFormat(NLFormats.getPattern((String)DateType.DEFAULT_INSTANCE.getDefaultFormatName(), (Locale)this.getLocale()), this.getLocale());
            if (this.timezone != null) {
                tempFormat.setTimeZone(this.timezone);
            }
            if (this.getDate() != null) {
                out.println(this.getId() + "_Obj.setInitialDate(\"" + DateUtil.removeBiDiCharacters(tempFormat.format(this.getDate())) + "\");\n");
            } else {
                Object initVal = this.getInitialValue();
                if (initVal instanceof DatePeriod) {
                    String initValueString = ((DatePeriod)initVal).toString(null, this.getLocale());
                    int nvalue = ((DatePeriod)initVal).getNDays();
                    if (nvalue < -1 || nvalue > 1) {
                        try {
                            String replacementValue = "N";
                            String patternStr = "[0-9]{1,}";
                            Pattern pattern = Pattern.compile(patternStr);
                            Matcher matcher = pattern.matcher(initValueString);
                            initValueString = matcher.replaceAll(replacementValue);
                        }
                        catch (PatternSyntaxException patternSyntaxException) {
                            // empty catch block
                        }
                        out.println(this.getId() + "_Obj.showNSelection(\"" + initValueString + "\", \"" + Math.abs(nvalue) + "\");\n");
                    } else {
                        out.println(this.getId() + "_Obj.setInitialDate(\"" + DateUtil.removeBiDiCharacters(initValueString) + "\");\n");
                        out.println("sas_DatePicker_checkForNSelection(null, " + this.getId() + "_Obj.id, " + this.getId() + "_Obj.comboComponent.id)");
                    }
                } else if (initVal instanceof SpecialValues) {
                    String initValueString = ((SpecialValues)initVal).getName();
                    out.println(this.getId() + "_Obj.setInitialDate(\"" + DateUtil.removeBiDiCharacters(initValueString) + "\");\n");
                } else if (initVal instanceof MissingValues) {
                    String initValueString = MissingValues.toQueryString((MissingValues)((MissingValues)initVal));
                    out.println(this.getId() + "_Obj.setInitialDate(\"" + DateUtil.removeBiDiCharacters(initValueString) + "\");\n");
                } else if (initVal instanceof Date) {
                    out.println(this.getId() + "_Obj.setInitialDate(\"" + DateUtil.removeBiDiCharacters(tempFormat.format(initVal)) + "\");\n");
                } else {
                    out.println(this.getId() + "_Obj.setInitialDate(\"" + DateUtil.removeBiDiCharacters(initVal.toString()) + "\");\n");
                }
            }
        }
        out.println(JavaScriptIncludeHandler.getEndScript(null));
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @SASScope
    public boolean isRelativeValuesIncluded() {
        return this.relativeValuesIncluded;
    }

    @SASScope
    public void setRelativeValuesIncluded(boolean state) {
        this.relativeValuesIncluded = state;
    }

    @SASScope
    public boolean isLabelsVisible() {
        return this.labelsVisible;
    }

    @SASScope
    public void setLabelsVisible(boolean state) {
        this.labelsVisible = state;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @SASScope
    public void setTimeZone(TimeZone timezone) {
        this.timezone = timezone;
    }

    @SASScope
    public void setFormat(SimpleDateFormat newFormat) {
        this.dateFormat = newFormat;
    }

    @SASScope
    public SimpleDateFormat getFormat() {
        return this.dateFormat;
    }

    public static void servletInvocationMethod(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType(BaseUtil.TEXT_PLAIN_MIME_TYPE);
        String pickerID = request.getParameter("pickerid");
        String date = request.getParameter("date");
        DateFormat dateFormat = null;
        DatePeriod datePeriod = null;
        TimeZone tz = TimeZone.getDefault();
        DateType dataType = new DateType(tz);
        int dateStylePattern = 1;
        ServletOutputStream out = response.getOutputStream();
        PrintWriter writer = new PrintWriter((OutputStream)out);
        writer.println(JavaScriptIncludeHandler.getStartScript());
        writer.print("var return_Obj = {");
        TransformationInterface ti = (TransformationInterface)ComponentSessionManager.getSessionManager(request).get(pickerID);
        if (ti != null && ti instanceof DatePicker) {
            DatePicker picker = (DatePicker)ti;
            dateFormat = picker.getFormat();
            dateStylePattern = picker.getDefaultDateStylePattern();
        }
        if (dateFormat == null) {
            dateFormat = DateFormat.getDateInstance(dateStylePattern, request.getLocale());
        }
        Date parsedDate = null;
        try {
            parsedDate = dateFormat.parse(date);
            if (parsedDate instanceof DatePeriod) {
                datePeriod = (DatePeriod)parsedDate;
            } else if (parsedDate instanceof Date) {
                datePeriod = new DatePeriod(parsedDate, DateTypes.DATE, request.getLocale());
            }
        }
        catch (ParseException e) {
            LoggerRepository2.getLogger((String)DatePicker.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
            writer.print("error : \"" + Strings.escapeForJavaScript((String)e.getLocalizedMessage(), (boolean)true) + "\"}");
        }
        if (dataType != null && datePeriod != null) {
            int year = datePeriod.getYear() + 1900;
            writer.print("month : \"" + datePeriod.getMonth() + "\",");
            writer.print("date : \"" + datePeriod.getDate() + "\",");
            writer.print("year : \"" + year + "\"");
            String relativeString = "";
            relativeString = dataType.getDisplayString((Object)datePeriod.getStartOfPeriod(), request.getLocale());
            writer.print(",");
            writer.print("relativeString : \"" + relativeString + "\"");
        }
        writer.print("}");
        writer.println(JavaScriptIncludeHandler.getEndScript(null));
        writer.flush();
    }

    @SASScope
    public ComboBoxModel getModel() {
        return this.comboModel;
    }

    @SASScope
    public void setModel(ComboBoxModel comboBoxModel) {
        this.comboModel = comboBoxModel;
        this.isRelativeValuesAddedToModel = false;
    }

    @Override
    @SASScope
    public void setOnChange(String value) {
        this.onChange = value;
    }

    @Override
    @SASScope
    public String getOnChange() {
        return this.onChange;
    }

    @Override
    @SASScope
    public void setOnFocus(String value) {
        this.onFocus = value;
    }

    @Override
    @SASScope
    public String getOnFocus() {
        return this.onFocus;
    }

    @Override
    @SASScope
    public void setOnBlur(String value) {
        this.onBlur = value;
    }

    @Override
    @SASScope
    public String getOnBlur() {
        return this.onBlur;
    }

    @SASScope
    public Object getInitialValue() {
        return this.initialValue;
    }

    @SASScope
    public void setInitialValue(Object initialValue) {
        this.initialValue = initialValue;
    }

    @SASScope
    public int getDefaultDateStylePattern() {
        return this.defaultDateStylePattern;
    }

    @SASScope
    public void setDefaultDateStylePattern(int defaultDateStylePattern) {
        this.defaultDateStylePattern = defaultDateStylePattern;
        this.calendar.setDefaultDateStylePattern(defaultDateStylePattern);
    }

    @SASScope
    public static void createDatePickerPalette(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType(BaseUtil.TEXT_PLAIN_MIME_TYPE);
        PrintWriter out = response.getWriter();
        String pickerID = request.getParameter("pickerid");
        int day = Integer.parseInt(request.getParameter("day"));
        int month = Integer.parseInt(request.getParameter("month"));
        int year = Integer.parseInt(request.getParameter("year"));
        TransformationInterface ti = (TransformationInterface)ComponentSessionManager.getSessionManager(request).get(pickerID);
        if (ti instanceof DatePicker) {
            DatePicker picker = (DatePicker)ti;
            DatePickerPopupWindow popDialog = new DatePickerPopupWindow(picker.getId());
            popDialog.setRequest(request);
            Calendar cal = (Calendar)picker.getComponent(CALENDAR_COMPONENT);
            cal.setRequest(request);
            cal.setSelectDateCallBack(pickerID + "_Obj.setTextEntryToCalendarDate();");
            SimpleDateFormat tempFormat = new SimpleDateFormat(NLFormats.getPattern((String)DateType.DEFAULT_INSTANCE.getDefaultFormatName(), (Locale)request.getLocale()), request.getLocale());
            java.util.Calendar calendar = java.util.Calendar.getInstance();
            calendar.set(year, month, day);
            Date d = calendar.getTime();
            cal.setTodayFormattedDate(Strings.escapeForJavaScript((String)tempFormat.format(d)));
            popDialog.setComponent(CALENDAR_COMPONENT, cal);
            popDialog.write(out);
        }
    }

    static {
        JavaScriptIncludeHandler.addAlias(DatePicker.class, "DATEPICKER");
    }
}

