/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.JavaScriptEventHandlerInterface;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.MapWithDefaults;
import com.sas.util.Util;
import com.sas.util.log.LoggerRepository2;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

@SASScope
public class Clock
extends BaseTransformation
implements JavaScriptEventHandlerInterface {
    private static final String RB_KEY = "Clock.";
    private MapWithDefaults componentStyleMap;
    private static final HashMap defaultStyleMap = new HashMap();
    private String parameterPrefix;
    private ResourceBundle bundle;
    public static final String CLOCK_FACE_HOUR_COLOR = "CLOCK_FACE_HOUR_COLOR";
    public static final String CLOCK_FACE_MINUTE_COLOR = "CLOCK_FACE_MINUTE_COLOR";
    public static final String CLOCK_SECOND_HAND_COLOR = "CLOCK_SECOND_HAND_COLOR";
    public static final String CLOCK_HOUR_HAND_COLOR = "CLOCK_HOUR_HAND_COLOR";
    public static final String CLOCK_MINUTE_HAND_COLOR = "CLOCK_MINUTE_HAND_COLOR";
    public static final String CLOCK_FACE_CONTAINER_STYLE = "CLOCK_FACE_CONTAINER_STYLE";
    public static final String CLOCK_FACE_HOUR_STYLE = "CLOCK_FACE_HOUR_STYLE";
    public static final String CLOCK_FACE_MINUTE_STYLE = "CLOCK_FACE_MINUTE_STYLE";
    public static final String CLOCK_HOUR_HAND_CONTAINER_STYLE = "CLOCK_HOUR_HAND_CONTAINER_STYLE";
    public static final String CLOCK_MINUTE_HAND_CONTAINER_STYLE = "CLOCK_MINUTE_HAND_CONTAINER_STYLE";
    public static final String CLOCK_SECOND_HAND_CONTAINER_STYLE = "CLOCK_SECOND_HAND_CONTAINER_STYLE";
    public static final String CLOCK_HOUR_HAND_COLOR_STYLE = "CLOCK_HOUR_HAND_COLOR_STYLE";
    public static final String CLOCK_MINUTE_HAND_COLOR_STYLE = "CLOCK_MINUTE_HAND_COLOR_STYLE";
    public static final String CLOCK_SECOND_HAND_COLOR_STYLE = "CLOCK_SECOND_HAND_COLOR_STYLE";
    private static final ImmutableStyleInfo clockFaceContainerStyle = new ImmutableStyleInfo("clockFaceContainer");
    private static final ImmutableStyleInfo clockFaceHourStyle = new ImmutableStyleInfo("clockFaceHour");
    private static final ImmutableStyleInfo clockFaceMinuteStyle = new ImmutableStyleInfo("clockFaceMinute");
    private static final ImmutableStyleInfo clockHourHandContainerStyle = new ImmutableStyleInfo("clockHourHandContainer");
    private static final ImmutableStyleInfo clockSecondHandContainerStyle = new ImmutableStyleInfo("clockSecondHandContainer");
    private static final ImmutableStyleInfo clockMinuteHandContainerStyle = new ImmutableStyleInfo("clockMinuteHandContainer");
    private static final ImmutableStyleInfo clockHourHandColorStyle = new ImmutableStyleInfo("clockHourHandColor");
    private static final ImmutableStyleInfo clockSecondHandColorStyle = new ImmutableStyleInfo("clockSecondHandColor");
    private static final ImmutableStyleInfo clockMinuteHandColorStyle = new ImmutableStyleInfo("clockMinuteHandColor");
    private boolean enabled = true;
    private boolean systemTimeDisabled = false;
    private Date date = null;
    private int hours = 0;
    private int minutes = 0;
    private int seconds = 0;
    private int clockXPos = 0;
    private int clockYPos = 0;
    private int clockDiameter = 0;
    private int secondHandLength = 0;
    private int minuteHandLength = 0;
    private int hourHandLength = 0;
    private String clockFaceHourColor;
    private String clockFaceMinuteColor;
    private String clockSecondHandColor;
    private String clockMinuteHandColor;
    private String clockHourHandColor;
    private String onChange = null;
    private String onFocus = null;
    private String onBlur = null;

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            ImmutableStyleInfo o = defaultStyleMap.put(CLOCK_FACE_CONTAINER_STYLE, clockFaceContainerStyle);
            o = defaultStyleMap.put(CLOCK_FACE_HOUR_STYLE, clockFaceHourStyle);
            o = defaultStyleMap.put(CLOCK_FACE_MINUTE_STYLE, clockFaceMinuteStyle);
            o = defaultStyleMap.put(CLOCK_HOUR_HAND_CONTAINER_STYLE, clockHourHandContainerStyle);
            o = defaultStyleMap.put(CLOCK_MINUTE_HAND_CONTAINER_STYLE, clockMinuteHandContainerStyle);
            o = defaultStyleMap.put(CLOCK_SECOND_HAND_CONTAINER_STYLE, clockSecondHandContainerStyle);
            o = defaultStyleMap.put(CLOCK_HOUR_HAND_COLOR_STYLE, clockHourHandColorStyle);
            o = defaultStyleMap.put(CLOCK_MINUTE_HAND_COLOR_STYLE, clockMinuteHandColorStyle);
            ImmutableStyleInfo immutableStyleInfo = defaultStyleMap.put(CLOCK_SECOND_HAND_COLOR_STYLE, clockSecondHandColorStyle);
        }
    }

    public Clock() {
        this(null);
    }

    public Clock(String id) {
        if (id == null) {
            this.setId(Util.getName((String)"clock"));
        } else {
            this.setId(id);
        }
        this.clockFaceHourColor = "#008080";
        this.clockFaceMinuteColor = "#D4D0C8";
        this.clockSecondHandColor = "#000000";
        this.clockMinuteHandColor = "#008080";
        this.clockHourHandColor = "#008080";
        this.systemTimeDisabled = false;
        this.clockXPos = 110;
        this.clockYPos = 90;
        this.clockDiameter = 50;
        this.secondHandLength = 45;
        this.hourHandLength = 36;
        this.minuteHandLength = 45;
        this.setHours(12);
        Clock.setupDefaultStyleMap();
        this.componentStyleMap = new MapWithDefaults((Map)defaultStyleMap);
    }

    public Map getStyleMap() {
        return this.componentStyleMap;
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        try {
            JavaScriptIncludeHandler.writeIncludes(out, "CLOCK", this.getRequest());
        }
        catch (IOException e) {
            LoggerRepository2.getLogger((String)Clock.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        out.println("<div id=\"" + this.getId() + "_clockDiv\"></div>");
        this.writeJavaScript(out);
        this.cleanUpResources();
    }

    private void writeJavaScript(PrintWriter out) {
        out.println(JavaScriptIncludeHandler.getStartScript());
        out.println("" + this.getId() + "_Obj = new sas_Clock('" + this.getId() + "');");
        out.println(this.getId() + "_Obj.clockXPos=" + this.getClockXPosition() + ";");
        out.println(this.getId() + "_Obj.clockYPos=" + this.getClockYPosition() + ";");
        out.println(this.getId() + "_Obj.clockDiameter=" + this.getClockDiameter() + ";");
        out.println(this.getId() + "_Obj.secondHandLength=" + this.getSecondHandLength() + ";");
        out.println(this.getId() + "_Obj.minuteHandLength=" + this.getMinuteHandLength() + ";");
        out.println(this.getId() + "_Obj.hourHandLength=" + this.getHourHandLength() + ";");
        out.println(this.getId() + "_Obj.systemTimeDisabled=" + this.isSystemTimeDisabled() + ";");
        out.println(this.getId() + "_Obj.faceHourColor=\"" + this.getClockFaceHourColor() + "\";");
        out.println(this.getId() + "_Obj.faceMinuteColor=\"" + this.getClockFaceMinuteColor() + "\";");
        out.println(this.getId() + "_Obj.secondHandColor=\"" + this.getClockSecondHandColor() + "\";");
        out.println(this.getId() + "_Obj.minuteHandColor=\"" + this.getClockMinuteHandColor() + "\";");
        out.println(this.getId() + "_Obj.hourHandColor=\"" + this.getClockHourHandColor() + "\";");
        Map clockStyles = this.getStyleMap();
        out.println(this.getId() + "_Obj.clockFaceContainerStyle=\"" + ((ImmutableStyleInfo)clockStyles.get(CLOCK_FACE_CONTAINER_STYLE)).getClassid() + "\";");
        out.println(this.getId() + "_Obj.clockFaceHourStyle=\"" + ((ImmutableStyleInfo)clockStyles.get(CLOCK_FACE_HOUR_STYLE)).getClassid() + "\";");
        out.println(this.getId() + "_Obj.clockFaceMinuteStyle=\"" + ((ImmutableStyleInfo)clockStyles.get(CLOCK_FACE_MINUTE_STYLE)).getClassid() + "\";");
        out.println(this.getId() + "_Obj.clockHourHandContainerStyle=\"" + ((ImmutableStyleInfo)clockStyles.get(CLOCK_HOUR_HAND_CONTAINER_STYLE)).getClassid() + "\";");
        out.println(this.getId() + "_Obj.clockMinuteHandContainerStyle=\"" + ((ImmutableStyleInfo)clockStyles.get(CLOCK_MINUTE_HAND_CONTAINER_STYLE)).getClassid() + "\";");
        out.println(this.getId() + "_Obj.clockSecondHandContainerStyle=\"" + ((ImmutableStyleInfo)clockStyles.get(CLOCK_SECOND_HAND_CONTAINER_STYLE)).getClassid() + "\";");
        out.println(this.getId() + "_Obj.clockHourHandColorStyle=\"" + ((ImmutableStyleInfo)clockStyles.get(CLOCK_HOUR_HAND_COLOR_STYLE)).getClassid() + "\";");
        out.println(this.getId() + "_Obj.clockMinuteHandColorStyle=\"" + ((ImmutableStyleInfo)clockStyles.get(CLOCK_MINUTE_HAND_COLOR_STYLE)).getClassid() + "\";");
        out.println(this.getId() + "_Obj.clockSecondHandColorStyle=\"" + ((ImmutableStyleInfo)clockStyles.get(CLOCK_SECOND_HAND_COLOR_STYLE)).getClassid() + "\";");
        out.println(this.getId() + "_Obj.setHours('" + this.getHours() + "');");
        out.println(this.getId() + "_Obj.setMinutes('" + this.getMinutes() + "');");
        out.println(this.getId() + "_Obj.setSeconds('" + this.getSeconds() + "');");
        out.println(this.getId() + "_Obj.createClock('" + this.getId() + "_clockDiv');");
        out.println(this.getId() + "_Obj.showClock('" + this.getId() + "');");
        out.println(JavaScriptIncludeHandler.getEndScript(null));
    }

    private void writeClock(PrintWriter out) {
        int i;
        for (i = 0; i < 60; ++i) {
            if (i % 5 == 0) {
                out.println("<div style=\"position:absolute;z-index:100;font-family:arial;font-size:18pt;font-weight:bold\" id=\"" + this.getId() + "_f" + i + "\"><font color=\"" + this.getClockFaceHourColor() + "\">.</font></div>");
                continue;
            }
            out.println("<div style=\"position:absolute;z-index:100;font-family:arial;font-size:16pt;font-weight:bold\" id=\"" + this.getId() + "_f" + i + "\"><font color=\"" + this.getClockFaceMinuteColor() + "\">.</font></div>");
        }
        for (i = 1; i < this.getSecondHandLength(); ++i) {
            out.println("<div style=\"position:absolute;z-index:500;font-family:arial;font-size:10pt;font-weight:bold\" id=\"" + this.getId() + "_s" + i + "\"><font color=\"" + this.getClockSecondHandColor() + "\">.</font></div>");
        }
        for (i = 1; i < this.getMinuteHandLength(); ++i) {
            out.println("<div style=\"position:absolute;z-index:400;font-family:arial;font-size:16pt;font-weight:bold\" id=\"" + this.getId() + "_m" + i + "\"><font color=\"" + this.getClockMinuteHandColor() + "\">.</font></div>");
        }
        for (i = 1; i < this.getHourHandLength(); ++i) {
            out.println("<div style=\"position:absolute;z-index:300;font-family:arial;font-size:16pt;font-weight:bold\" id=\"" + this.getId() + "_h" + i + "\"><font color=\"" + this.getClockHourHandColor() + "\">.</font></div>");
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isSystemTimeDisabled() {
        return this.systemTimeDisabled;
    }

    public void setSystemTimeDisabled(boolean disabled) {
        this.systemTimeDisabled = disabled;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setHours(int hours) {
        this.hours = hours;
    }

    public int getHours() {
        return this.hours;
    }

    public void setMinutes(int minutes) {
        this.minutes = minutes;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public void setSeconds(int seconds) {
        this.seconds = seconds;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public void setClockXPosition(int xpos) {
        this.clockXPos = xpos;
    }

    public int getClockXPosition() {
        return this.clockXPos;
    }

    public void setClockYPosition(int ypos) {
        this.clockYPos = ypos;
    }

    public int getClockYPosition() {
        return this.clockYPos;
    }

    public void setClockDiameter(int diam) {
        this.clockDiameter = diam;
    }

    public int getClockDiameter() {
        return this.clockDiameter;
    }

    public void setSecondHandLength(int len) {
        this.secondHandLength = len;
    }

    public int getSecondHandLength() {
        return this.secondHandLength;
    }

    public void setMinuteHandLength(int len) {
        this.minuteHandLength = len;
    }

    public int getMinuteHandLength() {
        return this.minuteHandLength;
    }

    public void setHourHandLength(int len) {
        this.hourHandLength = len;
    }

    public int getHourHandLength() {
        return this.hourHandLength;
    }

    public void setClockFaceHourColor(String color) {
        this.clockFaceHourColor = color;
    }

    public String getClockFaceHourColor() {
        return this.clockFaceHourColor;
    }

    public void setClockFaceMinuteColor(String color) {
        this.clockFaceMinuteColor = color;
    }

    public String getClockFaceMinuteColor() {
        return this.clockFaceMinuteColor;
    }

    public void setClockSecondHandColor(String color) {
        this.clockSecondHandColor = color;
    }

    public String getClockSecondHandColor() {
        return this.clockSecondHandColor;
    }

    public void setClockMinuteHandColor(String color) {
        this.clockMinuteHandColor = color;
    }

    public String getClockMinuteHandColor() {
        return this.clockMinuteHandColor;
    }

    public void setClockHourHandColor(String color) {
        this.clockHourHandColor = color;
    }

    public String getClockHourHandColor() {
        return this.clockHourHandColor;
    }

    @Override
    public void setOnChange(String value) {
        this.onChange = value;
    }

    @Override
    public String getOnChange() {
        return this.onChange;
    }

    @Override
    public void setOnFocus(String value) {
        this.onFocus = value;
    }

    @Override
    public String getOnFocus() {
        return this.onFocus;
    }

    @Override
    public void setOnBlur(String value) {
        this.onBlur = value;
    }

    @Override
    public String getOnBlur() {
        return this.onBlur;
    }

    static {
        JavaScriptIncludeHandler.addAlias(Clock.class, "CLOCK");
    }
}

