/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseCompositeTransformation;
import com.sas.servlet.tbeans.JavaScriptEventHandlerInterface;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.TemplateSupport;
import com.sas.servlet.tbeans.html.RB;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.servlet.util.DateUtil;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.text.NLInformats;
import com.sas.util.MapWithDefaults;
import com.sas.util.SimpleTemplate;
import com.sas.util.Strings;
import com.sas.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

@SASScope
public class Calendar
extends BaseCompositeTransformation
implements JavaScriptEventHandlerInterface {
    private static final String RB_KEY = "Calendar.";
    private static HashMap defaultStyleMap;
    private MapWithDefaults componentStyleMap;
    public static final String DEFAULT_AJAX_PALETTE_URL_TEMPLATE;
    public static final String CALENDAR_CONTAINER_STYLE = "CALENDAR_CONTAINER_STYLE";
    public static final String CALENDAR_CONTAINER_DISABLED_STYLE = "CALENDAR_CONTAINER_DISABLED_STYLE";
    public static final String CALENDAR_HEADER_STYLE = "CALENDAR_HEADER_STYLE";
    public static final String CALENDAR_HEADER_CONTENT_STYLE = "CALENDAR_HEADER_CONTENT_STYLE";
    public static final String CALENDAR_NAVIGATION_STYLE = "CALENDAR_NAVIGATION_STYLE";
    public static final String CALENDAR_NAVIGATION_ROLLOVER_STYLE = "CALENDAR_NAVIGATION_ROLLOVER_STYLE";
    public static final String CALENDAR_MONTH_LIST_STYLE = "CALENDAR_MONTH_LIST_STYLE";
    public static final String CALENDAR_YEAR_LIST_STYLE = "CALENDAR_YEAR_LIST_STYLE";
    public static final String CALENDAR_YEARMONTH_LIST_ROLLOVER_STYLE = "CALENDAR_YEARMONTH_LIST_ROLLOVER_STYLE";
    public static final String CALENDAR_CONTENT_STYLE = "CALENDAR_CONTENT_STYLE";
    public static final String CALENDAR_DAY_HEADER_STYLE = "CALENDAR_DAY_HEADER_STYLE";
    public static final String CALENDAR_WEEK_HEADER_SEPARATOR_STYLE = "CALENDAR_WEEK_HEADER_SEPARATOR_STYLE";
    public static final String CALENDAR_CURRENT_DAY_STYLE = "CALENDAR_CURRENT_DAY_STYLE";
    public static final String CALENDAR_DAY_STYLE = "CALENDAR_DAY_STYLE";
    public static final String CALENDAR_SELECTED_DAY_STYLE = "CALENDAR_SELECTED_DAY_STYLE";
    public static final String CALENDAR_FOOTER_STYLE = "CALENDAR_FOOTER_STYLE";
    public static final String CALENDAR_DAY_SPAN_STYLE = "CALENDAR_DAY_SPAN_STYLE";
    public static final String CALENDAR_DAY_ANCHOR_STYLE = "CALENDAR_DAY_ANCHOR_STYLE";
    public static final String CALENDAR_DAY_DISABLED_STYLE = "CALENDAR_DAY_DISABLED_STYLE";
    public static final int DAYS = 0;
    public static final int WEEKDAYS = 1;
    public static final int WEEKENDS = 2;
    public static final int WEEKS = 3;
    private static final String DEFAULT_TEMPLATE_FILE_NAME = "Calendar.html";
    public static final int START_ON_SUNDAY = 1;
    public static final int START_ON_MONDAY = 2;
    protected int weekStartingDay = 2;
    protected boolean displayToday = true;
    protected boolean displayWeekNumbers = true;
    protected String selectDateCallBack = null;
    private boolean enabled = true;
    private Date date = null;
    private String onChange = null;
    private String onFocus = null;
    private String onBlur = null;
    private SimpleDateFormat dateFormat = null;
    private int defaultDateStylePattern = 3;
    private int selectionMode;
    private SimpleTemplate ajaxURLTemplate;
    private Date selectionStartDate = null;
    private Date selectionEndDate = null;
    private String todayFormattedDate;

    public Calendar() {
        this(null);
    }

    public Calendar(String id) {
        if (id == null) {
            this.setId(Util.getName((String)"calendar"));
        } else {
            this.setId(id);
        }
        this.setTemplateKey("Calendar");
        this.ajaxURLTemplate = new SimpleTemplate();
        this.ajaxURLTemplate.setTemplate(DateUtil.DEFAULT_AJAX_URL_RELATIVE_VALUE_TEMPLATE);
        this.ajaxURLTemplate.setValueDictionary(new HashMap());
        this.componentStyleMap = new MapWithDefaults(Calendar.getDefaultStyleMap());
        this.setSelectionMode(0);
    }

    private static Map getDefaultStyleMap() {
        if (defaultStyleMap == null) {
            defaultStyleMap = new HashMap();
            StyleInfo calendarContainerStyle = new StyleInfo("CalendarContainer");
            defaultStyleMap.put(CALENDAR_CONTAINER_STYLE, calendarContainerStyle);
            StyleInfo calendarContainerDisabledStyle = new StyleInfo("CalendarContainerDisabled");
            defaultStyleMap.put(CALENDAR_CONTAINER_DISABLED_STYLE, calendarContainerDisabledStyle);
            StyleInfo calendarHeaderStyle = new StyleInfo("CalendarHeader");
            defaultStyleMap.put(CALENDAR_HEADER_STYLE, calendarHeaderStyle);
            StyleInfo calendarHeaderContentStyle = new StyleInfo("CalendarHeaderContent");
            defaultStyleMap.put(CALENDAR_HEADER_CONTENT_STYLE, calendarHeaderContentStyle);
            StyleInfo calendarNavigationStyle = new StyleInfo("CalendarNavigation");
            defaultStyleMap.put(CALENDAR_NAVIGATION_STYLE, calendarNavigationStyle);
            StyleInfo calendarNavigationRolloverStyle = new StyleInfo("CalendarNavigationRollover");
            defaultStyleMap.put(CALENDAR_NAVIGATION_ROLLOVER_STYLE, calendarNavigationRolloverStyle);
            StyleInfo calendarMonthListStyle = new StyleInfo("CalendarMonthList");
            defaultStyleMap.put(CALENDAR_MONTH_LIST_STYLE, calendarMonthListStyle);
            StyleInfo calendarYearListStyle = new StyleInfo("CalendarYearList");
            defaultStyleMap.put(CALENDAR_YEAR_LIST_STYLE, calendarYearListStyle);
            StyleInfo calendarYearMonthListRolloverStyle = new StyleInfo("CalendarYearMonthListRollover");
            defaultStyleMap.put(CALENDAR_YEARMONTH_LIST_ROLLOVER_STYLE, calendarYearMonthListRolloverStyle);
            StyleInfo calendarContentStyle = new StyleInfo("CalendarContent");
            defaultStyleMap.put(CALENDAR_CONTENT_STYLE, calendarContentStyle);
            StyleInfo calendarDayHeaderStyle = new StyleInfo("CalendarDayHeader");
            defaultStyleMap.put(CALENDAR_DAY_HEADER_STYLE, calendarDayHeaderStyle);
            StyleInfo calendarWeekHeaderSeparatorStyle = new StyleInfo("CalendarWeekHeaderSeparator");
            defaultStyleMap.put(CALENDAR_WEEK_HEADER_SEPARATOR_STYLE, calendarWeekHeaderSeparatorStyle);
            StyleInfo calendarCurrentDayStyle = new StyleInfo("CalendarCurrentDay");
            defaultStyleMap.put(CALENDAR_CURRENT_DAY_STYLE, calendarCurrentDayStyle);
            StyleInfo calendarDayStyle = new StyleInfo("CalendarDay");
            defaultStyleMap.put(CALENDAR_DAY_STYLE, calendarDayStyle);
            StyleInfo calendarSelectedDayStyle = new StyleInfo("CalendarSelectedDay");
            defaultStyleMap.put(CALENDAR_SELECTED_DAY_STYLE, calendarSelectedDayStyle);
            StyleInfo calendarFooterStyle = new StyleInfo("CalendarFooter");
            defaultStyleMap.put(CALENDAR_FOOTER_STYLE, calendarFooterStyle);
            StyleInfo calendarDaySpanStyle = new StyleInfo("CalendarDaySpan");
            defaultStyleMap.put(CALENDAR_DAY_SPAN_STYLE, calendarDaySpanStyle);
            StyleInfo calendarDayAnchorStyle = new StyleInfo("CalendarDayAnchor");
            defaultStyleMap.put(CALENDAR_DAY_ANCHOR_STYLE, calendarDayAnchorStyle);
            StyleInfo calendarDayDisabledStyle = new StyleInfo("CalendarDayDisabled");
            defaultStyleMap.put(CALENDAR_DAY_DISABLED_STYLE, calendarDayDisabledStyle);
        }
        return defaultStyleMap;
    }

    @Override
    public Map getStyleMap() {
        return this.componentStyleMap;
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        super.write(out);
        JavaScriptIncludeHandler.writeIncludes(out, "CALENDAR", this.getRequest());
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
        HashMap<String, String> dictionary = this.getTemplateDictionary();
        if (dictionary == null) {
            dictionary = new HashMap<String, String>();
            this.setTemplateDictionary(dictionary);
        }
        dictionary.put("CALENDAR_ID", this.getId());
        dictionary.put("CALENDAR_WIDTH", this.isDisplayWeekNumbers() ? "250" : "220");
        dictionary.put("PREVIOUS_MONTH_TEXT", Strings.escapeForJavaScript((String)RB.getStringResource(RB_KEY, "previous.month.txt", this.getLocale())));
        dictionary.put("NEXT_MONTH_TEXT", Strings.escapeForJavaScript((String)RB.getStringResource(RB_KEY, "next.month.txt", this.getLocale())));
        dictionary.put("SELECT_MONTH_TEXT", Strings.escapeForJavaScript((String)RB.getStringResource(RB_KEY, "select.month.txt", this.getLocale())));
        dictionary.put("SELECT_YEAR_TEXT", Strings.escapeForJavaScript((String)RB.getStringResource(RB_KEY, "select.year.txt", this.getLocale())));
        dictionary.put("PREVIOUS_MONTH_ALT_TEXT", Strings.escapeForJavaScript((String)RB.getStringResource(RB_KEY, "previous.month.alt.txt", this.getLocale())));
        dictionary.put("NEXT_MONTH_ALT_TEXT", Strings.escapeForJavaScript((String)RB.getStringResource(RB_KEY, "next.month.alt.txt", this.getLocale())));
        dictionary.put("SELECT_MONTH_ALT_TEXT", Strings.escapeForJavaScript((String)RB.getStringResource(RB_KEY, "select.month.txt", this.getLocale())));
        dictionary.put("SELECT_YEAR_ALT_TEXT", Strings.escapeForJavaScript((String)RB.getStringResource(RB_KEY, "select.year.txt", this.getLocale())));
        dictionary.put("LEFT_IMAGE", cpm.getImageURI("Calendar_Left"));
        dictionary.put("RIGHT_IMAGE", cpm.getImageURI("Calendar_Right"));
        dictionary.put("DOWN_IMAGE", cpm.getImageURI("Calendar_Down"));
        dictionary.put("JS_SCROLL_NEXT_MONTH", this.getId() + ".scrollNextMonth();");
        dictionary.put("JS_SCROLL_PREVIOUS_MONTH", this.getId() + ".scrollPreviousMonth();");
        String dateStyle = NLInformats.getDateStyle((Locale)this.getLocale());
        if (dateStyle != null && dateStyle.indexOf(89) < dateStyle.indexOf(77)) {
            dictionary.put("IS_YMD_DATESTYLE", dateStyle);
        }
        TemplateSupport.writeTemplate(this, null, out);
        this.writeJavaScript(out);
    }

    private void writeJavaScript(PrintWriter out) {
        String formatString;
        int m;
        Map map = this.ajaxURLTemplate.getValueDictionary();
        map.put("BASE_AJAX_URL", this.getAJAXControllerURL());
        if (this.getAJAXControllerURL().indexOf("?") == -1) {
            map.put("AJAX_URL_SUFFIX", "?");
        } else {
            map.put("AJAX_URL_SUFFIX", "&");
        }
        map.put("id", this.getId());
        out.println(JavaScriptIncludeHandler.getStartScript());
        out.println("" + this.getId() + " = " + this.getId() + "_Obj = new sas_Calendar('" + this.getId() + "'," + this.getLocalizedJavascriptStringsParm() + "," + this.getJavascriptImagesParm() + "," + this.getJavascriptStylesParm() + ");");
        out.println(this.getId() + "_Obj.url = '" + this.ajaxURLTemplate.format() + "';\n");
        if (this.selectionEndDate != null) {
            out.println(this.getId() + "_Obj.setSelectionEndDate(new Date(" + this.selectionEndDate.getTime() + "));");
        }
        if (this.selectionStartDate != null) {
            out.println(this.getId() + "_Obj.setSelectionStartDate(new Date(" + this.selectionStartDate.getTime() + "));");
        }
        String startOnMonday = "true";
        if (this.getWeekStartingDay() != 2) {
            startOnMonday = "false";
        }
        out.println(this.getId() + "_Obj.setDayNames(" + this.getJavascriptDayNamesArray(false) + "," + startOnMonday + ");");
        out.println(this.getId() + "_Obj.setDayAbbreviations(" + this.getJavascriptDayNamesArray(true) + ");");
        DateFormatSymbols dfs = new DateFormatSymbols(this.getLocale());
        out.println(this.getId() + "_Obj.setMonthNames(Array (");
        for (m = 0; m < 12; ++m) {
            out.println("'" + Strings.escapeForJavaScript((String)dfs.getMonths()[m]) + "'");
            if (m >= 11) continue;
            out.println(",");
        }
        out.println("));");
        out.println(this.getId() + "_Obj.setMonthAbbreviations(Array (");
        for (m = 0; m < 12; ++m) {
            out.println("'" + Strings.escapeForJavaScript((String)dfs.getShortMonths()[m]) + "'");
            if (m >= 11) continue;
            out.println(",");
        }
        out.println("));");
        if (this.getSelectionMode() == 0) {
            out.println(this.getId() + "_Obj.isDaysSelectionMode = true;");
        } else if (this.getSelectionMode() == 1) {
            out.println(this.getId() + "_Obj.isWeekdaysSelectionMode = true;");
        } else if (this.getSelectionMode() == 2) {
            out.println(this.getId() + "_Obj.isWeekendsSelectionMode = true;");
        } else if (this.getSelectionMode() == 3) {
            out.println(this.getId() + "_Obj.isWeeksSelectionMode = true;");
        }
        if (this.isDisplayToday()) {
            out.println(this.getId() + "_Obj.showTodayLine(1);");
        } else {
            out.println(this.getId() + "_Obj.showTodayLine(0);");
        }
        if (this.isDisplayWeekNumbers()) {
            out.println(this.getId() + "_Obj.showWeekNumbers(1);");
        } else {
            out.println(this.getId() + "_Obj.showWeekNumbers(0);");
        }
        if (this.getSelectDateCallBack() != null) {
            out.println(this.getId() + "_Obj.setSelectDateCallBack('" + this.getSelectDateCallBack() + "');");
        }
        if (this.getOnChange() != null) {
            out.println(this.getId() + "_Obj.onChange = \"" + this.getOnChange() + "\";");
        }
        if (!this.isEnabled()) {
            String function = "function(){" + this.getId() + "_Obj.disable();}";
            out.println("if(xIE){ window.attachEvent('onload', " + function + "); }");
            out.println("else { window.addEventListener('load'," + function + ", false); }");
        }
        if (this.getFormat() != null) {
            formatString = this.getFormat().toPattern();
        } else {
            SimpleDateFormat tempFormat = (SimpleDateFormat)DateFormat.getDateInstance(this.getDefaultDateStylePattern(), this.getLocale());
            if (this.getDefaultDateStylePattern() == 3) {
                Calendar.convertShortDateFormatTo4DigitYear(tempFormat);
            }
            formatString = tempFormat.toPattern();
        }
        out.println(this.getId() + "_Obj.setDateFormat('" + Strings.escapeForJavaScript((String)formatString) + "');");
        if (this.getDate() != null) {
            out.println(this.getId() + "_Obj.setDate(new Date(" + this.getDate().getTime() + "));");
        } else {
            out.println(this.getId() + "_Obj.refresh();");
        }
        if (this.getTodayFormattedDate() != null) {
            out.println(this.getId() + "_Obj.todayFormattedDate='" + this.getTodayFormattedDate() + "';");
        }
        out.println(JavaScriptIncludeHandler.getEndScript(null));
    }

    private String getLocalizedJavascriptStringsParm() {
        StringBuffer localizedStrings = new StringBuffer("{");
        localizedStrings.append("gotoString:'").append(Strings.escapeForJavaScript((String)RB.getStringResource(RB_KEY, "goto.today.txt", this.getLocale()))).append("'");
        localizedStrings.append(", weekString:'").append(Strings.escapeForJavaScript((String)RB.getStringResource(RB_KEY, "week.abbrev.txt", this.getLocale()))).append("'");
        localizedStrings.append(", todayString:'").append(Strings.escapeForJavaScript((String)RB.getStringResource(RB_KEY, "today.txt", this.getLocale()))).append("'");
        localizedStrings.append(", todayFormattedDate:'").append(Strings.escapeForJavaScript((String)DateFormat.getDateInstance(0, this.getLocale()).format(new Date()))).append("'");
        localizedStrings.append("}");
        return localizedStrings.toString();
    }

    private String getJavascriptStylesParm() {
        StringBuffer images = new StringBuffer("{");
        images.append("CalendarDay:'").append(((StyleInfo)this.getStyleMap().get(CALENDAR_DAY_STYLE)).getClassid()).append("'");
        images.append(", CalendarDayHeader:'").append(((StyleInfo)this.getStyleMap().get(CALENDAR_DAY_HEADER_STYLE)).getClassid()).append("'");
        images.append(", CalendarDaySpan:'").append(((StyleInfo)this.getStyleMap().get(CALENDAR_DAY_SPAN_STYLE)).getClassid()).append("'");
        images.append(", CalendarDayAnchor:'").append(((StyleInfo)this.getStyleMap().get(CALENDAR_DAY_ANCHOR_STYLE)).getClassid()).append("'");
        images.append(", CalendarWeekHeaderSeparator:'").append(((StyleInfo)this.getStyleMap().get(CALENDAR_WEEK_HEADER_SEPARATOR_STYLE)).getClassid()).append("'");
        images.append(", CalendarSelectedDay:'").append(((StyleInfo)this.getStyleMap().get(CALENDAR_SELECTED_DAY_STYLE)).getClassid()).append("'");
        images.append(", CalendarCurrentDay:'").append(((StyleInfo)this.getStyleMap().get(CALENDAR_CURRENT_DAY_STYLE)).getClassid()).append("'");
        images.append(", CalendarContainer:'").append(((StyleInfo)this.getStyleMap().get(CALENDAR_CONTAINER_STYLE)).getClassid()).append("'");
        images.append(", CalendarContainerDisabled:'").append(((StyleInfo)this.getStyleMap().get(CALENDAR_CONTAINER_DISABLED_STYLE)).getClassid()).append("'");
        images.append(", CalendarDayDisabled:'").append(((StyleInfo)this.getStyleMap().get(CALENDAR_DAY_DISABLED_STYLE)).getClassid()).append("'");
        images.append("}");
        return images.toString();
    }

    private String getJavascriptImagesParm() {
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
        StringBuffer images = new StringBuffer("{");
        images.append("spacer:'").append(cpm.getImageURI("Spacer")).append("'");
        images.append("}");
        return images.toString();
    }

    private String getJavascriptDayNamesArray(boolean abbreviations) {
        DateFormatSymbols dfs = new DateFormatSymbols(this.getLocale());
        String[] days = abbreviations ? dfs.getShortWeekdays() : dfs.getWeekdays();
        StringBuffer dayNames = new StringBuffer("Array(");
        if (this.getWeekStartingDay() == 1) {
            dayNames.append("'").append(Strings.escapeForJavaScript((String)days[1])).append("'");
            dayNames.append(",'").append(Strings.escapeForJavaScript((String)days[2])).append("'");
            dayNames.append(",'").append(Strings.escapeForJavaScript((String)days[3])).append("'");
            dayNames.append(",'").append(Strings.escapeForJavaScript((String)days[4])).append("'");
            dayNames.append(",'").append(Strings.escapeForJavaScript((String)days[5])).append("'");
            dayNames.append(",'").append(Strings.escapeForJavaScript((String)days[6])).append("'");
            dayNames.append(",'").append(Strings.escapeForJavaScript((String)days[7])).append("'");
        } else {
            dayNames.append("'").append(Strings.escapeForJavaScript((String)days[2])).append("'");
            dayNames.append(",'").append(Strings.escapeForJavaScript((String)days[3])).append("'");
            dayNames.append(",'").append(Strings.escapeForJavaScript((String)days[4])).append("'");
            dayNames.append(",'").append(Strings.escapeForJavaScript((String)days[5])).append("'");
            dayNames.append(",'").append(Strings.escapeForJavaScript((String)days[6])).append("'");
            dayNames.append(",'").append(Strings.escapeForJavaScript((String)days[7])).append("'");
            dayNames.append(",'").append(Strings.escapeForJavaScript((String)days[1])).append("'");
        }
        dayNames.append(")");
        return dayNames.toString();
    }

    public int getWeekStartingDay() {
        return this.weekStartingDay;
    }

    public void setWeekStartingDay(int startOn) {
        if (startOn != 1 && startOn != 2) {
            startOn = 1;
        }
        this.weekStartingDay = startOn;
    }

    public boolean isDisplayToday() {
        return this.displayToday;
    }

    public void setDisplayToday(boolean displayTodayLine) {
        this.displayToday = displayTodayLine;
    }

    public boolean isDisplayWeekNumbers() {
        return this.displayWeekNumbers;
    }

    public void setDisplayWeekNumbers(boolean displayWeekNumbers) {
        this.displayWeekNumbers = displayWeekNumbers;
    }

    public String getSelectDateCallBack() {
        return this.selectDateCallBack;
    }

    public void setSelectDateCallBack(String selectDateCallBack) {
        this.selectDateCallBack = selectDateCallBack;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @SASScope
    public void setFormat(SimpleDateFormat newFormat) {
        this.dateFormat = newFormat;
    }

    @SASScope
    public SimpleDateFormat getFormat() {
        return this.dateFormat;
    }

    public static void convertShortDateFormatTo4DigitYear(SimpleDateFormat sdf) {
        String sTemp = sdf.toPattern();
        if (sTemp.indexOf("yyyy") != -1) {
            return;
        }
        int iLen = sTemp.length();
        int i = sTemp.lastIndexOf(121) + 1;
        sTemp = sTemp.substring(0, i) + "yy" + (i < iLen ? sTemp.substring(i, iLen) : "");
        sdf.applyPattern(sTemp);
    }

    @Override
    @SASScope
    public void setOnChange(String value) {
        this.onChange = value;
    }

    @Override
    @SASScope
    public String getOnChange() {
        return this.onChange;
    }

    @Override
    @SASScope
    public void setOnFocus(String value) {
        this.onFocus = value;
    }

    @Override
    @SASScope
    public String getOnFocus() {
        return this.onFocus;
    }

    @Override
    @SASScope
    public void setOnBlur(String value) {
        this.onBlur = value;
    }

    @Override
    @SASScope
    public String getOnBlur() {
        return this.onBlur;
    }

    @SASScope
    public void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
    }

    @SASScope
    public int getSelectionMode() {
        return this.selectionMode;
    }

    @SASScope
    public int getDefaultDateStylePattern() {
        return this.defaultDateStylePattern;
    }

    @SASScope
    public void setDefaultDateStylePattern(int defaultDateStylePattern) {
        this.defaultDateStylePattern = defaultDateStylePattern;
    }

    @SASScope
    public Date getSelectionStartDate() {
        if (this.selectionStartDate != null) {
            return new Date(this.selectionStartDate.getTime());
        }
        return null;
    }

    @SASScope
    public Date getSelectionEndDate() {
        if (this.selectionEndDate != null) {
            return new Date(this.selectionEndDate.getTime());
        }
        return null;
    }

    @SASScope
    public void setSelectionDateRange(Date selectionStartDate, Date selectionEndDate) {
        if (selectionStartDate instanceof Date) {
            this.selectionStartDate = new Date(selectionStartDate.getTime());
        }
        if (selectionEndDate instanceof Date) {
            this.selectionEndDate = new Date(selectionEndDate.getTime());
        }
    }

    public String getTodayFormattedDate() {
        return this.todayFormattedDate;
    }

    public void setTodayFormattedDate(String value) {
        this.todayFormattedDate = value;
    }

    static {
        DEFAULT_AJAX_PALETTE_URL_TEMPLATE = "%BASE_AJAX_URL(%BASE_AJAX_URL)%AJAX_URL_SUFFIX(%AJAX_URL_SUFFIX)CLASS_PARAMETER=" + Calendar.class.getName() + "&id=%id";
        JavaScriptIncludeHandler.addAlias(Calendar.class, "CALENDAR");
    }
}

