/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.html;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.dataselectors.filters.FilterValueFormatter;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.ComplexStyleInterface;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.html.AppliedFiltersStyleKeysInterface;
import com.sas.servlet.tbeans.html.RB;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.swing.models.AppliedFiltersUtil;
import com.sas.swing.models.DataItemRoleProvider;
import com.sas.swing.models.QueryBasedDataItemRoleProvider;
import com.sas.swing.models.WRSAppliedFiltersTransform;
import com.sas.util.MapWithDefaults;
import com.sas.util.Util;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.Format;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@SASScope(value="ALL")
@SubjectToChange
public class AppliedFilters
extends BaseTransformation
implements ComplexStyleInterface,
AppliedFiltersStyleKeysInterface {
    public static final String RB_KEY = "AppliedFilters.";
    private static final ImmutableStyleInfo appliedFiltersLabelStyle = new ImmutableStyleInfo("appliedFiltersLabel");
    private static final ImmutableStyleInfo appliedFiltersLogicalOperatorStyle = new ImmutableStyleInfo("appliedFiltersLogicalOperator");
    private static final ImmutableStyleInfo appliedFiltersFilterExpressionTextStyle = new ImmutableStyleInfo("appliedFiltersFilterExpressionText");
    private static final ImmutableStyleInfo appliedFiltersDivStyle = new ImmutableStyleInfo("appliedFiltersDiv");
    private static final ImmutableStyleInfo appliedFiltersTitleStyle = new ImmutableStyleInfo("appliedFiltersTitle");
    private MapWithDefaults styleMap;
    private static final HashMap DEFAULT_STYLE_MAP = new HashMap();
    private boolean useUnfilteredMetadata;
    private boolean displayHiddenOLAPFilterItems;
    private boolean fullyQualifyOLAPMembers;
    private String olapFilterOutputType;
    public static final int TITLE_ALWAYS = 0;
    public static final int TITLE_NEVER = 2;
    public static final int TITLE_WHEN_FILTERS = 4;
    public static boolean IGNORE_ANCESTOR_STEP_FILTERS = false;
    private Map conditionTextFormatMap;
    private Map condtionSymbolFormatMap;
    private static final String DIV_ID = "<div id='";
    private static final String END_DIV = "</div>";
    private static final String LINE_BREAK = "<br>";
    private static final String APPLIED_STATE_DIV = "_APPLIED_FILTERS' class='";
    private String LOGICAL_AND;
    private String title;
    private String noFilterText;
    private String defaultTitle;
    private String defaultNoFilterText;
    private int isTitleDisplayed;
    private boolean isNoFilterTextDisplayed;
    private boolean textWrapped;
    private boolean parentFiltersDisplayed;
    private String conditionFormatType;
    private Map customConditionFormats;
    private Format relationalFilterValueFormatter;
    private String labelSeparator;
    private TransformInterface relationalFilterTextTransform;
    private Object model;
    private DataItemRoleProvider dataItemRoleProvider;

    private static synchronized void setupDefaultStyleMap() {
        if (DEFAULT_STYLE_MAP.size() == 0) {
            DEFAULT_STYLE_MAP.put("APPLIEDFILTERS_DIV", appliedFiltersDivStyle);
            DEFAULT_STYLE_MAP.put("APPLIEDFILTERS_LABEL", appliedFiltersLabelStyle);
            DEFAULT_STYLE_MAP.put("APPLIEDFILTERS_LOGICAL_OPERATOR", appliedFiltersLogicalOperatorStyle);
            DEFAULT_STYLE_MAP.put("APPLIEDFILTERS_FILTER_EXPRESSION", appliedFiltersFilterExpressionTextStyle);
            DEFAULT_STYLE_MAP.put("APPLIEDFILTERS_TITLE", appliedFiltersTitleStyle);
        }
    }

    public AppliedFilters() {
        this(Util.getName((String)"_appliedFilters"));
    }

    public AppliedFilters(String id) {
        this.setId(id);
        AppliedFilters.setupDefaultStyleMap();
        this.styleMap = new MapWithDefaults((Map)DEFAULT_STYLE_MAP);
        this.setLocaleDependentProperties(this.getLocale());
        this.useUnfilteredMetadata = false;
        this.displayHiddenOLAPFilterItems = true;
        this.fullyQualifyOLAPMembers = true;
        this.olapFilterOutputType = "olapFiltersAll";
        this.setTextWrapped(true);
        this.setTitleDisplayed(0);
        this.setNoFilterTextDisplayed(true);
        this.setParentFiltersDisplayed(true);
        this.setConditionFormatType("CONDITION_FORMAT_TEXT");
        this.setRelationalFilterValueFormatter((Format)FilterValueFormatter.getInstance((Locale)this.getLocale(), (boolean)false));
    }

    public Object getModel() {
        return this.model;
    }

    public void setModel(Object model) {
        this.model = model;
    }

    @SASScope
    public DataItemRoleProvider getDataItemRoleProvider() {
        return this.dataItemRoleProvider;
    }

    @SASScope
    public void setDataItemRoleProvider(DataItemRoleProvider dataItemRoleProvider) {
        this.dataItemRoleProvider = dataItemRoleProvider;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitleDisplayed(int isTitleDisplayed) {
        this.isTitleDisplayed = isTitleDisplayed;
    }

    public int getTitleDisplayed() {
        return this.isTitleDisplayed;
    }

    public void setNoAppliedFiltersText(String noFilterText) {
        this.noFilterText = noFilterText;
    }

    public String getNoAppliedFiltersText() {
        return this.noFilterText;
    }

    public void setNoFilterTextDisplayed(boolean isNoFilterTextDisplayed) {
        this.isNoFilterTextDisplayed = isNoFilterTextDisplayed;
    }

    public boolean isNoFilterTextDisplayed() {
        return this.isNoFilterTextDisplayed;
    }

    public void setTextWrapped(boolean textWrapped) {
        this.textWrapped = textWrapped;
    }

    public boolean isTextWrapped() {
        return this.textWrapped;
    }

    public void setParentFiltersDisplayed(boolean parentFiltersDisplayed) {
        this.parentFiltersDisplayed = parentFiltersDisplayed;
    }

    public boolean isParentFiltersDisplayed() {
        return this.parentFiltersDisplayed;
    }

    public void setConditionFormatType(String conditionFormatType) {
        if (conditionFormatType != "CONDITION_FORMAT_SYMBOL" && conditionFormatType != "CONDITION_FORMAT_TEXT") {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidConditionFormat.err.txt", this.getLocale()));
        }
        this.conditionFormatType = conditionFormatType;
    }

    public String getConditionFormatType() {
        return this.conditionFormatType;
    }

    public void setLabelSeparator(String labelSeparator) {
        this.labelSeparator = labelSeparator;
    }

    public String getLabelSeparator() {
        return this.labelSeparator;
    }

    public void setCustomFormatMap(Map customFormats) {
        this.customConditionFormats = customFormats;
    }

    public Map getCustomFormatMap() {
        return this.customConditionFormats;
    }

    public Format getRelationalFilterValueFormatter() {
        return this.relationalFilterValueFormatter;
    }

    public void setRelationalFilterValueFormatter(Format formatter) {
        this.relationalFilterValueFormatter = formatter;
    }

    public TransformInterface getRelationalFilterTextTransform() {
        return this.relationalFilterTextTransform;
    }

    public void setRelationalFilterTextTransform(TransformInterface transform) {
        this.relationalFilterTextTransform = transform;
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        String titleString;
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        super.write(out);
        StringBuffer sb = new StringBuffer();
        String noFilters = this.getNoAppliedFiltersText() != null ? this.getNoAppliedFiltersText() : this.defaultNoFilterText;
        StyleInfo divStyle = (StyleInfo)this.getStyleMap().get("APPLIEDFILTERS_DIV");
        sb.append(DIV_ID);
        sb.append(this.getId());
        sb.append(APPLIED_STATE_DIV);
        sb.append(divStyle.getClassid());
        sb.append("'");
        if (divStyle.getStyle() != null) {
            sb.append(" style='");
            sb.append(divStyle.getStyle());
            sb.append("'");
        }
        sb.append(">");
        String string = titleString = this.getTitle() != null ? this.getTitle() : this.defaultTitle;
        if (this.getTitleDisplayed() == 0 && titleString != null && titleString.length() > 0) {
            sb.append("<span ").append(this.getStyleTextInfo("APPLIEDFILTERS_TITLE")).append(">");
            sb.append(titleString).append("&#160;");
            sb.append("</span>");
        }
        if (this.model != null) {
            String securedFiltersText;
            String parentFilterText;
            StringBuffer logicalSB = new StringBuffer();
            logicalSB.append("<span ").append(this.getStyleTextInfo("APPLIEDFILTERS_LOGICAL_OPERATOR")).append(">");
            logicalSB.append(this.LOGICAL_AND);
            logicalSB.append("</span>");
            String logicalAndText = logicalSB.toString();
            DataItemRoleProvider roleProvider = this.getDataItemRoleProvider();
            if (roleProvider == null) {
                Object model = this.getModel();
                if (model instanceof BusinessQuery) {
                    roleProvider = new QueryBasedDataItemRoleProvider((BusinessQuery)model);
                } else if (model instanceof BusinessQueryProviderInterface) {
                    roleProvider = new QueryBasedDataItemRoleProvider(((BusinessQueryProviderInterface)model).getBusinessQuery());
                }
            }
            String filterText = this.getAppliedFilters(this.model, roleProvider, false);
            String string2 = parentFilterText = this.isParentFiltersDisplayed() ? this.getParentFilterText(logicalAndText) : "";
            if (parentFilterText.length() > 0) {
                if (filterText.length() > 0) {
                    filterText = !this.isTextWrapped() ? LINE_BREAK + logicalAndText + LINE_BREAK + filterText : " " + logicalAndText + " " + filterText;
                    filterText = "(" + parentFilterText + ")" + filterText;
                } else {
                    filterText = parentFilterText;
                }
            }
            if ((securedFiltersText = this.getOLAPSecuredSlicerMemberFilters()).length() > 0) {
                if (filterText.length() > 0) {
                    filterText = !this.isTextWrapped() ? filterText + LINE_BREAK : filterText + " " + logicalAndText + " ";
                    filterText = filterText + securedFiltersText;
                } else {
                    filterText = securedFiltersText;
                }
            }
            if (filterText.length() > 0) {
                if (this.getTitleDisplayed() == 4 && titleString != null && titleString.length() > 0) {
                    sb.append("<span ").append(this.getStyleTextInfo("APPLIEDFILTERS_TITLE")).append(">");
                    sb.append(titleString).append("&#160;");
                    sb.append("</span>");
                }
                if (this.getTitleDisplayed() != 2 && !this.isTextWrapped()) {
                    sb.append(LINE_BREAK);
                }
                sb.append(filterText);
            } else if (this.isNoFilterTextDisplayed() && noFilters != null && noFilters.length() > 0) {
                sb.append("<span ").append(this.getStyleTextInfo("APPLIEDFILTERS_FILTER_EXPRESSION")).append(">");
                sb.append(noFilters);
                sb.append("</span>");
            }
        } else if (this.isNoFilterTextDisplayed() && noFilters != null && noFilters.length() > 0) {
            sb.append("<span ").append(this.getStyleTextInfo("APPLIEDFILTERS_FILTER_EXPRESSION")).append(">");
            sb.append(noFilters);
            sb.append("</span>");
        }
        sb.append(END_DIV);
        out.println(sb.toString());
        this.cleanUpResources();
    }

    private String getParentFilterText(String logicalAndText) {
        BusinessQuery bq;
        String parentFilterText = "";
        DataSelection ds = null;
        if (this.model instanceof DataSelection) {
            ds = (DataSelection)this.model;
        } else if (this.model instanceof BusinessQueryProviderInterface && (bq = ((BusinessQueryProviderInterface)this.model).getBusinessQuery()) instanceof DataSelection) {
            ds = (DataSelection)bq;
        }
        if (ds != null) {
            DataSelection currentDataSelection = ds;
            while (currentDataSelection.getParentDataSelection() != null) {
                String currentParentFilterText = this.getAppliedFilters(currentDataSelection = currentDataSelection.getParentDataSelection(), null, IGNORE_ANCESTOR_STEP_FILTERS);
                if (currentParentFilterText.length() <= 0) continue;
                if (parentFilterText.length() > 0) {
                    parentFilterText = !this.isTextWrapped() ? parentFilterText + LINE_BREAK + logicalAndText + LINE_BREAK : parentFilterText + " " + logicalAndText + " ";
                }
                parentFilterText = parentFilterText + currentParentFilterText;
            }
        }
        return parentFilterText;
    }

    private String getOLAPSecuredSlicerMemberFilters() {
        Map conditionFormatMap;
        if (this.model == null || !this.isOLAP(this.model)) {
            return "";
        }
        Map defaultConditionFormatMap = this.getConditionFormatType() == "CONDITION_FORMAT_TEXT" ? this.conditionTextFormatMap : this.condtionSymbolFormatMap;
        Map customFormats = this.getCustomFormatMap();
        if (customFormats != null) {
            conditionFormatMap = new MapWithDefaults(defaultConditionFormatMap);
            ((MapWithDefaults)conditionFormatMap).setInternalMap(customFormats);
        } else {
            conditionFormatMap = defaultConditionFormatMap;
        }
        OLAPDataSetInterface dsi = null;
        BusinessQuery bq = null;
        if (this.model instanceof OLAPDataSetInterface) {
            dsi = (OLAPDataSetInterface)this.model;
        }
        if (this.model instanceof BusinessQueryProviderInterface) {
            bq = ((BusinessQueryProviderInterface)this.model).getBusinessQuery();
        } else if (this.model instanceof BusinessQuery) {
            bq = (BusinessQuery)this.model;
        }
        List filters = AppliedFiltersUtil.getSecuredSlicerMembersFilters((BusinessQuery)bq, (OLAPDataSetInterface)dsi, (Map)this.getTextStyleMap(), (Map)conditionFormatMap, (String)this.getLabelSeparator(), (boolean)this.isUseUnfilteredMetadata());
        StringBuffer sb = new StringBuffer();
        if (filters != null && filters.size() > 0) {
            int size = filters.size();
            for (int i = 0; i < size; ++i) {
                Object obj = filters.get(i);
                if (!(obj instanceof String) || ((String)obj).length() <= 0) continue;
                if (i > 0) {
                    if (this.isTextWrapped()) {
                        sb.append(" ");
                        sb.append("<span ").append(this.getStyleTextInfo("APPLIEDFILTERS_LOGICAL_OPERATOR")).append(">");
                        sb.append(this.LOGICAL_AND);
                        sb.append("</span>");
                        sb.append(" ");
                    } else {
                        sb.append(LINE_BREAK);
                    }
                }
                String text = (String)obj;
                sb.append(text);
            }
        }
        return sb.toString();
    }

    private String getAppliedFilters(Object filterModel, DataItemRoleProvider roleProvider, boolean treatAsAncestorQuery) {
        Map conditionFormatMap;
        Map defaultConditionFormatMap = this.getConditionFormatType() == "CONDITION_FORMAT_TEXT" ? this.conditionTextFormatMap : this.condtionSymbolFormatMap;
        Map customFormats = this.getCustomFormatMap();
        if (customFormats != null) {
            conditionFormatMap = new MapWithDefaults(defaultConditionFormatMap);
            ((MapWithDefaults)conditionFormatMap).setInternalMap(customFormats);
        } else {
            conditionFormatMap = defaultConditionFormatMap;
        }
        Format relationalFilterValueFormatter = this.getRelationalFilterValueFormatter();
        if (relationalFilterValueFormatter instanceof FilterValueFormatter) {
            BusinessQuery bq = null;
            if (this.model instanceof BusinessQuery) {
                bq = (BusinessQuery)this.model;
            } else if (this.model instanceof BusinessQueryProviderInterface) {
                bq = ((BusinessQueryProviderInterface)this.model).getBusinessQuery();
            }
            ((FilterValueFormatter)relationalFilterValueFormatter).setBusinessQuery(bq);
        }
        List filters = AppliedFiltersUtil.getAppliedFilters((Object)filterModel, (boolean)treatAsAncestorQuery, (DataItemRoleProvider)roleProvider, (Locale)this.getLocale(), (boolean)this.isTextWrapped(), (Map)this.getTextStyleMap(), (Map)conditionFormatMap, (Format)relationalFilterValueFormatter, (String)this.getLabelSeparator(), (int)0, (boolean)this.isUseUnfilteredMetadata(), (boolean)this.isFullyQualifyOLAPMembers(), (boolean)this.isDisplayHiddenOLAPFilterItems(), (String)this.getOLAPFilterOutputType());
        StringBuffer sb = new StringBuffer();
        if (filters != null && filters.size() > 0) {
            boolean isOLAP = this.isOLAP(filterModel);
            int size = filters.size();
            for (int i = 0; i < size; ++i) {
                Object obj = filters.get(i);
                if (obj instanceof String && ((String)obj).length() > 0) {
                    if (i > 0) {
                        if (this.isTextWrapped()) {
                            sb.append(" ");
                            sb.append("<span ").append(this.getStyleTextInfo("APPLIEDFILTERS_LOGICAL_OPERATOR")).append(">");
                            sb.append(this.LOGICAL_AND);
                            sb.append("</span>");
                            sb.append(" ");
                        } else if (isOLAP) {
                            sb.append(LINE_BREAK);
                        } else {
                            sb.append(LINE_BREAK);
                            sb.append("<span ").append(this.getStyleTextInfo("APPLIEDFILTERS_LOGICAL_OPERATOR")).append(">");
                            sb.append(this.LOGICAL_AND);
                            sb.append("</span>");
                            sb.append(LINE_BREAK);
                        }
                    }
                    String text = (String)obj;
                    TransformInterface transform = this.getRelationalFilterTextTransform();
                    if (!isOLAP && transform != null) {
                        if (transform instanceof WRSAppliedFiltersTransform) {
                            ((WRSAppliedFiltersTransform)transform).setBusinessModel(this.getBusinessModel());
                        }
                        try {
                            text = this.getRelationalFilterTextTransform().transform((Object)text).toString();
                        }
                        catch (TransformException transformException) {
                            // empty catch block
                        }
                    }
                    sb.append(text);
                    continue;
                }
                if (!(obj instanceof String[])) continue;
                String[] array = (String[])obj;
                if (array.length > 1) {
                    sb.append(array[0]);
                    sb.append(array[1]);
                }
                sb.append(LINE_BREAK);
            }
        }
        return sb.toString();
    }

    public String getAppliedFilters(Object filterModel) {
        return this.getAppliedFilters(filterModel, this.getDataItemRoleProvider(), false);
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        this.LOGICAL_AND = com.sas.dataselectors.filters.RB.getStringResource((String)"Util.", (String)"Boolean.AND.Label.txt", (Locale)locale);
        this.condtionSymbolFormatMap = AppliedFiltersUtil.getFormatMap((Locale)locale, (String)"CONDITION_FORMAT_SYMBOL", (String)"outputTypeHTML");
        this.conditionTextFormatMap = AppliedFiltersUtil.getFormatMap((Locale)locale, (String)"CONDITION_FORMAT_TEXT", (String)"outputTypeHTML");
        this.defaultTitle = com.sas.swing.models.RB.getStringResource((String)"AppliedFiltersUtil.", (String)"appliedFiltersTitle.txt", (Locale)locale);
        this.defaultNoFilterText = com.sas.swing.models.RB.getStringResource((String)"AppliedFiltersUtil.", (String)"noFiltersApplied.txt", (Locale)locale);
    }

    private Map getTextStyleMap() {
        String filterLogicalOperatorStyle;
        String filterLabelStyle;
        HashMap<String, String> textStyles = new HashMap<String, String>();
        String filterExpressionStyle = this.getStyleTextInfo("APPLIEDFILTERS_FILTER_EXPRESSION");
        if (filterExpressionStyle.length() > 0) {
            textStyles.put("Filter_Text_Span", filterExpressionStyle);
        }
        if ((filterLabelStyle = this.getStyleTextInfo("APPLIEDFILTERS_LABEL")).length() > 0) {
            textStyles.put("Filter_Label_Span", filterLabelStyle);
        }
        if ((filterLogicalOperatorStyle = this.getStyleTextInfo("APPLIEDFILTERS_LOGICAL_OPERATOR")).length() > 0) {
            textStyles.put("Logical_Operator_Span", filterLogicalOperatorStyle);
        }
        return textStyles;
    }

    private String getStyleTextInfo(String styleKey) {
        StyleInfo style = (StyleInfo)this.getStyleMap().get(styleKey);
        String styleString = "";
        if (style != null) {
            String inlineStyle;
            String classID = style.getClassid();
            if (classID != null && classID.length() > 0) {
                styleString = styleString + " class='" + classID + "'";
            }
            if ((inlineStyle = style.getStyle()) != null && inlineStyle.length() > 0) {
                styleString = styleString + " style='" + inlineStyle + "'";
            }
        }
        return styleString;
    }

    private boolean isOLAP(Object model) {
        boolean olap = false;
        if (model instanceof BusinessQueryProviderInterface) {
            BusinessQuery bq = ((BusinessQueryProviderInterface)model).getBusinessQuery();
            olap = bq.getBusinessModel().getStructure().isOLAP();
        } else if (model instanceof DataSelection) {
            DataSelection ds = (DataSelection)model;
            olap = ds.getStructure().isOLAP();
        }
        return olap;
    }

    private BusinessModel getBusinessModel() {
        if (this.model instanceof BusinessQueryProviderInterface) {
            return ((BusinessQueryProviderInterface)this.model).getBusinessQuery().getBusinessModel();
        }
        if (this.model instanceof DataSelection) {
            DataSelection ds = (DataSelection)this.model;
            return ds.getBusinessModel();
        }
        return null;
    }

    @Override
    public Map getStyleMap() {
        return this.styleMap;
    }

    @SASScope
    public boolean isUseUnfilteredMetadata() {
        return this.useUnfilteredMetadata;
    }

    @SASScope
    public void setUseUnfilteredMetadata(boolean useUnfilteredMetadata) {
        this.useUnfilteredMetadata = useUnfilteredMetadata;
    }

    public boolean isDisplayHiddenOLAPFilterItems() {
        return this.displayHiddenOLAPFilterItems;
    }

    public void setDisplayHiddenOLAPFilterItems(boolean displayHiddenOLAPFilterItems) {
        this.displayHiddenOLAPFilterItems = displayHiddenOLAPFilterItems;
    }

    public boolean isFullyQualifyOLAPMembers() {
        return this.fullyQualifyOLAPMembers;
    }

    public void setFullyQualifyOLAPMembers(boolean fullyQualifyOLAPMembers) {
        this.fullyQualifyOLAPMembers = fullyQualifyOLAPMembers;
    }

    public String getOLAPFilterOutputType() {
        return this.olapFilterOutputType;
    }

    public void setOLAPFilterOutputType(String olapFilterOutputType) {
        this.olapFilterOutputType = olapFilterOutputType;
    }
}

