/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.AJAXControllerURLInterface;
import com.sas.servlet.tbeans.BaseAjaxTreeView;
import com.sas.servlet.tbeans.ComplexStyleInterface;
import com.sas.servlet.tbeans.JavaScriptEventHandlerInterface;
import com.sas.servlet.tbeans.html.RB;
import com.sas.servlet.tbeans.html.TreeView;
import com.sas.servlet.tbeans.html.TreeViewStyleKeysInterface;
import com.sas.servlet.tbeans.models.TreeNodeInterface;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.ComponentSessionManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.Util;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.swing.tree.TreeModel;

@SASScope
public class AjaxTreeView
extends BaseAjaxTreeView
implements ComplexStyleInterface,
TreeViewStyleKeysInterface,
JavaScriptEventHandlerInterface,
AJAXControllerURLInterface {
    private static final String RB_KEY = "TreeView.";
    public static final int FULLYEXPANDED = 1;
    public static final int FULLYCOLLAPSED = 0;
    public static final int DYNAMIC = 2;
    private TreeView _treeView;
    private String remoteScriptURL;
    private String onChange = null;
    private String onFocus = null;
    private String onBlur = null;
    private String ajaxControllerURL;
    TreeView.TreeNodeTransform transform = new TreeView.DefaultTreeNodeTransform();
    public static String DEFAULT_REMOTE_SCRIPT_URL = "/MethodInvocationServlet";

    public AjaxTreeView() {
        this(Util.getName((String)"TreeView"), true, true, false, 0, 2, true, "");
    }

    public AjaxTreeView(String name) {
        this(name, true, true, false, 0, 2, true, "");
    }

    public AjaxTreeView(String name, boolean urlLinks, boolean usePlusMinus, boolean nodeSelection, int expansionLevel, int nodeLoading, boolean imageVisible, String styleClassPrefix) {
        this.createTreeView();
        this.setId(name);
        this.setUsingURLLinks(urlLinks);
        this.setUsePlusMinus(usePlusMinus);
        this.setExpansionLevel(expansionLevel);
        this.setImageVisible(imageVisible);
        this.setStyleClassPrefix(styleClassPrefix);
        this.setTarget("_blank");
        this.setSelectionMode(nodeSelection ? 1 : 0);
        this.setImageLocation(null);
        this.setUsePlusMinusLines(true);
    }

    private void createTreeView() {
        this._treeView = new TreeView(this.getId());
        this._treeView.setNodeLoading(2);
        this._treeView.setRenderUsingDivs(true);
        this._treeView.setFormEnabled(false);
        this._treeView.setJSType("TreeView");
        this._treeView.setRemoteScripting(0);
    }

    private void updateTreeView() {
        String onBlur;
        String onFocus;
        String onChange;
        String selNodeFn;
        String preSelFn;
        String preExFn;
        String postSelFn;
        String postExFn;
        String nrfn;
        String dsnfn;
        this._treeView.setUsePlusMinus(this.isUsePlusMinus());
        this._treeView.setUsingURLLinks(this.isUsingURLLinks());
        this._treeView.setImageVisible(this.isImageVisible());
        this._treeView.setStyleClassPrefix(this.getStyleClassPrefix());
        this._treeView.setTarget(this.getTarget());
        this._treeView.setSelectionMode(this.getSelectionMode());
        this._treeView.setImageLocation(this.getImageLocation());
        this._treeView.setFolderExpandCollapseEnabled(this.isFolderExpandCollapseEnabled());
        this._treeView.setRootNodeVisible(this.isRootNodeVisible());
        this._treeView.setRequest(this.getRequest());
        this._treeView.setResponse(this.getResponse());
        this._treeView.setLocale(this.getLocale());
        this._treeView.setDelayExecutionEnabled(this.isDelayExecutionEnabled());
        this._treeView.setUsePlusMinusLines(this.isUsePlusMinusLines());
        TreeModel model = this.getModel();
        if (model != null) {
            this._treeView.setModel(model);
        }
        if ((dsnfn = this.getDeselectNodeFunctionName()) != null && dsnfn.length() > 0) {
            this._treeView.setDeselectNodeFunctionName(dsnfn);
        }
        if ((nrfn = this.getNodeRendererFunctionName()) != null && nrfn.length() > 0) {
            this._treeView.setNodeRendererFunctionName(nrfn);
        }
        if ((postExFn = this.getPostExpandNodeFunctionName()) != null && postExFn.length() > 0) {
            this._treeView.setPostExpandNodeFunctionName(postExFn);
        }
        if ((postSelFn = this.getPostSelectNodeFunctionName()) != null && postSelFn.length() > 0) {
            this._treeView.setPostSelectNodeFunctionName(postSelFn);
        }
        if ((preExFn = this.getPreExpandNodeFunctionName()) != null && preExFn.length() > 0) {
            this._treeView.setPreExpandNodeFunctionName(preExFn);
        }
        if ((preSelFn = this.getPreSelectNodeFunctionName()) != null && preSelFn.length() > 0) {
            this._treeView.setPreSelectNodeFunctionName(preSelFn);
        }
        this._treeView.setSelectedNode(this.getSelectedNode());
        if (this.getSelectedNodes() != null) {
            this._treeView.setSelectedNodes(this.getSelectedNodes());
        }
        if ((selNodeFn = this.getSelectNodeFunctionName()) != null && selNodeFn.length() > 0) {
            this._treeView.setSelectNodeFunctionName(selNodeFn);
        }
        if ((onChange = this.getOnChange()) != null && onChange.length() > 0) {
            this._treeView.setOnChange(onChange);
        }
        if ((onFocus = this.getOnFocus()) != null && onFocus.length() > 0) {
            this._treeView.setOnFocus(onFocus);
        }
        if ((onBlur = this.getOnBlur()) != null && onBlur.length() > 0) {
            this._treeView.setOnBlur(onBlur);
        }
        if (this.getInitialExpansionLevel() >= -1) {
            this._treeView.setInitialExpansionLevel(this.getInitialExpansionLevel());
        } else {
            this._treeView.setExpansionLevel(this.getExpansionLevel());
        }
        this._treeView.setTransform(this.getTransform());
        this._treeView.getRemoteScriptForm().setAction(this.getRemoteScriptURL());
    }

    @Override
    public void setId(String id) {
        String previousId = this.getId();
        HttpServletRequest request = this.getRequest();
        if (previousId != null && request != null && ComponentSessionManager.getSessionManager(request).containsKey(previousId)) {
            ComponentSessionManager.getSessionManager(request).remove(previousId);
        }
        if (id != null && request != null) {
            ComponentSessionManager.getSessionManager(request).put(id, this);
        }
        super.setId(id);
        if (this._treeView != null) {
            this._treeView.setId(id);
        }
    }

    @Override
    public void setRequest(HttpServletRequest request) {
        super.setRequest(request);
        if (request != null) {
            ComponentSessionManager.getSessionManager(request).put(this.getId(), this);
        }
    }

    public Map getImageMap() {
        if (this._treeView != null) {
            return this._treeView.getImageMap();
        }
        return null;
    }

    @Override
    public Map getStyleMap() {
        if (this._treeView != null) {
            return this._treeView.getStyleMap();
        }
        return null;
    }

    public void setRemoteScriptURL(String remoteScriptURL) {
        this.remoteScriptURL = remoteScriptURL;
    }

    public String getRemoteScriptURL() {
        String value = this.remoteScriptURL;
        if (this.remoteScriptURL == null) {
            String contextPath;
            value = DEFAULT_REMOTE_SCRIPT_URL;
            if (this.getRequest() != null && (contextPath = this.getRequest().getContextPath()) != null) {
                value = contextPath + DEFAULT_REMOTE_SCRIPT_URL;
            }
        }
        return value;
    }

    static void setProperty(StringBuffer javaScript, String nodename, String propertySetter, boolean value) {
        if (value) {
            javaScript.append(nodename).append(propertySetter).append(";\n");
        }
    }

    static void setProperty(StringBuffer javaScript, String nodename, String property, String value) {
        if (value != null) {
            javaScript.append(nodename).append(property).append(value).append(";\n");
        }
    }

    static void setPropertyQuoted(StringBuffer javaScript, String nodename, String property, String value) {
        if (value != null) {
            javaScript.append(nodename).append(property).append("\"").append(value).append("\";\n");
        }
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        this.updateTreeView();
        this._treeView.write(out);
        this.writeAjaxJavaScriptProperties(out);
    }

    protected void writeAjaxJavaScriptProperties(PrintWriter out) throws IOException {
        JavaScriptIncludeHandler.writeIncludes(out, "AJAX", this.getRequest());
        String treename = this._treeView.getId();
        StringBuffer js = new StringBuffer(1024);
        js.append(JavaScriptIncludeHandler.getStartScript());
        AjaxTreeView.setProperty(js, treename, "_Obj.AJAX=true;", true);
        AjaxTreeView.setPropertyQuoted(js, treename, "_Obj.rsURL=", this._treeView.getRemoteScriptForm().getAction());
        AjaxTreeView.setPropertyQuoted(js, treename, "_Obj.CLASS_PARAMETER=", this.getClass().getName());
        AjaxTreeView.setPropertyQuoted(js, treename, "_Obj.sas_charEncoding=", BaseUtil.getOutputCharacterEncoding(this._treeView.getRequest()));
        js.append(JavaScriptIncludeHandler.getEndScript(null));
        out.println(js);
    }

    public TreeView getTreeView() {
        return this._treeView;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void servletInvocationMethod(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String treename = request.getParameter("treename");
        AjaxTreeView atv = (AjaxTreeView)request.getSession().getAttribute(treename);
        if (atv == null) {
            atv = (AjaxTreeView)ComponentSessionManager.getSessionManager(request).get(treename);
        }
        if (atv != null) {
            String charset = BaseUtil.getOutputCharacterEncoding(request);
            response.setContentType(BaseUtil.TEXT_PLAIN_MIME_TYPE + "; charset=" + charset);
            TreeView tv = atv.getTreeView();
            if (tv == null) throw new NullPointerException(RB.getStringResource(RB_KEY, "nullTreeParameter.txt", request.getLocale()));
            tv.getNodeAndExpandCollapse(request, response);
            return;
        } else {
            CommonLoggerInterface log = LoggerRepository2.getLogger((String)TreeView.class.getPackage().getName(), null);
            log.error(RB.getStringResource(RB_KEY, "nullTreeParameter.txt", request.getLocale()), (Throwable)new NullPointerException(RB.getStringResource(RB_KEY, "nullTreeParameter.txt", request.getLocale())));
        }
    }

    @Override
    public void setOnChange(String value) {
        this.onChange = value;
    }

    @Override
    public String getOnChange() {
        return this.onChange;
    }

    @Override
    public void setOnFocus(String value) {
        this.onFocus = value;
    }

    @Override
    public String getOnFocus() {
        return this.onFocus;
    }

    @Override
    public void setOnBlur(String value) {
        this.onBlur = value;
    }

    @Override
    public String getOnBlur() {
        return this.onBlur;
    }

    public TreeView.TreeNodeTransform getTransform() {
        return this.transform;
    }

    public void setTransform(TreeView.TreeNodeTransform transform) {
        this.transform = transform;
    }

    public static TreeNodeInterface findNode(String name, TreeNodeInterface node) {
        return TreeView.findNode(name, node);
    }

    public TreeNodeInterface findNode(String name) {
        if (this._treeView != null) {
            return this._treeView.findNode(name);
        }
        return null;
    }

    @Override
    public String getAJAXControllerURL() {
        if (this.ajaxControllerURL == null && this.getRequest() != null) {
            return this.getRequest().getContextPath() + "/MethodInvocationServlet";
        }
        return this.ajaxControllerURL;
    }

    @Override
    public void setAJAXControllerURL(String controllerURL) {
        this.ajaxControllerURL = controllerURL;
        this.setRemoteScriptURL(controllerURL);
    }
}

