/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.graphics.html;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.ChartImageMapInfo;
import com.sas.graphics.components.ChartValueZone;
import com.sas.graphics.components.ValueList;
import com.sas.graphics.components.VariableList;
import com.sas.servlet.tbeans.graphics.html.TileChart;
import java.util.ArrayList;

@SASScope
public class HtmlTileUtil {
    public static String[] getZoomInPath(TileChart tileChart, ChartImageMapInfo imageMap, int row) {
        if (tileChart == null) {
            return null;
        }
        if (imageMap == null) {
            return null;
        }
        ChartValueZone[] cvz = imageMap.getDataElementValueZones();
        ValueList cvzList = cvz[row].getCategoryValue();
        String[] rootTilePath = tileChart.getRootPath();
        int tileIndex = 0;
        if (rootTilePath != null) {
            tileIndex = rootTilePath.length;
        }
        String[] ss = new String[tileIndex + 1];
        int index = 0;
        int length = 0;
        for (VariableList vList = imageMap.getCategoryVariableList(); vList != null; vList = vList.getNext()) {
            ++length;
        }
        if (tileIndex >= length - 1) {
            return null;
        }
        while (cvzList != null && index <= tileIndex) {
            ss[index] = cvzList.getFormattedValue().trim();
            ++index;
            cvzList = cvzList.getNext();
        }
        return ss;
    }

    public static String getZoomInAttributePath(TileChart tileChart, ChartImageMapInfo imageMap, int row) {
        StringBuffer sb = new StringBuffer();
        String[] s = HtmlTileUtil.getZoomInPath(tileChart, imageMap, row);
        if (s == null) {
            return null;
        }
        for (int i = 0; i < s.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(s[i].length() + ",");
            sb.append(s[i]);
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    public static String getZoomOutAttributePath(TileChart tileChart, ChartImageMapInfo imageMap, int row) {
        StringBuffer sb = new StringBuffer();
        String[] s = HtmlTileUtil.getZoomOutPath(tileChart, imageMap, row);
        if (s == null) {
            return null;
        }
        for (int i = 0; i < s.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(s[i].length() + ",");
            sb.append(s[i]);
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    public static String[] getZoomOutPath(TileChart tileChart, ChartImageMapInfo imageMap, int row) {
        if (tileChart == null) {
            return null;
        }
        if (imageMap == null) {
            return null;
        }
        ChartValueZone[] cvz = imageMap.getDataElementValueZones();
        ValueList cvzList = cvz[row].getCategoryValue();
        String[] rootTilePath = tileChart.getRootPath();
        int tileIndex = 0;
        if (rootTilePath == null || rootTilePath.length <= 1) {
            return null;
        }
        tileIndex = rootTilePath.length - 1;
        String[] ss = new String[tileIndex];
        for (int index = 0; cvzList != null && index < tileIndex; ++index, cvzList = cvzList.getNext()) {
            ss[index] = cvzList.getFormattedValue().trim();
        }
        if (cvzList == null) {
            return null;
        }
        return ss;
    }

    public static String getZoomInMenuLabel(TileChart tileChart, ChartImageMapInfo imageMap, int row) {
        if (tileChart == null) {
            return null;
        }
        String[] ss = HtmlTileUtil.getZoomInPath(tileChart, imageMap, row);
        if (ss != null) {
            return ss[ss.length - 1];
        }
        return null;
    }

    public static String getZoomOutMenuLabel(TileChart tileChart, ChartImageMapInfo imageMap, int row) {
        if (tileChart == null) {
            return null;
        }
        if (imageMap == null) {
            return null;
        }
        VariableList varList = imageMap.getCategoryVariableList();
        String label = null;
        String[] rootTilePath = tileChart.getRootPath();
        int tileIndex = 0;
        if (rootTilePath != null) {
            tileIndex = rootTilePath.length;
        }
        for (int index = 0; varList != null && index < tileIndex; varList = varList.getNext(), ++index) {
            label = varList.getLabel() != null ? varList.getLabel() : varList.getColumnName();
        }
        if (label != null) {
            return label;
        }
        return null;
    }

    public static String[] getStringArrayPath(String path) {
        if (path == null) {
            return null;
        }
        int startIndex = 0;
        int endIndex = path.indexOf(",", startIndex);
        ArrayList<String> pathList = new ArrayList<String>();
        while (endIndex != -1) {
            int len = new Double(path.substring(startIndex, endIndex)).intValue();
            startIndex = endIndex + 1;
            endIndex = startIndex + len;
            pathList.add(path.substring(startIndex, endIndex));
            startIndex = endIndex + 1;
            endIndex = path.indexOf(",", startIndex);
        }
        return pathList.toArray(new String[0]);
    }
}

