/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.graphics.html;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.HttpAction;
import com.sas.codepolicy.SASScope;
import com.sas.entities.AttributeSetException;
import com.sas.graphics.components.ChartImageMapInfo;
import com.sas.graphics.components.ChartValueZone;
import com.sas.graphics.components.GraphOLAPDataSet;
import com.sas.graphics.components.PlotImageMapInfo;
import com.sas.graphics.components.PlotValueZone;
import com.sas.graphics.components.ValueList;
import com.sas.graphics.components.VariableList;
import com.sas.graphics.components.areabarchart.AreaBarChartTableDataModel;
import com.sas.graphics.components.barchart.BarChartOLAPDataModel;
import com.sas.graphics.components.barchart.BarChartTableDataModel;
import com.sas.graphics.components.barlinechart.BarLineChartOLAPDataModel;
import com.sas.graphics.components.barlinechart.BarLineChartTableDataModel;
import com.sas.graphics.components.kpichart.KPIChartTableDataModel;
import com.sas.graphics.components.linechart.LineChartOLAPDataModel;
import com.sas.graphics.components.linechart.LineChartTableDataModel;
import com.sas.graphics.components.lineplot.LinePlotTableDataModel;
import com.sas.graphics.components.mapchart.MapChartOLAPDataModel;
import com.sas.graphics.components.mapchart.MapChartTableDataModel;
import com.sas.graphics.components.piechart.PieChartOLAPDataModel;
import com.sas.graphics.components.piechart.PieChartTableDataModel;
import com.sas.graphics.components.radarchart.RadarChartOLAPDataModel;
import com.sas.graphics.components.radarchart.RadarChartTableDataModel;
import com.sas.graphics.components.riskmapplot.RiskMapPlotTableDataModel;
import com.sas.graphics.components.scatterplot.ScatterPlotOLAPDataModel;
import com.sas.graphics.components.scatterplot.ScatterPlotTableDataModel;
import com.sas.graphics.components.tilechart.TileChartOLAPDataModel;
import com.sas.graphics.components.tilechart.TileChartTableDataModel;
import com.sas.graphics.components.waterfallchart.WaterfallChartOLAPDataModel;
import com.sas.graphics.components.waterfallchart.WaterfallChartTableDataModel;
import com.sas.servlet.tbeans.features.FeatureList;
import com.sas.servlet.tbeans.graphics.BaseGraph;
import com.sas.servlet.tbeans.graphics.BaseGraphics;
import com.sas.servlet.tbeans.graphics.html.AreaBarChart;
import com.sas.servlet.tbeans.graphics.html.BarChart;
import com.sas.servlet.tbeans.graphics.html.BarLineChart;
import com.sas.servlet.tbeans.graphics.html.HtmlTileUtil;
import com.sas.servlet.tbeans.graphics.html.KPIChart;
import com.sas.servlet.tbeans.graphics.html.LineChart;
import com.sas.servlet.tbeans.graphics.html.LinePlot;
import com.sas.servlet.tbeans.graphics.html.MapChart;
import com.sas.servlet.tbeans.graphics.html.PieChart;
import com.sas.servlet.tbeans.graphics.html.RadarChart;
import com.sas.servlet.tbeans.graphics.html.RiskMapPlot;
import com.sas.servlet.tbeans.graphics.html.ScatterPlot;
import com.sas.servlet.tbeans.graphics.html.TileChart;
import com.sas.servlet.tbeans.graphics.html.WaterfallChart;
import com.sas.servlet.tbeans.graphics.html.features.GraphDnDFeature;
import com.sas.servlet.tbeans.graphics.html.features.MapFeatureInterface;
import com.sas.servlet.tbeans.menus.model.PopupMenuItem;
import com.sas.servlet.tbeans.menus.popupmenu.html.PopupMenu;
import com.sas.servlet.tbeans.olapgraphics.html.OLAPBarChart;
import com.sas.servlet.tbeans.olapgraphics.html.OLAPBarLineChart;
import com.sas.servlet.tbeans.olapgraphics.html.OLAPLineChart;
import com.sas.servlet.tbeans.olapgraphics.html.OLAPLinePlot;
import com.sas.servlet.tbeans.olapgraphics.html.OLAPMapChart;
import com.sas.servlet.tbeans.olapgraphics.html.OLAPPieChart;
import com.sas.servlet.tbeans.olapgraphics.html.OLAPRadarChart;
import com.sas.servlet.tbeans.olapgraphics.html.OLAPScatterPlot;
import com.sas.servlet.tbeans.olapgraphics.html.OLAPTileChart;
import com.sas.servlet.tbeans.olapgraphics.html.OLAPWaterfallChart;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.swing.util.ActionList;
import com.sas.swing.util.ActionUtils;
import com.sas.util.Strings;
import com.sas.util.Util;
import com.sas.util.log.LoggerRepository2;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@SASScope(value="ALL")
public class HtmlGraphUtil {
    public static void write(BaseGraphics baseGraphics, PrintWriter out) throws IOException {
        String epilog;
        String s;
        boolean isMap = false;
        String prolog = baseGraphics.getTagProlog();
        if (prolog != null) {
            out.write(prolog);
        }
        if ((s = baseGraphics.getURL()) != null && s.length() > 0) {
            isMap = true;
            if (baseGraphics.getTarget() == null) {
                out.println("<a href=\"" + s + "\">");
            } else {
                out.println("<a href=\"" + s + "\" target=\"" + baseGraphics.getTarget() + "\">");
            }
        }
        if (baseGraphics.getUseMap() != null) {
            out.print("<table cellpadding=\"0\" cellspacing=\"0\"");
            if (baseGraphics.getTableProperties() != null) {
                out.print(" " + baseGraphics.getTableProperties());
            } else {
                out.print(" borderwidth=\"0\" ");
            }
            out.println(">");
            out.println("<tr>");
            out.print("<div id=\"div" + baseGraphics.getId() + "\" style=\"position:absolute\"");
            if (baseGraphics.getTableProperties() != null) {
                out.print(" " + baseGraphics.getTableProperties());
            }
            out.println(">");
            out.println("<td>");
        } else if (baseGraphics.getTableProperties() != null) {
            out.println("<table cellpadding=\"0\" cellspacing=\"0\" " + baseGraphics.getTableProperties() + " >");
            out.println("<tr>");
            out.println("<td>");
        }
        s = baseGraphics.getId();
        if (s != null && s.length() > 0) {
            out.print("<img id=\"" + baseGraphics.getId() + "\"");
        } else {
            out.print("<img id=\"" + baseGraphics.getId() + "\"");
        }
        out.print(" onkeydown=\"return " + baseGraphics.getId() + "_menu(event);\"");
        s = baseGraphics.getImage();
        if (s != null && s.length() > 0) {
            out.print(" src=\"" + s + "\"");
        } else {
            HttpServletRequest request = baseGraphics.getRequest();
            HttpSession session = null;
            if (request != null) {
                session = request.getSession();
            }
            if (session != null) {
                String contentServletURL = request.getContextPath() + baseGraphics.getContentServletURL() + "?" + "CONTENT_KEY" + "=" + baseGraphics.getId() + "&amp;SRCID=" + Math.round(Math.random() * 100000.0) + BaseUtil.getRemoteSessionParameters(request, false);
                HttpServletResponse response = baseGraphics.getResponse();
                if (response != null) {
                    contentServletURL = response.encodeURL(contentServletURL);
                }
                out.print(" src=\"" + contentServletURL + "\"");
                session.setAttribute("sas_StreamContentServlet_ContentBytes" + baseGraphics.getId(), (Object)baseGraphics.getByteStream());
                session.setAttribute("sas_StreamContentServlet_ContentType" + baseGraphics.getId(), (Object)baseGraphics.getContentType());
                if (baseGraphics.getContentDisposition() != null) {
                    session.setAttribute("sas_StreamContentServlet_ContentDisposition" + baseGraphics.getId(), (Object)baseGraphics.getContentDisposition());
                } else {
                    session.setAttribute("sas_StreamContentServlet_ContentDisposition" + baseGraphics.getId(), (Object)("inline;filename=" + baseGraphics.getId()));
                }
                session.setAttribute("sas_StreamContentServlet_DisposeContents" + baseGraphics.getId(), (Object)(baseGraphics.isDisposeContents() ? "true" : "false"));
            }
        }
        if (!baseGraphics.isGalleryImageVisible()) {
            out.print(" galleryimg=\"no\"");
        }
        if ((s = baseGraphics.getAlternateText()) != null && s.length() > 0) {
            out.print(" alt=\"" + s + "\"");
        } else {
            out.print(" alt=\"\"");
        }
        s = baseGraphics.getAlignment();
        if (s != null && s.length() > 0) {
            out.print(" align=\"" + s + "\"");
        }
        if ((s = baseGraphics.getUseMap()) != null && s.length() > 0) {
            out.print(" usemap=\"#" + s + "\"");
        }
        Dimension defaultSize = baseGraphics.getImageSize();
        int i = baseGraphics.getWidth();
        if (i == -1 && defaultSize != null) {
            i = (int)defaultSize.getWidth();
        }
        out.print(" width=\"" + Integer.toString(i) + "\"");
        i = baseGraphics.getHeight();
        if (i == -1 && defaultSize != null) {
            i = (int)defaultSize.getHeight();
        }
        out.print(" height=\"" + Integer.toString(i) + "\"");
        i = baseGraphics.getVerticalSpace();
        if (i != -1) {
            out.print(" vspace=\"" + Integer.toString(i) + "\"");
        }
        if ((i = baseGraphics.getHorizontalSpace()) != -1) {
            out.print(" hspace=\"" + Integer.toString(i) + "\"");
        }
        if ((i = baseGraphics.getBorderWidth()) != -1) {
            out.print(" border=\"" + Integer.toString(i) + "\"");
        }
        out.print("/>");
        if (baseGraphics.getUseMap() != null) {
            out.println("</td>");
            out.println("</div>");
            out.println("</tr>");
            out.println("</table>");
        } else if (baseGraphics.getTableProperties() != null) {
            out.println("</td>");
            out.println("</tr>");
            out.println("</table>");
        }
        if (isMap) {
            out.println("</a>");
        }
        if ((epilog = baseGraphics.getTagEpilog()) != null) {
            out.write(epilog);
        }
    }

    public static void writeTooltip(PrintWriter out, BaseGraph baseGraph, Object imageMapInfo, boolean tooltipEnabled, ActionSupportFilter filter) {
        HtmlGraphUtil.writeTooltip(out, baseGraph, imageMapInfo, tooltipEnabled, filter, null);
    }

    @SASScope
    public static void writeTooltip(PrintWriter out, BaseGraph baseGraph, Object imageMapInfo, boolean tooltipEnabled, ActionSupportFilter filter, List popupMenuList) {
        int i;
        GraphDnDFeature graphDnDFeature;
        int length = 0;
        ChartValueZone[] cvz = null;
        ChartValueZone[] annovz = null;
        PlotValueZone[] pvz = null;
        ChartImageMapInfo bcimi = null;
        PlotImageMapInfo pimi = null;
        if (imageMapInfo instanceof ChartImageMapInfo) {
            bcimi = (ChartImageMapInfo)imageMapInfo;
        } else if (imageMapInfo instanceof PlotImageMapInfo) {
            pimi = (PlotImageMapInfo)imageMapInfo;
        } else {
            return;
        }
        if (bcimi != null) {
            cvz = bcimi.getDataElementValueZones();
            annovz = bcimi.getAnnotationValueZones();
            length = cvz.length;
        } else {
            pvz = pimi.getDataElementValueZones();
            length = pvz.length;
        }
        StringBuffer sb = new StringBuffer();
        StringBuffer sbAltTitle = new StringBuffer();
        StringBuffer sbLink = new StringBuffer();
        Shape shape = null;
        ArrayList label = new ArrayList();
        ArrayList value = new ArrayList();
        FeatureList features = baseGraph.getFeatures();
        MapFeatureInterface mapFeature = (MapFeatureInterface)features.find(MapFeatureInterface.class);
        if (mapFeature != null) {
            mapFeature.setImageMapInfo(imageMapInfo);
        }
        if ((graphDnDFeature = (GraphDnDFeature)features.find(GraphDnDFeature.class)) != null) {
            graphDnDFeature.setImageMapInfo(imageMapInfo);
        }
        if (annovz != null && tooltipEnabled) {
            for (i = annovz.length - 1; i >= 0; --i) {
                String annotationHTML = annovz[i].getAnnotationValue();
                if (annotationHTML == null) continue;
                shape = annovz[i].getShape();
                HtmlGraphUtil.beginArea(baseGraph, sb);
                sb.append(annotationHTML);
                HtmlGraphUtil.appendCoordAttribute(shape, sb);
                HtmlGraphUtil.endArea(sb);
                out.println(sb);
                sb.delete(0, sb.length());
            }
        }
        for (i = 0; i < length; ++i) {
            label.clear();
            value.clear();
            boolean hrefSet = false;
            if (cvz != null) {
                if (tooltipEnabled) {
                    if (bcimi.getCategoryVariableList() == null && bcimi.getColumnVariableList() != null) {
                        HtmlGraphUtil.setToolTipCombinedCategoryColumn(label, value, bcimi.getColumnVariableList(), bcimi.getRowVariableList(), cvz[i].getColumnValue(), cvz[i].getRowValue(), cvz[i].getCategoryValue());
                    } else {
                        HtmlGraphUtil.setToolTip(label, value, bcimi.getColumnVariableList(), cvz[i].getColumnValue());
                        HtmlGraphUtil.setToolTip(label, value, bcimi.getRowVariableList(), cvz[i].getRowValue());
                        HtmlGraphUtil.setToolTip(label, value, bcimi.getCategoryVariableList(), cvz[i].getCategoryValue());
                    }
                    HtmlGraphUtil.setToolTip(label, value, bcimi.getSubgroupVariableList(), cvz[i].getSubgroupValue());
                    HtmlGraphUtil.setToolTip(label, value, bcimi.getResponseVariableList(), cvz[i].getResponseValue());
                    HtmlGraphUtil.setToolTip(label, value, bcimi.getResponse2VariableList(), cvz[i].getResponse2Value());
                    HtmlGraphUtil.setToolTip(label, value, bcimi.getDataTipVariableList(), cvz[i].getDataTipValue());
                }
                shape = cvz[i].getShape();
            } else {
                if (tooltipEnabled) {
                    HtmlGraphUtil.setToolTip(label, value, pimi.getColumnVariableList(), pvz[i].getColumnValue());
                    HtmlGraphUtil.setToolTip(label, value, pimi.getRowVariableList(), pvz[i].getRowValue());
                    HtmlGraphUtil.setToolTip(label, value, pimi.getXVariableList(), pvz[i].getXValue());
                    HtmlGraphUtil.setToolTip(label, value, pimi.getGroupVariableList(), pvz[i].getGroupValue());
                    HtmlGraphUtil.setToolTip(label, value, pimi.getYVariableList(), pvz[i].getYValue());
                    HtmlGraphUtil.setToolTip(label, value, pimi.getY2VariableList(), pvz[i].getY2Value());
                    HtmlGraphUtil.setToolTip(label, value, pimi.getSizeVariableList(), pvz[i].getSizeValue());
                    HtmlGraphUtil.setToolTip(label, value, pimi.getDataTipVariableList(), pvz[i].getDataTipValue());
                }
                shape = pvz[i].getShape();
            }
            String descriptionText = null;
            String url = null;
            String target = null;
            com.sas.actionprovider.ActionList actions = null;
            if (filter != null) {
                actions = HtmlGraphUtil.getActions(i, baseGraph, imageMapInfo, filter, null);
            }
            PopupMenu popupMenu = null;
            if (actions != null) {
                popupMenu = new PopupMenu();
                popupMenu.setModel(new ArrayList());
                popupMenu.setRequest(baseGraph.getRequest());
                popupMenu.setResponse(baseGraph.getResponse());
                Iterator iter = ActionUtils.iterator((ActionList)actions);
                while (iter.hasNext()) {
                    HttpAction action;
                    Object o = iter.next();
                    if (!(o instanceof HttpAction) || !(action = (HttpAction)((Object)o)).isEnabled()) continue;
                    if ("ZOOM_IN_GRAPH_ACTION".equalsIgnoreCase(action.getActionType()) || "ZOOM_OUT_GRAPH_ACTION".equalsIgnoreCase(action.getActionType())) {
                        String menuTarget = (String)action.getValue("Target");
                        String menuUrl = (String)action.getValue("URL");
                        String menuDescriptionText = (String)action.getValue("ShortDescription");
                        HtmlGraphUtil.setPopupMenu(popupMenu, menuUrl, menuTarget, menuDescriptionText);
                        continue;
                    }
                    target = (String)action.getValue("Target");
                    url = (String)action.getValue("URL");
                    descriptionText = (String)action.getValue("ShortDescription");
                }
                if (url != null && url.length() > 0) {
                    sbLink.append(" href=\"" + url + "\" ");
                    hrefSet = true;
                }
                if (target != null && target.length() > 0) {
                    sbLink.append(" target=\"" + target + "\" ");
                }
            }
            if (label.size() == 0 && sbLink.length() == 0 && mapFeature == null) continue;
            String areaId = HtmlGraphUtil.beginArea(baseGraph, sb);
            if (mapFeature != null) {
                mapFeature.add(areaId);
            }
            if (!hrefSet && baseGraph.isMapTabIndexEnabled()) {
                sb.append(" tabindex=\"0\" ");
            }
            if (sbLink.length() > 0) {
                sb.append(sbLink);
            }
            if (popupMenu != null && popupMenu.getModel() != null && popupMenu.getModel().size() > 0) {
                HtmlGraphUtil.writePopup(baseGraph, popupMenu, areaId);
                popupMenuList.add(popupMenu);
            }
            if (label.size() > 0) {
                sbAltTitle.append(label.get(0));
                sbAltTitle.append(": ");
                sbAltTitle.append(value.get(0));
            }
            for (int j = 1; j < label.size(); ++j) {
                sbAltTitle.append("\n");
                sbAltTitle.append(label.get(j));
                sbAltTitle.append(": ");
                sbAltTitle.append(value.get(j));
            }
            if (descriptionText != null && descriptionText.length() > 0) {
                sbAltTitle.append("\n\n");
                sbAltTitle.append(descriptionText);
            }
            if (sbAltTitle.length() > 0) {
                sbAltTitle = Strings.replace((StringBuffer)sbAltTitle, (String)"\"", (String)"&quot;");
                sb.append(" alt=\"");
                sb.append(sbAltTitle);
                sb.append("\" ");
                sb.append(" title=\"");
                sb.append(sbAltTitle);
                sb.append("\" ");
            }
            HtmlGraphUtil.appendCoordAttribute(shape, sb);
            HtmlGraphUtil.endArea(sb);
            out.println(sb);
            sb.delete(0, sb.length());
            sbAltTitle.delete(0, sbAltTitle.length());
            sbLink.delete(0, sbLink.length());
        }
    }

    private static String beginArea(BaseGraph baseGraph, StringBuffer sb) {
        String areaId = baseGraph.getId() + "_area" + Util.getNumber();
        sb.append("<area id=\"" + areaId + "\" shape=\"polygon\" ");
        return areaId;
    }

    private static void endArea(StringBuffer sb) {
        sb.append("\" />\n");
    }

    private static void appendCoordAttribute(Shape shape, StringBuffer sb) {
        sb.append(" coords=\"");
        PathIterator path = shape.getPathIterator(null);
        float[] data = new float[6];
        while (!path.isDone()) {
            int type = path.currentSegment(data);
            if (type == 0) {
                sb.append((int)data[0]);
                sb.append(",");
                sb.append((int)data[1]);
            } else if (type == 1) {
                sb.append(",");
                sb.append((int)data[0]);
                sb.append(",");
                sb.append((int)data[1]);
            }
            path.next();
        }
    }

    private static void setToolTip(List label, List value, VariableList varList, ValueList valList) {
        while (varList != null && valList != null) {
            String fv = valList.getFormattedValue();
            if (fv != null) {
                label.add(varList.getLabel() != null ? varList.getLabel() : varList.getColumnName());
                value.add(fv.trim());
            }
            valList = valList.getNext();
            varList = varList.getNext();
        }
    }

    private static com.sas.actionprovider.ActionList getActions(int rowIndex, BaseGraph baseGraph, Object imageMapInfo, ActionSupportFilter filter, String[] tilePath) {
        com.sas.actionprovider.ActionList actions = null;
        try {
            if (baseGraph.getActionProvider() != null) {
                filter.setAttribute("imagemapinfo", imageMapInfo);
                filter.setAttribute("row", (Object)new Integer(rowIndex));
                if (baseGraph instanceof TileChart) {
                    filter.setAttribute("tilechart", (Object)((TileChart)baseGraph));
                    filter.setAttribute("zoomInPath", (Object)HtmlTileUtil.getZoomInAttributePath((TileChart)baseGraph, (ChartImageMapInfo)imageMapInfo, rowIndex));
                    filter.setAttribute("zoomOutPath", (Object)HtmlTileUtil.getZoomOutAttributePath((TileChart)baseGraph, (ChartImageMapInfo)imageMapInfo, rowIndex));
                    filter.setAttribute("zoominlabel", (Object)HtmlTileUtil.getZoomInMenuLabel((TileChart)baseGraph, (ChartImageMapInfo)imageMapInfo, rowIndex));
                    filter.setAttribute("zoomoutlabel", (Object)HtmlTileUtil.getZoomOutMenuLabel((TileChart)baseGraph, (ChartImageMapInfo)imageMapInfo, rowIndex));
                }
                filter.setViewerId(baseGraph.getId());
                actions = baseGraph.getActionProvider().getActions(filter);
            }
        }
        catch (AttributeSetException e) {
            LoggerRepository2.getLogger((String)HtmlGraphUtil.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        return actions;
    }

    private static void writePopup(BaseGraph baseGraph, PopupMenu popupMenu, String areaId) {
        if (popupMenu != null) {
            ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(baseGraph.getRequest());
            String launchEvent = cpm.getContextMenuLaunchEvent();
            if (launchEvent.equalsIgnoreCase("oncontextmenu")) {
                launchEvent = "onrightclick";
            }
            popupMenu.attachTo(areaId, null, launchEvent);
        }
    }

    private static void setPopupMenu(PopupMenu popupMenu, String url, String target, String description) {
        PopupMenuItem menuItem = new PopupMenuItem();
        menuItem.setText(description);
        if (url != null && url.startsWith("javascript:")) {
            menuItem.setJavascript(url.replaceFirst("javascript:", ""));
        } else {
            menuItem.setUrl(url);
        }
        popupMenu.getModel().add(menuItem);
    }

    @SASScope
    public static Object getModel(BaseGraph baseGraph) {
        Object model = null;
        if (baseGraph != null) {
            if (baseGraph instanceof OLAPBarChart && ((OLAPBarChart)baseGraph).getDataModel() != null) {
                model = ((BarChartOLAPDataModel)((OLAPBarChart)baseGraph).getDataModel()).getModel();
            } else if (baseGraph instanceof OLAPBarLineChart && ((OLAPBarLineChart)baseGraph).getDataModel() != null) {
                model = ((BarLineChartOLAPDataModel)((OLAPBarLineChart)baseGraph).getDataModel()).getModel();
            } else if (baseGraph instanceof OLAPLineChart && ((OLAPLineChart)baseGraph).getDataModel() != null) {
                model = ((LineChartOLAPDataModel)((OLAPLineChart)baseGraph).getDataModel()).getModel();
            } else if (baseGraph instanceof OLAPLinePlot && ((OLAPLinePlot)baseGraph).getDataModel() != null) {
                model = ((BarChartOLAPDataModel)((OLAPBarChart)baseGraph).getDataModel()).getModel();
            } else if (baseGraph instanceof OLAPMapChart && ((OLAPMapChart)baseGraph).getDataModel() != null) {
                model = ((MapChartOLAPDataModel)((OLAPMapChart)baseGraph).getDataModel()).getModel();
            } else if (baseGraph instanceof OLAPPieChart && ((OLAPPieChart)baseGraph).getDataModel() != null) {
                model = ((PieChartOLAPDataModel)((OLAPPieChart)baseGraph).getDataModel()).getModel();
            } else if (baseGraph instanceof OLAPRadarChart && ((OLAPRadarChart)baseGraph).getDataModel() != null) {
                model = ((RadarChartOLAPDataModel)((OLAPRadarChart)baseGraph).getDataModel()).getModel();
            } else if (baseGraph instanceof OLAPScatterPlot && ((OLAPScatterPlot)baseGraph).getDataModel() != null) {
                model = ((ScatterPlotOLAPDataModel)((OLAPScatterPlot)baseGraph).getDataModel()).getModel();
            } else if (baseGraph instanceof OLAPTileChart && ((OLAPTileChart)baseGraph).getDataModel() != null) {
                model = ((TileChartOLAPDataModel)((OLAPTileChart)baseGraph).getDataModel()).getModel();
            } else if (baseGraph instanceof OLAPWaterfallChart && ((OLAPWaterfallChart)baseGraph).getDataModel() != null) {
                model = ((WaterfallChartOLAPDataModel)((OLAPWaterfallChart)baseGraph).getDataModel()).getModel();
            } else if (baseGraph instanceof AreaBarChart && ((AreaBarChart)baseGraph).getDataModel() != null) {
                model = ((AreaBarChartTableDataModel)((AreaBarChart)baseGraph).getDataModel()).getModel();
            } else if (baseGraph instanceof BarChart && ((BarChart)baseGraph).getDataModel() != null) {
                model = ((BarChartTableDataModel)((BarChart)baseGraph).getDataModel()).getModel();
            } else if (baseGraph instanceof BarLineChart && ((BarLineChart)baseGraph).getDataModel() != null) {
                model = ((BarLineChartTableDataModel)((BarLineChart)baseGraph).getDataModel()).getModel();
            } else if (baseGraph instanceof KPIChart && ((KPIChart)baseGraph).getDataModel() != null) {
                model = ((KPIChartTableDataModel)((KPIChart)baseGraph).getDataModel()).getModel();
            } else if (baseGraph instanceof LineChart && ((LineChart)baseGraph).getDataModel() != null) {
                model = ((LineChartTableDataModel)((LineChart)baseGraph).getDataModel()).getModel();
            } else if (baseGraph instanceof LinePlot && ((LinePlot)baseGraph).getDataModel() != null) {
                model = ((LinePlotTableDataModel)((LinePlot)baseGraph).getDataModel()).getModel();
            } else if (baseGraph instanceof MapChart && ((MapChart)baseGraph).getDataModel() != null) {
                model = ((MapChartTableDataModel)((MapChart)baseGraph).getDataModel()).getModel();
            } else if (baseGraph instanceof PieChart && ((PieChart)baseGraph).getDataModel() != null) {
                model = ((PieChartTableDataModel)((PieChart)baseGraph).getDataModel()).getModel();
            } else if (baseGraph instanceof RadarChart && ((RadarChart)baseGraph).getDataModel() != null) {
                model = ((RadarChartTableDataModel)((RadarChart)baseGraph).getDataModel()).getModel();
            } else if (baseGraph instanceof RiskMapPlot && ((RiskMapPlot)baseGraph).getDataModel() != null) {
                model = ((RiskMapPlotTableDataModel)((RiskMapPlot)baseGraph).getDataModel()).getModel();
            } else if (baseGraph instanceof ScatterPlot && ((ScatterPlot)baseGraph).getDataModel() != null) {
                model = ((ScatterPlotTableDataModel)((ScatterPlot)baseGraph).getDataModel()).getModel();
            } else if (baseGraph instanceof TileChart && ((TileChart)baseGraph).getDataModel() != null) {
                model = ((TileChartTableDataModel)((TileChart)baseGraph).getDataModel()).getModel();
            } else if (baseGraph instanceof WaterfallChart && ((WaterfallChart)baseGraph).getDataModel() != null) {
                model = ((WaterfallChartTableDataModel)((WaterfallChart)baseGraph).getDataModel()).getModel();
            }
            if (model != null && model instanceof GraphOLAPDataSet) {
                model = ((GraphOLAPDataSet)model).getDelegateModel();
            }
        }
        return model;
    }

    private static void setToolTipCombinedCategoryColumn(List label, List value, VariableList colVarList, VariableList rowVarList, ValueList colValList, ValueList rowValList, ValueList catValList) {
        int i;
        String fv;
        ArrayList<String> colLabel = new ArrayList<String>();
        ArrayList<String> colValue = new ArrayList<String>();
        ArrayList<String> catLabel = new ArrayList<String>();
        ArrayList<String> catValue = new ArrayList<String>();
        while (colVarList != null && catValList != null) {
            fv = catValList.getFormattedValue();
            if (fv != null) {
                catLabel.add(colVarList.getLabel() != null ? colVarList.getLabel() : colVarList.getColumnName());
                catValue.add(fv.trim());
            }
            catValList = catValList.getNext();
            colVarList = colVarList.getNext();
        }
        while (colVarList != null && colValList != null) {
            fv = colValList.getFormattedValue();
            if (fv != null) {
                colLabel.add(colVarList.getLabel() != null ? colVarList.getLabel() : colVarList.getColumnName());
                colValue.add(fv.trim());
            }
            colValList = colValList.getNext();
            colVarList = colVarList.getNext();
        }
        for (i = 0; i < colLabel.size(); ++i) {
            label.add((String)colLabel.get(i));
            value.add((String)colValue.get(i));
        }
        HtmlGraphUtil.setToolTip(label, value, rowVarList, rowValList);
        for (i = 0; i < catLabel.size(); ++i) {
            label.add((String)catLabel.get(i));
            value.add((String)catValue.get(i));
        }
    }
}

