/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.graphics.html;

import com.sas.servlet.tbeans.BaseActionCompositeTransformation;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.dataselectors.html.ActionProviderMenuBar;
import com.sas.servlet.tbeans.dataselectors.html.RelationalMenuBar;
import com.sas.servlet.tbeans.graphics.html.GraphCompositeKeysInterface;
import com.sas.servlet.tbeans.graphics.html.GraphCompositeStyleKeysInterface;
import com.sas.servlet.tbeans.html.AppliedFilters;
import com.sas.servlet.tbeans.html.Label;
import com.sas.util.MapWithDefaults;
import com.sas.util.Util;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableModel;

public abstract class GraphComposite
extends BaseActionCompositeTransformation
implements GraphCompositeKeysInterface,
GraphCompositeStyleKeysInterface {
    private TableModel model;
    private static final HashMap defaultStyleMap = new HashMap();

    public GraphComposite(HttpServletRequest request, HttpServletResponse response) {
        this.setId(Util.getName((String)"gvc"));
        GraphComposite.setupDefaultStyleMap();
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap((Map)defaultStyleMap);
        this.setComponent("GRAPH_MENUBAR", this.getDefaultMenuBar());
        this.setComponent("GRAPH_TITLE", this.getDefaultTitle());
        this.setComponent("GRAPH_FOOTER", this.getDefaultFooter());
        this.setComponent("GRAPH_APPLIEDFILTERS", this.getDefaultAppliedFilters());
        this.setTemplateKey("Graph");
        this.setResponse(response);
        this.setRequest(request);
    }

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put("GRAPH_CONTAINER_STYLE", new ImmutableStyleInfo("GraphContainer"));
            defaultStyleMap.put("GRAPH_CONTENT_STYLE", new ImmutableStyleInfo("GraphContent"));
            defaultStyleMap.put("GRAPH_TITLE_STYLE", new ImmutableStyleInfo("GraphTitle"));
            defaultStyleMap.put("GRAPH_FOOTER_STYLE", new ImmutableStyleInfo("GraphFooter"));
            defaultStyleMap.put("GRAPH_TOOLBAR_STYLE", new ImmutableStyleInfo("GraphToolBar"));
        }
    }

    public Label getDefaultTitle() {
        Label title = new Label("GRAPH TITLE");
        title.setVisible(false);
        title.setId(this.getId() + "_title");
        return title;
    }

    public Label getDefaultFooter() {
        Label footer = new Label("GRAPH FOOTER");
        footer.setVisible(false);
        footer.setId(this.getId() + "_footer");
        return footer;
    }

    public ActionProviderMenuBar getDefaultMenuBar() {
        RelationalMenuBar mb = new RelationalMenuBar();
        mb.setActionSupportType("GRAPH_RELATIONAL_MENUBAR_SUPPORT");
        mb.setModel(this.getModel());
        mb.setVisible(false);
        mb.setId(this.getId() + "_mb");
        return mb;
    }

    public AppliedFilters getDefaultAppliedFilters() {
        AppliedFilters af = new AppliedFilters();
        af.setModel(this.getModel());
        af.setId(this.getId() + "_af");
        af.setTitleDisplayed(4);
        af.setNoFilterTextDisplayed(false);
        return af;
    }

    public TableModel getModel() {
        return this.model;
    }

    public void setModel(TableModel model) {
        if (this.getModel() != model) {
            this.model = model;
            TransformationInterface o = this.getComponent("GRAPH_MENUBAR");
            if (o != null && o instanceof RelationalMenuBar) {
                ((RelationalMenuBar)o).setModel(model);
            }
            if ((o = this.getComponent("GRAPH_APPLIEDFILTERS")) != null && o instanceof AppliedFilters) {
                ((AppliedFilters)o).setModel(model);
            }
        }
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        super.write(out);
        out.println(this.applyTemplate(this));
        this.cleanUpResources();
    }
}

