/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.graphics;

import com.objectplanet.image.PngEncoder;
import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseActionTransformation;
import com.sas.servlet.tbeans.graphics.ImagePool;
import com.sas.util.Util;
import com.sas.visuals.image.ImageFormatException;
import com.sas.visuals.image.encoder.GifEncoder;
import com.sas.visuals.image.encoder.ImageAdaptor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.JComponent;

@SASScope(value="DEFAULT")
public abstract class BaseGraphics
extends BaseActionTransformation {
    private JComponent comp;
    private String contentServletURL = "/StreamContentServlet";
    public static final String CONTENT_TYPE_GIF = "image/gif";
    public static final String CONTENT_TYPE_PNG = "image/png";
    private String contentType = "image/png";
    private String contentDisposition;
    private boolean disposeContents = false;
    private Dimension imagesize;
    private BufferedImage bimage;
    private ImagePool.ImagePoolEntry imagePoolEntry;
    private String name;
    private String image;
    private String alt;
    private String align;
    private String url;
    private int width;
    private int height;
    private int hspace;
    private int vspace;
    private int borderWidth;
    private boolean useAsForm;
    private String target;
    private String useMap;
    private String styleClassPrefix;
    private Dimension dimension = null;
    private String tableProperties = null;
    private boolean allActionsVisible;
    private boolean galleryImage;
    private boolean resizable;
    private boolean poolingOn;
    private boolean useImageIOEncoder = false;
    private static final String IMAGEIO_PNG = "png";

    public BaseGraphics(Object obj) {
        this.comp = (JComponent)obj;
        this.width = -1;
        this.height = -1;
        this.hspace = -1;
        this.vspace = -1;
        this.borderWidth = 0;
        this.setId(Util.getName((String)"gv"));
        this.allActionsVisible = true;
        this.galleryImage = false;
        this.resizable = false;
        this.poolingOn = true;
        if ("true".equalsIgnoreCase(System.getProperty("sun.pngencoder"))) {
            this.useImageIOEncoder = true;
        }
    }

    public void setTableProperties(String tableProperties) {
        this.tableProperties = tableProperties;
    }

    public String getTableProperties() {
        return this.tableProperties;
    }

    public void setOpaque(boolean opaque) {
        this.comp.setOpaque(opaque);
    }

    public boolean isOpaque() {
        return this.comp.isOpaque();
    }

    public void setGalleryImageVisible(boolean value) {
        this.galleryImage = value;
    }

    public boolean isGalleryImageVisible() {
        return this.galleryImage;
    }

    public void setSize(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    public Dimension getSize() {
        if (this.dimension == null) {
            this.dimension = new Dimension();
        }
        this.dimension.setSize(this.width, this.height);
        return this.dimension;
    }

    public Dimension getImageSize() {
        return this.imagesize;
    }

    public void setImage(String value) {
        this.image = value;
    }

    public String getImage() {
        return this.image;
    }

    public void setAlternateText(String value) {
        this.alt = value;
    }

    public String getAlternateText() {
        return this.alt;
    }

    public void setAlignment(String value) {
        this.align = value;
    }

    public String getAlignment() {
        return this.align;
    }

    public void setWidth(int value) {
        this.width = value;
        boolean vis = this.comp.isVisible();
        if (this.comp.getParent() == null) {
            this.comp.setVisible(false);
        }
        this.comp.setSize(this.width, this.comp.getHeight());
        if (this.comp.getParent() == null && vis) {
            this.comp.setVisible(true);
        }
    }

    public int getWidth() {
        int w = this.comp.getWidth();
        if (this.width != w && (this.width != -1 || w != 0)) {
            this.width = w;
        }
        return this.width;
    }

    public void setHeight(int value) {
        this.height = value;
        boolean vis = this.comp.isVisible();
        if (this.comp.getParent() == null) {
            this.comp.setVisible(false);
        }
        this.comp.setSize(this.comp.getWidth(), this.height);
        if (this.comp.getParent() == null && vis) {
            this.comp.setVisible(true);
        }
    }

    public int getHeight() {
        int h = this.comp.getHeight();
        if (this.height != h && (this.height != -1 || h != 0)) {
            this.height = h;
        }
        return this.height;
    }

    public void setHorizontalSpace(int value) {
        this.hspace = value;
    }

    public int getHorizontalSpace() {
        return this.hspace;
    }

    public void setVerticalSpace(int value) {
        this.vspace = value;
    }

    public int getVerticalSpace() {
        return this.vspace;
    }

    public void setUseAsFormElement(boolean enable) {
        this.useAsForm = enable;
    }

    public boolean getUseAsFormElement() {
        return this.useAsForm;
    }

    public void setURL(String location2) {
        this.url = location2;
    }

    public String getURL() {
        if (!this.getUseAsFormElement()) {
            return this.url;
        }
        return null;
    }

    public void setBorderWidth(int value) {
        this.borderWidth = value;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String value) {
        this.target = value;
    }

    public String getUseMap() {
        return this.useMap;
    }

    public void setUseMap(String useMap) {
        this.useMap = useMap;
    }

    public String getContentServletURL() {
        return this.contentServletURL;
    }

    public void setContentServletURL(String url) {
        this.contentServletURL = url;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public String getStyleClassPrefix() {
        return this.styleClassPrefix;
    }

    public void setStyleClassPrefix(String prefix) {
        this.styleClassPrefix = prefix;
    }

    public void setAllActionsVisible(boolean visible) {
        this.allActionsVisible = visible;
    }

    public boolean isAllActionsVisible() {
        return this.allActionsVisible;
    }

    public byte[] getByteStream() throws IOException {
        this.paint();
        ByteArrayOutputStream byteArrayStream = this.isPoolingOn() ? this.imagePoolEntry.getStream() : new ByteArrayOutputStream();
        this.encode(byteArrayStream);
        byte[] imageBytes = byteArrayStream.toByteArray();
        if (this.isPoolingOn()) {
            ImagePool.returnImage(this.imagePoolEntry);
            this.imagePoolEntry = null;
        }
        this.bimage = null;
        return imageBytes;
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (this.contentType.equals(CONTENT_TYPE_PNG)) {
            this.encodePng(outputStream);
        } else if (this.contentType.equals(CONTENT_TYPE_GIF)) {
            this.encodeGif(outputStream);
        }
    }

    private void encodeGif(OutputStream outputStream) throws IOException {
        ImageAdaptor iAdp = new ImageAdaptor((Image)this.bimage);
        boolean rc = false;
        try {
            rc = iAdp.setup();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ImageFormatException imgE) {
            BufferedImage bi = new BufferedImage(this.bimage.getWidth(null), this.bimage.getHeight(null), 13);
            bi.createGraphics().drawImage((Image)this.bimage, 0, 0, null);
            iAdp = new ImageAdaptor((Image)bi);
            try {
                rc = iAdp.setup();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ImageFormatException imageFormatException) {
                // empty catch block
            }
        }
        if (rc) {
            GifEncoder gifWriter = new GifEncoder(iAdp, outputStream);
            try {
                gifWriter.encode();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void encodePng(OutputStream outputStream) throws IOException {
        if (this.useImageIOEncoder) {
            ImageIO.setUseCache(false);
            ImageIO.write((RenderedImage)this.bimage, IMAGEIO_PNG, new BufferedOutputStream(outputStream));
        } else {
            new PngEncoder("SASPNG92", 2, 9).encode((Image)this.bimage, (OutputStream)new BufferedOutputStream(outputStream));
        }
    }

    public void paint() {
        int compHeight = this.comp.getHeight();
        int compWidth = this.comp.getWidth();
        int width = this.getWidth();
        int height = this.getHeight();
        boolean isPreferredSize = false;
        Dimension size = this.comp.getPreferredSize();
        if (width == -1 || height == -1) {
            Dimension minSize = this.comp.getMinimumSize();
            Dimension maxSize = this.comp.getMaximumSize();
            isPreferredSize = true;
            if (width == -1) {
                if (minSize != null && size.width < minSize.width) {
                    size.width = minSize.width;
                } else if (maxSize != null && size.width > maxSize.width) {
                    size.width = maxSize.width;
                }
            } else {
                size.width = width;
            }
            if (height == -1) {
                if (minSize != null && size.height < minSize.height) {
                    size.height = minSize.height;
                } else if (maxSize != null && size.height > maxSize.height) {
                    size.height = maxSize.height;
                }
            } else {
                size.height = height;
            }
        } else {
            size.height = height;
            size.width = width;
        }
        Locale cl = this.comp.getLocale();
        if (cl == null || !cl.equals(this.getLocale())) {
            this.comp.setLocale(this.getLocale());
        }
        this.imagesize = size;
        if (this.isPoolingOn()) {
            this.imagePoolEntry = ImagePool.getImage();
            this.bimage = this.imagePoolEntry.getImage(size.width, size.height, this.contentType.equals(CONTENT_TYPE_GIF) ? 9 : 1);
        } else {
            this.bimage = new BufferedImage(size.width, size.height, this.contentType.equals(CONTENT_TYPE_GIF) ? 9 : 1);
        }
        this.comp.addNotify();
        this.comp.setBounds(0, 0, size.width, size.height);
        this.prepareToPaint();
        this.comp.paintAll(this.bimage.getGraphics());
        if (isPreferredSize) {
            this.comp.setSize(compWidth, compHeight);
        }
    }

    public void prepareToPaint() {
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
    }

    public void setPoolingOn(boolean poolingOn) {
        this.poolingOn = poolingOn;
    }

    public boolean isPoolingOn() {
        return this.poolingOn;
    }

    @SASScope
    public void setDisposeContents(boolean disposeContents) {
        this.disposeContents = disposeContents;
    }

    @SASScope
    public boolean isDisposeContents() {
        return this.disposeContents;
    }
}

