/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.graphics;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.ColorScheme;
import com.sas.graphics.components.Graph;
import com.sas.graphics.components.GraphStyle;
import com.sas.graphics.components.MessageModel;
import com.sas.graphics.components.NoteModel;
import com.sas.servlet.tbeans.features.Feature;
import com.sas.servlet.tbeans.features.FeatureList;
import com.sas.servlet.tbeans.features.FeatureListInterface;
import com.sas.servlet.tbeans.graphics.BaseGraphics;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JComponent;
import javax.swing.RepaintManager;

@SASScope(value="DEFAULT")
public abstract class BaseGraph
extends BaseGraphics
implements FeatureListInterface {
    private Graph graph;
    protected Object graphObj;
    private boolean toolTipEnabled = true;
    private FeatureList features = new FeatureList();
    private boolean mapTabIndex = true;

    public BaseGraph(Object graphObj) {
        super(graphObj);
        this.graph = (Graph)graphObj;
        this.graphObj = graphObj;
        this.graph.setAutoRepaintEnabled(false);
        RepaintManager repaintManager = RepaintManager.currentManager((JComponent)this.graph);
        repaintManager.setDoubleBufferingEnabled(false);
        this.setDisplayPolicy(10000);
        this.graph.setMinimumSize(new Dimension(400, 300));
        this.graph.setMaximumSize(new Dimension(900, 900));
    }

    public Graph getGraph() {
        return this.graph;
    }

    public int getDefaultWidth() {
        return Graph.getDefaultWidth();
    }

    public int getDefaultHeight() {
        return Graph.getDefaultHeight();
    }

    public boolean isMiniumSizeSet() {
        return this.graph.isMinimumSizeSet();
    }

    public void setMinimumSize(Dimension minimumSize) {
        this.graph.setMinimumSize(minimumSize);
    }

    public Dimension getMinimumSize() {
        return this.graph.getMinimumSize();
    }

    public boolean isMaximumSizeSet() {
        return this.graph.isMaximumSizeSet();
    }

    public void setMaximumSize(Dimension maximumSize) {
        this.graph.setMaximumSize(maximumSize);
    }

    public Dimension getMaximumSize() {
        return this.graph.getMaximumSize();
    }

    public void setBackground(Color c) {
        this.graph.setBackground(c);
    }

    public Color getBackground() {
        return this.graph.getBackground();
    }

    public void paint(Graphics g) {
        this.graph.paint(g);
    }

    public void setDisplayPolicy(int newDisplayPolicy) throws IllegalArgumentException {
        this.graph.setDisplayPolicy(newDisplayPolicy);
    }

    public int getDisplayPolicy() {
        return this.graph.getDisplayPolicy();
    }

    public void setTitle(NoteModel newNoteModel, int position) throws IllegalArgumentException {
        this.graph.setTitle(newNoteModel, position);
    }

    public NoteModel getTitle(int position) throws IllegalArgumentException {
        return this.graph.getTitle(position);
    }

    public void setTitle1(NoteModel newNoteModel) throws IllegalArgumentException {
        this.graph.setTitle1(newNoteModel);
    }

    public NoteModel getTitle1() {
        return this.graph.getTitle1();
    }

    public void setTitle2(NoteModel newNoteModel) throws IllegalArgumentException {
        this.graph.setTitle2(newNoteModel);
    }

    public NoteModel getTitle2() {
        return this.graph.getTitle2();
    }

    public void setTitle3(NoteModel newNoteModel) throws IllegalArgumentException {
        this.graph.setTitle3(newNoteModel);
    }

    public NoteModel getTitle3() {
        return this.graph.getTitle3();
    }

    @Override
    public void prepareToPaint() {
        this.graph.prepareToPaint();
    }

    public void setTitle4(NoteModel newNoteModel) throws IllegalArgumentException {
        this.graph.setTitle4(newNoteModel);
    }

    public NoteModel getTitle4() {
        return this.graph.getTitle(4);
    }

    public void setFootnote(NoteModel newNoteModel, int position) throws IllegalArgumentException {
        this.graph.setFootnote(newNoteModel, position);
    }

    public NoteModel getFootnote(int position) throws IllegalArgumentException {
        return this.graph.getFootnote(position);
    }

    public void setFootnote1(NoteModel newNoteModel) throws IllegalArgumentException {
        this.graph.setFootnote1(newNoteModel);
    }

    public NoteModel getFootnote1() {
        return this.graph.getFootnote1();
    }

    public void setFootnote2(NoteModel newNoteModel) throws IllegalArgumentException {
        this.graph.setFootnote2(newNoteModel);
    }

    public NoteModel getFootnote2() {
        return this.graph.getFootnote2();
    }

    public void applyGraphStyle(GraphStyle graphStyle) {
        this.graph.applyGraphStyle(graphStyle);
    }

    public void applyColorScheme(ColorScheme scheme) {
        this.graph.applyColorScheme(scheme);
    }

    public boolean isToolTipEnabled() {
        return this.toolTipEnabled;
    }

    public void setToolTipEnabled(boolean toolTipEnabled) {
        this.toolTipEnabled = toolTipEnabled;
    }

    @SASScope
    public void setMessageModel(MessageModel messageModel) {
        this.graph.setMessageModel(messageModel);
    }

    @SASScope
    public MessageModel getMessageModel() {
        return this.graph.getMessageModel();
    }

    @SASScope
    public void addFeature(Feature feature) {
        this.features.add(feature);
    }

    @Override
    @SASScope
    public FeatureList getFeatures() {
        return this.features;
    }

    @SASScope
    public void writeFeatures(PrintWriter out) throws IOException {
        this.features.writeFeatures(this.getRequest(), out);
    }

    @SASScope
    public boolean isMapTabIndexEnabled() {
        return this.mapTabIndex;
    }

    @SASScope
    public void setMapTabIndexEnabled(boolean mapTabIndex) {
        this.mapTabIndex = mapTabIndex;
    }

    static {
        JavaScriptIncludeHandler.addAlias(BaseGraph.class, null);
    }
}

