/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.form.wml;

import com.sas.servlet.tbeans.form.BaseListBox;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.ListModel;

public class ListBox
extends BaseListBox {
    private String title;
    private String indexName;
    private ListModel onPickModel;

    public ListBox() {
        this("ListBox", null);
    }

    public ListBox(String name, ListModel model) {
        this.setName(name);
        this.setMultipleSelections(true);
        if (model != null) {
            this.setModel(model);
        }
    }

    public void setOnPickModel(ListModel model) {
        this.onPickModel = model;
    }

    public ListModel getOnPickModel() {
        return this.onPickModel;
    }

    @Override
    public void setTitle(String value) {
        this.title = value;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setIndexName(String value) {
        this.indexName = value;
    }

    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public void setSize(int value) {
    }

    @Override
    public int getSize() {
        return 0;
    }

    @Override
    public boolean getMultipleSelections() {
        return super.getMultipleSelections();
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        ListModel m1 = this.getModel();
        if (m1 == null) {
            this.cleanUpResources();
            throw new IOException("Model not set");
        }
        ListModel m2 = this.getDescriptionModel();
        if (m2 == null) {
            m2 = m1;
        }
        ListModel onPickModel = this.getOnPickModel();
        out.print("<select");
        if (this.getMultipleSelections()) {
            out.write(" multiple=\"true\"");
        }
        if (this.getName() != null) {
            out.print(" name=\"" + this.getName() + "\"");
        }
        if (this.getTitle() != null) {
            out.print(" title= \"" + this.getTitle() + "\"");
        }
        if (this.getSelectedItem() != null) {
            out.print(" value=\"" + this.getSelectedItem() + "\"");
        }
        if (this.getIndexName() != null) {
            out.print(" iname=\"" + this.getIndexName() + "\"");
        }
        out.println(">");
        boolean gotSelected = false;
        for (int i = 0; i < m1.getSize(); ++i) {
            String s = "" + m1.getElementAt(i);
            s = this.resolveSpecialCharacters(s);
            String desc = "";
            try {
                desc = "" + m2.getElementAt(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            desc = this.resolveSpecialCharacters(desc);
            String onpick = "";
            if (onPickModel != null) {
                onpick = "" + onPickModel.getElementAt(i);
            }
            onpick = this.resolveSpecialCharacters(onpick);
            out.print("<option value = \"" + s);
            if (onpick != null && !onpick.equals("")) {
                out.print("\" onpick= \"" + onpick);
            }
            out.println("\">");
            out.println(desc);
            out.println("</option>");
        }
        out.println("</select>");
        this.cleanUpResources();
    }

    private String resolveSpecialCharacters(String s) {
        s = this.resolveSpecialCharacters(s, '&');
        s = this.resolveSpecialCharacters(s, '$');
        s = this.resolveSpecialCharacters(s, '<');
        s = this.resolveSpecialCharacters(s, '>');
        s = this.resolveSpecialCharacters(s, '\'');
        s = this.resolveSpecialCharacters(s, '\"');
        return s;
    }

    private String resolveSpecialCharacters(String s, char special) {
        switch (special) {
            case '&': {
                int index = s.indexOf("&");
                if (index == -1) break;
                String before = s.substring(0, index);
                String after = s.substring(index + 1);
                after = this.resolveSpecialCharacters(after, '&');
                s = before + "&amp;" + after;
                break;
            }
            case '$': {
                int index = s.indexOf("$");
                if (index == -1) break;
                String before = s.substring(0, index);
                String after = s.substring(index + 1);
                after = this.resolveSpecialCharacters(after, '$');
                s = before + "$$" + after;
                break;
            }
            case '<': {
                int index = s.indexOf("<");
                if (index == -1) break;
                String before = s.substring(0, index);
                String after = s.substring(index + 1);
                after = this.resolveSpecialCharacters(after, '<');
                s = before + "&lt;" + after;
                break;
            }
            case '>': {
                int index = s.indexOf(">");
                if (index == -1) break;
                String before = s.substring(0, index);
                String after = s.substring(index + 1);
                after = this.resolveSpecialCharacters(after, '>');
                s = before + "&gt;" + after;
                break;
            }
            case '\'': {
                String after;
                String before;
                int index = s.indexOf("'");
                if (index != -1) {
                    before = s.substring(0, index);
                    after = s.substring(index + 1);
                    after = this.resolveSpecialCharacters(after, '\'');
                    s = before + "&apos;" + after;
                }
            }
            case '\"': {
                int index = s.indexOf("\"");
                if (index == -1) break;
                String before = s.substring(0, index);
                String after = s.substring(index + 1);
                after = this.resolveSpecialCharacters(after, '\"');
                s = before + "quot&;" + after;
            }
        }
        return s;
    }
}

