/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.form.html;

import com.sas.servlet.tbeans.StyleInterface;
import com.sas.servlet.tbeans.form.BaseTextEntry;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.Strings;
import com.sas.util.Util;
import java.io.IOException;
import java.io.PrintWriter;

public class TextEntry
extends BaseTextEntry
implements StyleInterface {
    public TextEntry() {
        this(Util.getName((String)"TextEntry"));
    }

    public TextEntry(String name) {
        this.setName(name);
        this.setId(name);
        this.setAutoComplete(true);
    }

    public TextEntry(String name, String value) {
        this.setName(name);
        this.setId(name);
        this.setText(value);
        this.setAutoComplete(true);
    }

    public TextEntry(String name, String value, int size) {
        this.setName(name);
        this.setId(name);
        this.setText(value);
        this.setSize(size);
        this.setAutoComplete(true);
    }

    public TextEntry(String name, String value, int size, int len) {
        this.setName(name);
        this.setId(name);
        this.setText(value);
        this.setSize(size);
        this.setMaximumLength(len);
        this.setAutoComplete(true);
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        String onselect;
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        this.writeValidationScript(out);
        String prolog = this.getTagProlog();
        if (prolog != null) {
            out.write(prolog);
        }
        out.print("<input type=\"text\"");
        out.print(" id=\"");
        out.print(this.getId());
        out.print("\" name=\"");
        out.print(this.getName());
        out.print("\"");
        String value = this.getText();
        char[] quote1 = new char[]{'\"'};
        String[] quote2 = new String[]{"&quot;"};
        if (value != null && value.length() > 0) {
            value = Strings.replace((String)value, (char[])quote1, (String[])quote2);
            out.print(" value=\"" + value + "\"");
        }
        String initText = this.getInitialText();
        if (value == "" && value.length() <= 0 && initText != null && initText.length() > 0) {
            initText = Strings.replace((String)initText, (char[])quote1, (String[])quote2);
            out.print(" value=\"" + initText + "\"");
        }
        if (this.getMaximumLength() > 0) {
            out.print(" maxlength=\"" + this.getMaximumLength() + "\"");
        }
        if (this.getSize() > 0) {
            out.print(" size=\"" + this.getSize() + "\"");
        }
        if ((onselect = this.getOnSelect()) != null && onselect.length() > 0) {
            out.print(" onSelect=\"" + onselect + "\"");
        }
        if (value == "" && value.length() <= 0 && initText != null && initText.length() > 0) {
            out.print(" onFocus=\"defaultText();\"");
        }
        super.write(out);
        if (this.isReadOnly()) {
            out.print(" readonly=\"readonly\"");
        }
        if (!this.isEnabled()) {
            out.print(" disabled=\"disabled\"");
        }
        if (this.disabledAutoComplete()) {
            out.print(" autocomplete=\"off\"");
        }
        out.println(" />");
        String epilog = this.getTagEpilog();
        if (epilog != null) {
            out.write(epilog);
        }
        if (value == "" && value.length() <= 0 && initText != null && initText.length() > 0) {
            this.writeDefaultText(out);
        }
        this.writeJavaScriptObject(out);
        this.cleanUpResources();
    }

    public void writeDefaultText(PrintWriter out) throws IOException {
        String tab = "   ";
        String tab2 = tab + tab;
        String tab3 = tab2 + tab;
        out.println(JavaScriptIncludeHandler.getStartScript());
        out.println("<!--");
        out.println(tab + "initialEntry = \"yes\";");
        out.println(tab + "function defaultText(){");
        out.println(tab2 + "if (initialEntry == \"yes\") {");
        out.println(tab3 + "var teObj = document.getElementById('" + this.getId() + "');");
        out.println(tab3 + "teObj.value=\" \";");
        out.println(tab3 + "initialEntry = \"no\";");
        out.println(tab2 + "}");
        out.println(tab + "}\n");
        out.println("// -->");
        out.println(JavaScriptIncludeHandler.getEndScript("This function is used to clear the initial text"));
    }

    private boolean disabledAutoComplete() {
        return !this.isAutoComplete() || !ComponentPropertyManager.getInstance(this.getRequest()).isAutoComplete();
    }
}

