/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.form.html;

import com.sas.servlet.tbeans.StyleInterface;
import com.sas.servlet.tbeans.form.BasePassword;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.util.Strings;
import com.sas.util.Util;
import java.io.IOException;
import java.io.PrintWriter;

public class Password
extends BasePassword
implements StyleInterface {
    public Password() {
        this(Util.getName((String)"Password"));
    }

    public Password(String name) {
        this.setName(name);
        this.setId(name);
        this.setAutoComplete(true);
    }

    public Password(String name, String value) {
        this.setName(name);
        this.setId(name);
        this.setText(value);
        this.setAutoComplete(true);
    }

    public Password(String name, String value, int size) {
        this.setName(name);
        this.setId(name);
        this.setText(value);
        this.setSize(size);
        this.setAutoComplete(true);
    }

    public Password(String name, String value, int size, int len) {
        this.setName(name);
        this.setId(name);
        this.setText(value);
        this.setSize(size);
        this.setMaximumLength(len);
        this.setAutoComplete(true);
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        String prolog = this.getTagProlog();
        if (prolog != null) {
            out.write(prolog);
        }
        out.print("<input type=\"password\" id=\"");
        out.print(this.getId());
        out.print("\" name=\"");
        out.print(this.getName());
        out.print("\"");
        String value = this.getText();
        char[] quote1 = new char[]{'\"'};
        String[] quote2 = new String[]{"&quot;"};
        if (value != null && value.length() > 0) {
            value = Strings.replace((String)value, (char[])quote1, (String[])quote2);
            out.print(" value=\"" + value + "\"");
        }
        if (this.getMaximumLength() > 0) {
            out.print(" maxlength=\"" + this.getMaximumLength() + "\"");
        }
        if (this.getSize() > 0) {
            out.print(" size=\"" + this.getSize() + "\"");
        }
        super.write(out);
        if (this.isReadOnly()) {
            out.print(" readonly=\"readonly\"");
        }
        if (!this.isEnabled()) {
            out.print(" disabled=\"disabled\"");
        }
        if (this.disabledAutoComplete()) {
            out.print(" autocomplete=\"off\"");
        }
        out.println(" />");
        String epilog = this.getTagEpilog();
        if (epilog != null) {
            out.write(epilog);
        }
        this.writeJavaScriptObject(out);
        this.cleanUpResources();
    }

    private boolean disabledAutoComplete() {
        return !this.isAutoComplete() || !ComponentPropertyManager.getInstance(this.getRequest()).isAutoComplete();
    }
}

