/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.form.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseButton;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.ComplexStyleInterface;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.form.BaseOrderedListComposite;
import com.sas.servlet.tbeans.form.html.ListBoxView;
import com.sas.servlet.tbeans.form.html.OrderedListStyleKeysInterface;
import com.sas.servlet.tbeans.html.Button;
import com.sas.util.Util;
import java.util.HashMap;
import javax.swing.ListModel;

@SASScope
public abstract class OrderedListComposite
extends BaseOrderedListComposite
implements OrderedListStyleKeysInterface {
    private boolean initialized;
    private static final HashMap defaultStyleMap = new HashMap();
    private static final ImmutableStyleInfo OrderedListButtonStyle = new ImmutableStyleInfo("button");
    protected ListModel model;

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            ImmutableStyleInfo immutableStyleInfo = defaultStyleMap.put("ORDERED_LIST_BUTTON", OrderedListButtonStyle);
        }
    }

    public OrderedListComposite() {
        this(Util.getName((String)"ListBoxView"));
    }

    public OrderedListComposite(String name) {
        BaseButton downButton;
        this.setId(name);
        this.setStyleClassPrefix("");
        this.setComponent("ORDERED_LIST", this);
        this.setComponent("ORDERED_LIST_COMPONENT", this.getListBoxComponent());
        HashMap<String, ImmutableStyleInfo> defaultMap = new HashMap<String, ImmutableStyleInfo>();
        defaultMap.put("BUTTON_STYLE", OrderedListButtonStyle);
        BaseButton upButton = this.getMoveUpButton();
        if (upButton instanceof ComplexStyleInterface) {
            ((Button)upButton).getStyleMap().putAll(defaultMap);
        }
        if ((downButton = this.getMoveDownButton()) instanceof ComplexStyleInterface) {
            ((Button)downButton).getStyleMap().putAll(defaultMap);
        }
        this.setComponent("ORDERED_LIST_UP_BUTTON", upButton);
        this.setComponent("ORDERED_LIST_DOWN_BUTTON", downButton);
        this.initialized = false;
    }

    protected void setDefaultComponentNames() {
        String name = this.getId();
        this.getComponent("ORDERED_LIST_COMPONENT").setName(name + "_component");
        ((BaseTransformation)this.getComponent("ORDERED_LIST_COMPONENT")).setId(name + "_component");
        this.getComponent("ORDERED_LIST_UP_BUTTON").setName(name + "_upButton");
        this.getComponent("ORDERED_LIST_DOWN_BUTTON").setName(name + "_downButton");
    }

    protected String getMoveItemsUp() {
        StringBuffer moveUp = new StringBuffer();
        moveUp.append("OrderedList_moveItemsUp('").append(this.getListBoxComponent().getId()).append("');");
        return moveUp.toString();
    }

    protected String getMoveItemsDown() {
        StringBuffer moveDown = new StringBuffer();
        moveDown.append("OrderedList_moveItemsDown('").append(this.getListBoxComponent().getId()).append("');");
        return moveDown.toString();
    }

    protected void setComponentDefaults() {
        if (!this.initialized) {
            BaseButton upButton = this.getMoveUpButton();
            upButton.setOnClick(this.getMoveItemsUp());
            if (upButton.getImage() == null && upButton.getLabel() == null) {
                upButton.setImageKey("Arrow_Up_Default");
                upButton.setImageLocation(this.imageLocation);
            }
            if (upButton.getDisabledImage() == null && upButton.getLabel() == null) {
                upButton.setDisabledImageKey("Arrow_Up_Inactive");
                upButton.setImageLocation(this.imageLocation);
            }
            BaseButton downButton = this.getMoveDownButton();
            downButton.setOnClick(this.getMoveItemsDown());
            if (downButton.getImage() == null && downButton.getLabel() == null) {
                downButton.setImageKey("Arrow_Down_Default");
                downButton.setImageLocation(this.imageLocation);
            }
            if (downButton.getDisabledImage() == null && downButton.getLabel() == null) {
                downButton.setDisabledImageKey("Arrow_Down_Inactive");
                downButton.setImageLocation(this.imageLocation);
            }
        }
    }

    @Override
    protected BaseButton getDefaultButton() {
        Button button = new Button();
        button.setRequest(this.getRequest());
        button.setResponse(this.getResponse());
        button.setLocale(this.getLocale());
        return button;
    }

    @Override
    public BaseTransformation getDefaultComponent() {
        ListBoxView listbox1 = new ListBoxView();
        return listbox1;
    }

    public ListModel getModel() {
        return this.model;
    }

    public void setModel(ListModel listModel) {
        this.model = listModel;
        ListBoxView sourceComponent = (ListBoxView)this.getListBoxComponent();
        sourceComponent.setModel(this.model);
    }

    @Override
    public void setId(String value) {
        String previousName = this.getId();
        if (previousName != null && this.getComponent("ORDERED_LIST_COMPONENT").getName().equals(previousName)) {
            this.getComponent("ORDERED_LIST_COMPONENT").setName(value);
        }
        super.setId(value);
    }
}

