/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.form.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.ScriptActivatedInterface;
import com.sas.servlet.tbeans.StyleInterface;
import com.sas.servlet.tbeans.form.BaseImage;
import com.sas.util.Strings;
import com.sas.util.Util;
import java.io.IOException;
import java.io.PrintWriter;

@SASScope(value="ALL")
public class Image
extends BaseImage
implements StyleInterface,
ScriptActivatedInterface {
    private boolean scriptActivated;

    public Image() {
        this(Util.getName((String)"Image"));
    }

    public Image(String name) {
        this(name, null);
    }

    public Image(String name, String image) {
        this(name, image, -1, -1);
    }

    public Image(String name, String image, int width, int height) {
        this.setName(name);
        this.setId(name);
        this.setImage(image);
        this.setWidth(width);
        this.setHeight(height);
        this.setWidthPercentage(0);
        this.setHeightPercentage(0);
        this.setBorderWidth(0);
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        StringBuffer sb = new StringBuffer();
        boolean formElement = this.getUseAsFormElement();
        boolean anchorTagUsed = false;
        if (this.getTagProlog() != null) {
            sb.append(this.getTagProlog());
        }
        if (formElement) {
            String id;
            sb.append("<input type=\"image\"");
            String name = this.getName();
            if (name != null && name.length() > 0) {
                sb.append(" name=\"");
                sb.append(name);
                sb.append("\"");
            }
            if ((id = this.getId()) != null && id.length() > 0) {
                sb.append(" id=\"");
                sb.append(id);
                sb.append("\"");
            }
        } else {
            String id;
            String url = this.getURL();
            if (url != null && url.length() > 0) {
                sb.append("<a href=\"");
                sb.append(url);
                if (this.getTarget() != null) {
                    sb.append("\" TARGET=\"");
                    sb.append(this.getTarget());
                }
                sb.append("\">");
                anchorTagUsed = true;
            }
            sb.append("<img");
            String name = this.getName();
            if (name != null && name.length() > 0) {
                sb.append(" name=\"");
                sb.append(name);
                sb.append("\"");
            }
            if ((id = this.getId()) != null && id.length() > 0) {
                sb.append(" id=\"");
                sb.append(id);
                sb.append("\"");
            }
        }
        String image = this.getImage();
        if (image != null && image.length() > 0) {
            sb.append(" src=\"");
            sb.append(image);
            sb.append("\"");
        }
        String altText = this.getAlternateText();
        char[] quote1 = new char[]{'\"'};
        String[] quote2 = new String[]{"&quot;"};
        if (altText != null && altText.length() > 0) {
            sb.append(" alt=\"");
            altText = Strings.replace((String)altText, (char[])quote1, (String[])quote2);
            sb.append(altText);
            sb.append("\"");
        } else {
            sb.append(" alt=\"\"");
        }
        String align = this.getAlignment();
        if (align != null && align.length() > 0) {
            sb.append(" align=\"");
            sb.append(align);
            sb.append("\"");
        }
        if (this.getWidth() != -1) {
            sb.append(" width=\"");
            sb.append(this.getWidth());
            sb.append("\"");
        } else if (this.getWidthPercentage() > 0) {
            sb.append(" width=\"").append(this.getWidthPercentage()).append("%\"");
        }
        if (this.getHeight() != -1) {
            sb.append(" height=\"");
            sb.append(this.getHeight());
            sb.append("\"");
        } else if (this.getHeightPercentage() > 0) {
            sb.append(" height=\"").append(this.getHeightPercentage()).append("%\"");
        }
        if (this.getVerticalSpace() != -1) {
            sb.append(" vspace=\"");
            sb.append(this.getVerticalSpace());
            sb.append("\"");
        }
        if (this.getHorizontalSpace() != -1) {
            sb.append(" hspace=\"");
            sb.append(this.getHorizontalSpace());
            sb.append("\"");
        }
        if (this.getBorderWidth() != -1) {
            sb.append(" border=\"");
            sb.append(this.getBorderWidth());
            sb.append("\"");
        }
        out.print(sb.toString());
        super.write(out);
        if (!this.isEnabled()) {
            out.print(" disabled=\"disabled\"");
        }
        if (anchorTagUsed) {
            out.println(" /></a>");
        } else {
            out.println(" />");
        }
        if (this.getTagEpilog() != null) {
            out.println(this.getTagEpilog());
        }
        this.writeJavaScriptObject(out);
        this.cleanUpResources();
    }

    @Override
    @SASScope
    public boolean isScriptActivated() {
        return this.scriptActivated;
    }

    @Override
    @SASScope
    public void setScriptActivated(boolean scriptActivated) {
        this.scriptActivated = scriptActivated;
    }
}

