/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.form.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.form.BaseFormElement;
import com.sas.servlet.tbeans.util.validators.DateStringValidator;
import com.sas.servlet.tbeans.util.validators.JavaScriptValidationInterface;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.Util;
import com.sas.util.validators.CompositeValidator;
import com.sas.util.validators.ValidationInterface;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.Vector;

@SASScope(value="ALL")
public class Form
extends BaseTransformation {
    public static final String DEFAULT_METHOD = "post";
    public static final String DEFAULT_ENCODE_TYPE = "application/x-www-form-urlcoded";
    public static final String DEFAULT_VALIDATION_FUNCTION_NAME = "OnSubmit";
    private Vector components = new Vector();
    private String name;
    private String method;
    private String action;
    private String enctype;
    private String validationFunctionName;
    private String onSubmitFunctionCall;
    private String processErrorsFunctionName;
    private String renderErrorsFunctionName;
    private String clearErrorsFunctionName;
    private String target;
    private String onBlur;
    private String onFocus;
    private String onKeyDown;
    private String onKeyPress;
    private String onKeyUp;
    private String onLoad;
    private String onMouseDown;
    private String onMouseUp;
    private String onReset;
    private String onSubmit;
    private String onUnload;
    private String onClick;
    private String onMouseOut;
    private String onMouseOver;
    private Boolean validationEnabled = new Boolean(false);
    private boolean autoComplete;
    @SASScope
    public static final String RB_KEY = "Form.";

    public Form() {
        this(Util.getName((String)"form"));
    }

    public Form(String name) {
        this.setName(name);
        this.setId(name);
        this.action = "";
        this.target = "";
        this.method = DEFAULT_METHOD;
        this.enctype = DEFAULT_ENCODE_TYPE;
        this.validationFunctionName = DEFAULT_VALIDATION_FUNCTION_NAME;
        this.onSubmit = DEFAULT_VALIDATION_FUNCTION_NAME;
        this.processErrorsFunctionName = "";
        this.renderErrorsFunctionName = "";
        this.clearErrorsFunctionName = "";
        this.onSubmitFunctionCall = "";
        this.onBlur = "";
        this.onFocus = "";
        this.onKeyDown = "";
        this.onKeyPress = "";
        this.onKeyUp = "";
        this.onLoad = "";
        this.onMouseDown = "";
        this.onMouseUp = "";
        this.onReset = "";
        this.onUnload = "";
        this.onClick = "";
        this.onMouseOut = "";
        this.onMouseOver = "";
        this.autoComplete = true;
    }

    @Override
    public void setName(String value) {
        if (this.name == null && value != null || this.name != null && !this.name.equals(value)) {
            this.firePropertyChange("name", this.name, value);
        }
        this.name = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public void setEncodeType(String enctype) {
        this.enctype = enctype;
    }

    public String getEncodeType() {
        return this.enctype;
    }

    public void setValidationFunctionName(String name) {
        this.validationFunctionName = name;
    }

    public String getValidationFunctionName() {
        return this.validationFunctionName;
    }

    public void setOnSubmit(String name) {
        this.onSubmit = name;
    }

    public String getOnSubmit() {
        return this.onSubmit;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getTarget() {
        return this.target;
    }

    public void setValidationEnabled(boolean validationEnabled) {
        this.validationEnabled = validationEnabled ? Boolean.TRUE : Boolean.FALSE;
    }

    @SASScope
    public boolean getValidationEnabled() {
        return this.isValidationEnabled();
    }

    public boolean isValidationEnabled() {
        if (this.validationEnabled != null) {
            return this.validationEnabled;
        }
        return false;
    }

    public void setOnBlur(String value) {
        this.onBlur = value;
    }

    public String getOnBlur() {
        return this.onBlur;
    }

    public void setOnClick(String value) {
        this.onClick = value;
    }

    public String getOnClick() {
        return this.onClick;
    }

    public void setOnFocus(String value) {
        this.onFocus = value;
    }

    public String getOnFocus() {
        return this.onFocus;
    }

    public void setOnLoad(String value) {
        this.onLoad = value;
    }

    public String getOnLoad() {
        return this.onLoad;
    }

    public void setOnKeyDown(String value) {
        this.onKeyDown = value;
    }

    public String getOnKeyDown() {
        return this.onKeyDown;
    }

    public void setOnKeyPress(String value) {
        this.onKeyPress = value;
    }

    public String getOnKeyPress() {
        return this.onKeyPress;
    }

    public void setOnKeyUp(String value) {
        this.onKeyUp = value;
    }

    public String getOnKeyUp() {
        return this.onKeyUp;
    }

    public void setOnMouseDown(String value) {
        this.onMouseDown = value;
    }

    public String getOnMouseDown() {
        return this.onMouseDown;
    }

    public void setOnMouseUp(String value) {
        this.onMouseUp = value;
    }

    public String getOnMouseUp() {
        return this.onMouseUp;
    }

    public void setOnMouseOut(String value) {
        this.onMouseOut = value;
    }

    public String getOnMouseOut() {
        return this.onMouseOut;
    }

    public void setOnMouseOver(String value) {
        this.onMouseOver = value;
    }

    public String getOnMouseOver() {
        return this.onMouseOver;
    }

    public void setOnReset(String value) {
        this.onReset = value;
    }

    public String getOnReset() {
        return this.onReset;
    }

    public void setOnUnload(String value) {
        this.onUnload = value;
    }

    public String getOnUnload() {
        return this.onUnload;
    }

    public void addComponent(TransformationInterface bean) {
        if (bean != null && !this.components.contains(bean)) {
            this.components.add(bean);
        }
    }

    public List getComponents() {
        return this.components;
    }

    public void setOnSubmitFunctionCall(String name) {
        this.onSubmitFunctionCall = name;
    }

    public String getOnSubmitFunctionCall() {
        return this.onSubmitFunctionCall;
    }

    public void setProcessErrorsFunctionName(String name) {
        this.processErrorsFunctionName = name;
    }

    public String getProcessErrorsFunctionName() {
        return this.processErrorsFunctionName;
    }

    public void setRenderErrorsFunctionName(String name) {
        this.renderErrorsFunctionName = name;
    }

    public String getRenderErrorsFunctionName() {
        return this.renderErrorsFunctionName;
    }

    public void setClearErrorsFunctionName(String name) {
        this.clearErrorsFunctionName = name;
    }

    public String getClearErrorsFunctionName() {
        return this.clearErrorsFunctionName;
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        this.writeHeader(out);
        this.cleanUpResources();
    }

    public void writeHeader(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            return;
        }
        if (this.isValidationEnabled()) {
            JavaScriptIncludeHandler.writeIncludes(out, "VALIDATOR", this.getRequest());
        }
        boolean validationsNeeded = this.isValidationNecessary();
        String prolog = this.getTagProlog();
        if (prolog != null) {
            out.write(prolog);
        }
        out.print("<form");
        this.writeAttribute(out, "name", this.getName());
        this.writeAttribute(out, "id", this.getId());
        this.writeAttribute(out, "method", this.getMethod());
        this.writeRequiredAttribute(out, "action", this.getAction());
        String s = this.getEncodeType();
        if (s != null && !s.equalsIgnoreCase(DEFAULT_ENCODE_TYPE)) {
            out.print(" enctype=\"" + s + "\"");
        }
        this.writeAttribute(out, "target", this.getTarget());
        if (validationsNeeded) {
            s = this.getOnSubmit();
            if (s != null && s.equalsIgnoreCase(DEFAULT_VALIDATION_FUNCTION_NAME) && (s = this.getValidationFunctionName()) != null && s.equalsIgnoreCase(DEFAULT_VALIDATION_FUNCTION_NAME)) {
                s = s + "_" + this.getName();
            }
            out.print(" onsubmit=\"return " + s + "(this)\"");
            this.setOnSubmitFunctionCall(s + "(" + this.getName() + ")");
        }
        this.writeAttribute(out, "onblur", this.getOnBlur());
        this.writeAttribute(out, "onclick", this.getOnClick());
        this.writeAttribute(out, "onfocus", this.getOnFocus());
        this.writeAttribute(out, "onkeydown", this.getOnKeyDown());
        this.writeAttribute(out, "onkeypress", this.getOnKeyPress());
        this.writeAttribute(out, "onkeyup", this.getOnKeyUp());
        this.writeAttribute(out, "onload", this.getOnLoad());
        this.writeAttribute(out, "onmousedown", this.getOnMouseDown());
        this.writeAttribute(out, "onmouseup", this.getOnMouseUp());
        this.writeAttribute(out, "onmouseout", this.getOnMouseOut());
        this.writeAttribute(out, "onmouseover", this.getOnMouseOver());
        this.writeAttribute(out, "onreset", this.getOnReset());
        this.writeAttribute(out, "onunload", this.getOnUnload());
        if (this.disabledAutoComplete()) {
            this.writeAttribute(out, "autocomplete", "off");
        }
        super.write(out);
        out.println(">");
    }

    private void writeAttribute(PrintWriter out, String property, String value) {
        if (value != null && value.length() > 0) {
            out.print(" " + property + "=\"" + value + "\"");
        }
    }

    private void writeRequiredAttribute(PrintWriter out, String property, String value) {
        if (value != null) {
            out.print(" " + property + "=\"" + value + "\"");
        } else {
            out.print(" " + property + "=\"\"");
        }
    }

    protected boolean isValidationNecessary() {
        boolean rc = false;
        if (this.validationEnabled.booleanValue()) {
            return this.validationEnabled;
        }
        if (this.components.size() > 0) {
            for (int i = 0; i < this.components.size(); ++i) {
                TransformationInterface bean = (TransformationInterface)this.components.get(i);
                JavaScriptValidationInterface validator = (JavaScriptValidationInterface)((BaseFormElement)bean).getValidator();
                if (validator == null) continue;
                rc = true;
                this.setValidationEnabled(true);
            }
        }
        return rc;
    }

    protected boolean writeValidations(PrintWriter out) throws IOException {
        boolean rc = false;
        boolean dateVariablesWritten = false;
        String tab = "   ";
        String tab2 = tab + tab;
        String tab3 = tab2 + tab;
        if (this.isValidationEnabled() && this.components.size() > 0) {
            out.println(JavaScriptIncludeHandler.getStartScript());
            out.println("<!--");
            out.println(tab + "// Validate fields before submitting");
            out.println("");
            out.println("");
            out.println(tab + "document." + this.getName() + ".failedValidationElements = new Array();");
            this.writeValidationFormProps(out, "processErrors", this.getProcessErrorsFunctionName(), "sas_Form_processErrors");
            this.writeValidationFormProps(out, "renderErrors", this.getRenderErrorsFunctionName(), "sas_Form_renderErrorsAlert");
            this.writeValidationFormProps(out, "clearErrors", this.getClearErrorsFunctionName(), "sas_Form_clearErrors");
            for (int b = 0; b < this.components.size(); ++b) {
                TransformationInterface tbean = (TransformationInterface)this.components.get(b);
                ValidationInterface val1 = ((BaseFormElement)tbean).getValidator();
                if (val1 instanceof CompositeValidator) {
                    List valList = ((CompositeValidator)val1).getValidators();
                    for (int c = 0; c < valList.size(); ++c) {
                        JavaScriptValidationInterface val2 = (JavaScriptValidationInterface)valList.get(c);
                        dateVariablesWritten = this.writeDateValidationVars(out, dateVariablesWritten, val2);
                    }
                    continue;
                }
                dateVariablesWritten = this.writeDateValidationVars(out, dateVariablesWritten, val1);
            }
            String valName = this.getOnSubmit();
            if (valName.equalsIgnoreCase(DEFAULT_VALIDATION_FUNCTION_NAME) && (valName = this.getValidationFunctionName()).equalsIgnoreCase(DEFAULT_VALIDATION_FUNCTION_NAME)) {
                valName = valName + "_" + this.getName();
            }
            out.println("");
            out.println("");
            out.println(tab + "function " + valName + "(theForm) {");
            out.println(tab2 + "document." + this.getName() + ".clearErrors(theForm);");
            for (int i = 0; i < this.components.size(); ++i) {
                Vector writtenValidationList = new Vector();
                TransformationInterface bean = (TransformationInterface)this.components.get(i);
                ValidationInterface validator = ((BaseFormElement)bean).getValidator();
                if (validator instanceof CompositeValidator) {
                    List validators = ((CompositeValidator)validator).getValidators();
                    for (int k = 0; k < validators.size(); ++k) {
                        JavaScriptValidationInterface val = (JavaScriptValidationInterface)validators.get(k);
                        if (val == null) continue;
                        this.writeValidation(out, bean, val, writtenValidationList);
                    }
                    continue;
                }
                this.writeValidation(out, bean, validator, writtenValidationList);
            }
            out.println("");
            out.println("");
            out.println(tab2 + "if (document." + this.getName() + ".failedValidationElements.length > 0) {");
            out.println(tab3 + "document." + this.getName() + ".processErrors(theForm);");
            out.println(tab3 + "return false;");
            out.println(tab2 + "}");
            out.println(tab2 + "else {");
            out.println(tab3 + "return true;");
            out.println(tab2 + "}");
            out.println(tab + "}");
            out.println("");
            out.println("");
            out.println("// -->");
            out.println(JavaScriptIncludeHandler.getEndScript(null));
            rc = true;
        }
        return rc;
    }

    private void writeValidationFormProps(PrintWriter out, String propName, String func, String defaultFunc) {
        if (func == null || func.length() < 1) {
            func = defaultFunc;
        }
        out.println("    document." + this.getName() + "." + propName + " = " + func + ";");
    }

    private boolean writeDateValidationVars(PrintWriter out, boolean dateVariablesWritten, ValidationInterface val1) {
        if (val1 instanceof DateStringValidator && !dateVariablesWritten) {
            out.println("var sas_Validator_monthValueArr={" + ((DateStringValidator)val1).getMonthValueString(this.getLocale()) + "}");
            out.println("var sas_Validator_shortMonthPat=new RegExp(/" + ((DateStringValidator)val1).getShortMonthString(this.getLocale()) + "/i);");
            out.println("var sas_Validator_fullMonthPat=new RegExp(/" + ((DateStringValidator)val1).getFullMonthString(this.getLocale()) + "/i);");
            dateVariablesWritten = true;
        }
        return dateVariablesWritten;
    }

    private void writeValidation(PrintWriter out, TransformationInterface bean, ValidationInterface validator, Vector writtenValidationList) {
        boolean found = false;
        if (validator == null) {
            return;
        }
        String jsFunctionCall = ((JavaScriptValidationInterface)validator).createValidationFunctionCall(bean);
        for (int m = 0; m < writtenValidationList.size(); ++m) {
            String writtenCalls = (String)writtenValidationList.get(m);
            if (!writtenCalls.equals(jsFunctionCall)) continue;
            found = true;
        }
        if (!found) {
            out.println("      " + jsFunctionCall + ";");
            writtenValidationList.addElement(jsFunctionCall);
        }
    }

    public void writeHeader(Writer out) throws IOException {
        this.writeHeader(new PrintWriter(out));
    }

    public void writeHeader(OutputStream out) throws IOException {
        this.writeHeader(new PrintWriter(out));
    }

    public void writeFooter(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            return;
        }
        out.println("</form>");
        boolean validationsNeeded = this.writeValidations(out);
        String epilog = this.getTagEpilog();
        if (epilog != null) {
            out.write(epilog);
        }
    }

    public void writeFooter(Writer out) throws IOException {
        this.writeFooter(new PrintWriter(out));
    }

    public void writeFooter(OutputStream out) throws IOException {
        this.writeFooter(new PrintWriter(out));
    }

    public void setAutoComplete(boolean value) {
        this.autoComplete = value;
    }

    public boolean isAutoComplete() {
        return this.autoComplete;
    }

    private boolean disabledAutoComplete() {
        return !this.isAutoComplete() || !ComponentPropertyManager.getInstance(this.getRequest()).isAutoComplete();
    }

    static {
        JavaScriptIncludeHandler.addAlias(Form.class, "VALIDATOR");
    }
}

