/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.form.html;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.servlet.tbeans.StyleInterface;
import com.sas.servlet.tbeans.form.BaseChoiceBox;
import com.sas.servlet.tbeans.models.Item;
import com.sas.servlet.tbeans.models.JavaScriptNode;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.Strings;
import com.sas.util.Util;
import com.sas.util.ValueItem;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;

public class ChoiceBox
extends BaseChoiceBox
implements StyleInterface {
    public ChoiceBox() {
        this(Util.getName((String)"ChoiceBox"), new DefaultComboBoxModel());
    }

    public ChoiceBox(String name, ComboBoxModel model) {
        this.setName(name);
        this.setId(name);
        this.setModel(model);
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        this.writeValidationScript(out);
        String prolog = this.getTagProlog();
        if (prolog != null) {
            out.write(prolog);
        }
        ComboBoxModel model = this.getModel();
        ComboBoxModel model2 = this.getDescriptionModel();
        if (model2 == null) {
            model2 = model;
        }
        boolean urlUsed = false;
        int modSize = model.getSize();
        int maxElementSize = 0;
        for (int i = 0; i <= modSize - 1; ++i) {
            Object n = model.getElementAt(i);
            String nText = "";
            if (n instanceof Item) {
                nText = ((Item)n).getText();
            } else if (n instanceof ValueItem) {
                nText = this.getValueItemLabel((ValueItem)n);
            } else if (n != null) {
                nText = n.toString();
            }
            if (nText == null || nText.length() <= maxElementSize) continue;
            maxElementSize = nText.length();
        }
        out.print("<select id=\"");
        out.print(this.getId());
        out.print("\" name=\"");
        out.print(this.getName());
        out.print("\" size=\"1\"");
        super.write(out);
        if (!this.isEnabled()) {
            out.print(" disabled=\"disabled\"");
        }
        out.println("style=\"z-index:1;\">");
        char[] quote1 = new char[]{'\"', '>', '<'};
        String[] quote2 = new String[]{"&quot;", "&gt;", "&lt;"};
        String s = "";
        String desc = "";
        this.getSeparatorIndices().clear();
        for (int i = 0; i <= modSize - 1; ++i) {
            Item node;
            Object item = model.getElementAt(i);
            if (item instanceof Item) {
                node = (Item)model.getElementAt(i);
                s = node.getValue();
                desc = node.getText();
            } else if (item instanceof ValueItem) {
                node = (ValueItem)item;
                s = node.getValue() instanceof SpecialValues ? ((SpecialValues)node.getValue()).getName() : (node.getValue() instanceof MissingValues ? MissingValues.toQueryString((MissingValues)((MissingValues)node.getValue())) : (node.getValue() != null ? (node.getValue() instanceof Date ? node.getLabel(this.getLocale()) : node.getValueAsString(this.getLocale())) : null));
                if ("-SEPARATOR-".equals(s)) {
                    item = new Item("", "");
                    desc = ((Item)item).getText();
                    s = ((Item)item).getValue();
                    ((Item)item).setUseAsSeparator(true);
                } else {
                    desc = this.getValueItemLabel((ValueItem)node);
                }
            } else if (item != null) {
                s = item.toString();
                if (s != null && s.equals("")) {
                    try {
                        desc = model2.getElementAt(i).toString();
                    }
                    catch (Exception node2) {}
                } else {
                    desc = s;
                }
            }
            String desc2 = "";
            String s2 = "";
            if (s != null && s.length() > 0) {
                s2 = s;
                desc2 = desc == null || desc.length() < 1 ? s2 : desc;
            } else if (desc != null && desc.length() > 0) {
                desc2 = desc;
                if (!(s != null && s.length() >= 1 || this.isNullReturnValuesAllowed())) {
                    s2 = desc2;
                }
            }
            if (item instanceof Item) {
                String onmouseup;
                String onmouseover;
                String onmouseout;
                String onmousedown;
                String onkeyup;
                String onkeypress;
                String onkeydown;
                String onfocus;
                String onclick;
                String onchange;
                String onblur;
                String name;
                String nodeURL;
                Item tempNode = (Item)item;
                if (tempNode.isUseAsSeparator()) {
                    this.getSeparatorIndices().add(new Integer(i));
                    out.print("<optgroup label='");
                    String dividerLine = "-----";
                    for (int d = 0; d < maxElementSize; ++d) {
                        dividerLine = dividerLine + "-";
                    }
                    out.print(dividerLine);
                    out.println("'></optgroup>");
                    continue;
                }
                if (item instanceof JavaScriptNode && (nodeURL = ((JavaScriptNode)tempNode).getLaunchURL()) != null && nodeURL.length() > 0) {
                    urlUsed = true;
                    this.setJavaScriptObjectCreationEnabled(true);
                }
                out.print("<option ");
                boolean selected = this.isSelected(i);
                if (!selected) {
                    selected = this.isSelected(s2);
                }
                if (selected) {
                    out.print("selected=\"selected\" ");
                }
                if ((name = tempNode.getName()) != null && name.length() > 0) {
                    out.print(" id=\"_" + name + "\"");
                }
                if ((onblur = tempNode.getOnBlur()) != null && onblur.length() > 0) {
                    out.print(" onblur=\"" + onblur + "\"");
                }
                if ((onchange = tempNode.getOnChange()) != null && onchange.length() > 0) {
                    out.print(" onchange=\"" + onchange + "\"");
                }
                if ((onclick = tempNode.getOnClick()) != null && onclick.length() > 0) {
                    out.print(" onclick=\"" + onclick + "\"");
                }
                if ((onfocus = tempNode.getOnFocus()) != null && onfocus.length() > 0) {
                    out.print(" onfocus=\"" + onfocus + "\"");
                }
                if ((onkeydown = tempNode.getOnKeyDown()) != null && onkeydown.length() > 0) {
                    out.print(" onkeydown=\"" + onkeydown + "\"");
                }
                if ((onkeypress = tempNode.getOnKeyPress()) != null && onkeypress.length() > 0) {
                    out.print(" onkeypress=\"" + onkeypress + "\"");
                }
                if ((onkeyup = tempNode.getOnKeyUp()) != null && onkeyup.length() > 0) {
                    out.print(" onkeyup=\"" + onkeyup + "\"");
                }
                if ((onmousedown = tempNode.getOnMouseDown()) != null && onmousedown.length() > 0) {
                    out.print(" onmousedown=\"" + onmousedown + "\"");
                }
                if ((onmouseout = tempNode.getOnMouseOut()) != null && onmouseout.length() > 0) {
                    out.print(" onmouseout=\"" + onmouseout + "\"");
                }
                if ((onmouseover = tempNode.getOnMouseOver()) != null && onmouseover.length() > 0) {
                    out.print(" onmouseover=\"" + onmouseover + "\"");
                }
                if ((onmouseup = tempNode.getOnMouseUp()) != null && onmouseup.length() > 0) {
                    out.print(" onmouseup=\"" + onmouseup + "\"");
                }
                s2 = Strings.replace((String)s2, (char[])quote1, (String[])quote2);
                desc2 = Strings.replace((String)desc2, (char[])quote1, (String[])quote2);
                out.print(" value=\"" + s2 + "\">");
                int indentLvl = tempNode.getIndentionLevel();
                if (indentLvl > 0) {
                    for (int d = 1; d <= indentLvl; ++d) {
                        out.print("&#160;");
                    }
                }
                if (this.isEncodeWhiteSpace()) {
                    desc2 = Strings.replace((String)desc2, (int)0, (int)-1, (String)" ", (String)"&#160;");
                }
                out.print(desc2);
                out.println("</option>");
                continue;
            }
            out.print("<option ");
            boolean selected = this.isSelected(i);
            if (!selected) {
                selected = this.isSelected(s2);
            }
            if (selected) {
                out.print("selected=\"selected\" ");
            }
            s2 = Strings.replace((String)s2, (char[])quote1, (String[])quote2);
            desc2 = Strings.replace((String)desc2, (char[])quote1, (String[])quote2);
            if (this.isEncodeWhiteSpace()) {
                desc2 = Strings.replace((String)desc2, (int)0, (int)-1, (String)" ", (String)"&#160;");
            }
            out.println(" value=\"" + s2 + "\">" + desc2 + "</option>");
        }
        out.println("</select>");
        String epilog = this.getTagEpilog();
        if (epilog != null) {
            out.write(epilog);
        }
        this.writeJavaScriptObject(out);
        if (urlUsed) {
            this.writeLaunchFunction(out);
        }
        this.cleanUpResources();
    }

    protected void writeLaunchFunction(PrintWriter out) throws IOException {
        out.println(JavaScriptIncludeHandler.getStartScript());
        out.println("var " + this.getId() + "_selObj = sas_getJavaScriptObject('" + this.getId() + "');");
        out.println(this.getId() + "_selObj.nodes = new Array();    //the array of items (nodes)");
        String constructorName = "";
        String paramsForJS = "";
        Map args = null;
        JavaScriptNode nde = new JavaScriptNode();
        int modSize = this.model.getSize();
        if (modSize > 0) {
            for (int i = 0; i <= modSize - 1; ++i) {
                if (!(this.model.getElementAt(i) instanceof Item) || (nde = (JavaScriptNode)this.model.getElementAt(i)).isUseAsSeparator()) continue;
                nde.setParentId(this.getId());
                constructorName = nde.getNodeConstructorName();
                args = nde.getNodeConstructorParameters();
                paramsForJS = nde.createNodeParameterString(args);
                out.println(this.getId() + "_selObj.nodes[" + this.getId() + "_selObj.nodes.length] = new " + constructorName + "({" + paramsForJS + "});");
            }
        }
        out.println("var " + this.getId() + "_comboSelect = document.getElementById(\"" + this.getId() + "\");");
        if (this.getOnChange() != null && this.getOnChange().length() > 0) {
            out.println("sas_registerEventHandler(" + this.getId() + "_comboSelect, 'change', function(event){ " + this.getOnChange() + "; sas_FormBean_choiceBoxLaunch('" + this.getId() + "');}, false);");
        } else {
            out.println("sas_registerEventHandler(" + this.getId() + "_comboSelect, 'change', function(event){ sas_FormBean_choiceBoxLaunch('" + this.getId() + "'); }, false);");
        }
        out.println(JavaScriptIncludeHandler.getEndScript(null));
    }
}

