/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.form.html;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.servlet.tbeans.form.html.ListBoxView;
import com.sas.servlet.tbeans.models.JavaScriptNode;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;

@SASScope(value="ALL")
@SubjectToChange
public class CheckBoxList
extends ListBoxView {
    private static final String NAME_PREFIX = "CheckBoxList";
    private boolean labelSelectionEnabled;

    public CheckBoxList() {
        this(Util.getName((String)NAME_PREFIX), new DefaultListModel());
    }

    public CheckBoxList(ListModel model) {
        this(Util.getName((String)NAME_PREFIX), model);
    }

    public CheckBoxList(String name, ListModel model) {
        this.setName(name);
        this.setId(name);
        this.setModel(model);
        this.setListConstructorName("sas_CheckBoxList_NodeList");
        this.setType(NAME_PREFIX);
        this.labelSelectionEnabled = true;
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        JavaScriptIncludeHandler.writeIncludes(out, "CHECKBOXLIST", this.getRequest());
        ListModel model = this.getModel();
        int modSize = model.getSize();
        if (modSize > 0) {
            for (int i = 0; i <= modSize - 1; ++i) {
                if (!(model.getElementAt(i) instanceof JavaScriptNode)) continue;
                JavaScriptNode checkBoxListNode = (JavaScriptNode)model.getElementAt(i);
                checkBoxListNode.setRenderNodeFunctionName("sas_Node_checkBoxListRenderer");
                String selectNodeFuncName = this.getSelectNodeFunctionName();
                if (selectNodeFuncName != null && selectNodeFuncName.length() > 0) {
                    checkBoxListNode.setSelectNodeFunctionName(selectNodeFuncName);
                } else {
                    checkBoxListNode.setSelectNodeFunctionName("sas_Node_checkBoxSelect");
                }
                String deselectNodeFuncName = this.getDeselectNodeFunctionName();
                if (deselectNodeFuncName != null && deselectNodeFuncName.length() > 0) {
                    checkBoxListNode.setDeselectNodeFunctionName(deselectNodeFuncName);
                    continue;
                }
                checkBoxListNode.setDeselectNodeFunctionName("sas_Node_checkBoxDeselect");
            }
        }
        super.write(out);
    }

    @SASScope
    public void setLabelSelectionEnabled(boolean value) {
        this.labelSelectionEnabled = value;
    }

    @SASScope
    public boolean isLabelSelectionEnabled() {
        return this.labelSelectionEnabled;
    }

    @Override
    protected void writeAdditionalInitParams(PrintWriter out) {
        String tab = "   ";
        out.println(tab + this.getName() + ".labelSelectionEnabled = " + this.isLabelSelectionEnabled() + ";");
    }

    static {
        JavaScriptIncludeHandler.addAlias(CheckBoxList.class, "CHECKBOXLIST");
    }
}

