/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.form;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.form.BaseFormElement;
import com.sas.servlet.tbeans.form.RB;
import com.sas.servlet.tbeans.models.Item;
import java.io.IOException;
import javax.swing.ListModel;
import javax.swing.SwingConstants;

@SASScope(value="ALL")
public abstract class BaseRadio
extends BaseFormElement
implements SwingConstants {
    public static final String RB_KEY = "BaseFormElement.";
    private int selected;
    private String selectedItem;
    private boolean breakAfter = true;
    private boolean labelVisible = true;
    private boolean labelBolding = false;
    private int labelOrientation;
    private ListModel descModel;
    private boolean horizontalAlignment = false;
    private String tableAlignment;
    private boolean validateSelection = false;
    private boolean encodeWhiteSpace = false;
    protected ListModel model;

    public BaseRadio() {
        this.setObjectDataProperty("selectedItem");
        this.setModificationEventName("onClick");
        this.selected = -1;
        this.selectedItem = null;
        this.tableAlignment = "";
        this.labelOrientation = -1;
    }

    public ListModel getModel() {
        return this.model;
    }

    public void setModel(ListModel listModel) {
        this.model = listModel;
    }

    public int getLabelOrientation() {
        return this.labelOrientation;
    }

    public void setLabelOrientation(int orientation) {
        switch (orientation) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.labelOrientation = orientation;
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidOrientation.txt", this.getLocale()));
            }
        }
    }

    public void setSelectedIndex(int value) throws IOException {
        if (this.model != null) {
            if (value < -1 || value > this.model.getSize() - 1) {
                if (this.isValidateSelection()) {
                    throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invRange.txt", this.getLocale()));
                }
                value = -1;
            }
            this.selected = value;
            if (this.selected == -1) {
                this.selectedItem = null;
            } else if (this.model.getElementAt(this.selected) instanceof Item) {
                Item item = (Item)this.model.getElementAt(this.selected);
                String tempItem = item.getValue();
                if (tempItem != null && tempItem.length() > 0) {
                    this.selectedItem = tempItem;
                } else {
                    tempItem = item.getText();
                    if (tempItem != null && tempItem.length() > 0) {
                        this.selectedItem = tempItem;
                    }
                }
            } else {
                this.selectedItem = this.model.getElementAt(this.selected).toString();
            }
        }
    }

    public void setSelectedItem(String value) throws IOException {
        if (this.model != null) {
            if (value == null) {
                this.selected = -1;
                this.selectedItem = null;
            } else {
                boolean found = false;
                int modSize = this.model.getSize();
                for (int i = 0; i <= modSize - 1 && !found; ++i) {
                    if (this.model.getElementAt(i) instanceof Item) {
                        Item tempNode = (Item)this.model.getElementAt(i);
                        String tempVal = tempNode.getValue();
                        if (tempVal != null && tempVal.length() > 0) {
                            if (tempVal.equals(value)) {
                                this.selected = i;
                                this.selectedItem = tempVal;
                                found = true;
                                continue;
                            }
                            tempVal = tempNode.getText();
                            if (tempVal == null || tempVal.length() <= 0 || !tempVal.equals(value)) continue;
                            this.selected = i;
                            this.selectedItem = tempVal;
                            found = true;
                            continue;
                        }
                        tempVal = tempNode.getText();
                        if (tempVal == null || tempVal.length() <= 0 || !tempVal.equals(value)) continue;
                        this.selected = i;
                        this.selectedItem = tempVal;
                        found = true;
                        continue;
                    }
                    String tempVal = this.model.getElementAt(i).toString();
                    if (!tempVal.equals(value)) continue;
                    this.selected = i;
                    this.selectedItem = value;
                    found = true;
                }
                if (!found && this.isValidateSelection()) {
                    throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invSelection.txt", this.getLocale()));
                }
            }
        }
    }

    public void setSelectedItem(String value, int defaultIndex) {
        try {
            this.setSelectedItem(value);
        }
        catch (Exception ex) {
            try {
                if (defaultIndex != -1) {
                    this.setSelectedIndex(defaultIndex);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int getSelectedIndex() {
        return this.selected;
    }

    public String getSelectedItem() {
        return this.selectedItem;
    }

    protected boolean isSelected(int index) {
        boolean rc = false;
        if (this.selected == index) {
            rc = true;
        }
        return rc;
    }

    protected boolean isSelected(String value) {
        boolean rc = false;
        if (value != null && this.selectedItem != null) {
            rc = value.equals(this.selectedItem);
        }
        return rc;
    }

    public void setBreak(boolean value) {
        this.breakAfter = value;
    }

    public boolean isBreak() {
        return this.breakAfter;
    }

    @SASScope
    public void setDescriptionModel(ListModel model) {
        this.descModel = model;
    }

    @SASScope
    public ListModel getDescriptionModel() {
        return this.descModel;
    }

    @SASScope
    public void setDisplayButtonText(boolean value) {
        this.setLabelVisible(value);
    }

    public void setLabelVisible(boolean value) {
        this.labelVisible = value;
    }

    @SASScope
    public boolean isDisplayButtonText() {
        return this.isLabelVisible();
    }

    public boolean isLabelVisible() {
        return this.labelVisible;
    }

    public void setHorizontalAlignment(boolean value) {
        this.horizontalAlignment = value;
    }

    public boolean getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setValidateSelection(boolean value) {
        this.validateSelection = value;
    }

    public boolean isValidateSelection() {
        return this.validateSelection;
    }

    public void setLabelBolding(boolean value) {
        this.labelBolding = value;
    }

    public boolean isLabelBolding() {
        return this.labelBolding;
    }

    @SASScope
    public void setEncodeWhiteSpace(boolean value) {
        this.encodeWhiteSpace = value;
    }

    @SASScope
    public boolean isEncodeWhiteSpace() {
        return this.encodeWhiteSpace;
    }
}

