/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.form;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.form.BaseFormElement;
import com.sas.servlet.tbeans.form.RB;
import com.sas.servlet.tbeans.models.Item;
import java.io.IOException;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;

@SASScope(value="ALL")
public abstract class BaseListBox
extends BaseFormElement {
    public static final String RB_KEY = "BaseFormElement.";
    private int size;
    private boolean multipleSelections = false;
    private int[] selected;
    private ListModel selectedItems;
    private ListModel descModel;
    private boolean validateSelection = false;
    private boolean encodeWhiteSpace = false;
    protected ListModel model;

    public BaseListBox() {
        this.setObjectDataProperty("selectedItem");
        this.setModificationEventName("onChange");
        this.size = 4;
    }

    public ListModel getModel() {
        return this.model;
    }

    public void setModel(ListModel listModel) {
        this.model = listModel;
    }

    public void setSize(int value) {
        this.size = value;
    }

    public int getSize() {
        return this.size;
    }

    public void setMultipleSelections(boolean value) {
        this.multipleSelections = value;
    }

    public boolean getMultipleSelections() {
        return this.multipleSelections;
    }

    public void setSelectedIndex(int value) throws IOException {
        if (value == -1) {
            this.setSelectedIndexes(null);
        } else {
            int[] i = new int[]{value};
            this.setSelectedIndexes(i);
        }
    }

    public void setSelectedIndexes(int[] value) throws IOException {
        DefaultListModel<String> tmp = new DefaultListModel<String>();
        if (value != null) {
            if (this.model != null) {
                int count = this.model.getSize() - 1;
                for (int i = 0; i < value.length; ++i) {
                    if (value[i] < 0 || value[i] > count) {
                        if (i == 0 && value[i] == -1) break;
                        if (this.isValidateSelection()) {
                            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invRange.txt", this.getLocale()));
                        }
                        value[i] = -1;
                        break;
                    }
                    if (this.model.getElementAt(value[i]) instanceof Item) {
                        Item item = (Item)this.model.getElementAt(value[i]);
                        String tempItem = item.getValue();
                        if (tempItem != null && tempItem.length() > 0) {
                            tmp.addElement(tempItem);
                            continue;
                        }
                        tempItem = item.getText();
                        if (tempItem == null || tempItem.length() <= 0) continue;
                        tmp.addElement(tempItem);
                        continue;
                    }
                    String s = this.model.getElementAt(value[i]).toString();
                    tmp.addElement(s);
                }
            }
            this.selected = value;
            this.selectedItems = tmp;
        }
    }

    public int getSelectedIndex() {
        if (this.selected != null && this.selected.length == 1) {
            return this.selected[0];
        }
        return -1;
    }

    public int[] getSelectedIndexes() {
        return this.selected;
    }

    public void setSelectedItem(String value) throws IOException {
        if (value == null) {
            this.setSelectedItems(null);
        } else {
            DefaultListModel<String> lm = new DefaultListModel<String>();
            lm.addElement(value);
            this.setSelectedItems(lm);
        }
    }

    public void setSelectedItem(String value, int defaultIndex) {
        try {
            this.setSelectedItem(value);
        }
        catch (Exception ex) {
            try {
                if (defaultIndex != -1) {
                    this.setSelectedIndex(defaultIndex);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setSelectedItems(ListModel values) throws IOException {
        this.processSelectedItems(values, true, -1);
    }

    public void setSelectedItems(ListModel values, int defaultIndex) {
        try {
            this.processSelectedItems(values, false, defaultIndex);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processSelectedItems(ListModel values, boolean throwException, int defaultIndex) throws IOException {
        if (values == null) {
            this.selected = null;
            this.selectedItems = null;
        } else {
            String modItem = "";
            int[] tmpSelected = new int[values.getSize()];
            int valSize = values.getSize();
            if (this.model != null) {
                int modSize = this.model.getSize();
                DefaultListModel<String> tmpModel = new DefaultListModel<String>();
                DefaultListModel<String> tmpReturnValuesModel = new DefaultListModel<String>();
                for (int k = 0; k <= modSize - 1; ++k) {
                    if (this.model.getElementAt(k) instanceof Item) {
                        String tempText;
                        Item item = (Item)this.model.getElementAt(k);
                        String tempVal = item.getValue();
                        if (tempVal != null && tempVal.length() > 0) {
                            tmpReturnValuesModel.addElement(tempVal);
                        }
                        if ((tempText = item.getText()) == null || tempText.length() <= 0) continue;
                        tmpModel.addElement(tempText);
                        continue;
                    }
                    tmpModel.addElement(this.model.getElementAt(k).toString());
                }
                boolean foundAtLeastOneItem = false;
                for (int i = 0; i <= valSize - 1; ++i) {
                    boolean found = false;
                    String valItem = "";
                    if (values.getElementAt(i) instanceof Item) {
                        Item selItems = (Item)values.getElementAt(i);
                        valItem = selItems.getValue();
                        if (valItem == null) {
                            valItem = selItems.getText();
                        }
                    } else {
                        valItem = values.getElementAt(i).toString();
                    }
                    if (tmpModel.getSize() > 0) {
                        tmpSelected[i] = tmpModel.indexOf(valItem, 0);
                        if (tmpSelected[i] > -1) {
                            found = true;
                            foundAtLeastOneItem = true;
                        }
                    }
                    if (!found && tmpReturnValuesModel.getSize() > 0) {
                        tmpSelected[i] = tmpReturnValuesModel.indexOf(valItem, 0);
                        if (tmpSelected[i] > -1) {
                            found = true;
                            foundAtLeastOneItem = true;
                        }
                    }
                    if (found) continue;
                    if (throwException && this.isValidateSelection()) {
                        throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invSelection.txt", this.getLocale()));
                    }
                    if (modSize <= 0 || i != valSize - 1 || foundAtLeastOneItem) continue;
                    tmpSelected[i] = defaultIndex < 0 || defaultIndex > this.model.getSize() - 1 ? -1 : defaultIndex;
                }
                this.selected = tmpSelected;
                this.selectedItems = values;
            }
        }
    }

    public String getSelectedItem() {
        if (this.selectedItems != null && this.selectedItems.getSize() == 1) {
            if (this.selectedItems.getElementAt(0) instanceof Item) {
                Item selItems = (Item)this.selectedItems.getElementAt(0);
                if (selItems.getText() != null) {
                    return selItems.getText();
                }
                return selItems.getValue();
            }
            return this.selectedItems.getElementAt(0).toString();
        }
        return "";
    }

    public ListModel getSelectedItems() {
        return this.selectedItems;
    }

    protected boolean isSelected(int index) {
        boolean rc = false;
        if (this.selected != null) {
            for (int i = 0; i < this.selected.length; ++i) {
                if (this.selected[i] != index) continue;
                rc = true;
                break;
            }
        }
        return rc;
    }

    protected boolean isSelected(String value) {
        boolean rc = false;
        if (value != null && this.selectedItems != null) {
            int modSize = this.selectedItems.getSize();
            for (int k = 0; k <= modSize - 1; ++k) {
                String modItem = "";
                if (this.selectedItems.getElementAt(k) instanceof Item) {
                    Item selItems = (Item)this.selectedItems.getElementAt(k);
                    modItem = selItems.getValue();
                    if (modItem == value) {
                        rc = true;
                        break;
                    }
                    modItem = selItems.getText();
                    if (modItem != value) continue;
                    rc = true;
                    break;
                }
                modItem = this.selectedItems.getElementAt(k).toString();
                if (modItem != value) continue;
                rc = true;
                break;
            }
        }
        return rc;
    }

    @SASScope
    public void setDescriptionModel(ListModel model) {
        this.descModel = model;
    }

    @SASScope
    public ListModel getDescriptionModel() {
        return this.descModel;
    }

    public void setValidateSelection(boolean value) {
        this.validateSelection = value;
    }

    public boolean isValidateSelection() {
        return this.validateSelection;
    }

    @SASScope
    public void setEncodeWhiteSpace(boolean value) {
        this.encodeWhiteSpace = value;
    }

    @SASScope
    public boolean isEncodeWhiteSpace() {
        return this.encodeWhiteSpace;
    }
}

