/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.features;

public class JavaScriptHelper {
    StringBuffer str;
    boolean first = true;

    public JavaScriptHelper() {
        this(new StringBuffer());
    }

    JavaScriptHelper(StringBuffer str) {
        this.str = str;
    }

    public JavaScriptHelper addStringProperty(String name, String value) {
        this.addComma().append(name).append(":");
        this.addQuotedString(value);
        return this;
    }

    public JavaScriptHelper addArrayProperty(String name, String[] values) {
        this.addComma().append(name).append(":");
        if (values != null) {
            this.str.append('[');
            for (int i = 0; i < values.length; ++i) {
                if (i != 0) {
                    this.str.append(",");
                }
                String value = values[i];
                this.addQuotedString(value);
            }
            this.str.append(']');
        } else {
            this.str.append("null");
        }
        return this;
    }

    private JavaScriptHelper addQuotedString(String value) {
        if (value != null) {
            this.str.append("\"").append(value).append("\"");
        } else {
            this.str.append("null");
        }
        return this;
    }

    public JavaScriptHelper addBooleanProperty(String name, boolean bool) {
        this.addComma().append(name).append(": ").append(bool);
        return this;
    }

    public JavaScriptHelper startNewObject(String name) {
        this.addComma().append(name).append(": {");
        this.first = true;
        return this;
    }

    public JavaScriptHelper startNewObject() {
        this.addComma().append("{");
        this.first = true;
        return this;
    }

    public JavaScriptHelper closeObject() {
        this.str.append("}");
        this.first = false;
        return this;
    }

    public JavaScriptHelper startNewArray(String name) {
        this.addComma().append(name).append(": [");
        this.first = true;
        return this;
    }

    public JavaScriptHelper startNewArray() {
        this.addComma().append("[");
        this.first = true;
        return this;
    }

    public JavaScriptHelper closeArray() {
        this.str.append("]");
        this.first = false;
        return this;
    }

    public StringBuffer addComma() {
        if (!this.first) {
            this.str.append(", ");
        } else {
            this.first = false;
        }
        return this.str;
    }

    public JavaScriptHelper addString(String str) {
        this.addComma();
        this.addQuotedString(str);
        return this;
    }

    public boolean isFirst() {
        return this.first;
    }

    public void setFirst(boolean first) {
        this.first = first;
    }

    public StringBuffer getBuffer() {
        return this.str;
    }

    public String toString() {
        return this.str.toString();
    }
}

