/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.features;

import com.sas.servlet.tbeans.features.JavaScriptHelper;
import com.sas.servlet.tbeans.features.dnd.DragZone;
import com.sas.servlet.tbeans.features.dnd.DropZone;
import com.sas.servlet.tbeans.features.dnd.Zone;
import com.sas.servlet.tbeans.features.dnd.ZoneElement;
import com.sas.servlet.tbeans.features.dnd.ZoneInfo;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class DnDFeature {
    public static final int INSERT_AND_REPLACE_MODE = 0;
    public static final int INSERT_MODE = 1;
    public static final int REPLACE_MODE = 2;
    private String id = null;
    private boolean dragEnabled = true;
    private boolean dropEnabled = true;
    private String actionURL = null;
    private String dropHandler = null;
    private String type = null;
    private String[] acceptedTypes = null;
    private String acceptsFunction = null;
    private String startDragFunction = null;
    private String endDragFunction = null;
    private int insertMode = 1;
    private ComponentPropertyManager cpm = null;
    private String configureDnDFunction = "sas_DnD_build";
    List dragZones = new ArrayList();
    List dropZones = new ArrayList();
    List zoneInfos = new ArrayList();
    protected JavaScriptHelper js = null;

    public void write(HttpServletRequest request, Writer out, String id) throws IOException {
        this.setId(id);
        JavaScriptIncludeHandler.writeIncludes(out, "DND", request);
        out.write(JavaScriptIncludeHandler.getStartScript());
        out.write(this.buildDnDConfig());
        out.write("sas_DnD_cleanup(\"" + id + "\");\n");
        out.write(this.getConfigureDnDFunction() + "();\n");
        String _contextPath = request.getContextPath();
        out.write("var sas_DnD_ContextURL = \"" + _contextPath + "/\";\n");
        String imageLoc = ComponentPropertyManager.getInstance(request).getImageLocation();
        out.write("var sas_DnD_imageLocation = \"" + imageLoc + "/\";\n");
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(request);
        out.write("var sas_DnD_downArrowImageName = \"" + cpm.getImageName("Arrow_Down_Dnd") + "\";\n");
        out.write("var sas_DnD_rightArrowImageName = \"" + cpm.getImageName("Arrow_Right_Dnd") + "\";\n");
        out.write(JavaScriptIncludeHandler.getEndScript(null));
        this.clearZones();
    }

    public String buildDnDConfig() {
        JavaScriptHelper js;
        StringBuffer str = new StringBuffer("var sas_DnDConfig = {");
        this.js = js = new JavaScriptHelper(str);
        js.addBooleanProperty("dragEnabled", this.isDragEnabled());
        js.addBooleanProperty("dropEnabled", this.isDropEnabled());
        js.addStringProperty("id", this.getId());
        js.addStringProperty("dropHandler", this.getDropHandler());
        js.addStringProperty("actionURL", this.getActionURL());
        js.addStringProperty("type", this.getType());
        js.addArrayProperty("acceptedTypes", this.getAcceptedTypes());
        js.addStringProperty("acceptsFunction", this.getAcceptsFunction());
        js.addStringProperty("startDrag", this.getStartDragFunction());
        js.addStringProperty("endDrag", this.getEndDragFunction());
        this.writeDragInfo(js);
        this.writeDropInfo(js);
        this.writeZoneInfo(js);
        this.addExtraParameters(str);
        str.append("};\n");
        this.js = null;
        return str.toString();
    }

    protected void addExtraParameters(StringBuffer str) {
    }

    private String getId() {
        return this.id;
    }

    private void setId(String id) {
        this.id = id;
    }

    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean dragEnabled) {
        this.dragEnabled = dragEnabled;
    }

    public boolean isDropEnabled() {
        return this.dropEnabled;
    }

    public void setDropEnabled(boolean dropEnabled) {
        this.dropEnabled = dropEnabled;
    }

    public String getActionURL() {
        return this.actionURL;
    }

    public void setActionURL(String actionURL) {
        this.actionURL = actionURL;
    }

    public String getDropHandler() {
        return this.dropHandler;
    }

    public void setDropHandler(String dropHandler) {
        this.dropHandler = dropHandler;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String[] getAcceptedTypes() {
        return this.acceptedTypes;
    }

    public void setAcceptedTypes(String[] acceptedTypes) {
        this.acceptedTypes = acceptedTypes;
    }

    public String getAcceptsFunction() {
        return this.acceptsFunction;
    }

    public void setAcceptsFunction(String acceptsFunction) {
        this.acceptsFunction = acceptsFunction;
    }

    public String getEndDragFunction() {
        return this.endDragFunction;
    }

    public void setEndDragFunction(String endDragFunction) {
        this.endDragFunction = endDragFunction;
    }

    public String getStartDragFunction() {
        return this.startDragFunction;
    }

    public void setStartDragFunction(String startDragFunction) {
        this.startDragFunction = startDragFunction;
    }

    public String getConfigureDnDFunction() {
        return this.configureDnDFunction;
    }

    public void setConfigureDnDFunction(String configureDnDFunction) {
        this.configureDnDFunction = configureDnDFunction;
    }

    public int getInsertMode() {
        return this.insertMode;
    }

    public void setInsertMode(int insertMode) {
        this.insertMode = insertMode;
    }

    protected String calculateOrientation(boolean horizontal) {
        String orientation;
        if (this.getInsertMode() == 2) {
            return "REPLACE";
        }
        String string = orientation = horizontal ? "HORIZONTAL" : "VERTICAL";
        if (this.getInsertMode() == 0) {
            return orientation + "REPLACE";
        }
        return orientation;
    }

    private void writeDragInfo(JavaScriptHelper js) {
        js.startNewObject("dragZoneInfo");
        for (int i = 0; i < this.dragZones.size(); ++i) {
            DragZone zone = (DragZone)this.dragZones.get(i);
            zone.write(js);
        }
        js.closeObject();
    }

    private void writeDropInfo(JavaScriptHelper js) {
        js.startNewObject("dropZoneInfo");
        for (int i = 0; i < this.dropZones.size(); ++i) {
            DropZone zone = (DropZone)this.dropZones.get(i);
            zone.write(js);
        }
        js.closeObject();
    }

    private void writeZoneInfo(JavaScriptHelper js) {
        js.startNewArray("zoneInfo");
        List zones = this.getZoneInfos();
        for (int i = 0; i < zones.size(); ++i) {
            ZoneInfo zoneInfo = (ZoneInfo)zones.get(i);
            zoneInfo.write(js);
        }
        js.closeArray();
    }

    private Zone findZone(List zones, String zoneName) {
        for (int i = 0; i < zones.size(); ++i) {
            Zone zone = (Zone)zones.get(i);
            if (!zone.getName().equals(zoneName)) continue;
            return zone;
        }
        return null;
    }

    private ZoneInfo findZoneInfo(List zoneInfos, String zoneName) {
        for (int i = 0; i < zoneInfos.size(); ++i) {
            ZoneInfo zoneInfo = (ZoneInfo)zoneInfos.get(i);
            if (!zoneInfo.getName().equals(zoneName)) continue;
            return zoneInfo;
        }
        return null;
    }

    public List getDragZones() {
        return this.dragZones;
    }

    public void setDragZones(List dragZones) {
        this.dragZones = dragZones;
    }

    public List getDropZones() {
        return this.dropZones;
    }

    public void setDropZones(List dropZones) {
        this.dropZones = dropZones;
    }

    public List getZoneInfos() {
        return this.zoneInfos;
    }

    public void setZoneInfos(List zoneInfos) {
        this.zoneInfos = zoneInfos;
    }

    public DragZone getDragZone(String name) {
        return (DragZone)this.findZone(this.dragZones, name);
    }

    public DropZone getDropZone(String name) {
        return (DropZone)this.findZone(this.dropZones, name);
    }

    public ZoneInfo getZoneInfo(String name) {
        return this.findZoneInfo(this.zoneInfos, name);
    }

    protected void createZones(String[] zones) {
        this.setDragZones(this.createZoneList(zones, true));
        this.setDropZones(this.createZoneList(zones, false));
        this.setZoneInfos(this.createZoneInfoList(zones));
    }

    protected List createZoneList(String[] names, boolean dragzones) {
        ArrayList<Zone> list = new ArrayList<Zone>(names.length);
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (dragzones) {
                list.add(new DragZone(name));
                continue;
            }
            list.add(new DropZone(name));
        }
        return list;
    }

    protected List createZoneInfoList(String[] names) {
        ArrayList<ZoneInfo> list = new ArrayList<ZoneInfo>(names.length);
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            list.add(new ZoneInfo(name));
        }
        return list;
    }

    protected void clearZones() {
        for (int i = 0; i < this.zoneInfos.size(); ++i) {
            ZoneInfo zone = (ZoneInfo)this.zoneInfos.get(i);
            zone.getElements().clear();
        }
    }

    public void setTypes(String[] zones, String type) {
        this.setTypes(zones, type, new String[]{type});
    }

    public void setTypes(String[] zones, String type, String[] acceptedTypes) {
        for (int i = 0; i < zones.length; ++i) {
            String zone = zones[i];
            DragZone dragZone = this.getDragZone(zone);
            DropZone dropZone = this.getDropZone(zone);
            dragZone.setType(type);
            dropZone.setAcceptedTypes(type == null ? null : (String[])acceptedTypes.clone());
        }
    }

    public void addAcceptedTypes(String[] zones, String type) {
        for (int i = 0; i < zones.length; ++i) {
            String zone = zones[i];
            DropZone dropZone = this.getDropZone(zone);
            String[] acceptedTypes = dropZone.getAcceptedTypes();
            String[] newlist = new String[acceptedTypes.length + 1];
            System.arraycopy(acceptedTypes, 0, newlist, 0, acceptedTypes.length);
            newlist[acceptedTypes.length] = type;
            dropZone.setAcceptedTypes(newlist);
        }
    }

    protected ZoneElement addHidden(ZoneInfo zone, String domid, String id, String label, String image) {
        ZoneElement element = new ZoneElement(domid, id, "REPLACE");
        zone.addElement(element);
        element.setElementType("HIDDEN");
        element.addProperty("highlightText", label);
        if (image != null) {
            if (image.endsWith(".gif")) {
                element.addProperty("highlightImage", image);
            } else if (this.getCPM() != null) {
                element.addProperty("highlightImageURI", this.getCPM().getImageURI(image));
            }
        }
        return element;
    }

    protected ComponentPropertyManager getCPM() {
        return this.cpm;
    }

    protected void setCPM(ComponentPropertyManager cpm) {
        this.cpm = cpm;
    }

    static {
        JavaScriptIncludeHandler.addAlias(DnDFeature.class, "DND");
    }
}

