/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.dualselector.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.dualselector.html.DualSelector;
import com.sas.servlet.tbeans.dualselector.html.DualTreeSelector;
import com.sas.servlet.tbeans.dualselector.html.RB;
import com.sas.servlet.tbeans.html.AjaxTreeView;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.html.TreeView;
import com.sas.servlet.tbeans.models.TreeNodeInterface;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.text.Message;
import com.sas.util.Util;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Stack;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

@SASScope
public class AjaxDualTreeSelector
extends DualSelector {
    private static final long serialVersionUID = 1L;
    public static final String RB_KEY = "DualSelector.";
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "DualTreeSelector.html";
    protected static String QUOTE_COMMA_QUOTE = "','";
    protected static String COMMA = ",";
    protected static String QUOTE_COMMA = "',";
    private TreeModel model;
    private TreeModel targetModel;
    private String targetNode;
    private static final String TREE_OPERATION = "operation";
    private static final String NODE_NAME = "nodename";
    private static final int OPERATION_MOVE_TO_TARGET = 1;
    private static final int OPERATION_MOVE_ALL_TO_TARGET = 2;
    private static final int OPERATION_REMOVE_FROM_TARGET = 3;
    private static final int OPERATION_REMOVE_ALL_FROM_TARGET = 4;
    private static final int OPERATION_MOVE_ITEMS_UP = 5;
    private static final int OPERATION_MOVE_ITEMS_DOWN = 6;
    private String statMv2Trg = null;
    private String statMvAll2Trg = null;
    private String staRemvFrmTarget = null;
    private String staRemAllFrmTrg = null;

    public AjaxDualTreeSelector(String name, TreeModel model) {
        this.setId(name);
        this.setModel(model);
        this.setTemplateKey("Dual_Tree_Selector");
        this.type = "DUALTREE";
        this.setDefaultComponentNames();
        this.setTreeDefaults();
    }

    public AjaxDualTreeSelector() {
        this(Util.getName((String)"ajxdtsel"), null);
    }

    protected void setTreeDefaults() {
        AjaxTreeView srcComponent = (AjaxTreeView)this.getSourceComponent();
        srcComponent.setSelectionMode(1);
        srcComponent.setUsingURLLinks(false);
        AjaxTreeView trgComponent = (AjaxTreeView)this.getTargetComponent();
        trgComponent.setSelectionMode(1);
        trgComponent.setUsingURLLinks(false);
    }

    @Override
    public void setId(String value) {
        String prevId = this.getId();
        super.setId(value);
        if (prevId != null) {
            this.getComponent("DUALSELECTOR_TARGET").setId(value + "_target");
        }
    }

    @Override
    protected void setDefaultComponentNames() {
        TransformationInterface targetLabel;
        super.setDefaultComponentNames();
        String name = this.getId();
        TransformationInterface sourceLabel = this.getComponent("DUALSELECTOR_SOURCE_LABEL");
        if (sourceLabel instanceof Label) {
            ((Label)sourceLabel).setFor(name + "_source" + "_Div");
        }
        if ((targetLabel = this.getComponent("DUALSELECTOR_TARGET_LABEL")) instanceof Label) {
            ((Label)targetLabel).setFor(name + "_Div");
        }
        this.getComponent("DUALSELECTOR_TARGET").setName(name + "_target");
        ((BaseTransformation)this.getComponent("DUALSELECTOR_TARGET")).setId(name + "_target");
    }

    @Override
    protected void setSelectorDefaults() {
        HttpServletRequest req;
        super.setSelectorDefaults();
        AjaxTreeView sourceComponent = (AjaxTreeView)this.getSourceComponent();
        TreeModel mi = this.getModel();
        if (mi == null) {
            com.sas.servlet.tbeans.models.TreeNode node = new com.sas.servlet.tbeans.models.TreeNode("rootNode", RB.getStringResource(RB_KEY, "root.txt", this.getLocale()));
            com.sas.servlet.tbeans.models.TreeNode child1 = new com.sas.servlet.tbeans.models.TreeNode("child", RB.getStringResource(RB_KEY, "node.txt", this.getLocale()));
            node.add(child1);
            mi = new DefaultTreeModel(node);
        }
        sourceComponent.setModel(mi);
        if (this.getMultipleSelections() && sourceComponent.getSelectionMode() != 3) {
            sourceComponent.setSelectionMode(3);
        }
        if (this.getImageLocation() != null) {
            sourceComponent.setImageLocation(this.getImageLocation());
        }
        sourceComponent.setRequest(this.getRequest());
        sourceComponent.setResponse(this.getResponse());
        sourceComponent.setLocale(this.getLocale());
        sourceComponent.setStyleClassPrefix(this.getStyleClassPrefix());
        AjaxTreeView targetComponent = (AjaxTreeView)this.getTargetComponent();
        TreeModel mi2 = this.getTargetModel();
        if (mi2 == null) {
            com.sas.servlet.tbeans.models.TreeNode node = new com.sas.servlet.tbeans.models.TreeNode("selection", RB.getStringResource(RB_KEY, "root.txt", this.getLocale()));
            mi2 = new DefaultTreeModel(node);
        }
        targetComponent.setModel(mi2);
        if (this.getMultipleSelections() && targetComponent.getSelectionMode() != 3) {
            targetComponent.setSelectionMode(3);
        }
        targetComponent.setRequest(this.getRequest());
        sourceComponent.setResponse(this.getResponse());
        sourceComponent.setLocale(this.getLocale());
        if (this.getImageLocation() != null) {
            targetComponent.setImageLocation(this.getImageLocation());
        }
        targetComponent.setStyleClassPrefix(this.getStyleClassPrefix());
        if (this.getTargetNode() != null) {
            targetComponent.setRootNodeVisible(false);
        }
        if ((req = this.getRequest()) != null) {
            HttpSession session = req.getSession();
            session.setAttribute(sourceComponent.getId(), (Object)sourceComponent);
            session.setAttribute(targetComponent.getId(), (Object)targetComponent);
            session.setAttribute(this.getId(), (Object)this);
        }
    }

    @Override
    public BaseTransformation getDefaultComponent() {
        return new AjaxTreeView();
    }

    public String getTargetNode() {
        return this.targetNode;
    }

    public void setTargetNode(String targetNode) {
        this.targetNode = targetNode;
    }

    public TreeModel getModel() {
        return this.model;
    }

    public void setModel(TreeModel treeModel) {
        this.model = treeModel;
    }

    public TreeModel getTargetModel() {
        if (this.targetModel == null) {
            com.sas.servlet.tbeans.models.TreeNode node = new com.sas.servlet.tbeans.models.TreeNode("selection", RB.getStringResource(RB_KEY, "root.txt", this.getLocale()));
            this.targetModel = new DefaultTreeModel(node);
            AjaxTreeView targetComponent = (AjaxTreeView)this.getTargetComponent();
            targetComponent.setRootNodeVisible(false);
        }
        return this.targetModel;
    }

    public void setTargetModel(TreeModel treeModel) {
        this.targetModel = treeModel;
    }

    @Override
    protected String getMoveToTarget() {
        StringBuffer moveToTarget = new StringBuffer();
        if (this.getPreTargetTrigger() != null) {
            moveToTarget.append("if (").append(this.getPreTargetTrigger()).append(") \n");
        }
        moveToTarget.append(this.getAjaxMoveToTarget());
        if (this.getPostTargetTrigger() != null) {
            moveToTarget.append(this.getPostTargetTrigger()).append(";");
        }
        return moveToTarget.toString();
    }

    private String _getMoveToTarget() {
        if (this.statMv2Trg == null) {
            StringBuffer moveToTarget = new StringBuffer();
            moveToTarget.append(" moveToTarget('");
            moveToTarget.append(this.getSourceComponentName()).append(QUOTE_COMMA_QUOTE);
            moveToTarget.append(this.getTargetComponentName()).append(QUOTE_COMMA).append(this.isStaticSourceAllowed()).append(COMMA);
            moveToTarget.append(this.isTargetDuplicateAllowed()).append(COMMA).append(this.getTargetMaximumCount()).append(");");
            this.statMv2Trg = moveToTarget.toString();
        }
        return this.statMv2Trg;
    }

    private String getAjaxMoveToTarget() {
        StringBuffer moveToTarget = new StringBuffer();
        moveToTarget.append("   ajaxMoveToTarget('").append(this.getId()).append(QUOTE_COMMA).append(1).append(",'");
        moveToTarget.append(this.getSourceComponentName()).append("');");
        return moveToTarget.toString();
    }

    @Override
    protected String getMoveAllToTarget() {
        StringBuffer moveAllToTarget = new StringBuffer();
        if (this.getPreTargetTrigger() != null) {
            moveAllToTarget.append("if (").append(this.getPreTargetTrigger()).append(") ");
        }
        moveAllToTarget.append(this.getAjaxMoveAllToTarget());
        if (this.getPostTargetTrigger() != null) {
            moveAllToTarget.append(this.getPostTargetTrigger()).append(";");
        }
        return moveAllToTarget.toString();
    }

    private String getAjaxMoveAllToTarget() {
        StringBuffer moveAllToTarget = new StringBuffer();
        moveAllToTarget.append("   ajaxMoveAllToTarget('").append(this.getId()).append(QUOTE_COMMA).append(2).append(",'").append(this.getSourceComponentName()).append("');");
        return moveAllToTarget.toString();
    }

    private String _getMoveAllToTarget() {
        if (this.statMvAll2Trg == null) {
            StringBuffer moveAllToTarget = new StringBuffer();
            moveAllToTarget.append("   moveAllToTarget('");
            moveAllToTarget.append(this.getSourceComponentName()).append(QUOTE_COMMA_QUOTE);
            moveAllToTarget.append(this.getTargetComponentName()).append(QUOTE_COMMA).append(this.isStaticSourceAllowed()).append(COMMA);
            moveAllToTarget.append(this.isTargetDuplicateAllowed()).append(COMMA).append(this.getTargetMaximumCount()).append(");");
            this.statMvAll2Trg = moveAllToTarget.toString();
        }
        return this.statMvAll2Trg;
    }

    @Override
    protected String getRemoveFromTarget() {
        StringBuffer removeFromTarget = new StringBuffer();
        if (this.getPreSourceTrigger() != null) {
            removeFromTarget.append("if (").append(this.getPreSourceTrigger()).append(")  \n");
        }
        removeFromTarget.append(this.getAjaxRemoveFromTarget());
        if (this.getPostSourceTrigger() != null) {
            removeFromTarget.append(this.getPostSourceTrigger()).append(";");
        }
        return removeFromTarget.toString();
    }

    private String getAjaxRemoveFromTarget() {
        StringBuffer removeFromTarget = new StringBuffer();
        removeFromTarget.append("   ajaxRemoveFromTarget('").append(this.getId()).append(QUOTE_COMMA).append(3).append(",'").append(this.getTargetComponentName()).append("');");
        return removeFromTarget.toString();
    }

    private String _getRemoveFromTarget() {
        if (this.staRemvFrmTarget == null) {
            StringBuffer removeFromTarget = new StringBuffer();
            removeFromTarget.append("   removeFromTarget('");
            removeFromTarget.append(this.getSourceComponentName()).append(QUOTE_COMMA_QUOTE);
            removeFromTarget.append(this.getTargetComponentName()).append(QUOTE_COMMA).append(this.isStaticSourceAllowed()).append(", true, true,'listview');");
            this.staRemvFrmTarget = removeFromTarget.toString();
        }
        return this.staRemvFrmTarget;
    }

    @Override
    protected String getRemoveAllFromTarget() {
        StringBuffer removeAllFromTarget = new StringBuffer();
        if (this.getPreSourceTrigger() != null) {
            removeAllFromTarget.append("if (").append(this.getPreSourceTrigger()).append(") ");
        }
        removeAllFromTarget.append(this.getAjaxRemoveAllFromTarget());
        if (this.getPostSourceTrigger() != null) {
            removeAllFromTarget.append(this.getPostSourceTrigger()).append(";");
        }
        return removeAllFromTarget.toString();
    }

    private String getAjaxRemoveAllFromTarget() {
        StringBuffer removeAllFromTarget = new StringBuffer();
        removeAllFromTarget.append("   ajaxRemoveAllFromTarget('").append(this.getId()).append(QUOTE_COMMA).append(4).append(",'").append(this.getTargetComponentName()).append("');");
        return removeAllFromTarget.toString();
    }

    private String _getRemoveAllFromTarget() {
        if (this.staRemAllFrmTrg == null) {
            StringBuffer removeAllFromTarget = new StringBuffer();
            removeAllFromTarget.append("   removeAllFromTarget('");
            removeAllFromTarget.append(this.getSourceComponentName());
            removeAllFromTarget.append(QUOTE_COMMA_QUOTE).append(this.getTargetComponentName()).append(QUOTE_COMMA);
            removeAllFromTarget.append(this.isStaticSourceAllowed()).append(", false ,'listview');");
            this.staRemAllFrmTrg = removeAllFromTarget.toString();
        }
        return this.staRemAllFrmTrg;
    }

    @Override
    protected String getMoveItemsUp() {
        StringBuffer moveUp = new StringBuffer();
        if (this.getPreUpTrigger() != null) {
            moveUp.append("if (").append(this.getPreUpTrigger()).append(") ");
        }
        moveUp.append("ajaxMoveItemsUp('").append(this.getId()).append(QUOTE_COMMA).append(5).append(",'").append(this.getTargetComponentName()).append("');");
        if (this.getPostUpTrigger() != null) {
            moveUp.append(this.getPostUpTrigger()).append(";");
        }
        return moveUp.toString();
    }

    @Override
    protected String getMoveItemsDown() {
        StringBuffer moveDown = new StringBuffer();
        if (this.getPreDownTrigger() != null) {
            moveDown.append("if (").append(this.getPreDownTrigger()).append(") ");
        }
        moveDown.append("ajaxMoveItemsDown('").append(this.getId()).append(QUOTE_COMMA).append(6).append(",'").append(this.getTargetComponentName()).append("');");
        if (this.getPostDownTrigger() != null) {
            moveDown.append(this.getPostDownTrigger()).append(";");
        }
        return moveDown.toString();
    }

    @Override
    protected String getSubmitAction() {
        StringBuffer sb = new StringBuffer();
        return sb.append("sas_AjaxDualTreeSelector_submitSelection('").append(this.getFormObject().getName()).append(QUOTE_COMMA_QUOTE).append(this.getId()).append("')").toString();
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        JavaScriptIncludeHandler.writeIncludes(out, "DUALTREESELECTOR", this.getRequest());
        this.writeSelectorHeader(out);
        StringBuffer jscript = new StringBuffer();
        if (this.getTargetNode() != null) {
            jscript.append(JavaScriptIncludeHandler.getStartScript());
            jscript.append(this.getTargetComponentName()).append(".targetNode = sas_TreeView_basicFindNode(\"");
            jscript.append(this.getTargetNode()).append("\");");
            jscript.append(JavaScriptIncludeHandler.getEndScript(null));
            out.println(jscript.toString());
        }
        this.writeSelectorFooter(out);
        long n = Util.getNumber();
        jscript.setLength(0);
        jscript.append(JavaScriptIncludeHandler.getStartScript());
        jscript.append("function sas_DualTreeSelector_moveToTarget").append(n).append("() {");
        jscript.append(this.getMoveToTarget()).append("\n}\n");
        jscript.append("if (typeof ").append(this.getSourceComponentName()).append(" != \"undefined\")\n\t");
        jscript.append(this.getSourceComponentName()).append(".ondblclick = sas_DualTreeSelector_moveToTarget").append(n).append(";\n");
        jscript.append("function sas_DualTreeSelector_removeFromTarget").append(n).append("() {");
        jscript.append(this.getRemoveFromTarget()).append("\n}\n");
        jscript.append("if (typeof ").append(this.getTargetComponentName()).append(" != \"undefined\")\n\t");
        jscript.append(this.getTargetComponentName()).append(".ondblclick = sas_DualTreeSelector_removeFromTarget").append(n).append(";\n");
        jscript.append("sas_DualTreeSelectorInit('").append(this.getSourceComponentName()).append("','").append(this.getTargetComponentName()).append("');\n");
        jscript.append(JavaScriptIncludeHandler.getEndScript(null));
        out.write(jscript.toString());
        this.writeAjaxJavaScriptProperties(out);
        this.cleanUpResources();
    }

    @Override
    public void cleanUpResources() {
        super.cleanUpResources();
        AjaxTreeView srcTv = (AjaxTreeView)this.getSourceComponent();
        srcTv.getTreeView().clearNodeCache();
        AjaxTreeView trgTv = (AjaxTreeView)this.getTargetComponent();
        trgTv.getTreeView().clearNodeCache();
    }

    public String getSynchronizeAction() {
        StringBuffer sb = new StringBuffer("sas_AjaxDualTreeSelector_Sync('");
        sb.append(this.getSourceComponentName()).append("','");
        sb.append(this.getTargetComponentName()).append("');");
        return sb.toString();
    }

    private void writeAjaxJavaScriptProperties(PrintWriter out) throws IOException {
        JavaScriptIncludeHandler.writeIncludes(out, "AJAX", this.getRequest());
        String dtsname = this.getId();
        StringBuffer js = new StringBuffer(1024);
        js.append(JavaScriptIncludeHandler.getStartScript());
        js.append("var ").append(dtsname).append("_").append("AJAX").append("=").append(true).append(";\n");
        js.append("var ").append(dtsname).append("_").append("ajxdtsel").append("='").append(dtsname).append("';\n");
        js.append("var ").append(dtsname).append("_rsURL='").append(this.getAJAXControllerURL()).append("';\n");
        js.append("var ").append(dtsname).append("_CLASS_PARAMETER='").append(this.getClass().getName()).append("';\n");
        js.append("var ").append(dtsname).append("_sas_charEncoding").append("='").append(BaseUtil.getOutputCharacterEncoding(this.getRequest())).append("';\n");
        js.append(JavaScriptIncludeHandler.getEndScript(null));
        out.println(js);
    }

    public static void servletInvocationMethod(HttpServletRequest req, HttpServletResponse res) throws IOException {
        AjaxDualTreeSelector.doMoveOperation(req, res);
    }

    private static void doMoveOperation(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String dualTreeSelectorName = req.getParameter("ajxdtsel");
        String treeOperation = req.getParameter(TREE_OPERATION);
        String[] nodeNames = req.getParameterValues(NODE_NAME);
        if (null == dualTreeSelectorName || null == treeOperation || nodeNames == null) {
            CommonLoggerInterface log = LoggerRepository2.getLogger((String)AjaxDualTreeSelector.class.getPackage().getName(), null);
            StringBuffer params = new StringBuffer("ajxdtsel");
            params.append(COMMA).append(TREE_OPERATION).append(COMMA).append(NODE_NAME);
            String msgStr = Message.format((String)RB.getStringResource(RB_KEY, "nullAjaxTreeReqParams.txt", req.getLocale()), (Object)params.toString());
            log.error(msgStr, (Throwable)new NullPointerException(msgStr));
            return;
        }
        HttpSession session = req.getSession();
        AjaxDualTreeSelector dts = (AjaxDualTreeSelector)session.getAttribute(dualTreeSelectorName);
        if (dts == null) {
            CommonLoggerInterface log = LoggerRepository2.getLogger((String)AjaxDualTreeSelector.class.getPackage().getName(), null);
            String msgStr = RB.getStringResource(RB_KEY, "nullAjaxDualTreeParameter.txt", req.getLocale());
            log.error(msgStr, (Throwable)new NullPointerException(msgStr));
            return;
        }
        Stack<NodeWrapper> selectedNodes = new Stack<NodeWrapper>();
        for (int i = nodeNames.length - 1; i >= 0; --i) {
            selectedNodes.push(new NodeWrapper(nodeNames[i]));
        }
        PrintWriter out = res.getWriter();
        int treeOp = Integer.parseInt(treeOperation);
        switch (treeOp) {
            case 1: {
                AjaxDualTreeSelector.doMoveToTarget(dts, selectedNodes, out);
                break;
            }
            case 2: {
                AjaxDualTreeSelector.doMoveAllToTarget(dts, selectedNodes, out);
                break;
            }
            case 3: {
                AjaxDualTreeSelector.doRemoveFromTarget(dts, selectedNodes, out);
                break;
            }
            case 4: {
                AjaxDualTreeSelector.doRemoveAllFromTarget(dts, selectedNodes, out);
                break;
            }
            case 5: {
                AjaxDualTreeSelector.doMoveItemsUp(dts, selectedNodes, out);
                break;
            }
            case 6: {
                AjaxDualTreeSelector.doMoveItemsDown(dts, selectedNodes, out);
            }
        }
        AjaxDualTreeSelector.writeJSResponse(out, " ");
    }

    private static void doMoveToTarget(AjaxDualTreeSelector dts, Stack nodeNames, PrintWriter out) {
        AjaxTreeView srcTree = (AjaxTreeView)dts.getSourceComponent();
        AjaxTreeView trgTree = (AjaxTreeView)dts.getTargetComponent();
        AjaxDualTreeSelector.moveNodes(srcTree, trgTree, nodeNames);
        AjaxDualTreeSelector.writeJSResponse(out, dts._getMoveToTarget());
    }

    private static void doMoveAllToTarget(AjaxDualTreeSelector dts, Stack nodeNames, PrintWriter out) {
        AjaxTreeView srcTree = (AjaxTreeView)dts.getSourceComponent();
        AjaxTreeView trgTree = (AjaxTreeView)dts.getTargetComponent();
        AjaxDualTreeSelector.moveNodes(srcTree, trgTree, nodeNames);
        AjaxDualTreeSelector.writeJSResponse(out, dts._getMoveAllToTarget());
    }

    private static void doRemoveFromTarget(AjaxDualTreeSelector dts, Stack nodeNames, PrintWriter out) {
        AjaxTreeView srcTree = (AjaxTreeView)dts.getSourceComponent();
        AjaxTreeView trgTree = (AjaxTreeView)dts.getTargetComponent();
        AjaxDualTreeSelector.moveNodes(trgTree, srcTree, nodeNames);
        AjaxDualTreeSelector.writeJSResponse(out, dts._getRemoveFromTarget());
    }

    private static void doRemoveAllFromTarget(AjaxDualTreeSelector dts, Stack nodeNames, PrintWriter out) {
        AjaxTreeView srcTree = (AjaxTreeView)dts.getSourceComponent();
        AjaxTreeView trgTree = (AjaxTreeView)dts.getTargetComponent();
        AjaxDualTreeSelector.moveNodes(trgTree, srcTree, nodeNames);
        AjaxDualTreeSelector.writeJSResponse(out, dts._getRemoveAllFromTarget());
    }

    private static void doMoveItemsUp(AjaxDualTreeSelector dts, Stack selectedNodes, PrintWriter out) {
        AjaxTreeView trgTree = (AjaxTreeView)dts.getTargetComponent();
        TreeModel model = trgTree.getModel();
        if (!(model instanceof DefaultTreeModel)) {
            return;
        }
        DefaultTreeModel dtmodel = (DefaultTreeModel)model;
        com.sas.servlet.tbeans.models.TreeNode root = (com.sas.servlet.tbeans.models.TreeNode)dtmodel.getRoot();
        while (selectedNodes.size() > 0) {
            com.sas.servlet.tbeans.models.TreeNode prevChild;
            NodeWrapper nodeWrapr = (NodeWrapper)selectedNodes.pop();
            String nodeName = nodeWrapr.nodeName;
            com.sas.servlet.tbeans.models.TreeNode selectedNode = (com.sas.servlet.tbeans.models.TreeNode)TreeView.findNode(nodeName, root);
            if (selectedNode == null || selectedNode.getParent() == null) {
                return;
            }
            com.sas.servlet.tbeans.models.TreeNode parent = (com.sas.servlet.tbeans.models.TreeNode)selectedNode.getParent();
            int nodeIndex = parent.getIndex(selectedNode);
            if (nodeIndex < 1 || (prevChild = (com.sas.servlet.tbeans.models.TreeNode)parent.getChildBefore(selectedNode)) == null) continue;
            dtmodel.removeNodeFromParent(prevChild);
            dtmodel.insertNodeInto(prevChild, parent, nodeIndex);
        }
    }

    private static void doMoveItemsDown(AjaxDualTreeSelector dts, Stack selectedNodes, PrintWriter out) {
        AjaxTreeView trgTree = (AjaxTreeView)dts.getTargetComponent();
        TreeModel model = trgTree.getModel();
        if (!(model instanceof DefaultTreeModel)) {
            return;
        }
        DefaultTreeModel dtmodel = (DefaultTreeModel)model;
        com.sas.servlet.tbeans.models.TreeNode root = (com.sas.servlet.tbeans.models.TreeNode)dtmodel.getRoot();
        for (int i = 0; i < selectedNodes.size(); ++i) {
            com.sas.servlet.tbeans.models.TreeNode parent;
            int nodeIndex;
            NodeWrapper nodeWrapr = (NodeWrapper)selectedNodes.get(i);
            String nodeName = nodeWrapr.nodeName;
            com.sas.servlet.tbeans.models.TreeNode selectedNode = (com.sas.servlet.tbeans.models.TreeNode)TreeView.findNode(nodeName, root);
            if (selectedNode == null || selectedNode.getParent() == null || (nodeIndex = (parent = (com.sas.servlet.tbeans.models.TreeNode)selectedNode.getParent()).getIndex(selectedNode)) == parent.getChildCount() - 1) continue;
            dtmodel.removeNodeFromParent(selectedNode);
            dtmodel.insertNodeInto(selectedNode, parent, nodeIndex + 1);
        }
    }

    private static void moveNodes(AjaxTreeView srcTree, AjaxTreeView trgTree, Stack stack) {
        TreeModel srcModel = srcTree.getModel();
        com.sas.servlet.tbeans.models.TreeNode srcRoot = (com.sas.servlet.tbeans.models.TreeNode)srcModel.getRoot();
        TreeModel trgModel = trgTree.getModel();
        com.sas.servlet.tbeans.models.TreeNode trgParentNd = (com.sas.servlet.tbeans.models.TreeNode)trgModel.getRoot();
        while (stack.size() > 0) {
            NodeWrapper nodewrap = (NodeWrapper)stack.pop();
            String nodeName = nodewrap.nodeName;
            com.sas.servlet.tbeans.models.TreeNode node = nodewrap.nodeRef;
            if (node == null) {
                nodewrap.nodeRef = node = (com.sas.servlet.tbeans.models.TreeNode)TreeView.findNode(nodeName, srcRoot);
            }
            if (node == null) continue;
            boolean isLeaf = node.isLeaf();
            if (!isLeaf) {
                AjaxDualTreeSelector.pushChildren(nodewrap, stack);
                continue;
            }
            if (!nodewrap.markedForDeletion) {
                TreeNode[] tnode = node.getPath();
                for (int ndInd = 0; ndInd < tnode.length; ++ndInd) {
                    com.sas.servlet.tbeans.models.TreeNode srcNd2Mov = (com.sas.servlet.tbeans.models.TreeNode)tnode[ndInd];
                    com.sas.servlet.tbeans.models.TreeNode tempNd = (com.sas.servlet.tbeans.models.TreeNode)TreeView.findNode(srcNd2Mov.getName(), (TreeNodeInterface)trgModel.getRoot());
                    if (tempNd == null) {
                        tempNd = new com.sas.servlet.tbeans.models.TreeNode(srcNd2Mov.getName(), srcNd2Mov.getText(), srcNd2Mov.getURL(), srcNd2Mov.getDefaultImage(), srcNd2Mov.getExpandedImage());
                        trgParentNd.add(tempNd);
                    }
                    trgParentNd = tempNd;
                }
            }
            if (null == node.getParent()) continue;
            ((com.sas.servlet.tbeans.models.TreeNode)node.getParent()).remove(node);
        }
    }

    private static void pushChildren(NodeWrapper node, Stack stack) {
        node.markedForDeletion = true;
        stack.push(node);
        for (int i = node.nodeRef.getChildCount() - 1; i >= 0; --i) {
            stack.push(new NodeWrapper(((com.sas.servlet.tbeans.models.TreeNode)node.nodeRef.getChildAt(i)).getName()));
        }
    }

    private static void writeJSResponse(PrintWriter out, String jshandler) {
        out.print(jshandler);
    }

    static {
        JavaScriptIncludeHandler.addAlias(DualTreeSelector.class, "DUALTREESELECTOR");
    }

    @SASScope
    private static class NodeWrapper {
        com.sas.servlet.tbeans.models.TreeNode nodeRef = null;
        String nodeName = null;
        boolean markedForDeletion = false;

        public NodeWrapper(String nodename) {
            this.nodeName = nodename;
        }
    }
}

