/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.datasource;

import com.sas.datatypes.DataSourceColumnType;
import com.sas.datatypes.DataTypeInterface;
import com.sas.models.datasources.DataSourceColumnInterface;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.storage.valueprovider.ValueType;
import com.sas.util.ValueItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class ValueProviderAdapter
implements ValueProviderInterface {
    public List valueProviders;
    private List dataSources;
    private long allowedDataSources;
    private long allowedColumnTypes;
    private static final String DATA_SOURCE_COLUMN = "DATA_SOURCE_COLUMN";
    public List values;

    public ValueProviderAdapter(long allowedDataSources, long allowedColumnTypes, List dataSources) {
        this.allowedDataSources = allowedDataSources;
        this.allowedColumnTypes = allowedColumnTypes;
        this.dataSources = dataSources;
    }

    public boolean isValueDisplayed() {
        return true;
    }

    public boolean setValueProvider(ValueProviderInterface provider) {
        this.values = null;
        if (this.valueProviders == null || this.valueProviders.size() != 1 || this.valueProviders.get(0) != provider) {
            this.valueProviders = new ArrayList();
            if (provider != null) {
                this.valueProviders.add(provider);
            }
            return true;
        }
        return false;
    }

    public boolean setValueProviders(List providers) {
        this.values = null;
        if (this.valueProviders != providers) {
            this.valueProviders = providers;
            return true;
        }
        return false;
    }

    public Object getValues(Locale locale) throws ValueProviderException {
        if (this.valueProviders != null) {
            if (this.valueProviders.size() == 1) {
                List values = (List)((ValueProviderInterface)this.valueProviders.get(0)).getValues(locale);
                this.values = values = (List)this.filterColumns(values);
                return values;
            }
            ArrayList allValues = new ArrayList();
            for (ValueProviderInterface provider : this.valueProviders) {
                Collection values = (Collection)provider.getValues(locale);
                values = this.filterColumns(values);
                allValues.addAll(values);
            }
            this.values = allValues;
            return allValues;
        }
        return Collections.EMPTY_LIST;
    }

    protected Collection filterColumns(Collection values) {
        ArrayList<ValueItem> filteredValues = new ArrayList<ValueItem>();
        for (ValueItem element : values) {
            if (!this.isValueItemAllowed(element)) continue;
            filteredValues.add(element);
        }
        return filteredValues;
    }

    protected boolean isValueItemAllowed(ValueItem vi) {
        if (vi.getValue() instanceof DataSourceColumnInterface) {
            DataSourceColumnInterface dataSourceColumn = (DataSourceColumnInterface)vi.getValue();
            if (this.dataSources == null || this.dataSources.isEmpty()) {
                return this.isDataSourceTypeAllowed(dataSourceColumn.getDataSource().getDataSourceType()) && this.isColumnTypeAllowed(dataSourceColumn.getColumnType());
            }
            return this.dataSources.contains(dataSourceColumn.getDataSource()) && this.isColumnTypeAllowed(dataSourceColumn.getColumnType());
        }
        return false;
    }

    private boolean isColumnTypeAllowed(long columnType) {
        if (this.allowedColumnTypes == -1L) {
            return true;
        }
        return (this.allowedColumnTypes & columnType) == columnType;
    }

    private boolean isDataSourceTypeAllowed(long dataSourceType) {
        if (dataSourceType == 8L || dataSourceType == 2L) {
            return false;
        }
        if (this.allowedDataSources == -1L) {
            return true;
        }
        return (this.allowedDataSources & dataSourceType) == dataSourceType;
    }

    private void addDataSourceInfo(Collection values) {
        for (ValueItem vi : values) {
            vi.setAttribute(DATA_SOURCE_COLUMN, vi.getValue());
        }
    }

    public Object getValues(Locale locale, int index, int count) throws ValueProviderException {
        if (this.valueProviders != null) {
            if (this.values == null) {
                this.getValues(locale);
            }
            if (this.values != null) {
                int size = this.values.size();
                if (count < 0) {
                    return this.values.subList(index, size);
                }
                return this.values.subList(index, Math.min(index + count, size));
            }
        }
        return Collections.EMPTY_LIST;
    }

    public DataTypeInterface getDataType() throws ValueProviderException {
        return DataSourceColumnType.DEFAULT_INSTANCE;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Object getValues(Locale locale, ValueType returnType) throws ValueProviderException {
        return this.getValues(locale);
    }

    public Object getValues(Locale locale, ValueType returnType, int index, int count) throws ValueProviderException {
        return this.getValues(locale);
    }
}

