/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.datasource;

import com.sas.models.SASLibraryLocationInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.servlet.tbeans.AJAXControllerURLInterface;
import com.sas.servlet.tbeans.BaseCompositeTransformation;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.JavaScriptEventHandlerInterface;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.TemplateSupport;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.datasource.RB;
import com.sas.servlet.tbeans.datasource.SASLibraryDialog;
import com.sas.servlet.tbeans.form.html.TextEntry;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.remotefileselector2.html.RemoteFileSelector;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.servlet.tbeans.valuepicker.ValuePicker;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.ComponentSessionManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.MapWithDefaults;
import com.sas.util.SimpleTemplate;
import com.sas.util.Util;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class SASLibraryPicker
extends BaseCompositeTransformation
implements JavaScriptEventHandlerInterface,
AJAXControllerURLInterface {
    private static final long serialVersionUID = 1L;
    public static final String RB_KEY = "SASLibraryPicker.";
    public static final String RB_KEY2 = "DataPicker.";
    protected TextEntry textEntry;
    protected TextEntry libRefEntry;
    protected Label libraryLabel;
    protected Label librefLabel;
    protected Button rfsButton;
    private String onChange;
    private String onFocus;
    private String onBlur;
    private UserContextInterface userContext;
    private long allowedDataSources;
    public static String SASLIBRARY_TEXT = "SASLIBRARY_TEXT";
    public static String SASLIBRARY_BUTTON = "SASLIBRARY_BUTTON";
    public static String SASLIBRARY_LIBREF_LABEL = "SASLIBRARY_LIBREF_LABEL";
    public static String SASLIBRARY_LABEL = "SASLIBRARY_LABEL";
    public static String SASLIBRARY_LABEL_STYLE = "SASLIBRARY_LABEL_STYLE";
    public static String SASLIBRARY_LIBREF_STYLE = "SASLIBRARY_LIBREF_STYLE";
    public static String SASLIBRARY_TEXTENTRY_STYLE = "SASLIBRARY_TEXTENTRY_STYLE";
    public static String SASLIBRARYPICKER_LIBREF = "SASLIBRARYPICKER_LIBREF";
    private SASLibraryDialog SASLibraryPanel;
    private Object initialValue;
    private static final String DEFAULT_TEMPLATE_FILE_NAME = "SASLibraryPicker.html";
    private static final String LIBREF_ID = "LIBREF_ID";
    public static final String DEFAULT_AJAX_URL_TEMPLATE = "%CONTEXTPATH/MethodInvocationServlet?CLASS_PARAMETER=" + SASLibraryPicker.class.getName() + "&" + "METHOD" + "=openRemoteFileSelector&id=%id";
    private static final HashMap defaultStyleMap;

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put(SASLIBRARY_LABEL_STYLE, new ImmutableStyleInfo("dataPickerFont"));
            defaultStyleMap.put(SASLIBRARY_TEXTENTRY_STYLE, new ImmutableStyleInfo("dataPickerFont"));
            defaultStyleMap.put(SASLIBRARY_LIBREF_STYLE, new ImmutableStyleInfo("sasLibraryPickerLibref dataPickerFont"));
        }
    }

    public SASLibraryPicker(UserContextInterface userContext) {
        this.setId(Util.getName((String)"slp"));
        SASLibraryPicker.setupDefaultStyleMap();
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap((Map)defaultStyleMap);
        this.userContext = userContext;
        this.setTemplateKey("SAS_Library_Picker");
        this.setTemplateDictionary(new HashMap());
        this.setObjectDataProperty("initialValue");
        SimpleTemplate ajaxURLTemplate = new SimpleTemplate();
        ajaxURLTemplate.setTemplate(DEFAULT_AJAX_URL_TEMPLATE);
        ajaxURLTemplate.setValueDictionary(new HashMap());
        this.setURLTemplate(ajaxURLTemplate);
        this.addComponents();
    }

    public UserContextInterface getUserContext() {
        return this.userContext;
    }

    protected void addComponents() {
        this.textEntry = new TextEntry();
        this.textEntry.setId(this.getId() + "_textEntry");
        this.textEntry.setStyleInfo((StyleInfo)this.getStyleMap().get(SASLIBRARY_TEXTENTRY_STYLE));
        this.textEntry.setReadOnly(false);
        this.setComponent(SASLIBRARY_TEXT, this.textEntry);
        this.libRefEntry = new TextEntry();
        this.libRefEntry.setId(this.getId() + "_libRefEntry");
        this.libRefEntry.setReadOnly(true);
        this.libRefEntry.setStyleInfo((StyleInfo)this.getStyleMap().get(SASLIBRARY_LIBREF_STYLE));
        this.setComponent(SASLIBRARYPICKER_LIBREF, this.libRefEntry);
        this.rfsButton = new Button();
        this.rfsButton.setId(this.getId() + "_button");
        this.setComponent(SASLIBRARY_BUTTON, this.rfsButton);
        this.libraryLabel = new Label();
        this.libraryLabel.setStyleInfo((StyleInfo)this.getStyleMap().get(SASLIBRARY_LABEL_STYLE));
        this.setComponent(SASLIBRARY_LABEL, this.libraryLabel);
        this.librefLabel = new Label();
        this.librefLabel.setStyleInfo((StyleInfo)this.getStyleMap().get(SASLIBRARY_LABEL_STYLE));
        this.setComponent(SASLIBRARY_LIBREF_LABEL, this.librefLabel);
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        this._setLocaleDependentProperties(locale);
    }

    private void _setLocaleDependentProperties(Locale currentLocale) {
        if (this.rfsButton != null) {
            this.rfsButton.setLabel(RB.getStringResource(RB_KEY2, "browse.txt", currentLocale));
        }
        if (this.libraryLabel != null) {
            this.libraryLabel.setText(RB.getStringResource(RB_KEY, "library.txt", currentLocale));
        }
        if (this.librefLabel != null) {
            this.librefLabel.setText(RB.getStringResource(RB_KEY, "libref.txt", currentLocale));
        }
    }

    protected void setup() {
        if (this.rfsButton != null) {
            this.rfsButton.setOnClick(this.getId() + "_Obj.openRFS()");
        }
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        this.textEntry = (TextEntry)this.getComponent(SASLIBRARY_TEXT);
        if (this.getOnChange() != null && this.textEntry != null) {
            this.textEntry.setOnChange(this.getOnChange());
        }
        JavaScriptIncludeHandler.writeIncludes(out, "MODALSELECTOR", this.getRequest());
        JavaScriptIncludeHandler.writeIncludes(out, "SASLIBRARYPICKER", this.getRequest());
        this.setup();
        this.getTemplateDictionary().put(LIBREF_ID, this.getId() + "_libref");
        this.getTemplateDictionary().put("ID", this.getId());
        TemplateSupport.writeTemplate(this, null, out);
        this.writeJavaScript(out);
    }

    protected void writeJavaScript(PrintWriter out) throws IOException {
        this.getURLTemplate().getValueDictionary().put("CONTEXTPATH", this.getRequest().getContextPath());
        this.getURLTemplate().getValueDictionary().put("id", this.getId());
        StringBuffer sb = new StringBuffer().append(JavaScriptIncludeHandler.getStartScript());
        String jsObj = this.getId() + "_Obj";
        sb.append(jsObj).append(" = new sas_SASLibraryPicker('").append(this.getId()).append("');\n");
        sb.append(jsObj).append(".url= \"").append(this.getURLTemplate().format()).append("\";");
        sb.append(JavaScriptIncludeHandler.getEndScript(null));
        out.println(sb.toString());
    }

    @Override
    public void setRequest(HttpServletRequest request) {
        super.setRequest(request);
        if (request != null) {
            ComponentSessionManager.getSessionManager(this.getRequest()).put(this.getId(), this);
        }
    }

    @Override
    public void setId(String value) {
        if (value != null && this.getRequest() != null) {
            String previousId = this.getId();
            if (previousId != null && ComponentSessionManager.getSessionManager(this.getRequest()).containsKey(previousId)) {
                ComponentSessionManager.getSessionManager(this.getRequest()).remove(previousId);
            }
            ComponentSessionManager.getSessionManager(this.getRequest()).put(value, this);
        }
        super.setId(value);
    }

    public static void openRemoteFileSelector(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String id = request.getParameter("id");
        TransformationInterface ti = (TransformationInterface)ComponentSessionManager.getSessionManager(request).get(id);
        if (ti instanceof SASLibraryPicker) {
            SASLibraryDialog sld;
            PrintWriter out = response.getWriter();
            SASLibraryPicker slp = (SASLibraryPicker)ti;
            slp.setRequest(request);
            slp.setResponse(response);
            String cmdid = request.getParameter("CMDID");
            if (cmdid != null) {
                slp.getActionProvider().executeCommand(request, response, out);
            }
            if ((sld = slp.getSASLibraryPanel()) == null) {
                TableView tv;
                slp.initializeRFS();
                sld = slp.getSASLibraryPanel();
                RemoteFileSelector rfs = (RemoteFileSelector)sld.getComponent("FILE_REMOTE_FILE_SELECTOR");
                if (rfs != null && (tv = (TableView)rfs.getComponent("RFS_FILE_DETAILVIEW")) != null) {
                    tv.setLockColumnHeaders(true);
                }
                sld.setRequest(request);
                sld.setResponse(response);
                sld.setActionProvider(slp.getActionProvider());
                ComponentSessionManager.getSessionManager(request).put(sld.getId(), sld);
            } else {
                sld.setRequest(request);
                sld.setResponse(response);
            }
            HashMap<String, String> dictionary = new HashMap<String, String>();
            dictionary.put("TITLE", RB.getStringResource(RB_KEY, "selectLibrary.txt", sld.getLocale()));
            BaseUtil.writeDialog(out, request, sld, dictionary, TemplateSupport.getTemplate(request, ValuePicker.DEFAULT_DIALOGTEMPLATE));
        }
    }

    public long getAllowedDataSources() {
        return this.allowedDataSources;
    }

    public void setAllowedDataSources(long allowedDataSources) {
        if (this.allowedDataSources != allowedDataSources) {
            this.allowedDataSources = allowedDataSources;
        }
    }

    public SASLibraryDialog getSASLibraryPanel() {
        return this.SASLibraryPanel;
    }

    public void setSASLibraryDialog(SASLibraryDialog sasLibrary) {
        this.SASLibraryPanel = sasLibrary;
    }

    public void initializeRFS() {
        if (this.SASLibraryPanel == null) {
            SASLibraryDialog panel = new SASLibraryDialog(this.getUserContext());
            panel.setOnChange(this.getOnChange());
            panel.setOnBlur(this.getOnBlur());
            panel.setOnFocus(this.getOnFocus());
            panel.setCallerId(this.getId());
            panel.setAJAXControllerURL(this.getAJAXControllerURL());
            this.setSASLibraryDialog(panel);
        }
    }

    @Override
    public String getOnBlur() {
        return this.onBlur;
    }

    @Override
    public void setOnBlur(String onBlur) {
        this.onBlur = onBlur;
    }

    @Override
    public String getOnChange() {
        return this.onChange;
    }

    @Override
    public void setOnChange(String onChange) {
        this.onChange = onChange;
    }

    @Override
    public String getOnFocus() {
        return this.onFocus;
    }

    @Override
    public void setOnFocus(String onFocus) {
        this.onFocus = onFocus;
    }

    public Object getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(Object initialValue) {
        TextEntry sasLibraryText = (TextEntry)this.getComponent(SASLIBRARY_TEXT);
        TextEntry libRef = (TextEntry)this.getComponent(SASLIBRARYPICKER_LIBREF);
        if (sasLibraryText != null) {
            if (initialValue instanceof SASLibraryLocationInterface) {
                sasLibraryText.setText(((SASLibraryLocationInterface)initialValue).getSASLibraryLocation());
                if (libRef != null) {
                    libRef.setText(((SASLibraryLocationInterface)initialValue).getLibref());
                }
            } else if (initialValue instanceof String) {
                sasLibraryText.setText(initialValue.toString());
            } else if (initialValue == null || initialValue.toString().length() == 0) {
                sasLibraryText.setText("");
                if (libRef != null) {
                    libRef.setText("");
                }
            }
        }
        this.initialValue = initialValue;
    }

    @Override
    public void cleanup(HttpServletRequest request) {
        this.cleanup(request.getSession());
    }

    @Override
    public void cleanup(HttpSession session) {
        super.cleanup(session);
        if (this.getSASLibraryPanel() != null) {
            this.getSASLibraryPanel().cleanup(session);
        }
    }

    static {
        JavaScriptIncludeHandler.addAlias(SASLibraryPicker.class, "SASLIBRARYPICKER");
        defaultStyleMap = new HashMap();
    }
}

