/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.datasource;

import com.sas.iom.SAS.IWorkspace;
import com.sas.models.FileLocation;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.services.user.UserContextInterface;
import com.sas.servlet.tbeans.AJAXControllerURLInterface;
import com.sas.servlet.tbeans.BaseCompositeTransformation;
import com.sas.servlet.tbeans.JavaScriptEventHandlerInterface;
import com.sas.servlet.tbeans.TemplateSupport;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.datasource.DataSourcePicker;
import com.sas.servlet.tbeans.datasource.DataSourceValidationException;
import com.sas.servlet.tbeans.datasource.DataSourceValidationInterface;
import com.sas.servlet.tbeans.datasource.IFileDialog;
import com.sas.servlet.tbeans.datasource.RB;
import com.sas.servlet.tbeans.form.html.TextEntry;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.remotefileselector2.html.RemoteFileSelector;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.servlet.tbeans.valuepicker.ValuePicker;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.ComponentSessionManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.swing.visuals.DataSourceUtil;
import com.sas.text.Message;
import com.sas.util.SimpleTemplate;
import com.sas.util.Util;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class IFilePicker
extends BaseCompositeTransformation
implements JavaScriptEventHandlerInterface,
AJAXControllerURLInterface,
DataSourceValidationInterface {
    protected TextEntry textEntry;
    protected Button rfsButton;
    private IFileDialog dialog;
    private IWorkspace iworkspace;
    private UserContextInterface userContext;
    private List fileTypes;
    private String logicalServerName;
    private FileLocation fileLocation;
    private String type = "OUTPUT_TYPE";
    public static final String INPUT_TYPE = "INPUT_TYPE";
    public static final String OUTPUT_TYPE = "OUTPUT_TYPE";
    public static final String separator = "@@";
    public static final String RB_KEY = "DataPicker.";
    public static final String DEFAULT_AJAX_URL_TEMPLATE = "%CONTEXTPATH/MethodInvocationServlet?CLASS_PARAMETER=" + IFilePicker.class.getName() + "&" + "METHOD" + "=openRemoteFileSelector&id=%id";

    public IFilePicker(IWorkspace iworkspace, List fileTypes) {
        this.iworkspace = iworkspace;
        this.fileTypes = fileTypes;
        this.fileLocation = new FileLocation(null, null);
        this.initialize();
    }

    public IFilePicker(UserContextInterface userContext, String logicalServerName, List fileTypes) {
        this.userContext = userContext;
        this.fileTypes = fileTypes;
        this.logicalServerName = logicalServerName;
        this.fileLocation = new FileLocation(null, null);
        this.initialize();
    }

    private void initialize() {
        this.setObjectDataProperty("text");
        this.setId(Util.getName((String)"fp"));
        this.setTemplateKey("Data_Source_Picker");
        SimpleTemplate ajaxURLTemplate = new SimpleTemplate();
        ajaxURLTemplate.setTemplate(DEFAULT_AJAX_URL_TEMPLATE);
        ajaxURLTemplate.setValueDictionary(new HashMap());
        this.setURLTemplate(ajaxURLTemplate);
        this.addComponents();
    }

    public void setText(String value) {
        if (value != null) {
            this.fileLocation.parseString(value);
            this.textEntry.setText(this.fileLocation.getFileLocation());
        } else {
            this.textEntry.setText("");
        }
    }

    public IWorkspace getIWorkspace() {
        return this.iworkspace;
    }

    public List getFileTypes() {
        return this.fileTypes;
    }

    protected void addComponents() {
        this.textEntry = new TextEntry();
        this.textEntry.setSize(50);
        this.textEntry.setId(this.getId() + "_textEntry");
        this.setComponent(DataSourcePicker.DATASOURCE_TEXT, this.textEntry);
        this.rfsButton = new Button();
        this.rfsButton.setId(this.getId() + "_button");
        this.setComponent(DataSourcePicker.DATASOURCE_BUTTON, this.rfsButton);
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        this._setLocaleDependentProperties(locale);
    }

    private void _setLocaleDependentProperties(Locale currentLocale) {
        if (this.rfsButton != null) {
            this.rfsButton.setLabel(RB.getStringResource(RB_KEY, "browse.txt", currentLocale));
        }
    }

    protected void setup() {
        if (this.rfsButton != null) {
            this.rfsButton.setOnClick(this.getId() + "_Obj.openRFS()");
        }
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        JavaScriptIncludeHandler.writeIncludes(out, "AJAX", this.getRequest());
        JavaScriptIncludeHandler.writeIncludes(out, "MODALSELECTOR", this.getRequest());
        JavaScriptIncludeHandler.writeIncludes(out, "IFILEPICKER", this.getRequest());
        this.setup();
        TemplateSupport.writeTemplate(this, null, out);
        this.writeJavaScript(out);
    }

    protected void writeJavaScript(PrintWriter out) throws IOException {
        this.getURLTemplate().getValueDictionary().put("CONTEXTPATH", this.getRequest().getContextPath());
        this.getURLTemplate().getValueDictionary().put("id", this.getId());
        StringBuffer sb = new StringBuffer().append(JavaScriptIncludeHandler.getStartScript());
        String jsObj = this.getId() + "_Obj";
        sb.append(jsObj).append(" = new sas_IFilePicker('").append(this.getId()).append("');\n");
        sb.append(jsObj).append(".url= \"").append(this.getURLTemplate().format()).append("\";");
        sb.append(jsObj + ".servername = \"" + this.getLogicalServerName() + "\";");
        sb.append(jsObj + ".separator = \" " + separator + " \";");
        sb.append(jsObj + ".dirOnly = \"false\";");
        sb.append(JavaScriptIncludeHandler.getEndScript(null));
        out.println(sb.toString());
    }

    @Override
    public void setRequest(HttpServletRequest request) {
        super.setRequest(request);
        if (request != null) {
            ComponentSessionManager.getSessionManager(this.getRequest()).put(this.getId(), this);
        }
    }

    @Override
    public void setId(String value) {
        if (value != null && this.getRequest() != null) {
            String previousId = this.getId();
            if (previousId != null && ComponentSessionManager.getSessionManager(this.getRequest()).containsKey(previousId)) {
                ComponentSessionManager.getSessionManager(this.getRequest()).remove(previousId);
            }
            ComponentSessionManager.getSessionManager(this.getRequest()).put(value, this);
        }
        super.setId(value);
    }

    public static void openRemoteFileSelector(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String id = request.getParameter("id");
        TransformationInterface ti = (TransformationInterface)ComponentSessionManager.getSessionManager(request).get(id);
        if (ti instanceof IFilePicker) {
            IFileDialog selectorPanel;
            PrintWriter out = response.getWriter();
            IFilePicker picker = (IFilePicker)ti;
            String cmdid = request.getParameter("CMDID");
            if (cmdid != null) {
                picker.getActionProvider().executeCommand(request, response, out);
            }
            if ((selectorPanel = picker.getDialog()) == null) {
                TableView tv;
                picker.initializeRFS();
                selectorPanel = picker.getDialog();
                RemoteFileSelector rfs = (RemoteFileSelector)selectorPanel.getComponent("FILE_REMOTE_FILE_SELECTOR");
                if (rfs != null && (tv = (TableView)rfs.getComponent("RFS_FILE_DETAILVIEW")) != null) {
                    tv.setLockColumnHeaders(true);
                }
                selectorPanel.setRequest(request);
                selectorPanel.setResponse(response);
                selectorPanel.setActionProvider(picker.getActionProvider());
                ComponentSessionManager.getSessionManager(request).put(selectorPanel.getId(), selectorPanel);
            } else {
                selectorPanel.resetWorkspace();
                selectorPanel.setRequest(request);
                selectorPanel.setResponse(response);
            }
            HashMap<String, String> dictionary = new HashMap<String, String>();
            dictionary.put("TITLE", RB.getStringResource("IFileDialog.", "selectFile.txt", selectorPanel.getLocale()));
            BaseUtil.writeDialog(out, request, selectorPanel, dictionary, TemplateSupport.getTemplate(request, ValuePicker.DEFAULT_DIALOGTEMPLATE));
        }
    }

    public void actionPerformed(ActionEvent e) {
    }

    public IFileDialog getDialog() {
        return this.dialog;
    }

    public void setDialog(IFileDialog fileSelectorPanel) {
        this.dialog = fileSelectorPanel;
    }

    public void initializeRFS() {
        if (this.dialog == null) {
            IFileDialog filedialog;
            if (this.userContext != null) {
                try {
                    filedialog = new IFileDialog(this.userContext, this.getLogicalServerName(), this.fileTypes);
                }
                catch (ServerConnectionException e) {
                    filedialog = new IFileDialog(this.iworkspace, this.fileTypes);
                }
            } else {
                filedialog = new IFileDialog(this.iworkspace, this.fileTypes);
            }
            filedialog.setOnChange(this.getOnChange());
            filedialog.setOnBlur(this.getOnBlur());
            filedialog.setOnFocus(this.getOnFocus());
            filedialog.setCallerId(this.getId());
            filedialog.setIFilePicker(this);
            filedialog.setAJAXControllerURL(this.getAJAXControllerURL());
            this.setDialog(filedialog);
        }
    }

    @Override
    public void setOnChange(String eventHandler) {
        this.textEntry.setOnChange(eventHandler);
    }

    @Override
    public String getOnChange() {
        return this.textEntry.getOnChange();
    }

    @Override
    public void setOnFocus(String value) {
        this.textEntry.setOnFocus(value);
    }

    @Override
    public String getOnFocus() {
        return this.textEntry.getOnFocus();
    }

    @Override
    public void setOnBlur(String value) {
        this.textEntry.setOnBlur(value);
    }

    @Override
    public String getOnBlur() {
        return this.textEntry.getOnBlur();
    }

    public String getLogicalServerName() {
        return this.logicalServerName;
    }

    public void setLogicalServerName(String logicalServerName) {
        this.logicalServerName = logicalServerName;
    }

    @Override
    public void cleanup(HttpServletRequest request) {
        this.cleanup(request.getSession());
    }

    @Override
    public void cleanup(HttpSession session) {
        super.cleanup(session);
        if (this.getDialog() != null) {
            this.getDialog().cleanup(session);
        }
    }

    public String getType() {
        if (this.type.equals(INPUT_TYPE)) {
            return INPUT_TYPE;
        }
        return OUTPUT_TYPE;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void validate(Object value, Locale locale) throws Exception {
        if (this.getType().equals(INPUT_TYPE) && value instanceof String) {
            String fullValue = (String)value;
            String fileName = fullValue.substring(fullValue.indexOf(separator) + separator.length(), fullValue.lastIndexOf(separator));
            fileName = fileName.trim();
            IWorkspace _iworkspace = this.getIWorkspace();
            DataProvider dataProvider = null;
            if (_iworkspace == null && this.logicalServerName != null) {
                dataProvider = new DataProvider(this.userContext);
                _iworkspace = dataProvider.getIWorkspace(this.logicalServerName);
            }
            if (!DataSourceUtil.isExistingFile((IWorkspace)_iworkspace, (String)fileName)) {
                if (dataProvider != null) {
                    dataProvider.close();
                }
                String error = new Message(com.sas.swing.visuals.RB.getStringResource((String)"IFilePicker.", (String)"notAFile.ex.txt", (Locale)locale), (Object)fileName).toString();
                throw new DataSourceValidationException(error);
            }
            if (dataProvider != null) {
                dataProvider.close();
            }
        }
    }

    static {
        JavaScriptIncludeHandler.addAlias(IFilePicker.class, "IFILEPICKER");
    }
}

