/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.datasource;

import com.sas.actionprovider.Area;
import com.sas.actionprovider.HttpAction;
import com.sas.actionprovider.HttpActionProvider;
import com.sas.iom.SAS.IWorkspace;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.services.user.UserContextInterface;
import com.sas.servlet.tbeans.BaseButton;
import com.sas.servlet.tbeans.BaseCompositeTransformation;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.JavaScriptEventHandlerInterface;
import com.sas.servlet.tbeans.TemplateSupport;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.dataselectors.SelectorContainerKeysInterface;
import com.sas.servlet.tbeans.dataselectors.html.SelectorContainerStyleKeysInterface;
import com.sas.servlet.tbeans.datasource.DataSourceDialogKeysInterface;
import com.sas.servlet.tbeans.datasource.DataSourceDialogStyleKeysInterface;
import com.sas.servlet.tbeans.datasource.DataSourcePicker;
import com.sas.servlet.tbeans.datasource.IFilePicker;
import com.sas.servlet.tbeans.datasource.RB;
import com.sas.servlet.tbeans.form.html.TextEntry;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.remotefileselector2.html.IFileServiceSelector;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.servlet.tbeans.valuepicker.ValuePicker;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.ComponentSessionManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.swing.models.remotefileselector2.BaseRemoteFileServerModel;
import com.sas.swing.models.remotefileselector2.RemoteFileNavigationModelInterface;
import com.sas.util.MapWithDefaults;
import com.sas.util.SimpleTemplate;
import com.sas.util.Util;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class IFileDialog
extends BaseCompositeTransformation
implements DataSourceDialogStyleKeysInterface,
DataSourceDialogKeysInterface,
SelectorContainerStyleKeysInterface,
SelectorContainerKeysInterface,
JavaScriptEventHandlerInterface {
    private static final long serialVersionUID = -8190384233826042100L;
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "IFileDialog.html";
    private static final String DEFAULT_RFS_TEMPLATE = "FileSelectorRemoteFileSelector.html";
    private IFileServiceSelector remoteFileSelector;
    private String callerId;
    private String onBlur;
    private String onFocus;
    private String onChange;
    private SimpleTemplate ajaxCombineFileFolderTemplate;
    private IFilePicker iFilePicker;
    private DataProvider dataProvider;
    private UserContextInterface userContext;
    private String logicalServerName;
    protected Label fileNameLabel;
    protected TextEntry fileNameText;
    protected BaseButton okButton;
    protected BaseButton cancelButton;
    private static final HashMap defaultStyleMap = new HashMap();
    private static final ImmutableStyleInfo containerStyle = new ImmutableStyleInfo("dataSelectorPanelContainer");
    private static final ImmutableStyleInfo labelStyle = new ImmutableStyleInfo("selectorLabel");
    private static final ImmutableStyleInfo valueTextEntryStyle = new ImmutableStyleInfo("selectorTextEntry fileSelectorInput");
    private static final ImmutableStyleInfo fileTypeChoiceBoxStyle = new ImmutableStyleInfo("selectorChoice fileSelectorChoice");
    private static final ImmutableStyleInfo buttonStyle = new ImmutableStyleInfo("selectorButton");
    private CommonLoggerInterface log = LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory());
    public static final String DEFAULT_AJAX_URL_TEMPLATE = "%CONTEXTPATH/MethodInvocationServlet?CLASS_PARAMETER=%CLASS_PARAMETER&METHOD=%METHOD&id=%id";
    public static final String RB_KEY = "IFileDialog.";

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put("FILE_PANEL_CONTAINER", containerStyle);
            defaultStyleMap.put("FILE_FILE_NAME_LABEL", labelStyle);
            defaultStyleMap.put("FILE_FILE_NAME_TEXTENTRY", valueTextEntryStyle);
            defaultStyleMap.put("FILE_FILE_TYPE_LABEL", labelStyle);
            defaultStyleMap.put("FILE_FILE_TYPE_CHOICEBOX", fileTypeChoiceBoxStyle);
            defaultStyleMap.put("SELECTOR_CONTAINER_OK_BUTTON", buttonStyle);
            defaultStyleMap.put("SELECTOR_CONTAINER_CANCEL_BUTTON", buttonStyle);
        }
    }

    public IFileDialog(UserContextInterface userContext, String logicalServerName, List fileTypes) throws ServerConnectionException {
        this.userContext = userContext;
        this.logicalServerName = logicalServerName;
        this.dataProvider = new DataProvider(userContext);
        this.initialize(this.dataProvider.getIWorkspace(logicalServerName), fileTypes);
    }

    public IFileDialog(IWorkspace iworkspace, List fileTypes) {
        this.initialize(iworkspace, fileTypes);
    }

    public void resetWorkspace() {
        this.remoteFileSelector = (IFileServiceSelector)this.getComponent("FILE_REMOTE_FILE_SELECTOR");
        if (this.remoteFileSelector != null) {
            this.dataProvider = new DataProvider(this.userContext);
            try {
                this.remoteFileSelector.setWorkspace(this.dataProvider.getIWorkspace(this.logicalServerName));
            }
            catch (ServerConnectionException e) {
                e.printStackTrace();
            }
        }
    }

    private void initialize(IWorkspace iworkspace, List fileTypes) {
        RemoteFileNavigationModelInterface model;
        this.setId(Util.getName((String)"fs_panel"));
        IFileDialog.setupDefaultStyleMap();
        MapWithDefaults stylemap = (MapWithDefaults)this.getStyleMap();
        stylemap.setDefaultMap((Map)defaultStyleMap);
        this.setTemplateKey("IFile_Dialog");
        SimpleTemplate ajaxURLTemplate = new SimpleTemplate();
        ajaxURLTemplate.setTemplate(DEFAULT_AJAX_URL_TEMPLATE);
        ajaxURLTemplate.setValueDictionary(new HashMap());
        this.setURLTemplate(ajaxURLTemplate);
        this.ajaxCombineFileFolderTemplate = new SimpleTemplate();
        this.ajaxCombineFileFolderTemplate.setTemplate(BaseUtil.AJAX_BASEUTIL_URL_TEMPLATE);
        this.ajaxCombineFileFolderTemplate.setValueDictionary(new HashMap());
        this.remoteFileSelector = new IFileServiceSelector(iworkspace, null, null);
        this.remoteFileSelector.setId(this.getId() + "_rfs");
        this.remoteFileSelector.setTemplateKey("File_Selector_Remote_File_Selector");
        this.remoteFileSelector.setPartialRefreshActionsEnabled(true);
        if (fileTypes != null && (model = this.remoteFileSelector.getModel()) instanceof BaseRemoteFileServerModel) {
            if (fileTypes != null) {
                for (String type : fileTypes) {
                    if (type == null || type.charAt(0) != '.') continue;
                    fileTypes.set(fileTypes.indexOf(type), type.substring(1));
                }
            }
            ((BaseRemoteFileServerModel)model).setFilterValues(fileTypes);
        }
        this.setComponent("FILE_REMOTE_FILE_SELECTOR", this.remoteFileSelector);
        this.fileNameLabel = new Label();
        this.fileNameLabel.setId(this.getId() + "_fileNameLabel");
        this.fileNameLabel.setStyleInfo(labelStyle);
        this.setComponent("FILE_NAME_LABEL", this.fileNameLabel);
        this.fileNameText = new TextEntry();
        this.fileNameText.setId(this.getId() + "_fileName");
        this.fileNameText.setStyleInfo(valueTextEntryStyle);
        this.fileNameText.setEnabled(true);
        this.setComponent("FILE_NAME_TEXTENTRY", this.fileNameText);
        this.okButton = new Button();
        this.okButton.setOnClick(this.getId() + "_Obj.OKAction();");
        this.setComponent("SELECTORCONTAINER_OK_BUTTON", this.okButton);
        this.cancelButton = new Button();
        this.cancelButton.setOnClick(this.getId() + "_Obj.CancelAction();");
        this.setComponent("SELECTORCONTAINER_CANCEL_BUTTON", this.cancelButton);
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        this._setLocaleDependentProperties(locale);
    }

    private void _setLocaleDependentProperties(Locale locale) {
        this.fileNameLabel.setText(RB.getStringResource(RB_KEY, "fileName.txt", locale));
        this.okButton.setLabel(RB.getStringResource(RB_KEY, "ok.txt", locale));
        this.cancelButton.setLabel(RB.getStringResource(RB_KEY, "cancel.txt", locale));
    }

    public static void performAction(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType(BaseUtil.TEXT_PLAIN_MIME_TYPE);
        String id = request.getParameter("id");
        TransformationInterface ti = (TransformationInterface)ComponentSessionManager.getSessionManager(request).get(id);
        if (ti instanceof IFileDialog) {
            PrintWriter out = response.getWriter();
            IFileDialog fsp = (IFileDialog)ti;
            String cmdid = request.getParameter("CMDID");
            if (cmdid != null) {
                fsp.getActionProvider().executeCommand(request, response, out);
                fsp.setRequest(request);
                fsp.setResponse(response);
            }
            IFileServiceSelector ifss = (IFileServiceSelector)fsp.getComponent("FILE_REMOTE_FILE_SELECTOR");
            ifss.setRequest(request);
            ifss.setResponse(response);
            fsp.setRequest(request);
            fsp.setResponse(response);
            BaseUtil.writeDialog(out, request, fsp, TemplateSupport.getTemplate(request, ValuePicker.DEFAULT_DIALOGTEMPLATE));
        }
    }

    @Override
    public void setActionProvider(HttpActionProvider ap) {
        super.setActionProvider(ap);
        if (ap != null) {
            this.remoteFileSelector.setActionProvider(ap);
            TableView tv = (TableView)this.remoteFileSelector.getComponent("RFS_FILE_DETAILVIEW");
            HttpAction selectFileAction = (HttpAction)this.remoteFileSelector.getActionProvider().getDefaultAction("REMOTE_FILE_SELECTOR2_COMPOSITE_SUPPORT", "DATA_CELL_AREA", "SELECT_FILE_IFILE_ACTION");
            selectFileAction.setURLTemplate(new SimpleTemplate("javascript:void(" + this.getId() + "_Obj.fileSelected('%fileName'))"));
            ArrayList<TableView> viewers = new ArrayList<TableView>();
            viewers.add(tv);
            this.remoteFileSelector.getActionProvider().setAction(selectFileAction, viewers, new Area("DATA_CELL_AREA"));
        }
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        this.remoteFileSelector.setRequest(this.getRequest());
        this.remoteFileSelector.setResponse(this.getResponse());
        JavaScriptIncludeHandler.writeIncludes(out, "IFILEDIALOG", this.getRequest());
        if (this.getActionProvider() == null) {
            out.println("ActionProvider is null " + this.getId());
            return;
        }
        if (this.getIFilePicker() != null) {
            TextEntry te = (TextEntry)this.getIFilePicker().getComponent(DataSourcePicker.DATASOURCE_TEXT);
            String path = te.getText();
            String fileName = null;
            String parentPath = null;
            if (path != null && path.length() > 0) {
                int index = path.lastIndexOf("/");
                if (index != -1) {
                    parentPath = path.substring(0, index) + "/";
                    fileName = path.substring(index + 1);
                } else {
                    index = path.lastIndexOf("\\");
                    if (index != -1) {
                        parentPath = path.substring(0, index) + "\\";
                        fileName = path.substring(index + 1);
                    }
                }
            }
            if (parentPath != null) {
                this.remoteFileSelector.getModel().setLocation(parentPath);
                this.fileNameText = (TextEntry)this.getComponent("FILE_NAME_TEXTENTRY");
                this.fileNameText.setText(fileName);
            }
        }
        this.writeTemplate(this, null, out);
        out.println(JavaScriptIncludeHandler.getStartScript());
        String jsObj = this.getId() + "_Obj";
        out.println(jsObj + " = new sas_IFileDialog('" + this.getId() + "', '" + this.getActionProvider().getParameterPrefix() + "', '" + this.getId() + "');");
        this.getURLTemplate().getValueDictionary().put("id", this.getId());
        this.getURLTemplate().getValueDictionary().put("METHOD", "performAction");
        this.getURLTemplate().getValueDictionary().put("CLASS_PARAMETER", IFileDialog.class.getName());
        out.println(jsObj + ".url = \"" + this.getURLTemplate().format() + "\";");
        out.println(jsObj + ".callerId = \"" + this.getCallerId() + "\";");
        out.println(jsObj + ".onChangeEvent = \"" + this.getOnChange() + "\";");
        Map map = this.ajaxCombineFileFolderTemplate.getValueDictionary();
        map.put("BASE_AJAX_URL", this.getAJAXControllerURL());
        if (this.getAJAXControllerURL().indexOf("?") == -1) {
            map.put("AJAX_URL_SUFFIX", "?");
        } else {
            map.put("AJAX_URL_SUFFIX", "&");
        }
        out.println(jsObj + ".urlCombine = \"" + this.ajaxCombineFileFolderTemplate.format() + "\";");
        if (this.getIFilePicker() != null) {
            boolean existCheck = this.getIFilePicker().getType().equals("INPUT_TYPE");
            out.println(jsObj + ".isExistCheck = " + existCheck + ";");
        }
        out.println(" if ( sas_FastClick_createFastClickManager != null && typeof sas_FastClick_createFastClickManager == 'function' )");
        out.println(" { ");
        out.println(" sas_FastClick_createFastClickManager();");
        out.println(" } ");
        out.println(JavaScriptIncludeHandler.getEndScript(null));
        this.cleanUpResources();
    }

    public String getCallerId() {
        return this.callerId;
    }

    public void setCallerId(String callerId) {
        this.callerId = callerId;
    }

    @Override
    public void setOnChange(String eventHandler) {
        this.onChange = eventHandler;
    }

    @Override
    public String getOnChange() {
        return this.onChange;
    }

    @Override
    public void setOnFocus(String eventHandler) {
        this.onFocus = eventHandler;
    }

    @Override
    public String getOnFocus() {
        return this.onFocus;
    }

    @Override
    public void setOnBlur(String eventHandler) {
        this.onBlur = eventHandler;
    }

    @Override
    public String getOnBlur() {
        return this.onBlur;
    }

    public IFilePicker getIFilePicker() {
        return this.iFilePicker;
    }

    public void setIFilePicker(IFilePicker filePicker) {
        this.iFilePicker = filePicker;
    }

    @Override
    public void cleanup(HttpServletRequest request) {
        this.cleanup(request.getSession());
    }

    @Override
    public void cleanup(HttpSession session) {
        super.cleanup(session);
        this.closeResources();
    }

    public void closeResources() {
        if (this.dataProvider != null) {
            try {
                this.dataProvider.close();
            }
            catch (ServerConnectionException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        JavaScriptIncludeHandler.addAlias(IFileDialog.class, "IFILEDIALOG");
    }
}

