/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.datasource;

import com.sas.models.datasources.DataSourceColumnInterface;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.iq.InfoMapItemsValueProvider;
import com.sas.prompts.valueprovider.dynamic.workspace.ColumnNamesValueProvider;
import com.sas.services.user.UserContextInterface;
import com.sas.servlet.tbeans.AJAXControllerURLInterface;
import com.sas.servlet.tbeans.BaseCompositeTransformation;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.JavaScriptEventHandlerInterface;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.TemplateSupport;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.datasource.DataSourceColumnDialog;
import com.sas.servlet.tbeans.datasource.DataSourceColumnItemListManager;
import com.sas.servlet.tbeans.datasource.RB;
import com.sas.servlet.tbeans.datasource.ValueProviderAdapter;
import com.sas.servlet.tbeans.form.html.ChoiceBox;
import com.sas.servlet.tbeans.form.html.TextEntry;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.remotefileselector2.html.RemoteFileSelector;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.servlet.tbeans.valuepicker.ValuePicker;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.ComponentSessionManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.swing.models.ValueItemsToTableModelAdapter;
import com.sas.util.MapWithDefaults;
import com.sas.util.SimpleTemplate;
import com.sas.util.Strings;
import com.sas.util.Util;
import com.sas.util.ValueItem;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class DataSourceColumnPicker
extends BaseCompositeTransformation
implements JavaScriptEventHandlerInterface,
AJAXControllerURLInterface {
    private BaseTransformation sourceComponent;
    public static final String RB_KEY = "DataPicker.";
    private static final ImmutableStyleInfo dataSourceColumnStyle = new ImmutableStyleInfo("dataSourceColumnTable");
    private static final long serialVersionUID = 1L;
    private boolean allowMultipleDataSource = true;
    protected Button rfsButton;
    private long allowedColumnTypes;
    private int selectionType;
    private UserContextInterface userContext;
    private long allowedDataSources;
    private static final HashMap defaultStyleMap = new HashMap();
    private SimpleTemplate ajaxURLTemplate;
    private DataSourceInterface dataSource;
    private String onChange;
    private String onFocus;
    private String onBlur;
    private DataProviderInterface dataProvider;
    private DataSourceInterface displayedDataSource;
    private String warningMessage;
    private boolean errorState;
    public static final int SINGLE_SELECTION = 300;
    public static final int MULTIPLE_SELECTION = 301;
    public static final int ORDERED_MULTIPLE_SELECTION = 302;
    private DataSourceColumnDialog dataSourcePanel;
    public static final String DATASOURCECOLUMN_TABLE_STYLE = "DATASOURCECOLUMN_TABLE_STYLE";
    public static final String DATASOURCECOLUMN_ITEMLISTMANAGER = "DATASOURCECOLUMN_ITEMLISTMANAGER";
    public static final String DATASOURCECOLUMN_CHOICEBOX = "DATASOURCECOLUMN_CHOICEBOX";
    public static final String DATASOURCECOLUMN_BROWSE_BUTTON = "DATASOURCECOLUMN_BROWSE_BUTTON";
    public static final String DEFAULT_AJAX_URL_TEMPLATE = "%CONTEXTPATH/MethodInvocationServlet?CLASS_PARAMETER=" + DataSourceColumnPicker.class.getName() + "&" + "METHOD" + "=openRemoteFileSelector&id=%id&dsColumnId=%dsColumnId";
    private Object initialValue;
    private List dataSources;
    private int maxValues;

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0 || defaultStyleMap.get(DATASOURCECOLUMN_TABLE_STYLE) == null) {
            defaultStyleMap.put(DATASOURCECOLUMN_TABLE_STYLE, dataSourceColumnStyle);
        }
    }

    public DataSourceColumnPicker(UserContextInterface userContext) {
        this(userContext, -1L, -1L, 300, null);
    }

    public DataSourceColumnPicker(UserContextInterface userContext, long allowedDataSources, long allowedColumnTypes, int selectionType, List dataSources) {
        this.selectionType = selectionType;
        this.setId(Util.getName((String)"dataSourceColumnPicker"));
        this.userContext = userContext;
        this.allowedDataSources = allowedDataSources;
        this.allowedColumnTypes = allowedColumnTypes;
        this.dataSources = dataSources;
        this.maxValues = -1;
        this.setObjectDataProperty("initialValue");
        DataSourceColumnPicker.setupDefaultStyleMap();
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap((Map)defaultStyleMap);
        this.ajaxURLTemplate = new SimpleTemplate();
        this.ajaxURLTemplate.setTemplate(DEFAULT_AJAX_URL_TEMPLATE);
        this.ajaxURLTemplate.setValueDictionary(new HashMap());
        this.setTemplateKey("Data_Source_Column_Picker");
        this.errorState = false;
        this.addComponents();
    }

    public UserContextInterface getUserContext() {
        return this.userContext;
    }

    public List getDataSources() {
        return this.dataSources;
    }

    public void setDataSources(List dataSources) {
        this.dataSources = dataSources;
    }

    protected void addComponents() {
        this.rfsButton = new Button();
        this.rfsButton.setId(this.getId() + "_button");
        if (this.selectionType == 301 || this.selectionType == 302) {
            this.sourceComponent = new DataSourceColumnItemListManager();
            DefaultTableModel m = new DefaultTableModel();
            TableView tv = (TableView)((DataSourceColumnItemListManager)this.sourceComponent).getComponent("ITEMLISTMANAGER_TABLE");
            ((DataSourceColumnItemListManager)this.sourceComponent).setModel(m);
            tv.setColumnHeaderVisible(true);
            tv.setLockColumnHeaders(false);
            this.sourceComponent.setId(this.getId() + "_ilm");
            this.setComponent(DATASOURCECOLUMN_ITEMLISTMANAGER, this.sourceComponent);
            ((DataSourceColumnItemListManager)this.sourceComponent).setComponent(DATASOURCECOLUMN_BROWSE_BUTTON, this.rfsButton);
        } else {
            if (this.dataSources == null || this.dataSources.isEmpty()) {
                this.sourceComponent = new ChoiceBox();
                ((ChoiceBox)this.sourceComponent).setStyleInfo(new StyleInfo(null, "width: 200px"));
                this.sourceComponent.setId(this.getId() + "_choice");
                this.setComponent(DATASOURCECOLUMN_CHOICEBOX, this.sourceComponent);
            } else {
                this.sourceComponent = new ValuePicker(this.getValueProvider(), 400, 300, this.getLocale());
                this.sourceComponent.setId(this.getId() + "_choice");
                this.setComponent(DATASOURCECOLUMN_CHOICEBOX, this.sourceComponent);
            }
            this.setComponent(DATASOURCECOLUMN_BROWSE_BUTTON, this.rfsButton);
        }
    }

    private String getType() {
        if (this.getSelectionType() == 301) {
            return "sas_DataSourceColumnPicker.ITEM_LIST_MANAGER";
        }
        if (this.getSelectionType() == 300 && (this.getDataSources() == null || this.getDataSources().isEmpty())) {
            return "sas_DataSourceColumnPicker.CHOICE_BOX";
        }
        return "sas_DataSourceColumnPicker.VALUE_PICKER";
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        this._setLocaleDependentProperties(locale);
    }

    private void _setLocaleDependentProperties(Locale currentLocale) {
        if (this.rfsButton != null) {
            if (this.selectionType == 300) {
                this.rfsButton.setLabel(RB.getStringResource(RB_KEY, "browse.txt", currentLocale));
            } else {
                this.rfsButton.setLabel("...");
            }
        }
        if (this.selectionType == 301 || this.selectionType == 302) {
            this.sourceComponent = (BaseTransformation)this.getComponent(DATASOURCECOLUMN_ITEMLISTMANAGER);
            if (this.sourceComponent instanceof DataSourceColumnItemListManager && ((DataSourceColumnItemListManager)this.sourceComponent).getModel() instanceof ValueItemsToTableModelAdapter) {
                ValueItemsToTableModelAdapter m = (ValueItemsToTableModelAdapter)((DataSourceColumnItemListManager)this.sourceComponent).getModel();
                m.setColumnName(RB.getStringResource(RB_KEY, "column.txt", currentLocale), 0);
                m.setColumnName(RB.getStringResource(RB_KEY, "dataSource.txt", currentLocale), 1);
            }
        }
    }

    private DataSourceValueProviderAdapter getValueProvider() {
        DataSourceValueProviderAdapter vpAdapter = new DataSourceValueProviderAdapter(this.getAllowedDataSources(), this.allowedColumnTypes, this.dataSources);
        if (this.dataSources == null) {
            return vpAdapter;
        }
        ArrayList<ColumnNamesValueProvider> providers = new ArrayList<ColumnNamesValueProvider>();
        for (DataSourceInterface dataSource : this.dataSources) {
            ColumnNamesValueProvider valueProvider = null;
            if (dataSource.getDataSourceType() == 1L) {
                ColumnNamesValueProvider columnNameValueProvider = new ColumnNamesValueProvider(dataSource.getDataSourceLocation());
                columnNameValueProvider.setValueDisplayed(true);
                columnNameValueProvider.setDataProvider(this.getDataProvider());
                valueProvider = columnNameValueProvider;
            } else if (dataSource.getDataSourceType() == 4L) {
                InfoMapItemsValueProvider infoMapItemsValueProvider = new InfoMapItemsValueProvider();
                infoMapItemsValueProvider.setIsOLAP(false);
                infoMapItemsValueProvider.setValueDisplayed(true);
                infoMapItemsValueProvider.setInfoMapUrl(dataSource.getDataSourceLocation());
                infoMapItemsValueProvider.setDataProvider(this.getDataProvider());
                valueProvider = infoMapItemsValueProvider;
            }
            providers.add(valueProvider);
        }
        vpAdapter.setValueProviders(providers);
        return vpAdapter;
    }

    private DataProviderInterface getDataProvider() {
        if (this.dataProvider == null) {
            this.dataProvider = new DataProvider(this.getUserContext());
        }
        return this.dataProvider;
    }

    public void writeContent(PrintWriter out) throws IOException {
        if (this.rfsButton != null) {
            this.rfsButton.setOnClick(this.getId() + ".openRFS()");
        }
        if (this.sourceComponent != null) {
            if (this.sourceComponent instanceof ValuePicker) {
                ((ValuePicker)this.sourceComponent).setOnChange(this.getOnChange());
            } else if (this.sourceComponent instanceof ChoiceBox) {
                ((ChoiceBox)this.sourceComponent).setOnChange(this.getOnChange());
            } else if (this.sourceComponent instanceof DataSourceColumnItemListManager) {
                ((DataSourceColumnItemListManager)this.sourceComponent).setOnUpdate(this.getOnChange());
            }
        }
        JavaScriptIncludeHandler.writeIncludes(out, "MODALSELECTOR", this.getRequest());
        JavaScriptIncludeHandler.writeIncludes(out, "DATASOURCECOLUMNPICKER", this.getRequest());
        TemplateSupport.writeTemplate(this, null, out);
        this.writeJavaScript(out);
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (this.warningMessage != null) {
            out.println(JavaScriptIncludeHandler.getStartScript());
            out.println("alert(\"" + Strings.escapeForJavaScript((String)this.warningMessage) + "\");");
            out.println(JavaScriptIncludeHandler.getEndScript(null));
            if (this.errorState) {
                Button browse = (Button)this.getComponent(DATASOURCECOLUMN_BROWSE_BUTTON);
                if (browse != null) {
                    browse.setEnabled(false);
                }
                BaseTransformation source = (BaseTransformation)this.getComponent(DATASOURCECOLUMN_CHOICEBOX);
                TextEntry te = new TextEntry();
                te.setEnabled(false);
                this.setComponent(DATASOURCECOLUMN_CHOICEBOX, te);
                this.errorState = false;
            }
        }
        this.warningMessage = null;
        out.println("<div id=\"" + this.getId() + "_container\">");
        this.writeContent(out);
        out.println("</div>");
    }

    public void writeJavaScript(PrintWriter out) {
        this.getAjaxURLTemplate().getValueDictionary().put("CONTEXTPATH", this.getRequest().getContextPath());
        this.getAjaxURLTemplate().getValueDictionary().put("id", this.getId());
        this.getAjaxURLTemplate().getValueDictionary().put("dsColumnId", this.getId());
        StringBuffer sb = new StringBuffer();
        sb.append(JavaScriptIncludeHandler.getStartScript());
        String choiceBoxId = null;
        if (this.getSelectionType() == 300) {
            TransformationInterface datasourceColumn = this.getComponent(DATASOURCECOLUMN_CHOICEBOX);
            TransformationInterface cb = null;
            if (datasourceColumn instanceof ValuePicker) {
                cb = ((ValuePicker)datasourceColumn).getComponent(ValuePicker.VALUEPICKER_SOURCE_COMPONENT);
            } else if (datasourceColumn instanceof ChoiceBox) {
                cb = datasourceColumn;
            }
            if (cb != null) {
                choiceBoxId = cb.getId();
            }
        }
        sb.append("" + this.getId() + " = new sas_DataSourceColumnPicker('" + this.getId() + "', '" + choiceBoxId + "'," + this.getType() + ");\n");
        sb.append(this.getId()).append(".url= \"").append(this.getAjaxURLTemplate().format()).append("\";\n");
        sb.append(JavaScriptIncludeHandler.getEndScript(null));
        out.println(sb.toString());
    }

    @Override
    public void setRequest(HttpServletRequest request) {
        super.setRequest(request);
        if (request != null) {
            ComponentSessionManager.getSessionManager(this.getRequest()).put(this.getId(), this);
        }
    }

    @Override
    public void setId(String value) {
        if (value != null && this.getRequest() != null) {
            String previousId = this.getId();
            if (previousId != null && ComponentSessionManager.getSessionManager(this.getRequest()).containsKey(previousId)) {
                ComponentSessionManager.getSessionManager(this.getRequest()).remove(previousId);
            }
            ComponentSessionManager.getSessionManager(this.getRequest()).put(value, this);
        }
        super.setId(value);
    }

    public static void openRemoteFileSelector(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String id = request.getParameter("dsColumnId");
        TransformationInterface ti = (TransformationInterface)ComponentSessionManager.getSessionManager(request).get(id);
        if (ti instanceof DataSourceColumnPicker) {
            TableView tv;
            DataSourceColumnDialog dssp;
            PrintWriter out = response.getWriter();
            DataSourceColumnPicker dsp = (DataSourceColumnPicker)ti;
            String cmdid = request.getParameter("CMDID");
            if (cmdid != null) {
                dsp.getActionProvider().executeCommand(request, response, out);
            }
            if ((dssp = dsp.getDataSourceColumnPanel()) == null) {
                dsp.setRequest(request);
                dsp.setResponse(response);
                dsp.initializeRFS();
                dssp = dsp.getDataSourceColumnPanel();
                RemoteFileSelector rfs = (RemoteFileSelector)dssp.getComponent("FILE_REMOTE_FILE_SELECTOR");
                if (rfs != null && (tv = (TableView)rfs.getComponent("RFS_FILE_DETAILVIEW")) != null) {
                    tv.setLockColumnHeaders(true);
                }
                dssp.setRequest(request);
                dssp.setResponse(response);
                dssp.setActionProvider(dsp.getActionProvider());
                ComponentSessionManager.getSessionManager(request).put(dssp.getId(), dssp);
            } else {
                dssp.setRequest(request);
                dssp.setResponse(response);
            }
            BaseTransformation srcComponent = dsp.getSourceComponent();
            if (srcComponent instanceof DataSourceColumnItemListManager) {
                tv = (TableView)((DataSourceColumnItemListManager)srcComponent).getComponent("ITEMLISTMANAGER_TABLE");
                dssp.setObjectData(tv.getModel());
            }
            dssp.setAllowedDataSources(dsp.getAllowedDataSources());
            HashMap<String, String> dictionary = new HashMap<String, String>();
            String title = dssp.getSelectionType() == 300 ? RB.getStringResource("DataSourceColumnPicker.", "selectDataSourceItem.txt", dssp.getLocale()) : RB.getStringResource("DataSourceColumnPicker.", "selectDataSourceItems.txt", dssp.getLocale());
            dictionary.put("TITLE", title);
            BaseUtil.writeDialog(response.getWriter(), request, dssp, dictionary, TemplateSupport.getTemplate(request, ValuePicker.DEFAULT_DIALOGTEMPLATE));
        }
    }

    public long getAllowedDataSources() {
        return this.allowedDataSources;
    }

    public void setAllowedDataSources(long allowedDataSources) {
        if (this.allowedDataSources != allowedDataSources) {
            this.allowedDataSources = allowedDataSources;
        }
    }

    public DataSourceColumnDialog getDataSourceColumnPanel() {
        return this.dataSourcePanel;
    }

    public void setMaximumValueCount(int max) {
        if (max < -1) {
            max = -1;
        }
        if (this.maxValues != max) {
            int oldValue = this.maxValues;
            this.maxValues = max;
            this.firePropertyChange("maxValues", oldValue, this.maxValues);
            if (this.dataSourcePanel != null) {
                this.dataSourcePanel.setMaximumValueCount(this.maxValues);
            }
        }
    }

    public int getMaximumValueCount() {
        return this.maxValues;
    }

    public void setDataSourceColumnPanel(DataSourceColumnDialog dataSource) {
        if (this.dataSourcePanel != dataSource) {
            DataSourceColumnDialog oldValue = this.dataSourcePanel;
            this.dataSourcePanel = dataSource;
            this.firePropertyChange("dataSourcePanel", oldValue, dataSource);
            if (this.dataSourcePanel != null) {
                this.dataSourcePanel.setMaximumValueCount(this.maxValues);
            }
        }
    }

    private void initializeRFS() {
        if (this.dataSourcePanel == null) {
            DataSourceColumnDialog panel = new DataSourceColumnDialog(this.getUserContext(), this.getAllowedDataSources(), this.getAllowedColumnTypes(), this.getDataSources(), this);
            panel.setId(this.getId() + "_dialog");
            panel.setSelectionType(this.getSelectionType());
            panel.setDataSources(this.getDataSources());
            panel.setAllowMultipleDataSource(this.isAllowMultipleDataSource());
            panel.setCallerId(this.getId());
            panel.setOnBlur(this.getOnBlur());
            panel.setOnChange(this.getOnChange());
            panel.setOnFocus(this.getOnFocus());
            panel.setAJAXControllerURL(this.getAJAXControllerURL());
            this.setDataSourceColumnPanel(panel);
        }
    }

    public long getAllowedColumnTypes() {
        return this.allowedColumnTypes;
    }

    public boolean isAllowMultipleDataSource() {
        return this.allowMultipleDataSource;
    }

    public void setAllowMultipleDataSource(boolean allowMultipleDataSource) {
        this.allowMultipleDataSource = allowMultipleDataSource;
    }

    public SimpleTemplate getAjaxURLTemplate() {
        return this.ajaxURLTemplate;
    }

    public void setAjaxURLTemplate(SimpleTemplate ajaxURLTemplate) {
        this.ajaxURLTemplate = ajaxURLTemplate;
    }

    @Override
    public String getOnBlur() {
        return this.onBlur;
    }

    @Override
    public void setOnBlur(String onBlur) {
        this.onBlur = onBlur;
    }

    @Override
    public String getOnChange() {
        return this.onChange;
    }

    @Override
    public void setOnChange(String onChange) {
        this.onChange = onChange;
    }

    @Override
    public String getOnFocus() {
        return this.onFocus;
    }

    @Override
    public void setOnFocus(String onFocus) {
        this.onFocus = onFocus;
    }

    public int getSelectionType() {
        return this.selectionType;
    }

    public void setSelectionType(int selectionType) {
        this.selectionType = selectionType;
    }

    public DataSourceInterface getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSourceInterface dataSource) {
        this.dataSource = dataSource;
    }

    public Object getInitialValue() {
        return this.initialValue;
    }

    public DataSourceInterface getDisplayedDataSource() {
        return this.displayedDataSource;
    }

    public void setInitialValue(Object initialValue) {
        if (initialValue == null) {
            if (this.getSelectionType() == 300) {
                BaseTransformation datasourceColumn = (BaseTransformation)this.getComponent(DATASOURCECOLUMN_CHOICEBOX);
                datasourceColumn.setObjectData(null);
            } else if (this.sourceComponent instanceof DataSourceColumnItemListManager) {
                ValueItemsToTableModelAdapter dsTableModel = new ValueItemsToTableModelAdapter(new ArrayList());
                ArrayList<String> columns = new ArrayList<String>();
                columns.add("LABEL");
                columns.add("VALUE");
                dsTableModel.setColumnName(RB.getStringResource(RB_KEY, "column.txt", this.getLocale()), 0);
                dsTableModel.setColumnName(RB.getStringResource(RB_KEY, "dataSource.txt", this.getLocale()), 1);
                dsTableModel.setColumns(columns);
                ((DataSourceColumnItemListManager)this.sourceComponent).setModel((TableModel)dsTableModel);
            }
            return;
        }
        if (initialValue instanceof List) {
            ArrayList<ValueItem> dsItems = new ArrayList<ValueItem>();
            for (int i = 0; i < ((List)initialValue).size(); ++i) {
                Object item = ((List)initialValue).get(i);
                if (!(item instanceof DataSourceColumnInterface)) continue;
                this.displayedDataSource = ((DataSourceColumnInterface)item).getDataSource();
                dsItems.add(new ValueItem((Object)((DataSourceColumnInterface)item).getColumnLabel(), item));
            }
            ValueItemsToTableModelAdapter dsTableModel = new ValueItemsToTableModelAdapter(dsItems);
            ArrayList<String> columns = new ArrayList<String>();
            columns.add("LABEL");
            columns.add("VALUE");
            dsTableModel.setColumnName(RB.getStringResource(RB_KEY, "column.txt", this.getLocale()), 0);
            dsTableModel.setColumnName(RB.getStringResource(RB_KEY, "dataSource.txt", this.getLocale()), 1);
            dsTableModel.setColumns(columns);
            TableView tv = (TableView)((DataSourceColumnItemListManager)this.sourceComponent).getComponent("ITEMLISTMANAGER_TABLE");
            ((DataSourceColumnItemListManager)this.sourceComponent).setModel((TableModel)dsTableModel);
            tv.setModel((TableModel)dsTableModel);
        } else if (initialValue instanceof DataSourceColumnInterface) {
            DataSourceColumnInterface dsc = (DataSourceColumnInterface)initialValue;
            if (this.getSelectionType() == 300) {
                BaseTransformation datasourceColumn = (BaseTransformation)this.getComponent(DATASOURCECOLUMN_CHOICEBOX);
                if (datasourceColumn instanceof ChoiceBox) {
                    ChoiceBox cb = (ChoiceBox)datasourceColumn;
                    if (this.getDataSources() == null) {
                        DefaultComboBoxModel<ValueItem> choiceModel = new DefaultComboBoxModel<ValueItem>();
                        choiceModel.addElement(new ValueItem((Object)"", null));
                        choiceModel.addElement(new ValueItem((Object)dsc.getColumnLabel(), (Object)dsc));
                        cb.setModel(choiceModel);
                        try {
                            cb.setSelectedIndex(1);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                datasourceColumn.setObjectData(dsc);
            }
        }
        this.initialValue = initialValue;
    }

    public BaseTransformation getSourceComponent() {
        return this.sourceComponent;
    }

    @Override
    public void cleanup(HttpServletRequest request) {
        this.cleanup(request.getSession());
    }

    @Override
    public void cleanup(HttpSession session) {
        super.cleanup(session);
        if (this.getDataSourceColumnPanel() != null) {
            this.getDataSourceColumnPanel().cleanup(session);
        }
    }

    static {
        JavaScriptIncludeHandler.addAlias(DataSourceColumnPicker.class, "DATASOURCECOLUMNPICKER");
    }

    private class DataSourceValueProviderAdapter
    extends ValueProviderAdapter {
        public DataSourceValueProviderAdapter(long allowedDataSources, long allowedColumnTypes, List dataSources) {
            super(allowedDataSources, allowedColumnTypes, dataSources);
        }

        @Override
        public Object getValues(Locale locale) throws ValueProviderException {
            if (this.valueProviders != null) {
                if (this.valueProviders.size() == 1) {
                    List values = null;
                    try {
                        values = (List)((ValueProviderInterface)this.valueProviders.get(0)).getValues(locale);
                        values = (List)this.filterColumns(values);
                    }
                    catch (Exception ex) {
                        DataSourceColumnPicker.this.warningMessage = ex.getLocalizedMessage();
                        DataSourceColumnPicker.this.errorState = true;
                        return Collections.EMPTY_LIST;
                    }
                    this.values = values;
                    return values;
                }
                ArrayList allValues = new ArrayList();
                for (ValueProviderInterface provider : this.valueProviders) {
                    Collection values = null;
                    try {
                        values = (Collection)provider.getValues(locale);
                    }
                    catch (Exception ex) {
                        DataSourceColumnPicker.this.warningMessage = ex.getLocalizedMessage();
                    }
                    if (values == null) continue;
                    values = this.filterColumns(values);
                    allValues.addAll(values);
                }
                this.values = allValues;
                return allValues;
            }
            return Collections.EMPTY_LIST;
        }
    }
}

