/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.dataselectors.totals.html;

import com.sas.actionprovider.HttpActionProvider;
import com.sas.codepolicy.SASScope;
import com.sas.commands.CancelInterface;
import com.sas.dataselectors.totals.OLAPTotalsSelectorInterface;
import com.sas.dataselectors.totals.RelationalTotalsSelectorInterface;
import com.sas.dataselectors.totals.TotalsSelectorInterface;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.dataselectors.html.SelectorPanel;
import com.sas.servlet.tbeans.dataselectors.totals.html.TotalsSelectorKeysInterface;
import com.sas.servlet.tbeans.dataselectors.totals.html.TotalsSelectorStyleKeysInterface;
import com.sas.servlet.tbeans.form.html.CheckBox;
import com.sas.servlet.tbeans.form.html.Form;
import com.sas.servlet.tbeans.form.html.Hidden;
import com.sas.servlet.tbeans.form.html.Radio;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.models.Item;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.MapWithDefaults;
import com.sas.util.Util;
import com.sas.util.log.LoggerRepository2;
import java.awt.ComponentOrientation;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;

@SASScope(value="ALL")
public class TotalsSelectorPanel
extends SelectorPanel
implements CancelInterface,
TotalsSelectorKeysInterface,
TotalsSelectorStyleKeysInterface {
    private Form form;
    private Object selectorModel;
    private String parameterPrefix;
    private boolean isOLAP;
    private ResourceBundle bundle;
    private String RB_KEY = "TotalsSelector.";
    private boolean isLeftToRight;
    private boolean isHorizontal;
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "TotalsSelectorPanel.html";
    protected CheckBox checkBox;
    protected Label label;
    protected Radio radio;
    private static final Map defaultStyleMap;

    public TotalsSelectorPanel() {
        this(Util.getName((String)"tSel_panel"));
    }

    public TotalsSelectorPanel(String name) {
        this.setId(name);
        this.setTemplateKey("Totals_Selector_Panel");
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap(defaultStyleMap);
        this.addComponents();
        super.setLocaleDependentProperties(this.getLocale());
        this._setLocaleDependentProperties(this.getLocale());
    }

    @Override
    @SASScope
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        this._setLocaleDependentProperties(locale);
    }

    private void _setLocaleDependentProperties(Locale locale) {
        this.bundle = ResourceBundle.getBundle("com.sas.swing.visuals.dataselectors.totals.Resources", locale);
        ComponentOrientation orientation = ComponentOrientation.getOrientation(locale);
        this.isLeftToRight = orientation.isLeftToRight();
        this.isHorizontal = orientation.isHorizontal();
        this.label = (Label)this.getComponent("TOTALSSELECTOR_INSERT_LABEL");
        if (this.label != null) {
            this.label.setText(this.bundle.getString(this.RB_KEY + "insertLabel.txt"));
        }
        this.label = (Label)this.getComponent("TOTALSSELECTOR_DISPLAY_LABEL");
        if (this.label != null) {
            this.label.setText(this.bundle.getString(this.RB_KEY + "displayLabel.txt"));
        }
        this.label = (Label)this.getComponent("TOTALSSELECTOR_TYPE_LABEL");
        if (this.label != null) {
            this.label.setText(this.bundle.getString(this.RB_KEY + "typeLabel.txt"));
        }
        this.checkBox = (CheckBox)this.getComponent("TOTALSSELECTOR_ROWS_TOTALS_CHECK_BOX");
        if (this.checkBox != null) {
            this.checkBox.setText(this.bundle.getString(this.RB_KEY + "rowTotals.txt"));
        }
        this.checkBox = (CheckBox)this.getComponent("TOTALSSELECTOR_COLUMNS_TOTALS_CHECK_BOX");
        if (this.checkBox != null) {
            this.checkBox.setText(this.bundle.getString(this.RB_KEY + "colTotals.txt"));
        }
        this.checkBox = (CheckBox)this.getComponent("TOTALSSELECTOR_ROWS_SUBTOTALS_CHECK_BOX");
        if (this.checkBox != null) {
            this.checkBox.setText(this.bundle.getString(this.RB_KEY + "rowSubtotals.txt"));
        }
        this.checkBox = (CheckBox)this.getComponent("TOTALSSELECTOR_COLUMNS_SUBTOTALS_CHECK_BOX");
        if (this.checkBox != null) {
            this.checkBox.setText(this.bundle.getString(this.RB_KEY + "colSubtotals.txt"));
        }
        this.checkBox = (CheckBox)this.getComponent("TOTALSSELECTOR_EXPANDED_TOTALS_CHECK_BOX");
        if (this.checkBox != null) {
            this.checkBox.setText(this.bundle.getString(this.RB_KEY + "itemize.txt"));
        }
        this.label = (Label)this.getComponent("TOTALSSELECTOR_MESSAGE_LABEL");
        if (this.label != null) {
            this.label.setText(this.bundle.getString(this.RB_KEY + "noAdditiveDataItems.txt"));
        }
        this.radio = (Radio)this.getComponent("TOTALSSELECTOR_VISUAL_TOTALS_RADIO");
        if (this.radio != null) {
            this.radio.setLabelOrientation(this.isLeftToRight ? 4 : 2);
        }
        this.radio = (Radio)this.getComponent("TOTALSSELECTOR_PARENT_TOTALS_RADIO");
        if (this.radio != null) {
            this.radio.setLabelOrientation(this.isLeftToRight ? 4 : 2);
        }
        this.label = (Label)this.getComponent("TOTALSSELECTOR_PARENT_TOTALS_DESC_LABEL");
        if (this.label != null) {
            this.label.setText(this.bundle.getString(this.RB_KEY + "parentTotalsDesc.txt"));
        }
        this.label = (Label)this.getComponent("TOTALSSELECTOR_VISUAL_TOTALS_DESC_LABEL");
        if (this.label != null) {
            this.label.setText(this.bundle.getString(this.RB_KEY + "visualTotalsDesc.txt"));
        }
        this.radio = (Radio)this.getComponent("TOTALSSELECTOR_POSITION_RADIO_BOX");
        if (this.radio != null) {
            this.radio.setLabelOrientation(this.isLeftToRight ? 4 : 2);
        }
    }

    @Override
    public void write(PrintWriter out) {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        if (this.isOLAP) {
            try {
                JavaScriptIncludeHandler.writeIncludes(out, "TOTALSSELECTOR", this.getRequest());
            }
            catch (IOException e) {
                LoggerRepository2.getLogger((String)TotalsSelectorPanel.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
            }
            this.setCheckBoxesOnClickHandler();
            this.radio = (Radio)this.getComponent("TOTALSSELECTOR_VISUAL_TOTALS_RADIO");
            if (this.radio != null) {
                this.radio.setOnClick("tsObj.setItemizeCheckBoxState()");
            }
            this.radio = (Radio)this.getComponent("TOTALSSELECTOR_PARENT_TOTALS_RADIO");
            if (this.radio != null) {
                this.radio.setOnClick("tsObj.setItemizeCheckBoxState()");
            }
        }
        this.form = this.getFormObject();
        this.form.setRequest(this.getRequest());
        this.form.setResponse(this.getResponse());
        this.form.setLocale(this.getLocale());
        try {
            this.writeSelectorPanelHeader(out);
            this.writeActionProviderFields(out);
            this.setComponentValues();
            this.addItemsToTemplateDictionaryMap();
            String formattedSelector = this.applyTemplate(this);
            out.println(formattedSelector);
            this.writeSelectorPanelFooter(out);
        }
        catch (IOException e) {
            LoggerRepository2.getLogger((String)TotalsSelectorPanel.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        if (this.isOLAP) {
            this.writeJsVars(out);
        }
        this.cleanUpResources();
    }

    private void writeJsVars(PrintWriter out) {
        out.println(JavaScriptIncludeHandler.getStartScript());
        out.print("\tvar tsObj = new sas_TotalsSelector();");
        out.print("\n\ttsObj.rsCb=document.getElementById('");
        out.print(((CheckBox)this.getComponent("TOTALSSELECTOR_ROWS_SUBTOTALS_CHECK_BOX")).getId());
        out.println("');");
        out.print("\ttsObj.rtCb=document.getElementById('");
        out.print(((CheckBox)this.getComponent("TOTALSSELECTOR_ROWS_TOTALS_CHECK_BOX")).getId());
        out.println("');");
        out.print("\ttsObj.csCb=document.getElementById('");
        out.print(((CheckBox)this.getComponent("TOTALSSELECTOR_COLUMNS_SUBTOTALS_CHECK_BOX")).getId());
        out.println("');");
        out.print("\ttsObj.ctCb=document.getElementById('");
        out.print(((CheckBox)this.getComponent("TOTALSSELECTOR_COLUMNS_TOTALS_CHECK_BOX")).getId());
        out.println("');");
        out.print("\ttsObj.etCb=document.getElementById('");
        out.print(((CheckBox)this.getComponent("TOTALSSELECTOR_EXPANDED_TOTALS_CHECK_BOX")).getId());
        out.println("');");
        out.print("\ttsObj.poRb0=document.getElementsByName('");
        out.print(((Radio)this.getComponent("TOTALSSELECTOR_POSITION_RADIO_BOX")).getName());
        out.println("')[0];");
        out.print("\ttsObj.poRb1=document.getElementsByName('");
        out.print(((Radio)this.getComponent("TOTALSSELECTOR_POSITION_RADIO_BOX")).getName());
        out.println("')[1];");
        out.print("\ttsObj.typeRadioName='");
        out.print(((Radio)this.getComponent("TOTALSSELECTOR_VISUAL_TOTALS_RADIO")).getName());
        out.print("';");
        out.print("\ttsObj.parentTotalsValue='");
        out.print("U");
        out.print("';");
        if (this.form != null) {
            out.print("\ttsObj.formName = '" + this.form.getName() + "';");
        }
        Object selectorModel = this.getSelectorModel();
        int pct = ((OLAPTotalsSelectorInterface)selectorModel).getAppliedPercentOfTotals();
        out.print("\ttsObj.pct=" + pct + ";");
        String pctMsg = pct > 0 ? this.bundle.getString(this.RB_KEY + "removePercentConfirmationMsg.txt") : "";
        out.print("\ttsObj.pctMsg=\"" + pctMsg + "\";");
        out.print("\ttsObj.onCbClick();");
        out.println(JavaScriptIncludeHandler.getEndScript(null));
    }

    private void writeActionProviderFields(PrintWriter out) {
        Hidden.writeElement(out, null, "APNAME", this.getActionProvider().getName(), true);
        String cmdId = this.getCommandId();
        Hidden.writeElement(out, null, "CMDID", cmdId == null ? "" : cmdId, true);
        Hidden.writeElement(out, null, this.getActionProvider().getParameterPrefix() + "mode", "COMMIT", true);
    }

    private void setCheckBoxesOnClickHandler() {
        this.checkBox = (CheckBox)this.getComponent("TOTALSSELECTOR_ROWS_TOTALS_CHECK_BOX");
        if (this.checkBox != null) {
            this.checkBox.setOnClick("tsObj.onCbClick()");
        }
        this.checkBox = (CheckBox)this.getComponent("TOTALSSELECTOR_COLUMNS_TOTALS_CHECK_BOX");
        if (this.checkBox != null) {
            this.checkBox.setOnClick("tsObj.onCbClick()");
        }
        this.checkBox = (CheckBox)this.getComponent("TOTALSSELECTOR_ROWS_SUBTOTALS_CHECK_BOX");
        if (this.checkBox != null) {
            this.checkBox.setOnClick("tsObj.onCbClick()");
        }
        this.checkBox = (CheckBox)this.getComponent("TOTALSSELECTOR_COLUMNS_SUBTOTALS_CHECK_BOX");
        if (this.checkBox != null) {
            this.checkBox.setOnClick("tsObj.onCbClick()");
        }
    }

    @SASScope
    protected void addComponents() {
        if (this.getComponents().isEmpty()) {
            this.setComponent("TOTALSSELECTOR_INSERT_LABEL", this.newLabel("insertLabel", "TOTALSSELECTOR_LABEL"));
            this.setComponent("TOTALSSELECTOR_ROWS_TOTALS_CHECK_BOX", this.newCheckBox("rowTotals", "TOTALSSELECTOR_CHECK"));
            this.setComponent("TOTALSSELECTOR_ROWS_SUBTOTALS_CHECK_BOX", this.newCheckBox("rowSubtotals", "TOTALSSELECTOR_CHECK"));
            this.setComponent("TOTALSSELECTOR_DISPLAY_LABEL", this.newLabel("displayLabel", "TOTALSSELECTOR_LABEL"));
            this.setComponent("TOTALSSELECTOR_EXPANDED_TOTALS_CHECK_BOX", this.newCheckBox("expandedTotals", "TOTALSSELECTOR_CHECK"));
            this.setComponent("TOTALSSELECTOR_TYPE_LABEL", this.newLabel("typeLabel", "TOTALSSELECTOR_LABEL"));
            this.setComponent("TOTALSSELECTOR_COLUMNS_TOTALS_CHECK_BOX", this.newCheckBox("columnTotals", "TOTALSSELECTOR_CHECK"));
            this.setComponent("TOTALSSELECTOR_COLUMNS_SUBTOTALS_CHECK_BOX", this.newCheckBox("columnSubtotals", "TOTALSSELECTOR_CHECK"));
            this.setComponent("TOTALSSELECTOR_MESSAGE_LABEL", this.newLabel("messageLabel", "TOTALSSELECTOR_LABEL"));
            this.setComponent("TOTALSSELECTOR_VISUAL_TOTALS_RADIO", this.newRadio("totalsType", "TOTALSSELECTOR_RADIO", "TOTALSSELECTOR_RADIO_LABEL"));
            this.setComponent("TOTALSSELECTOR_PARENT_TOTALS_RADIO", this.newRadio("totalsType", "TOTALSSELECTOR_RADIO", "TOTALSSELECTOR_RADIO_LABEL"));
            this.setComponent("TOTALSSELECTOR_VISUAL_TOTALS_DESC_LABEL", this.newLabel("visualTotalsDescLabel", "TOTALSSELECTOR_RADIO_LABEL"));
            this.setComponent("TOTALSSELECTOR_PARENT_TOTALS_DESC_LABEL", this.newLabel("parentTotalsDescLabel", "TOTALSSELECTOR_RADIO_LABEL"));
            this.setComponent("TOTALSSELECTOR_POSITION_RADIO_BOX", this.newRadio("totalsPosition", "TOTALSSELECTOR_RADIO", "TOTALSSELECTOR_RADIO_LABEL"));
        }
    }

    private void setComponentValues() {
        DefaultListModel<Item> listModel;
        Object selectorModel = this.getSelectorModel();
        this.checkBox = (CheckBox)this.getComponent("TOTALSSELECTOR_ROWS_TOTALS_CHECK_BOX");
        if (this.checkBox != null) {
            this.checkBox.setValue("1");
            this.checkBox.setName(this.parameterPrefix + "rowTotals");
            if (!this.isOLAP) {
                this.checkBox.setEnabled(false);
            } else if (selectorModel != null) {
                this.checkBox.setSelected(((OLAPTotalsSelectorInterface)selectorModel).rowTotals());
            }
            this.checkBox.setRequest(this.getRequest());
            this.checkBox.setResponse(this.getResponse());
            this.checkBox.setLocale(this.getLocale());
        }
        this.checkBox = (CheckBox)this.getComponent("TOTALSSELECTOR_COLUMNS_TOTALS_CHECK_BOX");
        if (this.checkBox != null) {
            this.checkBox.setValue("1");
            this.checkBox.setName(this.parameterPrefix + "columnTotals");
            if (selectorModel != null) {
                this.checkBox.setSelected(((TotalsSelectorInterface)selectorModel).columnTotals());
            }
            this.checkBox.setRequest(this.getRequest());
            this.checkBox.setResponse(this.getResponse());
            this.checkBox.setLocale(this.getLocale());
        }
        this.checkBox = (CheckBox)this.getComponent("TOTALSSELECTOR_ROWS_SUBTOTALS_CHECK_BOX");
        if (this.checkBox != null) {
            this.checkBox.setValue("1");
            this.checkBox.setName(this.parameterPrefix + "rowSubtotals");
            if (!this.isOLAP) {
                this.checkBox.setEnabled(false);
            } else if (selectorModel != null) {
                this.checkBox.setSelected(((OLAPTotalsSelectorInterface)selectorModel).rowSubtotals());
            }
            this.checkBox.setRequest(this.getRequest());
            this.checkBox.setResponse(this.getResponse());
            this.checkBox.setLocale(this.getLocale());
        }
        this.checkBox = (CheckBox)this.getComponent("TOTALSSELECTOR_COLUMNS_SUBTOTALS_CHECK_BOX");
        if (this.checkBox != null) {
            this.checkBox.setValue("1");
            this.checkBox.setName(this.parameterPrefix + "columnSubtotals");
            if (!this.isOLAP) {
                this.checkBox.setEnabled(false);
            } else if (selectorModel != null) {
                this.checkBox.setSelected(((OLAPTotalsSelectorInterface)selectorModel).columnSubtotals());
            }
            this.checkBox.setRequest(this.getRequest());
            this.checkBox.setResponse(this.getResponse());
            this.checkBox.setLocale(this.getLocale());
        }
        this.checkBox = (CheckBox)this.getComponent("TOTALSSELECTOR_EXPANDED_TOTALS_CHECK_BOX");
        if (this.checkBox != null) {
            this.checkBox.setValue("1");
            this.checkBox.setName(this.parameterPrefix + "expandedTotals");
            if (this.isOLAP && selectorModel != null) {
                this.checkBox.setSelected(((OLAPTotalsSelectorInterface)selectorModel).isExpandedTotals());
            }
            this.checkBox.setRequest(this.getRequest());
            this.checkBox.setResponse(this.getResponse());
            this.checkBox.setLocale(this.getLocale());
        }
        this.label = (Label)this.getComponent("TOTALSSELECTOR_INSERT_LABEL");
        if (this.label != null) {
            this.label.setRequest(this.getRequest());
            this.label.setResponse(this.getResponse());
            this.label.setLocale(this.getLocale());
        }
        this.label = (Label)this.getComponent("TOTALSSELECTOR_DISPLAY_LABEL");
        if (this.label != null) {
            this.label.setRequest(this.getRequest());
            this.label.setResponse(this.getResponse());
            this.label.setLocale(this.getLocale());
        }
        this.label = (Label)this.getComponent("TOTALSSELECTOR_TYPE_LABEL");
        if (this.label != null) {
            this.label.setRequest(this.getRequest());
            this.label.setResponse(this.getResponse());
            this.label.setLocale(this.getLocale());
        }
        this.label = (Label)this.getComponent("TOTALSSELECTOR_MESSAGE_LABEL");
        if (this.label != null) {
            this.label.setRequest(this.getRequest());
            this.label.setResponse(this.getResponse());
            this.label.setLocale(this.getLocale());
            this.label.setVisible(false);
        }
        if (!this.isOLAP && !((TotalsSelectorInterface)selectorModel).hasSummarizeableItems()) {
            this.checkBox = (CheckBox)this.getComponent("TOTALSSELECTOR_ROWS_TOTALS_CHECK_BOX");
            if (this.checkBox != null) {
                this.checkBox.setEnabled(false);
            }
            this.checkBox = (CheckBox)this.getComponent("TOTALSSELECTOR_COLUMNS_TOTALS_CHECK_BOX");
            if (this.checkBox != null) {
                this.checkBox.setEnabled(false);
            }
            this.checkBox = (CheckBox)this.getComponent("TOTALSSELECTOR_ROWS_SUBTOTALS_CHECK_BOX");
            if (this.checkBox != null) {
                this.checkBox.setEnabled(false);
            }
            this.checkBox = (CheckBox)this.getComponent("TOTALSSELECTOR_COLUMNS_SUBTOTALS_CHECK_BOX");
            if (this.checkBox != null) {
                this.checkBox.setEnabled(false);
            }
            this.label = (Label)this.getComponent("TOTALSSELECTOR_MESSAGE_LABEL");
            if (this.label != null) {
                this.label.setVisible(true);
            }
        }
        this.radio = (Radio)this.getComponent("TOTALSSELECTOR_VISUAL_TOTALS_RADIO");
        if (this.radio != null) {
            this.radio.setName(this.parameterPrefix + "totalsType");
            listModel = new DefaultListModel<Item>();
            listModel.addElement(new Item(this.bundle.getString(this.RB_KEY + "visualTotals.txt"), "V"));
            this.radio.setModel(listModel);
            try {
                if (this.isOLAP && "V".equals(((OLAPTotalsSelectorInterface)selectorModel).getTotalsType())) {
                    this.radio.setSelectedIndex(0);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.radio = (Radio)this.getComponent("TOTALSSELECTOR_PARENT_TOTALS_RADIO");
        if (this.radio != null) {
            this.radio.setName(this.parameterPrefix + "totalsType");
            listModel = new DefaultListModel();
            listModel.addElement(new Item(this.bundle.getString(this.RB_KEY + "parentTotals.txt"), "U"));
            this.radio.setModel(listModel);
            try {
                if (this.isOLAP && !"V".equals(((OLAPTotalsSelectorInterface)selectorModel).getTotalsType())) {
                    this.radio.setSelectedIndex(0);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.label = (Label)this.getComponent("TOTALSSELECTOR_VISUAL_TOTALS_DESC_LABEL");
        if (this.label != null) {
            this.label.setRequest(this.getRequest());
            this.label.setResponse(this.getResponse());
            this.label.setLocale(this.getLocale());
        }
        this.label = (Label)this.getComponent("TOTALSSELECTOR_PARENT_TOTALS_DESC_LABEL");
        if (this.label != null) {
            this.label.setRequest(this.getRequest());
            this.label.setResponse(this.getResponse());
            this.label.setLocale(this.getLocale());
        }
        this.radio = (Radio)this.getComponent("TOTALSSELECTOR_POSITION_RADIO_BOX");
        if (this.radio != null) {
            this.radio.setName(this.parameterPrefix + "totalsPosition");
            listModel = new DefaultListModel();
            listModel.addElement(new Item(this.bundle.getString(this.RB_KEY + "top.txt"), "T"));
            listModel.addElement(new Item(this.bundle.getString(this.RB_KEY + "bottom.txt"), "B"));
            this.radio.setModel(listModel);
            try {
                if (this.isOLAP) {
                    if ("B".equals(((OLAPTotalsSelectorInterface)selectorModel).getTotalsPosition())) {
                        this.radio.setSelectedIndex(1);
                    } else {
                        this.radio.setSelectedIndex(0);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("TOTALSSELECTOR_MESSAGE", "selectorErrorMessages");
        this.setTemplateDictionary(map);
    }

    protected Label newLabel(String name, String styleKey) {
        Label label = new Label();
        if (name != null) {
            label.setId(this.getId() + "_" + name);
        }
        if (styleKey != null) {
            label.setStyleInfo((StyleInfo)defaultStyleMap.get(styleKey));
        }
        return label;
    }

    protected CheckBox newCheckBox(String name, String styleKey) {
        CheckBox checkBox = new CheckBox();
        if (styleKey != null) {
            checkBox.getStyleMap().put("CHECKBOX_LABEL", defaultStyleMap.get(styleKey));
        }
        if (name != null) {
            checkBox.setId(this.getId() + "_" + name);
        }
        return checkBox;
    }

    protected Radio newRadio(String name, String styleKey, String labelStyleKey) {
        this.radio = new Radio();
        this.radio.setId(new StringBuffer().append(this.getId()).append(name).toString());
        Map radioStyleMap = this.radio.getStyleMap();
        if (styleKey != null) {
            radioStyleMap.put("RADIO_BOX", defaultStyleMap.get(styleKey));
        }
        if (labelStyleKey != null) {
            radioStyleMap.put("RADIO_LABEL", defaultStyleMap.get(labelStyleKey));
        }
        return this.radio;
    }

    public void cancel() {
    }

    @Override
    public void setActionProvider(HttpActionProvider ap) {
        super.setActionProvider(ap);
        this.parameterPrefix = this.getActionProvider().getParameterPrefix();
    }

    @Override
    public void setSelectorModel(Object selectorModel) {
        super.setSelectorModel(selectorModel);
        if ((selectorModel instanceof RelationalTotalsSelectorInterface || selectorModel instanceof OLAPTotalsSelectorInterface) && this.selectorModel != selectorModel) {
            super.setSelectorModel(selectorModel);
            this.selectorModel = selectorModel;
            this.isOLAP = selectorModel instanceof OLAPTotalsSelectorInterface;
        }
    }

    @Override
    public Object getSelectorModel() {
        return this.selectorModel;
    }

    private void addItemsToTemplateDictionaryMap() {
        HashMap<String, String> dMap = this.getTemplateDictionary();
        String displayStyle = null;
        if (dMap == null || !dMap.containsKey("TOTALSSELECTOR_OLAP_DISPLAY_STYLE")) {
            if (dMap == null) {
                dMap = new HashMap<String, String>();
            }
            if (!dMap.containsKey("TOTALSSELECTOR_OLAP_DISPLAY_STYLE")) {
                displayStyle = this.isOLAP ? "" : "display:none;";
                dMap.put("TOTALSSELECTOR_OLAP_DISPLAY_STYLE", displayStyle);
            }
            if (dMap.size() > 0) {
                this.setTemplateDictionary(dMap);
            }
        }
    }

    static {
        JavaScriptIncludeHandler.addAlias(TotalsSelectorPanel.class, "TOTALSSELECTOR");
        defaultStyleMap = new HashMap(8, 1.0f);
        defaultStyleMap.put("TOTALSSELECTOR_CHECK", new ImmutableStyleInfo("selectorCheckBoxLabel"));
        defaultStyleMap.put("TOTALSSELECTOR_LABEL", new ImmutableStyleInfo("selectorLabel"));
        defaultStyleMap.put("TOTALSSELECTOR_RADIO", new ImmutableStyleInfo("selectorRadio"));
        defaultStyleMap.put("TOTALSSELECTOR_RADIO_LABEL", new ImmutableStyleInfo("selectorRadioLabel"));
    }
}

