/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.dataselectors.propertyeditor.html;

import com.sas.actionprovider.ActionProviderEvent;
import com.sas.actionprovider.HttpActionProvider;
import com.sas.codepolicy.SASScope;
import com.sas.collection.ContentsChangedEvent;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.dataselectors.html.SelectorPanel;
import com.sas.servlet.tbeans.dataselectors.propertyeditor.editors.html.TextEntryPropertyEditor;
import com.sas.servlet.tbeans.dataselectors.propertyeditor.html.EntityAttributeValueSelectorKeysInterface;
import com.sas.servlet.tbeans.dataselectors.propertyeditor.html.EntityAttributeValueSelectorStyleKeysInterface;
import com.sas.servlet.tbeans.dataselectors.propertyeditor.html.PropertyEditorContainer;
import com.sas.servlet.tbeans.dataselectors.propertyeditor.html.PropertyNode;
import com.sas.servlet.tbeans.form.html.Form;
import com.sas.servlet.tbeans.form.html.Hidden;
import com.sas.servlet.tbeans.form.html.ListBoxView;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.swing.visuals.dataselectors.propertyeditor.EntityAttributeValueModelInterface;
import com.sas.swing.visuals.dataselectors.propertyeditor.PropertyValueInterface;
import com.sas.swing.visuals.dataselectors.propertyeditor.RB;
import com.sas.util.MapWithDefaults;
import com.sas.util.Strings;
import com.sas.util.Util;
import com.sas.util.log.LoggerRepository2;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;

@SASScope(value="ALL")
public class EntityAttributeValueSelectorPanel
extends SelectorPanel
implements EntityAttributeValueSelectorKeysInterface,
EntityAttributeValueSelectorStyleKeysInterface {
    private static final boolean DEBUG = false;
    public static final String RB_KEY = "EntityAttributeValuePanel.";
    public static final String DEFAULT_ENTITY_ATTRIBUTE_VALUE_SELECTOR_NAME = "eavSel_panel";
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "EntityAttributeValueSelector.html";
    public static final String DEFAULT_REMOTE_SCRIPT_URL = "SelectorServlet";
    private static final ImmutableStyleInfo EAVSPropertyListXPStyle;
    private static final ImmutableStyleInfo EAVSPropertyListStyle;
    private static final ImmutableStyleInfo EAVSInstructionTextStyle;
    private static final ImmutableStyleInfo EAVSPropertyLabelTextStyle;
    private static final HashMap defaultStyleMap;
    protected Label instructionText;
    protected Label attributeGroupLabel;
    protected ListBoxView attributeListBox;
    protected PropertyEditorContainer editorContainer;
    protected Map editorIdMap;
    protected Map valueMap;
    protected Form remoteScriptForm;
    protected String remoteScriptURL;
    protected String serverError;
    protected String selectedProperty;
    protected String currentProperty;
    protected List availableValues;
    protected List selectedValues;
    protected Map supplementalProperties;
    protected boolean propertyValueChanged;
    protected EntityAttributeValueModelInterface selectorModel;

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put("ENTITYATTRIBUTEVALUESELECTOR_PROPERTY_LIST", EAVSPropertyListStyle);
            defaultStyleMap.put("ENTITYATTRIBUTEVALUESELECTOR_PROPERTY_LIST_XP", EAVSPropertyListXPStyle);
            defaultStyleMap.put("ENTITYATTRIBUTEVALUESELECTOR_INSTRUCTION_TEXT", EAVSInstructionTextStyle);
            defaultStyleMap.put("ENTITYATTRIBUTEVALUESELECTOR_LABEL", EAVSPropertyLabelTextStyle);
        }
    }

    public EntityAttributeValueSelectorPanel() {
        this(Util.getName((String)DEFAULT_ENTITY_ATTRIBUTE_VALUE_SELECTOR_NAME));
    }

    public EntityAttributeValueSelectorPanel(String name) {
        this.setId(name);
        this.setTemplateKey("Entity_Attribute_Value_Selector");
        this.setVisible(true);
        EntityAttributeValueSelectorPanel.setupDefaultStyleMap();
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap((Map)defaultStyleMap);
        this.initComponents();
        super.setLocaleDependentProperties(this.getLocale());
        this._setLocaleDependentProperties(this.getLocale());
    }

    private void initComponents() {
        this.editorIdMap = new HashMap();
        this.instructionText = new Label();
        this.instructionText.setStyleInfo(EAVSInstructionTextStyle);
        this.setComponent("EAVS_INSTRUCTION_TEXT", this.instructionText);
        this.attributeGroupLabel = new Label();
        this.attributeGroupLabel.setStyleInfo(EAVSPropertyLabelTextStyle);
        this.setComponent("EAVS_ATTRIBUTE_GROUP_LABEL", this.attributeGroupLabel);
        this.attributeListBox = new ListBoxView();
        this.attributeListBox.setSize(11);
        this.attributeListBox.setMultipleSelections(false);
        this.setComponent("EAVS_ATTRIBUTE_LIST", this.attributeListBox);
        Map stylemap = this.attributeListBox.getStyleMap();
        stylemap.put("LISTBOXVIEW_OUTER_DIV", EAVSPropertyListStyle);
        stylemap.put("LISTBOXVIEW_OUTER_DIV_XP", EAVSPropertyListXPStyle);
        this.editorContainer = new PropertyEditorContainer();
        this.setComponent("EAVS_EDITOR_PANEL", this.editorContainer);
        this.initRemoteScriptForm();
    }

    private void _setLocaleDependentProperties(Locale currentLocale) {
        this.instructionText.setText(RB.getStringResource((String)RB_KEY, (String)"selectPrompt.txt", (Locale)currentLocale));
        this.attributeGroupLabel.setText(RB.getStringResource((String)RB_KEY, (String)"prompts.txt", (Locale)currentLocale));
    }

    private void initRemoteScriptForm() {
        this.remoteScriptForm = new Form();
        this.remoteScriptForm.setAction(this.getRemoteScriptURL());
    }

    public String getRemoteScriptURL() {
        if (this.remoteScriptURL == null) {
            String contextPath;
            this.remoteScriptURL = DEFAULT_REMOTE_SCRIPT_URL;
            if (this.getRequest() != null && (contextPath = this.getRequest().getContextPath()) != null) {
                this.remoteScriptURL = contextPath + DEFAULT_REMOTE_SCRIPT_URL;
            }
        }
        return this.remoteScriptURL;
    }

    public void setRemoteScriptURL(String value) {
        if (value != this.remoteScriptURL) {
            String oldValue = this.remoteScriptURL;
            this.remoteScriptURL = value;
            this.firePropertyChange("remoteScriptURL", oldValue, value);
        }
    }

    protected void setRequiredProperties() {
        HttpActionProvider ap = this.getActionProvider();
        String apPrefix = ap == null ? "" : ap.getParameterPrefix();
        this.instructionText = (Label)this.getComponent("EAVS_INSTRUCTION_TEXT");
        this.instructionText.setId(this.getId() + "_instructionText");
        this.attributeGroupLabel = (Label)this.getComponent("EAVS_ATTRIBUTE_GROUP_LABEL");
        this.attributeGroupLabel.setId(this.getId() + "_attributeGroupLabel");
        this.attributeListBox = (ListBoxView)this.getComponent("EAVS_ATTRIBUTE_LIST");
        this.attributeListBox.setId(this.getId() + "_attributeListBox");
        this.editorContainer = (PropertyEditorContainer)this.getComponent("EAVS_EDITOR_PANEL");
        this.editorContainer.setId(this.getId() + "_editorContainer");
        this.setRequiredJavaScriptEvents();
    }

    protected void setRequiredJavaScriptEvents() {
        String name = this.getId();
        this.attributeListBox = (ListBoxView)this.getComponent("EAVS_ATTRIBUTE_LIST");
        this.attributeListBox.setOnChange(name + ".attributeValueChanged(this)");
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        JavaScriptIncludeHandler.writeIncludes(out, "ENTITYATTRIBUTEVALUESELECTORPANEL", this.getRequest());
        this.setRequiredProperties();
        Form selectorForm = this.getFormObject();
        selectorForm.setName(this.getId() + "_FORM");
        selectorForm.setId(this.getId() + "_FORM");
        selectorForm.setAction(this.remoteScriptForm.getAction());
        selectorForm.setTarget(this.getIframeName());
        selectorForm.setValidationEnabled(true);
        ListBoxView attributes = (ListBoxView)this.getComponent("EAVS_ATTRIBUTE_LIST");
        ListModel propertyList = this.getAttributeList();
        attributes.setModel(propertyList);
        this.createEditorMap(propertyList);
        this.editorContainer.setEditorMap(this.editorIdMap);
        this.writeSelectorForm(out, selectorForm);
        String value = this.applyTemplate(this);
        out.println(value);
        selectorForm.writeFooter(out);
        out.println(this.getConstructionJavaScript());
        StringBuffer sb = new StringBuffer();
        sb.append(JavaScriptIncludeHandler.getStartScript());
        String name = this.getId();
        this.cleanUpResources();
    }

    protected String getConstructionJavaScript() {
        String name = this.getId();
        StringBuffer js = new StringBuffer(JavaScriptIncludeHandler.getStartScript());
        HttpActionProvider ap = this.getActionProvider();
        String apPrefix = ap != null ? ap.getParameterPrefix() : "";
        js.append(name).append(" = new sas_EntityAttributeValueSelector('").append(name).append("', '").append(apPrefix).append("');\n");
        if (this.attributeListBox != null) {
            js.append(name).append(".attributeListBox = sas_getComponent('").append(this.attributeListBox.getId()).append("');\n");
        }
        js.append(name).append(".initializePropertyInfoMap();\n");
        js.append(JavaScriptIncludeHandler.getEndScript(null));
        return js.toString();
    }

    protected void writeSelectorForm(PrintWriter out, Form form) throws IOException {
        String apPrefix = "";
        String cmdID = this.getCommandId();
        if (cmdID == null) {
            cmdID = "";
        }
        form.setRequest(this.getRequest());
        form.setResponse(this.getResponse());
        form.setLocale(this.getRequestLocale());
        form.writeHeader(out);
        HttpActionProvider ap = this.getActionProvider();
        if (ap != null) {
            apPrefix = ap.getParameterPrefix();
            Hidden.writeElement(out, null, "ACTIONPROVIDERNAME", ap.getName(), true);
            Hidden.writeElement(out, null, "APNAME", ap.getName(), true);
        }
        Hidden.writeElement(out, null, "CMDID", this.getCommandId(), true);
        Hidden.writeElement(out, null, apPrefix + "mode", "process", true);
        Hidden.writeElement(out, null, "METHOD_PARAMETER", "", true);
        Hidden.writeElement(out, null, "sas_charEncoding", BaseUtil.getOutputCharacterEncoding(this.getRequest()), true);
        Hidden.writeElement(out, this.getId() + "_mainAction", "temp", "", true);
        Hidden.writeElement(out, this.getId() + "_action", apPrefix + "action", "", true);
        Hidden.writeElement(out, this.getId() + "_selectedProperty", "selectedProperty", "", true);
        Hidden.writeElement(out, this.getId() + "_currentProperty", "currentProperty", "", true);
    }

    @Override
    public void contentsChanged(ContentsChangedEvent event) {
        if (event instanceof ActionProviderEvent) {
            Map info = ((ActionProviderEvent)event).getEventInfo();
            HttpServletResponse response = (HttpServletResponse)info.get("response");
            this.propertyValueChanged = false;
            if (response == null) {
                return;
            }
            this.serverError = (String)info.get("ERROR");
            this.currentProperty = (String)info.get("currentProperty");
            this.selectedProperty = (String)info.get("selectedProperty");
            this.availableValues = (List)info.get("availableValues");
            this.selectedValues = (List)info.get("selectedValues");
            this.supplementalProperties = (Map)info.get("supplementalProperties");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRemoteScriptCommands(PrintWriter out) throws IOException {
        super.writeRemoteScriptCommands(out);
        try {
            String remoteObjectName = "   parent." + this.getId();
            if (this.serverError != null) {
                if (this.currentProperty != null) {
                    out.println(JavaScriptIncludeHandler.getStartScript());
                    out.println(remoteObjectName + ".commandInProgress = true;");
                    out.println("parent.document.body.style.cursor = 'wait';");
                    out.println(JavaScriptIncludeHandler.getEndScript(null));
                    out.println(JavaScriptIncludeHandler.getStartScript());
                    out.println(remoteObjectName + ".setSelectedProperty(\"" + this.currentProperty + "\");\n");
                    out.println(JavaScriptIncludeHandler.getEndScript(null));
                    out.println(JavaScriptIncludeHandler.getStartScript());
                    out.println("parent.document.body.style.cursor = 'auto';");
                    out.println(remoteObjectName + ".commandInProgress = false;\n");
                    out.println(JavaScriptIncludeHandler.getEndScript(null));
                }
                out.println(JavaScriptIncludeHandler.getStartScript());
                String error = Strings.escapeForJavaScript((String)this.serverError);
                out.println("alert(\"" + error + "\");");
                out.println("parent.document.body.style.cursor = 'auto';");
                out.println(JavaScriptIncludeHandler.getEndScript(null));
                this.serverError = null;
                return;
            }
            if (this.selectedProperty != null) {
                out.println(JavaScriptIncludeHandler.getStartScript());
                out.println(remoteObjectName + ".commandInProgress = true;");
                out.println("parent.document.body.style.cursor = 'wait';");
                out.println(JavaScriptIncludeHandler.getEndScript(null));
                out.println(JavaScriptIncludeHandler.getStartScript());
                StringBuffer sb = new StringBuffer();
                this.getRemoteValues(sb, this.selectedProperty, this.availableValues, this.selectedValues, this.supplementalProperties);
                out.println(sb.toString());
                out.println(JavaScriptIncludeHandler.getEndScript(null));
                out.println(JavaScriptIncludeHandler.getStartScript());
                out.println("parent.document.body.style.cursor = 'auto';");
                out.println(remoteObjectName + ".commandInProgress = false;\n");
                out.println(JavaScriptIncludeHandler.getEndScript(null));
            }
        }
        catch (Exception e) {
            LoggerRepository2.getLogger((String)EntityAttributeValueSelectorPanel.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.serverError = null;
            this.currentProperty = null;
            this.selectedProperty = null;
            this.availableValues = null;
            this.selectedValues = null;
            this.supplementalProperties = null;
        }
    }

    protected StringBuffer getRemoteValues(StringBuffer sb, String property, List availableValues, List selectedValues, Map supplementalProperties) {
        String formatted;
        String remoteObjectName = "   parent." + this.getId();
        this.updateValueMap(property, availableValues);
        if (supplementalProperties != null) {
            sb.append("  var supplementalProperties = new Array(); \n");
            Iterator iter = supplementalProperties.keySet().iterator();
            int j = 0;
            while (iter.hasNext()) {
                Object propLabel = iter.next();
                Object propValue = supplementalProperties.get(propLabel);
                sb.append(" supplementalProperties[" + j++ + "] = {label:\"" + propLabel.toString() + "\" , value:\"" + propValue.toString() + "\"};\n");
            }
            sb.append(remoteObjectName).append(".setSupplementalProperties(\"" + property + "\", supplementalProperties").append(");\n");
        }
        sb.append("   var propertyValues = new Array();\n");
        if (availableValues != null) {
            int size = availableValues.size();
            for (int i = 0; i < size; ++i) {
                if (!(availableValues.get(i) instanceof PropertyValueInterface)) continue;
                PropertyValueInterface value = (PropertyValueInterface)availableValues.get(i);
                formatted = value.getFormattedValue();
                String unformatted = com.sas.servlet.tbeans.dataselectors.html.Util.getID(value);
                sb.append(" propertyValues[" + i + "] = {unformatted:\"" + unformatted + "\" , formatted:\"" + Strings.escapeForJavaScript((String)formatted) + "\",nodeTextStyle:\"javaScriptNodeText\"};\n");
            }
        }
        sb.append(remoteObjectName).append(".setAvailableValues(\"" + property + "\", propertyValues").append(");\n");
        if (selectedValues != null) {
            sb.append("  var selectedValues = new Array(); \n");
            for (int j = 0; j < selectedValues.size(); ++j) {
                if (!(selectedValues.get(j) instanceof PropertyValueInterface)) continue;
                PropertyValueInterface value = (PropertyValueInterface)selectedValues.get(j);
                String valueString = this.getValueID(property, value);
                if (valueString == null) {
                    formatted = value.getFormattedValue();
                    valueString = formatted != null ? formatted : (value.getUnformattedValue() != null ? value.getUnformattedValue().toString() : "");
                }
                sb.append(" selectedValues[" + j + "] = \"" + valueString + "\";\n");
            }
            sb.append(remoteObjectName).append(".setSelectedValues(\"" + property + "\", selectedValues").append(");\n");
        }
        return sb;
    }

    private String getValueID(String property, PropertyValueInterface value) {
        String id = null;
        Map valMap = (Map)this.valueMap.get(property);
        if (value != null && valMap != null) {
            Set values = valMap.entrySet();
            for (Map.Entry entry : values) {
                PropertyValueInterface val = (PropertyValueInterface)entry.getValue();
                if (!value.equals(val, this.getLocale())) continue;
                id = (String)entry.getKey();
                break;
            }
        }
        return id;
    }

    private void updateValueMap(String property, List values) {
        if (values != null) {
            HashMap propertyValues = new HashMap();
            for (Object obj : values) {
                if (!(obj instanceof PropertyValueInterface)) continue;
                propertyValues.put(com.sas.servlet.tbeans.dataselectors.html.Util.getID(obj), obj);
            }
            this.valueMap.put(property, propertyValues);
        }
    }

    @Override
    public void setSelectorModel(Object model) {
        super.setSelectorModel(model);
        if (model instanceof EntityAttributeValueModelInterface) {
            EntityAttributeValueModelInterface inModel = (EntityAttributeValueModelInterface)model;
            this.valueMap = (HashMap)inModel.getApplicationData();
            if (this.valueMap == null) {
                this.valueMap = new HashMap();
                inModel.setApplicationData((Object)this.valueMap);
            }
        }
    }

    protected ListModel getAttributeList() {
        EntityAttributeValueModelInterface selModel;
        Map propertyMap;
        Iterator iterator;
        DefaultListModel<PropertyNode> model = new DefaultListModel<PropertyNode>();
        if (this.getSelectorModel() instanceof EntityAttributeValueModelInterface && (iterator = (propertyMap = (selModel = (EntityAttributeValueModelInterface)this.getSelectorModel()).getProperties(this.getLocale())).keySet().iterator()) != null) {
            while (iterator.hasNext()) {
                PropertyNode node = new PropertyNode();
                String name = (String)iterator.next();
                node.setValue(name);
                node.setText((String)propertyMap.get(name));
                String instructionText = selModel.getEditorInstructionText(name);
                if (instructionText != null && instructionText.length() > 0) {
                    node.setInstructionText(instructionText);
                }
                model.addElement(node);
            }
        }
        return model;
    }

    private void createEditorMap(ListModel propertyList) {
        this.editorIdMap.clear();
        if (this.getSelectorModel() instanceof EntityAttributeValueModelInterface && propertyList != null) {
            EntityAttributeValueModelInterface selModel = (EntityAttributeValueModelInterface)this.getSelectorModel();
            int size = propertyList.getSize();
            for (int i = 0; i < size; ++i) {
                PropertyNode node = (PropertyNode)propertyList.getElementAt(i);
                String name = node.getValue();
                String id = this.getId() + "_" + name + "Editor";
                String editorType = selModel.getEditor(name, "JSPPanel");
                Object editor = null;
                if (editorType == null) {
                    editorType = TextEntryPropertyEditor.class.getName();
                }
                for (Object currEditor : this.editorIdMap.values()) {
                    if (!currEditor.getClass().getName().equals(editorType)) continue;
                    editor = currEditor;
                    break;
                }
                if (editor == null) {
                    try {
                        editor = Class.forName(editorType).newInstance();
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Unable to create editor for property: " + name);
                    }
                }
                node.setEditorObjectID(id);
                this.editorIdMap.put(id, editor);
            }
        }
    }

    static {
        JavaScriptIncludeHandler.addAlias(EntityAttributeValueSelectorPanel.class, "ENTITYATTRIBUTEVALUESELECTORPANEL");
        EAVSPropertyListXPStyle = new ImmutableStyleInfo("listBoxViewDropDownXP entityAttributeList");
        EAVSPropertyListStyle = new ImmutableStyleInfo("listBoxViewDropDown entityAttributeList");
        EAVSInstructionTextStyle = new ImmutableStyleInfo("selectorText entityAttributeLabel");
        EAVSPropertyLabelTextStyle = new ImmutableStyleInfo("selectorText entityAttributeLabel");
        defaultStyleMap = new HashMap();
    }
}

