/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.dataselectors.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.form.BaseFormElement;
import com.sas.servlet.tbeans.form.html.CheckBox;
import com.sas.servlet.tbeans.form.html.ChoiceBox;
import com.sas.servlet.tbeans.form.html.TextEntry;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.models.Item;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;

@SASScope
public class Util {
    public static final String SCRIPT_COLLECTION_KEY = "com.sas.servlet.sas_JavaScript_Includes";

    public static String getID(Object object) {
        String id = null;
        if (object != null) {
            id = Integer.toHexString(System.identityHashCode(object));
        }
        return id;
    }

    public static DefaultComboBoxModel[] getDefaultComboBoxModelPair(String message) {
        DefaultComboBoxModel[] model = new DefaultComboBoxModel[]{new DefaultComboBoxModel(), new DefaultComboBoxModel()};
        if (message != null) {
            model[0].addElement("");
            model[1].addElement(message);
        }
        return model;
    }

    public static DefaultListModel[] getDefaultListModelPair(String message) {
        DefaultListModel[] model = new DefaultListModel[]{new DefaultListModel(), new DefaultListModel()};
        if (message != null) {
            model[0].addElement("");
            model[1].addElement(message);
        }
        return model;
    }

    public static DefaultListModel getDefaultListModel(String message) {
        DefaultListModel<Item> model = new DefaultListModel<Item>();
        if (message != null) {
            model.addElement(new Item(message, ""));
        }
        return model;
    }

    public static DefaultComboBoxModel getDefaultComboBoxModel(String message) {
        DefaultComboBoxModel<Item> model = new DefaultComboBoxModel<Item>();
        if (message != null) {
            model.addElement(new Item(message, ""));
        }
        return model;
    }

    public static void writeJavaScriptIncludes(PrintWriter out, HttpServletRequest request, String jsPath, String[] requiredScripts) throws IOException {
        if (requiredScripts == null || out == null) {
            return;
        }
        if (jsPath == null) {
            if (request != null) {
                String contextPath = request.getContextPath();
                jsPath = contextPath + "/";
            } else {
                jsPath = "";
            }
        }
        Vector<String> scripts = null;
        if (request != null) {
            Object temp = request.getAttribute(SCRIPT_COLLECTION_KEY);
            if (temp == null) {
                scripts = new Vector();
                request.setAttribute(SCRIPT_COLLECTION_KEY, scripts);
            } else {
                scripts = temp instanceof Vector ? (Vector<String>)temp : new Vector<String>();
            }
        } else {
            scripts = new Vector<String>();
        }
        for (int i = 0; i < requiredScripts.length; ++i) {
            if (scripts.contains(requiredScripts[i])) continue;
            scripts.add(requiredScripts[i]);
            out.println("<script type=\"text/javascript\" language=\"JavaScript\" src=\"" + jsPath + requiredScripts[i] + "\"> </script>");
        }
    }

    public static void writeLabel(PrintWriter out, String text) throws IOException {
        Label label = new Label();
        label.setText(text);
        label.write(out);
    }

    public static void writeTextEntry(PrintWriter out, String name, int size, String text) throws IOException {
        TextEntry textEntry = new TextEntry();
        textEntry.setName(name);
        textEntry.setSize(size);
        textEntry.setMaximumLength(size);
        textEntry.setText(text);
        textEntry.write(out);
    }

    public static void writeCheckBox(PrintWriter out, String name, String text, String value, boolean selected) throws IOException {
        CheckBox checkbox = new CheckBox();
        checkbox.setName(name);
        checkbox.setSelected(selected);
        checkbox.setValue(value);
        checkbox.setText(text);
        checkbox.write(out);
    }

    public static void writeChoiceBox(PrintWriter out, String name, ComboBoxModel dataModel, ComboBoxModel descriptionModel, int selectedIndex) throws IOException {
        ChoiceBox choicebox = new ChoiceBox();
        choicebox.setName(name);
        choicebox.setModel(dataModel);
        choicebox.setDescriptionModel(descriptionModel);
        choicebox.setSelectedIndex(selectedIndex);
        ((BaseFormElement)choicebox).write(out);
    }
}

