/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.dataselectors.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.dataselectors.BaseSelectorPanel;
import com.sas.servlet.tbeans.form.html.Form;
import com.sas.servlet.tbeans.form.html.FormViewInterface;
import com.sas.servlet.tbeans.form.html.Hidden;
import com.sas.servlet.tbeans.html.HtmlUtil;
import com.sas.servlet.util.BaseUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Set;

@SASScope(value="ALL")
public abstract class SelectorPanel
extends BaseSelectorPanel
implements FormViewInterface {
    private Form formObject;
    private boolean formEnabled;
    private HashMap additionalParameters;
    private String iframeName;

    @Override
    public void setFormObject(Form form) {
        this.formObject = form;
    }

    @Override
    public Form getFormObject() {
        if (this.formObject == null) {
            this.formObject = this.getDefaultFormObject();
        }
        return this.formObject;
    }

    @Override
    public Form getDefaultFormObject() {
        return BaseUtil.getDefaultFormObject(this, this.getRequest(), this.getResponse());
    }

    @Override
    public HashMap getAdditionalParameters() {
        return this.additionalParameters;
    }

    @Override
    public void setAdditionalParameters(HashMap map) {
        this.additionalParameters = map;
    }

    @Override
    public void setAdditionalParameter(String name, String value) {
        if (this.additionalParameters == null) {
            this.additionalParameters = new HashMap();
        }
        this.additionalParameters.put(name, value);
    }

    @Override
    public void setFormEnabled(boolean enable) {
        this.formEnabled = enable;
    }

    @Override
    public boolean isFormEnabled() {
        return this.formEnabled;
    }

    public void setIframeName(String name) {
        this.iframeName = name;
    }

    public String getIframeName() {
        return this.iframeName;
    }

    public void writeRemoteScriptCommands(PrintWriter out) throws IOException {
    }

    public void writeRemoteScriptFrame(PrintWriter out) throws IOException {
        HtmlUtil.writeHiddenIFrame(out, this.getId() + "_RSIFrame", this.getRequest());
    }

    public void writeSelectorPanelHeader(PrintWriter out) throws IOException {
        HashMap map;
        if (this.isFormEnabled()) {
            Form form = this.getFormObject();
            String action = form.getAction();
            HttpServletRequest request = this.getRequest();
            if (action.length() == 0 && request != null) {
                action = request.getRequestURI();
                HttpServletResponse response = this.getResponse();
                if (response != null) {
                    action = response.encodeURL(action);
                }
                form.setAction(action);
            }
            form.writeHeader(out);
        }
        if ((map = this.getAdditionalParameters()) != null) {
            Set keys = map.keySet();
            for (String name : keys) {
                Hidden.writeElement(out, null, name, (String)map.get(name), true);
            }
        }
    }

    public void writeSelectorPanelFooter(PrintWriter out) throws IOException {
        if (this.isFormEnabled()) {
            Form form = this.getFormObject();
            form.writeFooter(out);
        }
    }

    public void close() {
    }
}

