/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.dataselectors.html;

import com.sas.codepolicy.SASScope;
import com.sas.commands.dataselectors.DataSelectorCommandInterface;
import com.sas.util.log.LoggerRepository2;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

@SASScope
public class GraphSelectorCommandFactory {
    private static Map selectorNameMap;

    protected static DataSelectorCommandInterface newSelectorCommandInstance(String className) {
        String selectorClass = (String)GraphSelectorCommandFactory.getSelectorNameMap().get(className);
        if (selectorClass == null) {
            return null;
        }
        DataSelectorCommandInterface command = null;
        try {
            Class<?> commandClass = Class.forName(selectorClass);
            Constructor<?> constructor = commandClass.getConstructor(String.class);
            command = (DataSelectorCommandInterface)constructor.newInstance("Chart Selector");
        }
        catch (Throwable e) {
            LoggerRepository2.getLogger((String)GraphSelectorCommandFactory.class.getPackage().getName(), null).error(e.getMessage(), e);
        }
        return command;
    }

    protected static void initializeSelectorNameMap(Map namesMap) {
        namesMap.put("com.sas.servlet.tbeans.graphics.html.BarChart", "com.sas.graphics.actionprovider.commands.components.barlinechart.BarLineChartPropertySelectorCommand");
        namesMap.put("com.sas.servlet.tbeans.graphics.html.BarLineChart", "com.sas.graphics.actionprovider.commands.components.barlinechart.BarLineChartPropertySelectorCommand");
        namesMap.put("com.sas.servlet.tbeans.graphics.html.LineChart", "com.sas.graphics.actionprovider.commands.components.barlinechart.BarLineChartPropertySelectorCommand");
        namesMap.put("com.sas.servlet.tbeans.graphics.html.PieChart", "com.sas.graphics.actionprovider.commands.components.piechart.PieChartPropertySelectorCommand");
        namesMap.put("com.sas.servlet.tbeans.graphics.html.ScatterPlot", "com.sas.graphics.actionprovider.commands.components.scatterplot.ScatterPlotPropertySelectorCommand");
        namesMap.put("com.sas.servlet.tbeans.graphics.html.TileChart", "com.sas.graphics.actionprovider.commands.components.tilechart.TileChartPropertySelectorCommand");
        namesMap.put("com.sas.servlet.tbeans.olapgraphics.html.OLAPBarChart", "com.sas.graphics.actionprovider.commands.components.barlinechart.BarLineChartPropertySelectorCommand");
        namesMap.put("com.sas.servlet.tbeans.olapgraphics.html.OLAPBarLineChart", "com.sas.graphics.actionprovider.commands.components.barlinechart.BarLineChartPropertySelectorCommand");
        namesMap.put("com.sas.servlet.tbeans.olapgraphics.html.OLAPLineChart", "com.sas.graphics.actionprovider.commands.components.barlinechart.BarLineChartPropertySelectorCommand");
        namesMap.put("com.sas.servlet.tbeans.olapgraphics.html.OLAPPieChart", "com.sas.graphics.actionprovider.commands.components.piechart.PieChartPropertySelectorCommand");
        namesMap.put("com.sas.servlet.tbeans.olapgraphics.html.OLAPScatterPlot", "com.sas.graphics.actionprovider.commands.components.scatterplot.ScatterPlotPropertySelectorCommand");
    }

    private static Map getSelectorNameMap() {
        if (selectorNameMap == null) {
            selectorNameMap = new HashMap();
            GraphSelectorCommandFactory.initializeSelectorNameMap(selectorNameMap);
        }
        return selectorNameMap;
    }
}

