/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.dataselectors.export.html;

import com.sas.actionprovider.HttpActionProvider;
import com.sas.codepolicy.SASScope;
import com.sas.commands.CancelInterface;
import com.sas.dataselectors.export.BaseExportSelectorAdapter;
import com.sas.dataselectors.export.ExportColumnsInterface;
import com.sas.dataselectors.export.ExportSelectorInterface;
import com.sas.dataselectors.export.OLAPExportSelectorInterface;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.dataselectors.export.html.ExportSelectorKeysInterface;
import com.sas.servlet.tbeans.dataselectors.export.html.ExportSelectorStyleKeysInterface;
import com.sas.servlet.tbeans.dataselectors.html.ActionProviderMenuBar;
import com.sas.servlet.tbeans.dataselectors.html.SelectorPanel;
import com.sas.servlet.tbeans.form.html.CheckBox;
import com.sas.servlet.tbeans.form.html.CheckBoxList;
import com.sas.servlet.tbeans.form.html.Form;
import com.sas.servlet.tbeans.form.html.Hidden;
import com.sas.servlet.tbeans.form.html.ListBox;
import com.sas.servlet.tbeans.form.html.OrderedCheckBoxList;
import com.sas.servlet.tbeans.form.html.Radio;
import com.sas.servlet.tbeans.form.html.TextEntry;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.models.Item;
import com.sas.servlet.tbeans.models.JavaScriptNode;
import com.sas.servlet.tbeans.models.JavaScriptNodeInterface;
import com.sas.servlet.tbeans.tableview.BaseTableView;
import com.sas.servlet.tbeans.tableview.TableColumnModel;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.servlet.tbeans.util.validators.MaximumValueValidator;
import com.sas.servlet.tbeans.util.validators.MinimumValueValidator;
import com.sas.servlet.tbeans.util.validators.NumericInputValidator;
import com.sas.servlet.tbeans.util.validators.RequiredStringValidator;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.table.FormattedInterface;
import com.sas.text.Message;
import com.sas.util.MapWithDefaults;
import com.sas.util.Strings;
import com.sas.util.Util;
import com.sas.util.log.LoggerRepository2;
import java.awt.ComponentOrientation;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import javax.swing.table.TableModel;

@SASScope(value="ALL")
public class ExportSelectorPanel
extends SelectorPanel
implements CancelInterface,
ExportSelectorKeysInterface,
ExportSelectorStyleKeysInterface {
    private Form form;
    private String parameterPrefix;
    private boolean isOLAP;
    private boolean exportCSS;
    private ResourceBundle bundle;
    @SASScope
    private String RB_KEY;
    private boolean isLeftToRight;
    private boolean isHorizontal;
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "ExportSelectorPanel.html";
    public static final boolean DEFAULT_EXPORT_CSS = true;
    @SASScope
    protected Label outputLabel;
    @SASScope
    protected ListBox listBox;
    protected ListBox saveAsListBox;
    @SASScope
    protected Label includeLabel;
    @SASScope
    protected Radio includeRadio;
    protected Radio exportToRadio;
    protected Radio saveAsRadio;
    @SASScope
    protected Label fromLabel;
    @SASScope
    protected TextEntry fromTextEntry;
    @SASScope
    protected Label toLabel;
    @SASScope
    protected TextEntry toTextEntry;
    @SASScope
    protected Label formatLabel;
    @SASScope
    protected CheckBox formatCheck;
    @SASScope
    protected Label optionsLabel;
    @SASScope
    protected CheckBox repeatRowLabelsCheckBox;
    @SASScope
    protected int maxTextEntrySize;
    protected OrderedCheckBoxList columnsCheckBoxList;
    protected Label rowsLabel;
    protected Label columnsLabel;
    protected Radio columnsRadio;
    @SASScope
    protected String isExportFromNonBlankErrorMessage = null;
    @SASScope
    protected String isExportFromNonNumericErrorMessage = null;
    @SASScope
    protected String isExportFromMinValueValidErrorMessage = null;
    protected String isExportFromMaxValueValidErrorMessage = null;
    protected String isExportToMaxValueValidErrorMessage = null;
    @SASScope
    protected String isExportToNonBlankErrorMessage = null;
    @SASScope
    protected String isExportToNonNumericErrorMessage = null;
    @SASScope
    protected String isExportToMinValueValidErrorMessage = null;
    protected String isNoColumnsChosenErrorMessage = null;
    protected static String CHECKBOX_STYLEMAP_KEY = "CHECKBOX_BOX";
    protected static String CHECKBOX_LABEL_STYLEMAP_KEY = "CHECKBOX_LABEL";
    protected static String RADIOBOX_STYLEMAP_KEY = "RADIO_BOX";
    protected static String RADIOBOX_LABEL_STYLEMAP_KEY = "RADIO_LABEL";
    private static final String EXPORTSELECTOR_TEXT_DEFAULT_STYLE_NAME = "selectorText";
    private static final String EXPORTSELECTOR_LABEL_DEFAULT_STYLE_NAME = "selectorLabel";
    private static final String EXPORTSELECTOR_CHECK_DEFAULT_STYLE_NAME = "selectorCheckBox";
    private static final String EXPORTSELECTOR_CHECK_LABEL_DEFAULT_STYLE_NAME = "selectorCheckBoxLabel";
    private static final String EXPORTSELECTOR_LIST_DEFAULT_STYLE_NAME = "exportSelectorList";
    private static final String EXPORTSELECTOR_RADIO_DEFAULT_STYLE_NAME = "selectorRadio";
    private static final String EXPORTSELECTOR_RADIO_LABEL_DEFAULT_STYLE_NAME = "selectorRadioLabel";
    private static final String EXPORTSELECTOR_TEXT_ENTRY_DEFAULT_STYLE_NAME = "selectorTextEntryDisabled";
    private static final String EXPORTSELECTOR_CHECK_BOX_LIST_DEFAULT_STYLE_NAME = "exportSelectorOrderedCheckBoxList";
    private static final Map defaultStyleMap = new HashMap();
    private static final ImmutableStyleInfo ESTextStyle = new ImmutableStyleInfo("selectorText");
    private static final ImmutableStyleInfo ESLabelStyle = new ImmutableStyleInfo("selectorLabel");
    private static final ImmutableStyleInfo ESCheckStyle = new ImmutableStyleInfo("selectorCheckBox");
    private static final ImmutableStyleInfo ESCheckLabelStyle = new ImmutableStyleInfo("selectorCheckBoxLabel");
    private static final ImmutableStyleInfo ESListStyle = new ImmutableStyleInfo("exportSelectorList");
    private static final ImmutableStyleInfo ESRadioStyle = new ImmutableStyleInfo("selectorRadio");
    private static final ImmutableStyleInfo ESRadioLabelStyle = new ImmutableStyleInfo("selectorRadioLabel");
    private static final ImmutableStyleInfo ESTextEntryDisabledStyle = new ImmutableStyleInfo("selectorTextEntryDisabled");
    private static final ImmutableStyleInfo ESCheckBoxListStyle = new ImmutableStyleInfo("exportSelectorOrderedCheckBoxList", "height: 170px; width: 170px; overflow-x: auto; overflow-y: auto; background-color: white;");
    private static String OUTPUT_TYPE_FORM_FIELD_NAME = "outputType";
    private boolean allColumnsDisplayed = false;

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put("EXPORTSELECTOR_TEXT", ESTextStyle);
            defaultStyleMap.put("EXPORTSELECTOR_LABEL", ESLabelStyle);
            defaultStyleMap.put("EXPORTSELECTOR_CHECK", ESCheckStyle);
            defaultStyleMap.put("EXPORTSELECTOR_CHECK_LABEL", ESCheckLabelStyle);
            defaultStyleMap.put("EXPORTSELECTOR_LIST", ESListStyle);
            defaultStyleMap.put("EXPORTSELECTOR_RADIO", ESRadioStyle);
            defaultStyleMap.put("EXPORTSELECTOR_RADIO_LABEL", ESRadioLabelStyle);
            defaultStyleMap.put("EXPORTSELECTOR_TEXT_ENTRY", ESTextEntryDisabledStyle);
        }
    }

    public ExportSelectorPanel() {
        this(Util.getName((String)"eSel_panel"));
    }

    public ExportSelectorPanel(String name) {
        this.setId(name);
        this.RB_KEY = "ExportSelector.";
        this.maxTextEntrySize = 8;
        this.setExportCSS(true);
        this.setTemplateKey("Export_Selector_Panel");
        this.addComponents();
        ExportSelectorPanel.setupDefaultStyleMap();
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap(defaultStyleMap);
        this._setLocaleDependentProperties(this.getLocale());
    }

    @Override
    @SASScope
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        this._setLocaleDependentProperties(locale);
    }

    private void _setLocaleDependentProperties(Locale locale) {
        this.bundle = ResourceBundle.getBundle("com.sas.swing.visuals.dataselectors.export.Resources", locale);
        ComponentOrientation orientation = ComponentOrientation.getOrientation(locale);
        this.isLeftToRight = orientation.isLeftToRight();
        this.isHorizontal = orientation.isHorizontal();
        this.outputLabel = (Label)this.getComponent("EXPORTSELECTOR_OUTPUT_LABEL");
        if (this.outputLabel != null) {
            this.outputLabel.setText(this.bundle.getString(this.RB_KEY + "outputLabel.txt"));
        }
        this.includeLabel = (Label)this.getComponent("EXPORTSELECTOR_INCLUDE_LEGEND_LABEL");
        if (this.includeLabel != null) {
            this.includeLabel.setText(this.bundle.getString(this.RB_KEY + "includeLabel.txt"));
        }
        this.includeRadio = (Radio)this.getComponent("EXPORTSELECTOR_INCLUDE_RADIO");
        if (this.includeRadio != null) {
            this.includeRadio.setLabelOrientation(this.isLeftToRight ? 4 : 2);
        }
        this.exportToRadio = (Radio)this.getComponent("EXPORTSELECTOR_EXPORT_TO_RADIO");
        if (this.exportToRadio != null) {
            this.exportToRadio.setLabelOrientation(this.isLeftToRight ? 4 : 2);
        }
        this.saveAsRadio = (Radio)this.getComponent("EXPORTSELECTOR_SAVE_AS_RADIO");
        if (this.saveAsRadio != null) {
            this.saveAsRadio.setLabelOrientation(this.isLeftToRight ? 4 : 2);
        }
        this.fromLabel = (Label)this.getComponent("EXPORTSELECTOR_FROM_LABEL");
        if (this.fromLabel != null) {
            this.fromLabel.setText(this.bundle.getString(this.RB_KEY + "fromLabel.txt"));
        }
        this.toLabel = (Label)this.getComponent("EXPORTSELECTOR_TO_LABEL");
        if (this.toLabel != null) {
            this.toLabel.setText(this.bundle.getString(this.RB_KEY + "toLabel.txt"));
        }
        this.formatCheck = (CheckBox)this.getComponent("EXPORTSELECTOR_FORMAT_CHECK");
        if (this.formatCheck != null) {
            this.formatCheck.setText(this.bundle.getString(this.RB_KEY + "formattedData.txt"));
        }
        this.optionsLabel = (Label)this.getComponent("EXPORTSELECTOR_OPTIONS_LEGEND_LABEL");
        if (this.optionsLabel != null) {
            this.optionsLabel.setText(this.bundle.getString(this.RB_KEY + "optionsLabel.txt"));
        }
        this.repeatRowLabelsCheckBox = (CheckBox)this.getComponent("EXPORTSELECTOR_REPEAT_ROW_LABELS_CHECK_BOX");
        if (this.repeatRowLabelsCheckBox != null) {
            this.repeatRowLabelsCheckBox.setText(this.bundle.getString(this.RB_KEY + "repeatRowLabels.txt"));
        }
        this.isExportFromNonBlankErrorMessage = this.bundle.getString(this.RB_KEY + "noFromValueSet.txt");
        this.isExportFromNonNumericErrorMessage = this.bundle.getString(this.RB_KEY + "fromValueNotNumeric.txt");
        int minNrows = 1;
        int maxNrows = 500000;
        Object adapter = this.getSelectorModel();
        if (adapter instanceof ExportSelectorInterface) {
            minNrows = ((ExportSelectorInterface)adapter).getMinNrows();
            maxNrows = ((ExportSelectorInterface)adapter).getMaxNrows();
        }
        this.isExportFromMinValueValidErrorMessage = Message.format((ResourceBundle)this.bundle, (String)(this.RB_KEY + "fromValueBelowMinimum.fmt.txt"), (Object)new Integer(minNrows));
        this.isExportFromMaxValueValidErrorMessage = Message.format((ResourceBundle)this.bundle, (String)(this.RB_KEY + "fromValueAboveMaximum.fmt.txt"), (Object)new Integer(maxNrows));
        this.isExportToMaxValueValidErrorMessage = Message.format((ResourceBundle)this.bundle, (String)(this.RB_KEY + "toValueAboveMaximum.fmt.txt"), (Object)new Integer(maxNrows));
        this.isExportToNonBlankErrorMessage = this.bundle.getString(this.RB_KEY + "noToValueSet.txt");
        this.isExportToNonNumericErrorMessage = this.bundle.getString(this.RB_KEY + "toValueNotNumeric.txt");
        this.isExportToMinValueValidErrorMessage = this.bundle.getString(this.RB_KEY + "toValueBelowMinimum.txt");
        this.isNoColumnsChosenErrorMessage = this.bundle.getString(this.RB_KEY + "noColumnsChosen.txt");
        this.rowsLabel = (Label)this.getComponent("EXPORTSELECTOR_ROWS_LABEL");
        if (this.rowsLabel != null) {
            this.rowsLabel.setText(this.bundle.getString(this.RB_KEY + "rowsLabel.txt"));
        }
        this.columnsLabel = (Label)this.getComponent("EXPORTSELECTOR_COLUMNS_LABEL");
        if (this.columnsLabel != null) {
            this.columnsLabel.setText(this.bundle.getString(this.RB_KEY + "columnsLabel.txt"));
        }
        this.columnsRadio = (Radio)this.getComponent("EXPORTSELECTOR_COLUMNS_RADIO");
        if (this.columnsRadio != null) {
            this.columnsRadio.setLabelOrientation(this.isLeftToRight ? 4 : 2);
        }
    }

    @Override
    public void write(PrintWriter out) {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        if (!this.isOLAP) {
            this.removeComponent("EXPORTSELECTOR_REPEAT_ROW_LABELS_CHECK_BOX");
            this.setCurrentlyDisplayedColumnIndexes();
        }
        try {
            JavaScriptIncludeHandler.writeIncludes(out, "EXPORTSELECTOR", this.getRequest());
            JavaScriptIncludeHandler.writeIncludes(out, "VALIDATOR", this.getRequest());
        }
        catch (IOException e) {
            LoggerRepository2.getLogger((String)ExportSelectorPanel.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        this.form = this.getFormObject();
        this.form.setRequest(this.getRequest());
        this.form.setResponse(this.getResponse());
        this.form.setLocale(this.getLocale());
        try {
            this.writeSelectorPanelHeader(out);
            String name = this.getActionProvider().getName();
            name = Strings.escapeForJavaScript((String)name);
            Hidden.writeElement(out, "APNAME", "APNAME", name, true);
            Hidden.writeElement(out, "CMDID", "CMDID", Strings.escapeForJavaScript((String)this.getCommandId()), true);
            String prefix = Strings.escapeForJavaScript((String)this.getActionProvider().getParameterPrefix());
            Hidden.writeElement(out, prefix + "mode", prefix + "mode", "COMMIT", true);
            this.setComponentValues();
            this.addItemsToTemplateDictionaryMap();
            String formattedSelector = this.applyTemplate(this);
            out.println(formattedSelector);
            this.writeSelectorPanelFooter(out);
            this.initJsVars(out);
        }
        catch (IOException e) {
            LoggerRepository2.getLogger((String)ExportSelectorPanel.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        this.cleanUpResources();
    }

    private void addItemsToTemplateDictionaryMap() {
        HashMap<String, String> dMap = this.getTemplateDictionary();
        String displayStyle = null;
        if (!(dMap != null && dMap.containsKey("EXPORTSELECTOR_OPTIONS_DISPLAY_STYLE") && dMap.containsKey("EXPORTSELECTOR_COLUMNS_DISPLAY_STYLE") && dMap.containsKey("EXPORTSELECTOR_ROWS_DISPLAY_STYLE"))) {
            if (dMap == null) {
                dMap = new HashMap<String, String>();
            }
            if (!dMap.containsKey("EXPORTSELECTOR_OPTIONS_DISPLAY_STYLE")) {
                displayStyle = this.isOLAP ? "display:auto;" : "display:none;";
                dMap.put("EXPORTSELECTOR_OPTIONS_DISPLAY_STYLE", displayStyle);
            }
            if (!dMap.containsKey("EXPORTSELECTOR_COLUMNS_DISPLAY_STYLE")) {
                displayStyle = this.isOLAP ? "display:none;" : "display:auto;";
                dMap.put("EXPORTSELECTOR_COLUMNS_DISPLAY_STYLE", displayStyle);
            }
            if (!dMap.containsKey("EXPORTSELECTOR_ROWS_DISPLAY_STYLE")) {
                displayStyle = "display:auto;";
                dMap.put("EXPORTSELECTOR_ROWS_DISPLAY_STYLE", displayStyle);
            }
            if (dMap.size() > 0) {
                this.setTemplateDictionary(dMap);
            }
        }
    }

    private void setCurrentlyDisplayedColumnIndexes() {
        TableColumnModel columnModel;
        BaseTableView htmlTable = null;
        ExportColumnsInterface exportColumnsAdapter = null;
        Object adapter = this.getSelectorModel();
        if (adapter instanceof ExportColumnsInterface) {
            exportColumnsAdapter = (ExportColumnsInterface)adapter;
            Object viewer = exportColumnsAdapter.getViewer();
            if (viewer instanceof TableView) {
                htmlTable = (TableView)viewer;
            }
            if (viewer instanceof ActionProviderMenuBar && (viewer = ((ActionProviderMenuBar)viewer).getViewer()) instanceof TableView) {
                htmlTable = (TableView)viewer;
            }
        }
        if (htmlTable != null && exportColumnsAdapter != null && (columnModel = htmlTable.getColumnModel()) != null) {
            int nCols;
            Object model;
            int startColumn = htmlTable.getStartColumn();
            int endColumn = htmlTable.getEndColumn();
            int nDisplayedCols = Math.abs(startColumn - endColumn) + 1;
            int[] currentlyDisplayedColumnIndexes = new int[nDisplayedCols];
            int i = startColumn;
            int a = 0;
            while (i <= endColumn) {
                currentlyDisplayedColumnIndexes[a] = columnModel.getColumn(i).getModelIndex();
                ++i;
                ++a;
            }
            exportColumnsAdapter.setCurrentlyDisplayedColumnIndexes(currentlyDisplayedColumnIndexes);
            if (adapter instanceof BaseExportSelectorAdapter && (model = ((BaseExportSelectorAdapter)adapter).getDataModel()) instanceof TableModel && nDisplayedCols == (nCols = ((TableModel)model).getColumnCount())) {
                this.allColumnsDisplayed = true;
            }
        }
    }

    @SASScope
    protected void addComponents() {
        if (this.getComponents().isEmpty()) {
            this.outputLabel = this.newLabel("outputLabel", ESLabelStyle);
            this.setComponent("EXPORTSELECTOR_OUTPUT_LABEL", this.outputLabel);
            this.listBox = this.newListBox("exportToListBox", ESListStyle);
            this.setComponent("EXPORTSELECTOR_LIST_BOX", this.listBox);
            this.saveAsListBox = this.newListBox("saveAsListBox", ESListStyle);
            this.setComponent("EXPORTSELECTOR_SAVE_AS_LIST_BOX", this.saveAsListBox);
            this.includeLabel = this.newLabel("includeLabel", ESLabelStyle);
            this.setComponent("EXPORTSELECTOR_INCLUDE_LEGEND_LABEL", this.includeLabel);
            this.includeRadio = this.newRadio("rows");
            this.setComponent("EXPORTSELECTOR_INCLUDE_RADIO", this.includeRadio);
            this.exportToRadio = this.newRadio("exp_save");
            this.setComponent("EXPORTSELECTOR_EXPORT_TO_RADIO", this.exportToRadio);
            this.saveAsRadio = this.newRadio("exp_save");
            this.setComponent("EXPORTSELECTOR_SAVE_AS_RADIO", this.saveAsRadio);
            this.fromLabel = this.newLabel("fromLabel", ESTextStyle);
            this.setComponent("EXPORTSELECTOR_FROM_LABEL", this.fromLabel);
            this.createFromTextEntry();
            this.setComponent("EXPORTSELECTOR_FROM_TEXT_ENTRY", this.fromTextEntry);
            this.toLabel = this.newLabel("toLabel", ESTextStyle);
            this.setComponent("EXPORTSELECTOR_TO_LABEL", this.toLabel);
            this.createToTextEntry();
            this.setComponent("EXPORTSELECTOR_TO_TEXT_ENTRY", this.toTextEntry);
            this.createFormatCheck();
            this.setComponent("EXPORTSELECTOR_FORMAT_CHECK", this.formatCheck);
            this.optionsLabel = this.newLabel("optionsLabel", ESLabelStyle);
            this.setComponent("EXPORTSELECTOR_OPTIONS_LEGEND_LABEL", this.optionsLabel);
            this.createRepeatRowLabelsCheckBox();
            this.setComponent("EXPORTSELECTOR_REPEAT_ROW_LABELS_CHECK_BOX", this.repeatRowLabelsCheckBox);
            this.columnsCheckBoxList = this.newOrderedCheckBoxList("columns", ESCheckBoxListStyle);
            this.setComponent("EXPORTSELECTOR_COLUMNS_CHECK_BOX_LIST", this.columnsCheckBoxList);
            this.rowsLabel = this.newLabel("rowsLabel", ESLabelStyle);
            this.setComponent("EXPORTSELECTOR_ROWS_LABEL", this.rowsLabel);
            this.columnsLabel = this.newLabel("columnLabel", ESLabelStyle);
            this.setComponent("EXPORTSELECTOR_COLUMNS_LABEL", this.columnsLabel);
            this.columnsRadio = this.newRadio("whichColumns");
            this.setComponent("EXPORTSELECTOR_COLUMNS_RADIO", this.columnsRadio);
        }
    }

    @SASScope
    protected void createOutputLabel() {
        this.outputLabel = new Label();
        this.outputLabel.setId(new StringBuffer().append(this.getId()).append("_").append("outputLabel").toString());
        this.outputLabel.setStyleInfo(ESLabelStyle);
    }

    @SASScope
    protected void createListBox() {
        this.listBox = new ListBox();
        this.listBox.setId(new StringBuffer().append(this.getId()).append("exportToListBox").toString());
        this.listBox.setStyleInfo(ESListStyle);
    }

    protected ListBox newListBox(String name, ImmutableStyleInfo style) {
        ListBox listBox = new ListBox();
        listBox.setId(new StringBuffer().append(this.getId()).append(name).toString());
        listBox.setStyleInfo(style);
        return listBox;
    }

    protected OrderedCheckBoxList newOrderedCheckBoxList(String name, ImmutableStyleInfo style) {
        Map styleMap;
        OrderedCheckBoxList orderedCheckBoxList = new OrderedCheckBoxList();
        orderedCheckBoxList.setId(new StringBuffer().append(this.getId()).append(name).toString());
        orderedCheckBoxList.setMultipleSelections(true);
        orderedCheckBoxList.setSize(5);
        CheckBoxList cboxList = (CheckBoxList)orderedCheckBoxList.getComponent("ORDERED_LIST_COMPONENT");
        if (cboxList != null && (styleMap = cboxList.getStyleMap()) != null) {
            styleMap.put("LISTBOXVIEW_OUTER_DIV_XP", style);
            styleMap.put("LISTBOXVIEW_SELECTED", ESListStyle);
        }
        Button cbUpButton = (Button)orderedCheckBoxList.getComponent("ORDERED_LIST_UP_BUTTON");
        Button cbDownButton = (Button)orderedCheckBoxList.getComponent("ORDERED_LIST_DOWN_BUTTON");
        ImmutableStyleInfo myCBButtonStyles = new ImmutableStyleInfo("foo");
        cbUpButton.getStyleMap().put("BUTTON_STYLE", myCBButtonStyles);
        cbDownButton.getStyleMap().put("BUTTON_STYLE", myCBButtonStyles);
        return orderedCheckBoxList;
    }

    @SASScope
    protected void createIncludeRadio() {
        this.includeRadio = new Radio();
        this.includeRadio.setId(new StringBuffer().append(this.getId()).append("rows").toString());
        Map includeRadioStyleMap = this.includeRadio.getStyleMap();
        includeRadioStyleMap.put(RADIOBOX_STYLEMAP_KEY, new StyleInfo(EXPORTSELECTOR_RADIO_DEFAULT_STYLE_NAME));
        includeRadioStyleMap.put(RADIOBOX_LABEL_STYLEMAP_KEY, new StyleInfo(EXPORTSELECTOR_RADIO_LABEL_DEFAULT_STYLE_NAME));
    }

    protected Radio newRadio(String name) {
        Radio radio = new Radio();
        radio.setId(new StringBuffer().append(this.getId()).append(name).toString());
        Map radioStyleMap = radio.getStyleMap();
        radioStyleMap.put(RADIOBOX_STYLEMAP_KEY, new StyleInfo(EXPORTSELECTOR_RADIO_DEFAULT_STYLE_NAME));
        radioStyleMap.put(RADIOBOX_LABEL_STYLEMAP_KEY, new StyleInfo(EXPORTSELECTOR_RADIO_LABEL_DEFAULT_STYLE_NAME));
        return radio;
    }

    @SASScope
    protected void createFromLabel() {
        this.fromLabel = new Label();
        this.fromLabel.setId(new StringBuffer().append(this.getId()).append("_").append("fromLabel").toString());
        this.fromLabel.setStyleInfo(ESLabelStyle);
    }

    @SASScope
    protected void createFromTextEntry() {
        this.fromTextEntry = new TextEntry();
        this.fromTextEntry.setId(new StringBuffer().append(this.getId()).append("startRow").toString());
        this.fromTextEntry.setSize(this.maxTextEntrySize);
        this.fromTextEntry.setStyleInfo(ESTextEntryDisabledStyle);
        this.fromTextEntry.setEnabled(false);
    }

    @SASScope
    protected void createToLabel() {
        this.toLabel = new Label();
        this.toLabel.setId(new StringBuffer().append(this.getId()).append("_").append("toLabel").toString());
        this.toLabel.setStyleInfo(ESLabelStyle);
    }

    @SASScope
    protected void createToTextEntry() {
        this.toTextEntry = new TextEntry();
        this.toTextEntry.setId(new StringBuffer().append(this.getId()).append("endRow").toString());
        this.toTextEntry.setSize(this.maxTextEntrySize);
        this.toTextEntry.setStyleInfo(ESTextEntryDisabledStyle);
        this.toTextEntry.setEnabled(false);
    }

    protected TextEntry newTextEntry(String name, int size, ImmutableStyleInfo style, boolean isEnabled) {
        TextEntry textEntry = new TextEntry();
        textEntry.setId(new StringBuffer().append(this.getId()).append(name).toString());
        textEntry.setSize(size);
        textEntry.setStyleInfo(style);
        textEntry.setEnabled(isEnabled);
        return textEntry;
    }

    @SASScope
    protected void createFormatLabel() {
        this.formatLabel = new Label();
        this.formatLabel.setId(new StringBuffer().append(this.getId()).append("_").append("formatLabel").toString());
        this.formatLabel.setStyleInfo(ESLabelStyle);
    }

    protected Label newLabel(String name, ImmutableStyleInfo style) {
        Label label = new Label();
        label.setId(new StringBuffer().append(this.getId()).append("_").append(name).toString());
        label.setStyleInfo(style);
        return label;
    }

    @SASScope
    protected void createFormatCheck() {
        this.formatCheck = new CheckBox();
        this.formatCheck.setId(new StringBuffer().append(this.getId()).append("formatted").toString());
        Map formatCheckStyleMap = this.formatCheck.getStyleMap();
        formatCheckStyleMap.put(CHECKBOX_STYLEMAP_KEY, new StyleInfo(EXPORTSELECTOR_CHECK_DEFAULT_STYLE_NAME));
        formatCheckStyleMap.put(CHECKBOX_LABEL_STYLEMAP_KEY, new StyleInfo(EXPORTSELECTOR_CHECK_LABEL_DEFAULT_STYLE_NAME));
    }

    @SASScope
    protected void createRepeatRowLabelsCheckBox() {
        this.repeatRowLabelsCheckBox = new CheckBox();
        this.repeatRowLabelsCheckBox.setId(new StringBuffer().append(this.getId()).append("repeatLabels").toString());
        Map repeatRowLabelsCheckBoxStyleMap = this.repeatRowLabelsCheckBox.getStyleMap();
        repeatRowLabelsCheckBoxStyleMap.put(CHECKBOX_STYLEMAP_KEY, new StyleInfo(EXPORTSELECTOR_CHECK_DEFAULT_STYLE_NAME));
        repeatRowLabelsCheckBoxStyleMap.put(CHECKBOX_LABEL_STYLEMAP_KEY, new StyleInfo(EXPORTSELECTOR_CHECK_LABEL_DEFAULT_STYLE_NAME));
        this.repeatRowLabelsCheckBox.setStyleInfo(ESCheckStyle);
    }

    private void setComponentValues() {
        String name;
        this.listBox = (ListBox)this.getComponent("EXPORTSELECTOR_LIST_BOX");
        this.setOutputTypeListBoxValues(this.listBox, "exportToListBox", this.getOutputTypes());
        this.listBox = (ListBox)this.getComponent("EXPORTSELECTOR_SAVE_AS_LIST_BOX");
        this.setOutputTypeListBoxValues(this.listBox, "saveAsListBox", this.getSaveAsOutputTypes());
        this.includeRadio = (Radio)this.getComponent("EXPORTSELECTOR_INCLUDE_RADIO");
        if (this.includeRadio != null) {
            this.includeRadio.setName(new StringBuffer().append(this.parameterPrefix).append("rows").toString());
            this.includeRadio.setModel(this.getLocalizedIncludeRadioModel());
            try {
                this.includeRadio.setSelectedIndex(0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.includeRadio.setOnClick("sas_exportSelector_respondIncludeRowsChange( );");
        }
        this.exportToRadio = (Radio)this.getComponent("EXPORTSELECTOR_EXPORT_TO_RADIO");
        if (this.exportToRadio != null) {
            name = new StringBuffer().append(this.parameterPrefix).append("exp_save").toString();
            this.exportToRadio.setName(name);
            this.exportToRadio.setId(name + "E");
            this.exportToRadio.setModel(this.getLocalizedExportToRadioModel());
            try {
                this.exportToRadio.setSelectedIndex(0);
            }
            catch (IOException e) {
                LoggerRepository2.getLogger((String)ExportSelectorPanel.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
            }
            this.exportToRadio.setOnClick("sas_exportSelector_respondExportSaveChange( );");
        }
        this.saveAsRadio = (Radio)this.getComponent("EXPORTSELECTOR_SAVE_AS_RADIO");
        if (this.saveAsRadio != null) {
            name = new StringBuffer().append(this.parameterPrefix).append("exp_save").toString();
            this.saveAsRadio.setName(name);
            this.saveAsRadio.setId(name + "S");
            this.saveAsRadio.setModel(this.getLocalizedSaveAsRadioModel());
            this.saveAsRadio.setOnClick("sas_exportSelector_respondExportSaveChange( );");
        }
        this.fromTextEntry = (TextEntry)this.getComponent("EXPORTSELECTOR_FROM_TEXT_ENTRY");
        if (this.fromTextEntry != null) {
            this.fromTextEntry.setName(new StringBuffer().append(this.parameterPrefix).append("startRow").toString());
        }
        this.toTextEntry = (TextEntry)this.getComponent("EXPORTSELECTOR_TO_TEXT_ENTRY");
        if (this.toTextEntry != null) {
            this.toTextEntry.setName(new StringBuffer().append(this.parameterPrefix).append("endRow").toString());
        }
        this.formatCheck = (CheckBox)this.getComponent("EXPORTSELECTOR_FORMAT_CHECK");
        if (this.formatCheck != null) {
            Object model;
            this.formatCheck.setName(new StringBuffer().append(this.parameterPrefix).append("formatted").toString());
            this.formatCheck.setValue("1");
            this.formatCheck.setSelected(true);
            Object adapter = this.getSelectorModel();
            if (!this.isOLAP && adapter instanceof BaseExportSelectorAdapter && (model = ((BaseExportSelectorAdapter)adapter).getDataModel()) instanceof FormattedInterface && !((FormattedInterface)model).isFormattedDataUsed()) {
                this.formatCheck.setValue("0");
                this.formatCheck.setSelected(false);
            }
        }
        this.repeatRowLabelsCheckBox = (CheckBox)this.getComponent("EXPORTSELECTOR_REPEAT_ROW_LABELS_CHECK_BOX");
        if (this.repeatRowLabelsCheckBox != null) {
            this.repeatRowLabelsCheckBox.setValue("1");
            this.repeatRowLabelsCheckBox.setName(new StringBuffer().append(this.parameterPrefix).append("repeatLabels").toString());
            this.repeatRowLabelsCheckBox.setSelected(true);
        }
        this.columnsCheckBoxList = (OrderedCheckBoxList)this.getComponent("EXPORTSELECTOR_COLUMNS_CHECK_BOX_LIST");
        if (this.columnsCheckBoxList != null) {
            this.columnsCheckBoxList.setId(new StringBuffer().append(this.parameterPrefix).append("columns").toString());
            ListModel columns = this.getColumns();
            this.columnsCheckBoxList.setModel(columns);
        }
        this.columnsRadio = (Radio)this.getComponent("EXPORTSELECTOR_COLUMNS_RADIO");
        if (this.columnsRadio != null) {
            this.columnsRadio.setName(new StringBuffer().append(this.parameterPrefix).append("whichColumns").toString());
            this.columnsRadio.setModel(this.getLocalizedColumnsRadioModel());
            try {
                this.columnsRadio.setSelectedIndex(0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.columnsRadio.setOnClick("sas_exportSelector_respondIncludeColumnsChange( );");
        }
    }

    private void setOutputTypeListBoxValues(ListBox listBox, String name, ListModel values) {
        if (listBox != null) {
            listBox.setName(new StringBuffer().append(this.parameterPrefix).append(name).toString());
            listBox.setModel(values);
            listBox.setMultipleSelections(false);
            listBox.setSize(2);
            if (values.getSize() > 0) {
                try {
                    listBox.setSelectedIndex(0);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            listBox.setOnChange(new StringBuffer("sas_exportSelector_respondOutputTypeChange('").append(Strings.escapeForJavaScript((String)listBox.getName())).append("');").toString());
        }
    }

    private ListModel getLocalizedIncludeRadioModel() {
        DefaultListModel<Item> listModel = new DefaultListModel<Item>();
        listModel.addElement(new Item(this.bundle.getString(this.RB_KEY + "allRows.txt"), "A"));
        listModel.addElement(new Item(this.bundle.getString(this.RB_KEY + "rows.txt"), "R"));
        return listModel;
    }

    private ListModel getLocalizedExportToRadioModel() {
        DefaultListModel<Item> listModel = new DefaultListModel<Item>();
        listModel.addElement(new Item(this.bundle.getString(this.RB_KEY + "exportTo.txt"), "E"));
        return listModel;
    }

    private ListModel getLocalizedSaveAsRadioModel() {
        DefaultListModel<Item> listModel = new DefaultListModel<Item>();
        listModel.addElement(new Item(this.bundle.getString(this.RB_KEY + "saveAs.txt"), "S"));
        return listModel;
    }

    protected ListModel getLocalizedColumnsRadioModel() {
        DefaultListModel<Item> listModel = new DefaultListModel<Item>();
        listModel.addElement(new Item(this.bundle.getString(this.RB_KEY + "allColumns.txt"), "A"));
        if (!this.allColumnsDisplayed) {
            listModel.addElement(new Item(this.bundle.getString(this.RB_KEY + "displayedColumns.txt"), "D"));
        }
        listModel.addElement(new Item(this.bundle.getString(this.RB_KEY + "selectedColumns.txt"), "S"));
        return listModel;
    }

    private ListModel getOutputTypes() {
        DefaultListModel<Item> listModel = new DefaultListModel<Item>();
        Class<?> exportToXLSXClass = null;
        try {
            exportToXLSXClass = Class.forName("com.sas.export.office.commands.ExportToXLSXCommand", false, this.getClass().getClassLoader());
        }
        catch (Throwable t) {
            exportToXLSXClass = null;
        }
        if (exportToXLSXClass != null) {
            listModel.addElement(new Item(this.bundle.getString(this.RB_KEY + "ExcelXLSX.txt"), "XLSX"));
        }
        listModel.addElement(new Item(this.bundle.getString(this.RB_KEY + "ExcelHTML.txt"), "HTML"));
        listModel.addElement(new Item(this.bundle.getString(this.RB_KEY + "WordHTML.txt"), "WHTML"));
        return listModel;
    }

    private ListModel getSaveAsOutputTypes() {
        DefaultListModel<Item> listModel = new DefaultListModel<Item>();
        listModel.addElement(new Item(this.bundle.getString(this.RB_KEY + "ExcelTSV.txt"), "TSV"));
        listModel.addElement(new Item(this.bundle.getString(this.RB_KEY + "ExcelCSV.txt"), "CSV"));
        return listModel;
    }

    private ListModel getColumns() {
        DefaultListModel<JavaScriptNodeInterface> listModel = new DefaultListModel<JavaScriptNodeInterface>();
        Object adapter = this.getSelectorModel();
        if (adapter instanceof ExportColumnsInterface) {
            List columns = ((ExportColumnsInterface)adapter).getAvailableColumns();
            Iterator cols = columns.iterator();
            String[] quadruplet = null;
            while (cols.hasNext()) {
                quadruplet = (String[])cols.next();
                listModel.addElement(this.newJavaScriptNode(quadruplet[0], quadruplet[1], quadruplet[2], quadruplet[3]));
            }
        }
        return listModel;
    }

    private JavaScriptNodeInterface newJavaScriptNode(String text, String value, String enabledImageName, String disabledImageName) {
        JavaScriptNode node = new JavaScriptNode();
        node.setText(text);
        node.setValue(value);
        node.setImage(enabledImageName);
        node.getStyleMap().put("JAVASCRIPTNODE_TEXT", ESListStyle);
        node.setNoWrap(true);
        node.setDisabledImage(disabledImageName);
        return node;
    }

    private void initJsVars(PrintWriter out) {
        NumericInputValidator numericInputValidator;
        RequiredStringValidator requiredStringValidator;
        out.println(JavaScriptIncludeHandler.getStartScript());
        String name = this.parameterPrefix;
        name = Strings.escapeForJavaScript((String)name);
        out.println(new StringBuffer().append("apPrefix = '").append(name).append("';").toString());
        name = this.getFormObject().getName();
        name = Strings.escapeForJavaScript((String)name);
        out.println(new StringBuffer().append("formName = '").append(name).append("';").toString());
        out.println(new StringBuffer().append("cssURLParmName = '").append("cssURL").append("';").toString());
        out.println(new StringBuffer().append("cssMIMETypeParmName = '").append("cssMIMEType").append("';").toString());
        out.println(new StringBuffer().append("cssMediaListParmName = '").append("cssMediaList").append("';").toString());
        out.println(new StringBuffer().append("cssTitleParmName = '").append("cssTitle").append("';").toString());
        out.println(new StringBuffer().append("missingValue = '").append(".").append("';").toString());
        if (!this.isExportCSS()) {
            out.println(new StringBuffer().append("sas_exportSelector_exportCSS = false;").toString());
        }
        this.listBox = (ListBox)this.getComponent("EXPORTSELECTOR_LIST_BOX");
        if (this.listBox != null) {
            name = this.listBox.getName();
            name = Strings.escapeForJavaScript((String)name);
            out.println(new StringBuffer().append("exportToListBoxName = '").append(name).append("';").toString());
        }
        this.saveAsListBox = (ListBox)this.getComponent("EXPORTSELECTOR_SAVE_AS_LIST_BOX");
        if (this.saveAsListBox != null) {
            name = this.saveAsListBox.getName();
            name = Strings.escapeForJavaScript((String)name);
            out.println(new StringBuffer().append("saveAsListBoxName = '").append(name).append("';").toString());
        }
        this.exportToRadio = (Radio)this.getComponent("EXPORTSELECTOR_EXPORT_TO_RADIO");
        if (this.exportToRadio != null) {
            name = this.exportToRadio.getName();
            name = Strings.escapeForJavaScript((String)name);
            out.println(new StringBuffer().append("exportSaveRadioName = '").append(name).append("';").toString());
        }
        out.println(new StringBuffer().append("outputTypeFormFieldName = '").append(Strings.escapeForJavaScript((String)new StringBuffer().append(this.parameterPrefix).append(OUTPUT_TYPE_FORM_FIELD_NAME).toString())).append("';").toString());
        String formatCheckBoxName = "";
        this.formatCheck = (CheckBox)this.getComponent("EXPORTSELECTOR_FORMAT_CHECK");
        if (this.formatCheck != null) {
            formatCheckBoxName = this.formatCheck.getId();
        }
        out.println(new StringBuffer().append("formatCheckBoxName = '").append(formatCheckBoxName).append("';").toString());
        String repeatRowLabelsCheckBoxName = "";
        this.repeatRowLabelsCheckBox = (CheckBox)this.getComponent("EXPORTSELECTOR_REPEAT_ROW_LABELS_CHECK_BOX");
        if (this.repeatRowLabelsCheckBox != null) {
            repeatRowLabelsCheckBoxName = this.repeatRowLabelsCheckBox.getId();
        }
        name = Strings.escapeForJavaScript((String)repeatRowLabelsCheckBoxName);
        out.println(new StringBuffer().append("repeatRowLabelsCheckBoxName = '").append(name).append("';").toString());
        out.println(new StringBuffer().append("htmlOutputType = '").append("HTML").append("';").toString());
        out.println(new StringBuffer().append("wordHtmlOutputType = '").append("WHTML").append("';").toString());
        int minNrows = 1;
        int maxNrows = 500000;
        Object adapter = this.getSelectorModel();
        if (adapter instanceof ExportSelectorInterface) {
            minNrows = ((ExportSelectorInterface)adapter).getMinNrows();
            maxNrows = ((ExportSelectorInterface)adapter).getMaxNrows();
        }
        this.fromTextEntry = (TextEntry)this.getComponent("EXPORTSELECTOR_FROM_TEXT_ENTRY");
        if (this.fromTextEntry != null) {
            requiredStringValidator = new RequiredStringValidator();
            String isExportFromNonBlankFunction = requiredStringValidator.createValidationFunctionCall(this.fromTextEntry);
            name = Strings.escapeForJavaScript((String)isExportFromNonBlankFunction);
            out.println(new StringBuffer().append("isExportFromNonBlankFunction = '").append(name).append("';").toString());
            name = Strings.escapeForJavaScript((String)this.isExportFromNonBlankErrorMessage);
            out.println(new StringBuffer().append("isExportFromNonBlankErrorMessage = '").append(name).append("';").toString());
            numericInputValidator = new NumericInputValidator();
            String isExportFromNonNumericFunction = numericInputValidator.createValidationFunctionCall(this.fromTextEntry);
            name = Strings.escapeForJavaScript((String)isExportFromNonNumericFunction);
            out.println(new StringBuffer().append("isExportFromNonNumericFunction = '").append(name).append("';").toString());
            name = Strings.escapeForJavaScript((String)this.isExportFromNonNumericErrorMessage);
            out.println(new StringBuffer().append("isExportFromNonNumericErrorMessage = '").append(name).append("';").toString());
            MinimumValueValidator minimumValueValidator = new MinimumValueValidator(minNrows);
            String isExportFromMinValueValidFunction = minimumValueValidator.createValidationFunctionCall(this.fromTextEntry);
            name = Strings.escapeForJavaScript((String)isExportFromMinValueValidFunction);
            out.println(new StringBuffer().append("isExportFromMinValueValidFunction = '").append(name).append("';").toString());
            this.isExportFromMinValueValidErrorMessage = Message.format((ResourceBundle)this.bundle, (String)(this.RB_KEY + "fromValueBelowMinimum.fmt.txt"), (Object)new Integer(minNrows));
            name = Strings.escapeForJavaScript((String)this.isExportFromMinValueValidErrorMessage);
            out.println(new StringBuffer().append("isExportFromMinValueValidErrorMessage = '").append(name).append("';").toString());
            MaximumValueValidator maximumValueValidator = new MaximumValueValidator(maxNrows);
            String isExportFromMaxValueValidFunction = maximumValueValidator.createValidationFunctionCall(this.fromTextEntry);
            name = Strings.escapeForJavaScript((String)isExportFromMaxValueValidFunction);
            out.println(new StringBuffer().append("isExportFromMaxValueValidFunction = '").append(name).append("';").toString());
            this.isExportFromMaxValueValidErrorMessage = Message.format((ResourceBundle)this.bundle, (String)(this.RB_KEY + "fromValueAboveMaximum.fmt.txt"), (Object)new Integer(maxNrows));
            name = Strings.escapeForJavaScript((String)this.isExportFromMaxValueValidErrorMessage);
            out.println(new StringBuffer().append("isExportFromMaxValueValidErrorMessage = '").append(name).append("';").toString());
        }
        this.toTextEntry = (TextEntry)this.getComponent("EXPORTSELECTOR_TO_TEXT_ENTRY");
        if (this.toTextEntry != null) {
            requiredStringValidator = new RequiredStringValidator();
            String isExportToNonBlankFunction = requiredStringValidator.createValidationFunctionCall(this.toTextEntry);
            name = Strings.escapeForJavaScript((String)isExportToNonBlankFunction);
            out.println(new StringBuffer().append("isExportToNonBlankFunction = '").append(name).append("';").toString());
            name = Strings.escapeForJavaScript((String)this.isExportToNonBlankErrorMessage);
            out.println(new StringBuffer().append("isExportToNonBlankErrorMessage = '").append(name).append("';").toString());
            numericInputValidator = new NumericInputValidator();
            String isExportToNonNumericFunction = numericInputValidator.createValidationFunctionCall(this.toTextEntry);
            name = Strings.escapeForJavaScript((String)isExportToNonNumericFunction);
            out.println(new StringBuffer().append("isExportToNonNumericFunction = '").append(name).append("';").toString());
            name = Strings.escapeForJavaScript((String)this.isExportToNonNumericErrorMessage);
            out.println(new StringBuffer().append("isExportToNonNumericErrorMessage = '").append(name).append("';").toString());
            MaximumValueValidator maximumValueValidator = new MaximumValueValidator(maxNrows);
            String isExportToMaxValueValidFunction = maximumValueValidator.createValidationFunctionCall(this.toTextEntry);
            name = Strings.escapeForJavaScript((String)isExportToMaxValueValidFunction);
            out.println(new StringBuffer().append("isExportToMaxValueValidFunction = '").append(name).append("';").toString());
            this.isExportToMaxValueValidErrorMessage = Message.format((ResourceBundle)this.bundle, (String)(this.RB_KEY + "toValueAboveMaximum.fmt.txt"), (Object)new Integer(maxNrows));
            name = Strings.escapeForJavaScript((String)this.isExportToMaxValueValidErrorMessage);
            out.println(new StringBuffer().append("isExportToMaxValueValidErrorMessage = '").append(name).append("';").toString());
            name = Strings.escapeForJavaScript((String)this.isExportToMinValueValidErrorMessage);
            out.println(new StringBuffer().append("isExportToMinValueValidErrorMessage = '").append(name).append("';").toString());
        }
        String columnsCheckBoxListName = "";
        this.columnsCheckBoxList = (OrderedCheckBoxList)this.getComponent("EXPORTSELECTOR_COLUMNS_CHECK_BOX_LIST");
        if (this.columnsCheckBoxList != null) {
            name = Strings.escapeForJavaScript((String)this.columnsCheckBoxList.getId());
            out.println(new StringBuffer().append("var columnsCheckBoxListFormFieldName = '").append(name).append("';").toString());
            CheckBoxList comp = (CheckBoxList)this.columnsCheckBoxList.getComponent("ORDERED_LIST_COMPONENT");
            if (comp != null) {
                columnsCheckBoxListName = comp.getId();
            }
        }
        name = Strings.escapeForJavaScript((String)columnsCheckBoxListName);
        out.println(new StringBuffer().append("var columnsCheckBoxListName = '").append(name).append("';").toString());
        name = Strings.escapeForJavaScript((String)this.isNoColumnsChosenErrorMessage);
        out.println(new StringBuffer().append("isNoColumnsChosenErrorMessage = '").append(name).append("';").toString());
        String columnsRadioName = "";
        this.columnsRadio = (Radio)this.getComponent("EXPORTSELECTOR_COLUMNS_RADIO");
        if (this.columnsRadio != null) {
            columnsRadioName = this.columnsRadio.getName();
        }
        name = Strings.escapeForJavaScript((String)columnsRadioName);
        out.println(new StringBuffer().append("var columnsRadioName = '").append(name).append("';").toString());
        String selectedColumnsOptionValue = "";
        name = Strings.escapeForJavaScript((String)"S");
        out.println(new StringBuffer().append("var selectedColumnsOptionValue = '").append(name).append("';").toString());
        out.println(new StringBuffer().append("sas_exportSelector_respondIncludeColumnsChange();").toString());
        out.println(new StringBuffer().append("sas_exportSelector_respondExportSaveChange();").toString());
        out.println(JavaScriptIncludeHandler.getEndScript(null));
    }

    public void cancel() {
    }

    @Override
    public void setActionProvider(HttpActionProvider ap) {
        super.setActionProvider(ap);
        this.parameterPrefix = this.getActionProvider().getParameterPrefix();
    }

    @Override
    public void setSelectorModel(Object selectorModel) {
        super.setSelectorModel(selectorModel);
        this.isOLAP = selectorModel instanceof OLAPExportSelectorInterface;
    }

    @SASScope
    public boolean isExportCSS() {
        return this.exportCSS;
    }

    @SASScope
    public void setExportCSS(boolean exportCSS) {
        this.exportCSS = exportCSS;
    }
}

