/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.dataselectors;

import com.sas.actionprovider.HttpActionProvider;
import com.sas.actionprovider.Util;
import com.sas.codepolicy.SASScope;
import com.sas.commands.DynamicAttributeCommandInterface;
import com.sas.commands.dataselectors.DataSelectorCommandInterface;
import com.sas.commands.dataselectors.SelectorCommandFactory;
import com.sas.dataselectors.SelectorKeysInterface;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.dataselectors.BaseDataSelector;
import com.sas.servlet.tbeans.dataselectors.filters.html.AdvancedFilterSelector;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

@SASScope
public class HttpSelectorFactory
implements SelectorKeysInterface {
    static final String RB_KEY = "HttpSelectorFactory.";
    public static final String TYPE = "type";
    public static final String MODEL = "model";
    public static final String VIEWER = "viewer";
    public static final String ACTIONPROVIDER = "ap";
    public static final String VIEWER_ID = "viewerId";
    private static Map selectorNameMap;
    private static Map commandKeysMap;
    private static Map selectorIdsMap;

    public static BaseDataSelector newSelectorInstance(String selectorKey, Map attributeMap) {
        CommonLoggerInterface log = LoggerRepository2.getLogger((String)HttpSelectorFactory.class.getPackage().getName(), null);
        log.debug("SelectorFactory: getSelector(): beginning");
        BaseTransformation selector = null;
        String selectorClassName = (String)HttpSelectorFactory.getSelectorNameMap().get(selectorKey);
        if (selectorClassName != null) {
            block15: {
                String viewerId = null;
                if (attributeMap != null) {
                    viewerId = (String)attributeMap.get(VIEWER_ID);
                }
                try {
                    Class<?> selectorClass = Class.forName(selectorClassName);
                    Constructor<?> constructor = selectorClass.getConstructor(String.class);
                    String selectorId = viewerId == null ? (String)HttpSelectorFactory.getSelectorIdsMap().get(selectorKey) : viewerId + "_" + (String)HttpSelectorFactory.getSelectorIdsMap().get(selectorKey);
                    selector = (BaseDataSelector)constructor.newInstance(selectorId);
                }
                catch (InstantiationException ie) {
                    log.error(selectorKey + ": " + viewerId, (Throwable)ie);
                }
                catch (IllegalAccessException ie) {
                    log.error(selectorKey + ": " + viewerId, (Throwable)ie);
                }
                catch (Exception e) {
                    if (!(e instanceof InvocationTargetException)) break block15;
                    InvocationTargetException e2 = (InvocationTargetException)e;
                    Throwable t = e2.getTargetException();
                    log.debug("MSG = ", t.getMessage());
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            if (selector != null) {
                int selectorType = 4;
                if (attributeMap != null) {
                    Integer sType = (Integer)attributeMap.get(TYPE);
                    if (sType != null) {
                        selectorType = sType;
                    }
                    HttpActionProvider ap = (HttpActionProvider)((Object)attributeMap.get(ACTIONPROVIDER));
                    Object viewer = attributeMap.get(VIEWER);
                    if (ap != null && viewer != null) {
                        ((BaseDataSelector)selector).setActionProvider(ap);
                        DataSelectorCommandInterface selectorCommand = SelectorCommandFactory.newSelectorCommandInstance((String)HttpSelectorFactory.getSelectorCommandKeyMap().get(selectorKey));
                        if (selectorCommand instanceof DynamicAttributeCommandInterface) {
                            ((BaseDataSelector)selector).setCommandId(ap.storeCommand((DynamicAttributeCommandInterface)selectorCommand, viewer, attributeMap));
                        }
                    }
                    String chainedReferringURI = Util.getChainedReferringURI(viewer);
                    ((BaseDataSelector)selector).setReferringURI(chainedReferringURI);
                    HttpServletRequest request = (HttpServletRequest)attributeMap.get("request");
                    if (request != null) {
                        ((BaseDataSelector)selector).setRequest(request);
                        ((BaseDataSelector)selector).setReferringURI(request.getRequestURI());
                    } else if (viewer != null && viewer instanceof BaseTransformation && (request = ((BaseTransformation)viewer).getRequest()) != null) {
                        ((BaseDataSelector)selector).setRequest(request);
                    }
                }
                selector.setVisible(true);
                ((BaseDataSelector)selector).setSelectorType(selectorType);
                if (selector instanceof AdvancedFilterSelector && "RESTRICTED_FILTER_SELECTOR".equals(selectorKey)) {
                    ((AdvancedFilterSelector)selector).setRestrictOlap(true);
                }
            }
        }
        return selector;
    }

    protected static void initializeSelectorNameMap(Map namesMap) {
        namesMap.put("FIND_SELECTOR", "com.sas.servlet.tbeans.dataselectors.find.html.FindSelector");
        namesMap.put("DATAITEM_SELECTOR", "com.sas.servlet.tbeans.dataselectors.dataitems.html.DataItemSelector");
        namesMap.put("ADVANCED_FILTER_SELECTOR", "com.sas.servlet.tbeans.dataselectors.filters.html.AdvancedFilterSelector");
        namesMap.put("RESTRICTED_FILTER_SELECTOR", "com.sas.servlet.tbeans.dataselectors.filters.html.AdvancedFilterSelector");
        namesMap.put("SIMPLE_CALCULATED_ITEM_SELECTOR", "com.sas.servlet.tbeans.dataselectors.calculateditems.html.SimpleCalculatedItemSelector");
        namesMap.put("EXPORT_TO_SELECTOR", "com.sas.servlet.tbeans.dataselectors.export.html.ExportSelector");
        namesMap.put("RANKING_SELECTOR", "com.sas.servlet.tbeans.dataselectors.ranking.html.RankingSelector");
        namesMap.put("TOTALS_SELECTOR", "com.sas.servlet.tbeans.dataselectors.totals.html.TotalsSelector");
        namesMap.put("FORMAT_SELECTOR", "com.sas.servlet.tbeans.dataselectors.format.html.FormatSelector");
        namesMap.put("FILTER_AND_RANK_SELECTOR", "com.sas.servlet.tbeans.dataselectors.filterandrank.html.FilterAndRankSelector");
        namesMap.put("SORT_SELECTOR", "com.sas.servlet.tbeans.dataselectors.sort.html.SortSelector");
        namesMap.put("FILE_SELECTOR", "com.sas.servlet.tbeans.dataexplorer.selectors.FileSelector");
        namesMap.put("VISUAL_DATA_EXPLORER_CUSTOMIZER", "com.sas.servlet.tbeans.dataexplorer.html.VisualDataExplorerCustomizer");
        namesMap.put("MANAGE_VIEWS_SELECTOR", "com.sas.servlet.tbeans.dataexplorer.selectors.ManageViewsSelector");
        namesMap.put("DATA_EXPLORATION_PROPERTIES_SELECTOR", "com.sas.servlet.tbeans.dataexplorer.selectors.DataExplorationPropertiesSelector");
        namesMap.put("EXCEPTION_HIGHLIGHTING_SELECTOR", "com.sas.servlet.tbeans.dataselectors.exceptionhighlighting.html.ExceptionHighlightingSelector");
        namesMap.put("EXCEPTION_HIGHLIGHTING_CHART_SELECTOR", "com.sas.servlet.tbeans.dataselectors.exceptionhighlighting.html.ExceptionHighlightingChartSelector");
        namesMap.put("PERCENT_CALCULATIONS_SELECTOR", "com.sas.servlet.tbeans.dataselectors.calculations.percent.html.PercentCalculationsSelector");
        namesMap.put("MEMBER_PROPERTIES_SELECTOR", "com.sas.servlet.tbeans.dataselectors.memberproperties.html.MemberPropertiesSelector");
        namesMap.put("SAVE_VIEW_AS_SELECTOR", "com.sas.servlet.tbeans.dataexplorer.selectors.SaveViewAsSelector");
        namesMap.put("VIEW_QUERY_SELECTOR", "com.sas.servlet.tbeans.dataexplorer.selectors.ViewQuerySelector");
        namesMap.put("MAP_PROPERTIES_SELECTOR", "com.sas.servlet.tbeans.dataselectors.customizer.html.MapPropertySelector");
        namesMap.put("TABLE_CUSTOMIZER", "com.sas.servlet.tbeans.tableview.html.TableViewCompositeCustomizer");
        namesMap.put("OLAP_TABLE_CUSTOMIZER", "com.sas.servlet.tbeans.olaptableview.html.OLAPTableViewCompositeCustomizer");
        namesMap.put("COLOR_MAPPED_OLAP_TABLE_CUSTOMIZER", "com.sas.servlet.tbeans.olaptableview.html.GraphOLAPTableViewCompositeCustomizer");
        namesMap.put("GRAPH_PROPERTY_SELECTOR", "com.sas.graphics.servlet.tbeans.componentsui.html.ChartPropertySelector");
    }

    protected static void initializeCommandKeysMap(Map commandsMap) {
        commandsMap.put("FIND_SELECTOR", "FIND_SELECTOR_CMD");
        commandsMap.put("DATAITEM_SELECTOR", "DATAITEM_SELECTOR_CMD");
        commandsMap.put("ADVANCED_FILTER_SELECTOR", "ADVANCED_FILTER_SELECTOR_CMD");
        commandsMap.put("RESTRICTED_FILTER_SELECTOR", "ADVANCED_FILTER_SELECTOR_CMD");
        commandsMap.put("SIMPLE_CALCULATED_ITEM_SELECTOR", "SIMPLE_CALCULATED_ITEM_SELECTOR_CMD");
        commandsMap.put("EXPORT_TO_SELECTOR", "EXPORT_TO_SELECTOR_CMD");
        commandsMap.put("RANKING_SELECTOR", "RANKING_SELECTOR_CMD");
        commandsMap.put("TOTALS_SELECTOR", "TOTALS_SELECTOR_CMD");
        commandsMap.put("FORMAT_SELECTOR", "FORMAT_SELECTOR_CMD");
        commandsMap.put("FILTER_AND_RANK_SELECTOR", "FILTER_AND_RANK_SELECTOR_CMD");
        commandsMap.put("SORT_SELECTOR", "SORT_SELECTOR_CMD");
        commandsMap.put("FILE_SELECTOR", "FILE_SELECTOR_CMD");
        commandsMap.put("EXCEPTION_HIGHLIGHTING_SELECTOR", "EXCEPTION_HIGHLIGHTING_SELECTOR_CMD");
        commandsMap.put("EXCEPTION_HIGHLIGHTING_CHART_SELECTOR", "EXCEPTION_HIGHLIGHTING_CHART_SELECTOR_CMD");
        commandsMap.put("PERCENT_CALCULATIONS_SELECTOR", "PERCENT_CALCULATIONS_SELECTOR_CMD");
        commandsMap.put("MEMBER_PROPERTIES_SELECTOR", "MEMBER_PROPERTIES_SELECTOR_CMD");
        commandsMap.put("MAP_PROPERTIES_SELECTOR", "MAP_PROPERTIES_SELECTOR_CMD");
        commandsMap.put("GRAPH_PROPERTY_SELECTOR", "GRAPH_PROPERTY_SELECTOR_CMD");
        commandsMap.put("TABLE_CUSTOMIZER", "TABLE_CUSTOMIZER_SELECTOR_CMD");
        commandsMap.put("OLAP_TABLE_CUSTOMIZER", "OLAP_TABLE_CUSTOMIZER_SELECTOR_CMD");
        commandsMap.put("COLOR_MAPPED_OLAP_TABLE_CUSTOMIZER", "COLOR_MAPPED_OLAP_TABLE_CUSTOMIZER_SELECTOR_CMD");
        commandsMap.put("VISUAL_DATA_EXPLORER_CUSTOMIZER", "VISUAL_DATA_EXPLORER_CUSTOMIZER_SELECTOR_CMD");
        commandsMap.put("MANAGE_VIEWS_SELECTOR", "MANAGE_VIEWS_SELECTOR_CMD");
        commandsMap.put("DATA_EXPLORATION_PROPERTIES_SELECTOR", "DATA_EXPLORATION_PROPERTIES_SELECTOR_CMD");
        commandsMap.put("SAVE_VIEW_AS_SELECTOR", "SAVE_VIEW_AS_SELECTOR_CMD");
        commandsMap.put("VIEW_QUERY_SELECTOR", "VIEW_QUERY_SELECTOR_CMD");
    }

    protected static void initializeSelectorIdsMap(Map idsMap) {
        idsMap.put("FIND_SELECTOR", "fSel");
        idsMap.put("DATAITEM_SELECTOR", "qrSel");
        idsMap.put("ADVANCED_FILTER_SELECTOR", "afSel");
        idsMap.put("RESTRICTED_FILTER_SELECTOR", "afSel");
        idsMap.put("SIMPLE_CALCULATED_ITEM_SELECTOR", "sciSel");
        idsMap.put("EXPORT_TO_SELECTOR", "eSel");
        idsMap.put("RANKING_SELECTOR", "rSel");
        idsMap.put("TOTALS_SELECTOR", "tSel");
        idsMap.put("FORMAT_SELECTOR", "forSel");
        idsMap.put("FILTER_AND_RANK_SELECTOR", "frSel");
        idsMap.put("SORT_SELECTOR", "sSel");
        idsMap.put("FILE_SELECTOR", "fiSel");
        idsMap.put("PERCENT_CALCULATIONS_SELECTOR", "pcsSel");
        idsMap.put("MEMBER_PROPERTIES_SELECTOR", "mpSel");
        idsMap.put("EXCEPTION_HIGHLIGHTING_SELECTOR", "ehSel");
        idsMap.put("TABLE_CUSTOMIZER", "tvCstmzr");
        idsMap.put("OLAP_TABLE_CUSTOMIZER", "tvCstmzr");
        idsMap.put("COLOR_MAPPED_OLAP_TABLE_CUSTOMIZER", "tvCstmzr");
        idsMap.put("MAP_PROPERTIES_SELECTOR", "_mps");
        idsMap.put("GRAPH_PROPERTY_SELECTOR", "gpSel");
        idsMap.put("VISUAL_DATA_EXPLORER_CUSTOMIZER", "vcs");
        idsMap.put("MANAGE_VIEWS_SELECTOR", "mvs");
        idsMap.put("DATA_EXPLORATION_PROPERTIES_SELECTOR", "deps");
        idsMap.put("EXCEPTION_HIGHLIGHTING_CHART_SELECTOR", "ehcSel");
        idsMap.put("SAVE_VIEW_AS_SELECTOR", "svas");
        idsMap.put("VIEW_QUERY_SELECTOR", "vqs");
    }

    public static DataSelectorCommandInterface newSelectorCommandInstance(String selectorKey) {
        return SelectorCommandFactory.newSelectorCommandInstance(selectorKey);
    }

    private static Map getSelectorNameMap() {
        if (selectorNameMap == null) {
            selectorNameMap = new HashMap();
            HttpSelectorFactory.initializeSelectorNameMap(selectorNameMap);
        }
        return selectorNameMap;
    }

    private static Map getSelectorCommandKeyMap() {
        if (commandKeysMap == null) {
            commandKeysMap = new HashMap();
            HttpSelectorFactory.initializeCommandKeysMap(commandKeysMap);
        }
        return commandKeysMap;
    }

    private static Map getSelectorIdsMap() {
        if (selectorIdsMap == null) {
            selectorIdsMap = new HashMap();
            HttpSelectorFactory.initializeSelectorIdsMap(selectorIdsMap);
        }
        return selectorIdsMap;
    }
}

