/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans;

import com.sas.codepolicy.SASScope;
import java.util.StringTokenizer;

@SASScope(value="ALL")
public class StyleInfo {
    private String classid;
    private String style;

    public StyleInfo() {
    }

    public StyleInfo(String classid, String style) {
        this.classid = classid;
        this.style = style;
    }

    public StyleInfo(String classid) {
        this(classid, null);
    }

    @SASScope
    public StyleInfo(StyleInfo styleInfo) {
        this(styleInfo.getClassid(), styleInfo.getStyle());
    }

    public String getClassid() {
        return this.classid;
    }

    public void setClassid(String classid) {
        this.classid = classid;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public Object clone() {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException e) {
            return new StyleInfo(this.classid, this.style);
        }
        return clone;
    }

    @SASScope
    public StringBuffer write(StringBuffer sb, String styleClassPrefix) {
        String style;
        String classid = this.trim(this.getClassid());
        if (classid != null) {
            sb.append(" class=\"");
            if (styleClassPrefix == null) {
                styleClassPrefix = "";
            }
            String seperator = "";
            StringTokenizer tokenizer = new StringTokenizer(classid, " ");
            while (tokenizer.hasMoreTokens()) {
                sb.append(seperator).append(styleClassPrefix).append(tokenizer.nextToken());
                seperator = " ";
            }
            sb.append("\"");
        }
        if ((style = this.trim(this.getStyle())) != null) {
            sb.append(" style=\"").append(style).append("\"");
        }
        return sb;
    }

    private String trim(String str) {
        if (str != null) {
            str = str.trim();
        }
        if (str != null && str.length() == 0) {
            return null;
        }
        return str;
    }

    @SASScope
    public StyleInfo addStyle(String style) {
        if ((style = this.trim(style)) == null) {
            return this;
        }
        String sep = "";
        String newStyle = this.trim(this.style);
        if (newStyle == null) {
            newStyle = "";
        } else {
            sep = "; ";
            if (newStyle.endsWith(";")) {
                sep = " ";
            }
        }
        newStyle = newStyle + sep + style;
        this.setStyle(newStyle);
        return this;
    }

    public String toString() {
        return "CLASSID=" + this.classid + "\nStyle=" + this.style;
    }
}

