/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.models.AttributeGeneratorInterface;
import com.sas.servlet.tbeans.models.StaticLevelNodeInterface;
import com.sas.servlet.tbeans.models.StaticNodeCellStyleInterface;
import com.sas.servlet.tbeans.models.StaticNodeCellStyleKeyInterface;
import com.sas.servlet.tbeans.models.TreeNode;
import com.sas.servlet.tbeans.models.TreeNodeInterface;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.util.MapWithDefaults;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import javax.swing.tree.TreeModel;

@SASScope(value="ALL")
public class BaseTreeView
extends BaseTransformation {
    public static final int FULL = 1;
    public static final int PROGRESSIVE = 0;
    public static final int FULLYEXPANDED = 1;
    public static final int FULLYCOLLAPSED = 0;
    public static final int IMAGE = 3;
    public static final int NOIMAGE = 4;
    public static final int NO_SELECTION = 0;
    public static final int SINGLE_SELECTION = 1;
    public static final int SINGLE_REQUIRED_SELECTION = 2;
    public static final int MULTIPLE_SELECTION = 3;
    public static final int CHECKBOX_SELECTION = 4;
    public static final int CHECKBOX_LEAF_SELECTION = 5;
    public static final int TRISTATE_SELECTION = 6;
    public static final int COMPLEX_INDICATOR_SELECTION = 7;
    public static final int RADIO_SELECTION = 8;
    public static final int RADIO_LEAF_SELECTION = 9;
    private int lineStyle;
    protected String imageLocation;
    private String target;
    private int expansionLevel;
    private int initialExpansionLevel;
    private boolean nodeSelectionVisible;
    private boolean usePlusMinus;
    private boolean usePlusMinusLines;
    private String selectedNode;
    private TreeNode selectedNodeObject;
    private boolean usingURLLinks;
    private boolean imageVisible;
    private String nodeStyleClass;
    private int load_state;
    private boolean rootNodeVisible = true;
    private String styleClassPrefix;
    @SASScope
    protected HashMap styleList;
    private TreeModel model;
    private boolean autoChildrenVerify;
    private boolean multipleSelections;
    private boolean selectionRequired;
    private boolean checkboxSelectionMode;
    private boolean radioboxSelectionMode;
    private boolean onlyLeavesSelectable = false;
    private int selectionMode;
    private boolean indicatorImage;
    private boolean isFolderExpandCollapseEnabled = true;
    private String preSelectFunctionName;
    private String postSelectFunctionName;
    private String preOnContextMenuFunctionName;
    private String postOnContextMenuFunctionName;
    private String selectFunctionName;
    private String deselectFunctionName;
    private String nodeRendererFunctionName;
    private String preExpandFunctionName;
    private String postExpandFunctionName;
    protected static final HashMap defaultImageMap = new HashMap();
    private Map componentImageMap;
    private ListModel selectedNodes;
    private AttributeGeneratorInterface _attributeGenerator;
    public static final String OPEN_FOLDER = "OPEN_FOLDER";
    public static final String CLOSED_FOLDER = "CLOSED_FOLDER";
    public static final String DISABLED_FOLDER = "DISABLED_FOLDER";
    public static final String LEAF_ICON = "LEAF_ICON";
    public static final String INDICATOR_ALL_CHILDREN = "INDICATOR_ALL_CHILDREN";
    public static final String INDICATOR_SOME_CHILDREN = "INDICATOR_SOME_CHILDREN";
    public static final String INDICATOR_NO_CHILDREN = "INDICATOR_NO_CHILDREN";
    public static final String INDICATOR_SELF_ALL_CHILDREN = "INDICATOR_SELF_ALL_CHILDREN";
    public static final String INDICATOR_SELF_SOME_CHILDREN = "INDICATOR_SELF_SOME_CHILDREN";
    public static final String INDICATOR_SELF_NO_CHILDREN = "INDICATOR_SELF_NO_CHILDREN";
    public static final String VERTICAL_LINE = "VERTICAL_LINE";
    public static final String MISSING_ROOT_MINUS_NODE = "MISSING_ROOT_MINUS_NODE";
    public static final String MISSING_ROOT_PLUS_NODE = "MISSING_ROOT_PLUS_NODE";
    public static final String MINUS_ONLY_NODE = "MINUS_ONLY_NODE";
    public static final String PLUS_ONLY_NODE = "PLUS_ONLY_NODE";
    public static final String FIRST_NODE = "FIRST_NODE";
    public static final String MINUS_LAST_NODE = "MINUS_LAST_NODE";
    public static final String PLUS_LAST_NODE = "PLUS_LAST_NODE";
    public static final String MINUS_NODE = "MINUS_NODE";
    public static final String PLUS_NODE = "PLUS_NODE";
    public static final String NODE = "NODE";
    public static final String LAST_NODE = "LAST_NODE";

    public BaseTreeView() {
        BaseTreeView.setupDefaultImageMap();
        this.componentImageMap = new MapWithDefaults((Map)defaultImageMap);
        this.initialExpansionLevel = -111960;
        this.setObjectDataProperty("selectedNode");
    }

    public boolean isFolderExpandCollapseEnabled() {
        return this.isFolderExpandCollapseEnabled;
    }

    public void setFolderExpandCollapseEnabled(boolean folderExpandCollapseEnabled) {
        this.isFolderExpandCollapseEnabled = folderExpandCollapseEnabled;
    }

    public boolean isNodeSelectionVisible() {
        return this.nodeSelectionVisible;
    }

    public boolean isImageVisible() {
        return this.imageVisible;
    }

    public void setImageVisible(boolean imageVisible) {
        this.imageVisible = imageVisible;
    }

    public String getImageLocation() {
        if (this.imageLocation != null) {
            return this.imageLocation;
        }
        return ComponentPropertyManager.getInstance(this.getRequest()).getImageLocation();
    }

    public void setImageLocation(String iLocation) {
        if (iLocation != null && iLocation.lastIndexOf(47) == -1) {
            StringBuffer sb = new StringBuffer(iLocation);
            sb.append('/');
            this.imageLocation = sb.toString();
        } else {
            this.imageLocation = iLocation;
        }
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setExpansionLevel(int expansionLevel) {
        this.expansionLevel = expansionLevel;
    }

    public int getExpansionLevel() {
        return this.expansionLevel;
    }

    public void setInitialExpansionLevel(int expansionLevel) {
        this.initialExpansionLevel = expansionLevel;
    }

    public int getInitialExpansionLevel() {
        return this.initialExpansionLevel;
    }

    public void setNodeLoading(int load_state) {
        this.load_state = load_state;
    }

    public int getNodeLoading() {
        return this.load_state;
    }

    public void setUsePlusMinus(boolean usePlusMinus) {
        this.usePlusMinus = usePlusMinus;
    }

    public boolean isUsePlusMinus() {
        return this.usePlusMinus;
    }

    @SASScope
    public void setUsePlusMinusLines(boolean usePlusMinusLines) {
        this.usePlusMinusLines = usePlusMinusLines;
    }

    @SASScope
    public boolean isUsePlusMinusLines() {
        return this.usePlusMinusLines;
    }

    public void setSelectedNode(String selectedNode) {
        if (selectedNode == null) {
            this.setSelectedNodes(null);
        } else {
            DefaultListModel<String> lm = new DefaultListModel<String>();
            lm.addElement(selectedNode);
            this.setSelectedNodes(lm);
        }
    }

    @SASScope
    public void setSelectedNode(TreeNode selectedNode) {
        if (selectedNode == null) {
            this.setSelectedNodes(null);
        } else {
            DefaultListModel<TreeNode> lm = new DefaultListModel<TreeNode>();
            lm.addElement(selectedNode);
            this.setSelectedNodes(lm);
        }
    }

    public void setSelectedNodes(ListModel selectedNodes) {
        this.selectedNodes = selectedNodes;
    }

    public String getSelectedNode() {
        String selNodeValue = "";
        if (this.selectedNodes != null && this.selectedNodes.getSize() > 0) {
            Object node = this.selectedNodes.getElementAt(this.selectedNodes.getSize() - 1);
            selNodeValue = node instanceof TreeNodeInterface ? ((TreeNodeInterface)node).getName() : node.toString();
        }
        return selNodeValue;
    }

    public ListModel getSelectedNodes() {
        return this.selectedNodes;
    }

    public void setUsingURLLinks(boolean useURLLinks) {
        this.usingURLLinks = useURLLinks;
    }

    public boolean isUsingURLLinks() {
        return this.usingURLLinks;
    }

    public void setRootNodeVisible(boolean rootNodeVisible) {
        this.rootNodeVisible = rootNodeVisible;
    }

    public boolean isRootNodeVisible() {
        return this.rootNodeVisible;
    }

    public void setStyleClassPrefix(String styleClassPrefix) {
        this.styleClassPrefix = styleClassPrefix;
    }

    public String getStyleClassPrefix() {
        return this.styleClassPrefix;
    }

    @SASScope
    public void setDefaultNodeStyleClass(String nodeStyleClass) {
        this.nodeStyleClass = nodeStyleClass;
    }

    @SASScope
    public String getDefaultNodeStyleClass() {
        if (this.nodeStyleClass == null) {
            this.nodeStyleClass = "treecellstyle";
        }
        return this.nodeStyleClass;
    }

    @SASScope
    public void setLevelCellStyle(int level, String style) {
        if (this.styleList == null) {
            this.styleList = new HashMap();
        }
        Integer lvl = new Integer(level);
        this.styleList.put(lvl, style);
    }

    public String getLevelCellStyle(int level) {
        Integer lvl = new Integer(level);
        if (this.styleList.get(lvl) != null) {
            return this.styleList.get(lvl).toString();
        }
        return null;
    }

    @SASScope
    public void setCellStyleAssociationByKey(String key, String style) {
        if (this.styleList == null) {
            this.styleList = new HashMap();
        }
        this.styleList.put(key, style);
    }

    @SASScope
    public String getCellStyleAssociationByKey(String key) {
        if (this.styleList == null) {
            this.styleList = new HashMap();
        }
        if (this.styleList.get(key) != null) {
            return this.styleList.get(key).toString();
        }
        return null;
    }

    @SASScope
    public String getNodeCellStyle(Object node) {
        if (node instanceof StaticNodeCellStyleInterface && ((StaticNodeCellStyleInterface)node).getNodeCellStyleClass() != null) {
            return ((StaticNodeCellStyleInterface)node).getNodeCellStyleClass();
        }
        if (node instanceof StaticNodeCellStyleKeyInterface && ((StaticNodeCellStyleKeyInterface)node).getNodeCellStyleKey() != null && this.getCellStyleAssociationByKey(((StaticNodeCellStyleKeyInterface)node).getNodeCellStyleKey()) != null) {
            String key = ((StaticNodeCellStyleKeyInterface)node).getNodeCellStyleKey();
            return this.getCellStyleAssociationByKey(key);
        }
        if (node instanceof StaticLevelNodeInterface && this.getLevelCellStyle(((StaticLevelNodeInterface)node).getLevel()) != null) {
            return this.getLevelCellStyle(((StaticLevelNodeInterface)node).getLevel());
        }
        return this.getDefaultNodeStyleClass();
    }

    public TreeModel getModel() {
        return this.model;
    }

    public void setModel(TreeModel model) {
        this.model = model;
    }

    public void setLineStyle(int lstyle) {
        this.lineStyle = lstyle;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void setAutoChildrenVerify(boolean autochildren) {
        this.autoChildrenVerify = autochildren;
    }

    public boolean isAutoChildrenVerify() {
        return this.autoChildrenVerify;
    }

    public boolean getMultipleSelections() {
        return this.multipleSelections;
    }

    public boolean isSelectionRequired() {
        return this.selectionRequired;
    }

    public boolean isCheckboxSelectionMode() {
        return this.checkboxSelectionMode;
    }

    @SASScope
    public boolean isRadioboxSelectionMode() {
        return this.radioboxSelectionMode;
    }

    public boolean isOnlyLeavesSelectable() {
        return this.onlyLeavesSelectable;
    }

    boolean isIndicatorImage() {
        return this.indicatorImage;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
        this.selectionRequired = false;
        this.nodeSelectionVisible = true;
        if (selectionMode == 0) {
            this.nodeSelectionVisible = false;
        } else if (selectionMode == 1) {
            this.multipleSelections = false;
            this.checkboxSelectionMode = false;
            this.radioboxSelectionMode = false;
            this.onlyLeavesSelectable = false;
            this.indicatorImage = false;
        } else if (selectionMode == 2) {
            this.multipleSelections = false;
            this.checkboxSelectionMode = false;
            this.radioboxSelectionMode = false;
            this.onlyLeavesSelectable = false;
            this.indicatorImage = false;
            this.selectionRequired = true;
        } else if (selectionMode == 3) {
            this.multipleSelections = true;
            this.checkboxSelectionMode = false;
            this.radioboxSelectionMode = false;
            this.onlyLeavesSelectable = false;
            this.indicatorImage = false;
        } else if (selectionMode == 4) {
            this.multipleSelections = true;
            this.checkboxSelectionMode = true;
            this.radioboxSelectionMode = false;
            this.onlyLeavesSelectable = false;
            this.indicatorImage = false;
        } else if (selectionMode == 5) {
            this.multipleSelections = true;
            this.checkboxSelectionMode = true;
            this.radioboxSelectionMode = false;
            this.onlyLeavesSelectable = true;
            this.indicatorImage = false;
        } else if (selectionMode == 8) {
            this.multipleSelections = false;
            this.radioboxSelectionMode = true;
            this.checkboxSelectionMode = false;
            this.onlyLeavesSelectable = false;
            this.indicatorImage = false;
        } else if (selectionMode == 9) {
            this.multipleSelections = false;
            this.radioboxSelectionMode = true;
            this.checkboxSelectionMode = false;
            this.onlyLeavesSelectable = true;
            this.indicatorImage = false;
        } else if (selectionMode == 6) {
            this.multipleSelections = true;
            this.checkboxSelectionMode = true;
            this.radioboxSelectionMode = false;
            this.onlyLeavesSelectable = true;
            this.indicatorImage = true;
        } else if (selectionMode == 7) {
            this.multipleSelections = true;
            this.checkboxSelectionMode = true;
            this.radioboxSelectionMode = false;
            this.onlyLeavesSelectable = false;
            this.indicatorImage = true;
        }
    }

    public Map getImageMap() {
        return this.componentImageMap;
    }

    private static void setupDefaultImageMap() {
        if (defaultImageMap.size() == 0) {
            ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(null);
            defaultImageMap.put(OPEN_FOLDER, cpm.getImageName("Folder_Open"));
            defaultImageMap.put(CLOSED_FOLDER, cpm.getImageName("Folder_Closed"));
            defaultImageMap.put(DISABLED_FOLDER, cpm.getImageName("Folder_Disabled"));
            defaultImageMap.put(LEAF_ICON, cpm.getImageName("Tree_View_Leaf_Node"));
            defaultImageMap.put(INDICATOR_ALL_CHILDREN, cpm.getImageName("Tree_View_Children"));
            defaultImageMap.put(INDICATOR_NO_CHILDREN, cpm.getImageName("Tree_View_Empty"));
            defaultImageMap.put(INDICATOR_SOME_CHILDREN, cpm.getImageName("Tree_View_Some_Children"));
            defaultImageMap.put(INDICATOR_SELF_ALL_CHILDREN, cpm.getImageName("Tree_View_Node_Children"));
            defaultImageMap.put(INDICATOR_SELF_NO_CHILDREN, cpm.getImageName("Tree_View_Node"));
            defaultImageMap.put(INDICATOR_SELF_SOME_CHILDREN, cpm.getImageName("Tree_View_Some_Children"));
            defaultImageMap.put(VERTICAL_LINE, cpm.getImageName("Vert_Line"));
            defaultImageMap.put(MISSING_ROOT_MINUS_NODE, cpm.getImageName("Missing_Root_Minus_Node"));
            defaultImageMap.put(MISSING_ROOT_PLUS_NODE, cpm.getImageName("Missing_Root_Plus_Node"));
            defaultImageMap.put(MINUS_ONLY_NODE, cpm.getImageName("Only_Node_Minus"));
            defaultImageMap.put(PLUS_ONLY_NODE, cpm.getImageName("Only_Node_Plus"));
            defaultImageMap.put(FIRST_NODE, cpm.getImageName("First_Node"));
            defaultImageMap.put(MINUS_LAST_NODE, cpm.getImageName("Minus_Last_Node"));
            defaultImageMap.put(PLUS_LAST_NODE, cpm.getImageName("Plus_Last_Node"));
            defaultImageMap.put(MINUS_NODE, cpm.getImageName("Minus_Node"));
            defaultImageMap.put(PLUS_NODE, cpm.getImageName("Plus_Node"));
            defaultImageMap.put(NODE, cpm.getImageName("Node"));
            defaultImageMap.put(LAST_NODE, cpm.getImageName("Last_Node"));
        }
    }

    public String getSelectNodeFunctionName() {
        return this.selectFunctionName;
    }

    public void setSelectNodeFunctionName(String selectFunctionName) {
        this.selectFunctionName = selectFunctionName;
    }

    public String getDeselectNodeFunctionName() {
        return this.deselectFunctionName;
    }

    public void setDeselectNodeFunctionName(String deselectFunctionName) {
        this.deselectFunctionName = deselectFunctionName;
    }

    public String getNodeRendererFunctionName() {
        return this.nodeRendererFunctionName;
    }

    public void setNodeRendererFunctionName(String string) {
        this.nodeRendererFunctionName = string;
    }

    public String getPreSelectNodeFunctionName() {
        return this.preSelectFunctionName;
    }

    public void setPreSelectNodeFunctionName(String preSelectFunctionName) {
        this.preSelectFunctionName = preSelectFunctionName;
    }

    public String getPostSelectNodeFunctionName() {
        return this.postSelectFunctionName;
    }

    public void setPostSelectNodeFunctionName(String postSelectFunctionName) {
        this.postSelectFunctionName = postSelectFunctionName;
    }

    @SASScope
    public String getPreOnContextMenuFunctionName() {
        return this.preOnContextMenuFunctionName;
    }

    @SASScope
    public void setPreOnContextMenuFunctionName(String preOnContextMenuFunctionName) {
        this.preOnContextMenuFunctionName = preOnContextMenuFunctionName;
    }

    @SASScope
    public String getPostOnContextMenuFunctionName() {
        return this.postOnContextMenuFunctionName;
    }

    @SASScope
    public void setPostOnContextMenuFunctionName(String postOnContextMenuFunctionName) {
        this.postOnContextMenuFunctionName = postOnContextMenuFunctionName;
    }

    public String getPreExpandNodeFunctionName() {
        return this.preExpandFunctionName;
    }

    public void setPreExpandNodeFunctionName(String preExpandFunctionName) {
        this.preExpandFunctionName = preExpandFunctionName;
    }

    public String getPostExpandNodeFunctionName() {
        return this.postExpandFunctionName;
    }

    public void setPostExpandNodeFunctionName(String postExpandFunctionName) {
        this.postExpandFunctionName = postExpandFunctionName;
    }

    @SASScope
    public AttributeGeneratorInterface getAttributeGenerator() {
        return this._attributeGenerator;
    }

    @SASScope
    public void setAttributeGenerator(AttributeGeneratorInterface generator) {
        this._attributeGenerator = generator;
    }
}

