/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans;

import com.sas.beans.PropertyChangeSource;
import com.sas.beans.Util;
import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseCompositeTransformation;
import com.sas.servlet.tbeans.RB;
import com.sas.servlet.tbeans.RenderableInterface;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.util.ComponentSessionManager;
import com.sas.util.WriteToPrintWriterInterface;
import com.sas.util.transforms.BaseTransforms;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;

@SASScope(value="ALL")
public abstract class BaseTransformation
implements TransformationInterface,
RenderableInterface,
PropertyChangeSource,
WriteToPrintWriterInterface {
    @SASScope
    public static final String RB_KEY = "BaseTransformation.";
    private Method setMethod;
    private Method getMethod;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String customAttributes;
    private String id;
    private String description;
    private String tagProlog;
    private String tagEpilog;
    private String style;
    private String styleClass;
    private Locale locale;
    private Locale requestLocale;
    private BaseCompositeTransformation parentComposite;
    private boolean visible = true;
    private boolean cleanUpResources;
    private Class[] pType = null;
    private String objectDataProperty = null;
    private TransformInterface inputTransform = null;
    private TransformInterface outputTransform = null;
    private PropertyChangeSupport propertyChangeSupport = null;
    private StringBuffer writeBuffer = null;
    private Object[] arguments;
    @SASScope
    protected boolean designTime;
    static final long serialVersionUID = 3378934008687120304L;

    public BaseTransformation() {
        this.setDesignTime(Util.isDesignTime());
        this.cleanUpResources = true;
    }

    @SASScope
    protected void setDesignTime(boolean newValue) {
        this.designTime = newValue;
    }

    @SASScope
    protected boolean isDesignTime() {
        return this.designTime;
    }

    @Override
    public void setId(String value) {
        if (this.id == null && value != null || this.id != null && !this.id.equals(value)) {
            this.firePropertyChange("id", this.id, value);
        }
        this.id = value;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setName(String value) {
        if (this.id == null && value != null || this.id != null && !this.id.equals(value)) {
            this.firePropertyChange("name", this.id, value);
        }
        this.setId(value);
    }

    @Override
    public String getName() {
        return this.getId();
    }

    @Override
    public void setDescription(String value) {
        this.description = value;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void write(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.setRequest(req);
        this.setResponse(resp);
        PrintWriter out = resp.getWriter();
        this.write(out);
    }

    @Override
    public void write(Writer out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.write(o);
        o.flush();
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        String styleClass;
        String style;
        String custom = this.getCustomAttributes();
        if (custom != null && custom.length() > 0) {
            this.getWriteBuffer().append(" ").append(custom);
        }
        if ((style = this.getStyle()) != null && style.length() > 0) {
            this.getWriteBuffer().append(" style=\"").append(style).append("\"");
        }
        if ((styleClass = this.getStyleClass()) != null && styleClass.length() > 0) {
            this.getWriteBuffer().append(" class=\"").append(styleClass).append("\"");
        }
        if (this.getWriteBuffer().length() > 0) {
            out.print(this.getWriteBuffer().toString());
        }
        this.writeBuffer = null;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.write(o);
        o.flush();
    }

    @Override
    public void setRequest(HttpServletRequest request) {
        this.request = request;
        if (request != null) {
            this.setRequestLocale(request.getLocale());
        }
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    @Override
    public HttpServletResponse getResponse() {
        return this.response;
    }

    public String toString() {
        if (this.isDesignTime()) {
            return super.toString();
        }
        StringWriter out = new StringWriter();
        try {
            this.write(out);
        }
        catch (Exception ex) {
            out.write("ERROR: " + ex.getMessage() + "\n");
            RuntimeException rte = new RuntimeException(ex.getMessage());
            rte.setStackTrace(ex.getStackTrace());
            throw rte;
        }
        return out.toString();
    }

    @Override
    public void setCustomAttributes(String value) {
        this.customAttributes = value;
    }

    @Override
    public String getCustomAttributes() {
        return this.customAttributes;
    }

    @Override
    public String getTagProlog() {
        return this.tagProlog;
    }

    @Override
    public void setTagProlog(String prolog) {
        this.tagProlog = prolog;
    }

    @Override
    public String getTagEpilog() {
        return this.tagEpilog;
    }

    @Override
    public void setTagEpilog(String epilog) {
        this.tagEpilog = epilog;
    }

    @Override
    public void setLocale(Locale loc) {
        if (loc != null && !loc.equals(this.locale) || this.locale != null && !this.locale.equals(loc)) {
            if (loc == null) {
                if (!Locale.getDefault().equals(this.locale)) {
                    this.setLocaleDependentProperties(Locale.getDefault());
                }
            } else {
                this.setLocaleDependentProperties(loc);
            }
            this.locale = loc;
        }
    }

    @Override
    public Locale getLocale() {
        if (this.locale == null) {
            return this.getRequestLocale() == null ? Locale.getDefault() : this.getRequestLocale();
        }
        return this.locale;
    }

    protected void setLocaleDependentProperties(Locale loc) {
    }

    @SASScope
    protected void setRequestLocale(Locale requestLoc) {
        if (this.locale == null) {
            if (requestLoc == null) {
                if (!Locale.getDefault().equals(this.requestLocale)) {
                    this.setLocaleDependentProperties(Locale.getDefault());
                }
            } else if (!requestLoc.equals(this.requestLocale)) {
                this.setLocaleDependentProperties(requestLoc);
            }
        }
        this.requestLocale = requestLoc;
    }

    @SASScope
    protected Locale getRequestLocale() {
        return this.requestLocale;
    }

    @SASScope
    public void setStyle(String style) {
        this.style = style;
    }

    @SASScope
    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    @SASScope
    public String getStyle() {
        return this.style;
    }

    @SASScope
    public String getStyleClass() {
        return this.styleClass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setObjectData(Object value) {
        Class[] paramType = this._getPType();
        if (paramType == null || paramType.length != 1) return;
        if (this.inputTransform == null) {
            if (paramType[0].getName() == "boolean" && value instanceof Boolean || paramType[0].isInstance(value)) {
                this.arguments = this.getArgumentArray(value);
            } else if (value != null) {
                BaseTransforms inputTForm = BaseTransforms.defaultInstance;
                if (!inputTForm.isTransformable(value.getClass(), paramType[0])) throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "notTransformable.txt", this.getLocale()));
                TransformInterface transformer = inputTForm.lookupTransform(value.getClass(), paramType[0]);
                try {
                    Object newValue = transformer.transform(value);
                    this.arguments = this.getArgumentArray(newValue);
                }
                catch (TransformException e) {
                    throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "objectFailed.txt", this.getLocale()));
                }
            } else {
                this.arguments = this.getArgumentArray(value);
            }
        } else if (this.inputTransform != null) {
            try {
                Object newValue = this.inputTransform.transform(value);
                this.arguments = this.getArgumentArray(newValue);
            }
            catch (TransformException e) {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "objectFailed.txt", this.getLocale()));
            }
        }
        try {
            Object o = null;
            o = this._getWriteMethod().invoke((Object)this, this.arguments);
            return;
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "methodInaccessible.txt", this.getLocale()));
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "methodFailed.txt", this.getLocale()));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "paramDiffer.txt", this.getLocale()));
        }
    }

    public Object getObjectData() {
        if (this.objectDataProperty != null) {
            Object dataObj = null;
            try {
                dataObj = this._getReadMethod().invoke((Object)this, (Object[])null);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "methodInaccessible.txt", this.getLocale()));
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "methodFailed.txt", this.getLocale()));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "paramDiffer.txt", this.getLocale()));
            }
            if (this.outputTransform != null) {
                try {
                    Object newValue;
                    dataObj = newValue = this.outputTransform.transform(dataObj);
                }
                catch (TransformException e) {
                    throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "objectFailed.txt", this.getLocale()));
                }
            }
            return dataObj;
        }
        return this.objectDataProperty;
    }

    @Override
    public void setObjectDataProperty(String property) {
        if (property == null || !property.equals(this.objectDataProperty)) {
            this.setMethod = null;
            this.getMethod = null;
            this.pType = null;
        }
        this.objectDataProperty = property;
    }

    @Override
    public String getObjectDataProperty() {
        return this.objectDataProperty;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Method _getWriteMethod() {
        if (this.setMethod != null || this.objectDataProperty == null) return this.setMethod;
        PropertyDescriptor pd = Util.getPropertyDescriptor(this.getClass(), (String)this.objectDataProperty);
        if (pd == null) throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "noMethod.txt", this.getLocale()));
        this.setMethod = pd.getWriteMethod();
        if (this.setMethod == null) throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "noMethod.txt", this.getLocale()));
        this.pType = this.setMethod.getParameterTypes();
        return this.setMethod;
    }

    private Method _getReadMethod() {
        if (this.getMethod == null && this.objectDataProperty != null) {
            PropertyDescriptor pd = Util.getPropertyDescriptor(this.getClass(), (String)this.objectDataProperty);
            if (pd != null) {
                this.getMethod = pd.getReadMethod();
                if (this.getMethod == null) {
                    throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "noMethod.txt", this.getLocale()));
                }
            } else {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "noMethod.txt", this.getLocale()));
            }
        }
        return this.getMethod;
    }

    private Class[] _getPType() {
        if (this.pType == null && this.objectDataProperty != null) {
            PropertyDescriptor pd = Util.getPropertyDescriptor(this.getClass(), (String)this.objectDataProperty);
            if (pd != null) {
                this.setMethod = pd.getWriteMethod();
                if (this.setMethod == null) {
                    throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "noMethod.txt", this.getLocale()));
                }
                this.pType = this.setMethod.getParameterTypes();
            } else {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "noMethod.txt", this.getLocale()));
            }
        }
        return this.pType;
    }

    @Override
    public void setInputTransform(TransformInterface transform) {
        this.inputTransform = transform;
    }

    @Override
    public TransformInterface getInputTransform() {
        return this.inputTransform;
    }

    @Override
    public void setOutputTransform(TransformInterface transform) {
        this.outputTransform = transform;
    }

    @Override
    public TransformInterface getOutputTransform() {
        return this.outputTransform;
    }

    @Override
    public void setVisible(boolean b) {
        this.visible = b;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public void setCleanUpResourcesOn(boolean b) {
        this.cleanUpResources = b;
    }

    public boolean isCleanUpResourcesOn() {
        return this.cleanUpResources;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport != null) {
            this.getPropertyChangeSupport().removePropertyChangeListener(listener);
        }
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.hasListeners(propertyName)) {
            this.getPropertyChangeSupport().removePropertyChangeListener(propertyName, listener);
        }
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.getPropertyChangeSupport().firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.getPropertyChangeSupport().firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.getPropertyChangeSupport().firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(PropertyChangeEvent evt) {
        if (this.propertyChangeSupport != null) {
            this.getPropertyChangeSupport().firePropertyChange(evt);
        }
    }

    public boolean hasListeners(String propertyName) {
        if (this.propertyChangeSupport == null) {
            return false;
        }
        return this.getPropertyChangeSupport().hasListeners(propertyName);
    }

    private PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        return this.propertyChangeSupport;
    }

    public void cleanUpResources() {
        if (this.isCleanUpResourcesOn()) {
            this.setRequest(null);
            this.setResponse(null);
        }
    }

    private StringBuffer getWriteBuffer() {
        if (this.writeBuffer == null) {
            this.writeBuffer = new StringBuffer();
        }
        return this.writeBuffer;
    }

    private Object[] getArgumentArray(Object value) {
        if (this.arguments == null) {
            this.arguments = new Object[1];
        }
        this.arguments[0] = value;
        return this.arguments;
    }

    @SASScope
    public BaseCompositeTransformation getParentComposite() {
        return this.parentComposite;
    }

    @SASScope
    public void setParentComposite(BaseCompositeTransformation parentComposite) {
        this.parentComposite = parentComposite;
    }

    @SASScope
    public void cleanup(HttpServletRequest request) {
        this.cleanup(request.getSession());
    }

    @SASScope
    public void cleanup(HttpSession session) {
        Map sessionManager = ComponentSessionManager.getSessionManager(session);
        if (this.getId() == null || sessionManager == null) {
            return;
        }
        if (sessionManager.get(this.getId()) != null) {
            sessionManager.remove(this.getId());
        }
    }
}

