/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.commands.jdbc.export;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.export.HTMLExportCSSInfoInterface;
import com.sas.iquery.dataretrieval.OfflineResultSetConfiguration;
import com.sas.iquery.dataretrieval.QueryConnector;
import com.sas.iquery.dataretrieval.QueryConnectorInterface;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemExtendedType;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.StyleInterface;
import com.sas.servlet.tbeans.olaptableview.BaseOLAPTableView;
import com.sas.servlet.tbeans.tableview.AbstractBaseTableView;
import com.sas.servlet.tbeans.tableview.BaseTableView;
import com.sas.servlet.tbeans.tableview.TableColumn;
import com.sas.servlet.tbeans.tableview.TableColumnModel;
import com.sas.servlet.tbeans.tableview.html.BaseTableCell;
import com.sas.storage.iquery.BusinessQueryToTableModelAdapter;
import com.sas.storage.jdbc.RawSASNumericValueProvider;
import com.sas.storage.jdbc.export.ExcelDirectives;
import com.sas.storage.jdbc.export.SAStoExcelUtil;
import com.sas.storage.jdbc.export.ToNotParseFormats;
import com.sas.table.FormattedInterface;
import com.sas.text.SASFormat;
import com.sas.util.Strings;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.table.TableModel;

@SASScope(value="ALL")
public class Util {
    public static String CHARSET_FOR_NON_HTML_EXPORT_TO_EXCEL = com.sas.commands.export.Util.CHARSET_FOR_NON_HTML_EXPORT_TO_EXCEL;
    public static int REVERSED_BOM_FOR_NON_HTML_EXPORT_TO_EXCEL = 65279;
    public static String CHARSET_FOR_HTML_EXPORT_TO_EXCEL = "UTF8";

    public static String getHTMLHeader(HTMLExportCSSInfoInterface[] css, String styles) {
        return Util.getHTMLHeader(css, styles, null);
    }

    @SASScope
    public static String getHTMLHeader(HTMLExportCSSInfoInterface[] css, String styles, String[] nameSpaces) {
        StringBuffer buffer = new StringBuffer(50);
        buffer.append("\n<html");
        if (nameSpaces != null) {
            for (int i = 0; i < nameSpaces.length; ++i) {
                buffer.append(" ").append(nameSpaces[i].trim());
            }
        }
        buffer.append(">");
        buffer.append("\n<head>");
        buffer.append("\n<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">");
        if (css != null) {
            String token = null;
            for (int i = 0; i < css.length; ++i) {
                buffer.append("\n<link rel=\"stylesheet\" ");
                token = css[i].getCSSMIMEType();
                if (!token.equalsIgnoreCase(".")) {
                    buffer.append("type=\"").append(token).append("\" ");
                }
                if (!(token = css[i].getCSSURL()).equalsIgnoreCase(".")) {
                    buffer.append("href=\"").append(token).append("\" ");
                }
                if (!(token = css[i].getCSSMediaList()).equalsIgnoreCase(".")) {
                    buffer.append("media=\"").append(token).append("\" ");
                }
                if (!(token = css[i].getCSSTitle()).equalsIgnoreCase(".")) {
                    buffer.append("title=\"").append(token).append("\" ");
                }
                buffer.append("/>");
            }
        }
        if (styles != null) {
            buffer.append(styles);
        }
        buffer.append("\n</head>");
        buffer.append("\n<body>");
        return buffer.toString();
    }

    public static String getHTMLFooter() {
        StringBuffer buffer = new StringBuffer("\n</body>");
        buffer.append("\n</html>");
        return buffer.toString();
    }

    public static String getHTMLNewLineSpan(String string) {
        StringBuffer buffer = new StringBuffer("\n<br><span>");
        if (string != null) {
            buffer.append("\n").append(string);
        }
        buffer.append("\n</span>");
        return buffer.toString();
    }

    public static String getExportFileName(String fileExtension) {
        return com.sas.commands.export.Util.getExportFileName((String)fileExtension);
    }

    @SASScope
    public static Locale getDataLocale(AbstractBaseTableView tableview) {
        BusinessModel bm;
        BusinessQuery bq;
        Locale locale = tableview.getLocale();
        Object dataModel = null;
        if (tableview instanceof BaseOLAPTableView) {
            dataModel = ((BaseOLAPTableView)tableview).getModel();
        } else if (tableview instanceof BaseTableView) {
            dataModel = ((BaseTableView)tableview).getModel();
        }
        if (dataModel instanceof BusinessQueryProviderInterface && (bq = ((BusinessQueryProviderInterface)dataModel).getBusinessQuery()) != null && (bm = bq.getBusinessModel()) != null) {
            locale = bm.getDataLocale();
        }
        return locale;
    }

    public static void addExcelXMLDirective(BaseTableCell renderer, Object rawValue, String sasFormatName, Locale locale, String formattedValue, boolean treatNumericCustomFormattedValuesAsText) {
        if (rawValue != null) {
            String customAttributes = renderer.getCustomAttributes();
            int dataType = SAStoExcelUtil.getDataType((Locale)locale, rawValue.getClass(), (String)sasFormatName);
            if (dataType == -1) {
                renderer.setCustomAttributes(customAttributes != null ? customAttributes + SAStoExcelUtil.EXCEL_XML_TEXT_DIRECTIVE : SAStoExcelUtil.EXCEL_XML_TEXT_DIRECTIVE);
            } else {
                String formatDirective;
                ExcelDirectives excelDirectives = null;
                if (formattedValue != null && !SAStoExcelUtil.isFormatSupported((String)sasFormatName, (int)dataType)) {
                    if (treatNumericCustomFormattedValuesAsText) {
                        excelDirectives = new ExcelDirectives();
                        excelDirectives.getXmlDirectives().add(SAStoExcelUtil.EXCEL_XML_TEXT_DIRECTIVE.trim());
                    } else {
                        String excelFormat = null;
                        excelFormat = SAStoExcelUtil.getFormattedValueAsExcelFormat((String)formattedValue);
                        excelDirectives = SAStoExcelUtil.getExcelXMLNumericFormattingDirective((Object)rawValue, (String)sasFormatName, (int)dataType, (Locale)locale, (String)excelFormat);
                    }
                } else {
                    excelDirectives = SAStoExcelUtil.getExcelXMLNumericFormattingDirective((Object)rawValue, (String)sasFormatName, (int)dataType, (Locale)locale);
                }
                List xmlDirectives = excelDirectives.getXmlDirectives();
                if (!xmlDirectives.isEmpty()) {
                    StringBuffer attrs = customAttributes != null ? new StringBuffer(customAttributes) : new StringBuffer(38);
                    Iterator i = xmlDirectives.iterator();
                    while (i.hasNext()) {
                        attrs.append((String)i.next());
                    }
                    renderer.setCustomAttributes(attrs.toString());
                }
                if (!"".equals(formatDirective = excelDirectives.getFormatDirective())) {
                    Util.addFormatDirective(renderer, formatDirective);
                }
            }
        } else {
            renderer.setCustomAttributes(SAStoExcelUtil.EXCEL_XML_TEXT_DIRECTIVE);
        }
    }

    @SASScope
    public static void addExcelXMLDirective(BaseTableCell renderer, Object rawValue, String sasFormatName, Locale locale) {
        Util.addExcelXMLDirective(renderer, rawValue, sasFormatName, locale, null, false);
    }

    @SASScope
    public static void addFormatDirective(BaseTableCell renderer, String formatDirective) {
        if (renderer instanceof StyleInterface && formatDirective != null && !"".equals(formatDirective)) {
            BaseTableCell styleSource = renderer;
            StyleInfo currentStyleInfo = styleSource.getStyleInfo();
            StyleInfo newStyle = new StyleInfo(currentStyleInfo);
            newStyle.addStyle(formatDirective);
            styleSource.setStyleInfo(newStyle);
        }
    }

    public static void addExcelXMLDirective(BaseTableCell renderer, TableModel tm, int rowNumber, int colModelIndex, Locale locale, String customAttributes, String formattedValue, boolean treatNumericCustomFormattedValuesAsText) {
        if (renderer != null) {
            String formatDirective;
            block21: {
                formatDirective = null;
                if (tm instanceof FormattedInterface) {
                    if (rowNumber >= 0 && colModelIndex >= 0) {
                        try {
                            String excelFormat;
                            Class unformattedClass = ((FormattedInterface)tm).getUnformattedColumnClass(colModelIndex - 1);
                            String format = ((FormattedInterface)tm).getFormat(colModelIndex - 1);
                            int dataType = SAStoExcelUtil.getDataType((Locale)locale, (Class)unformattedClass, (String)format);
                            Object rawValue = null;
                            rawValue = dataType != -1 && tm instanceof RawSASNumericValueProvider ? (dataType == 3 ? ((FormattedInterface)tm).getUnformattedValueAt(rowNumber - 1, colModelIndex - 1) : ((RawSASNumericValueProvider)tm).getRawSASNumericValue(rowNumber - 1, colModelIndex - 1)) : ((FormattedInterface)tm).getUnformattedValueAt(rowNumber - 1, colModelIndex - 1);
                            if (rawValue instanceof String && dataType == -1 && (SAStoExcelUtil.isSASDateFormat((String)format, (Locale)locale) || SAStoExcelUtil.isSASDateTimeFormat((String)format, (Locale)locale) || SAStoExcelUtil.isSASTimeFormat((String)format, (Locale)locale)) && ToNotParseFormats.isFormatToParse((String)format, (Locale)locale)) {
                                SASFormat sasFormat = SASFormat.getInstance((String)format, (Locale)locale);
                                Object newRawValue = null;
                                if (sasFormat != null) {
                                    try {
                                        newRawValue = sasFormat.parseObject(((String)rawValue).trim());
                                        if (newRawValue != null && !(newRawValue instanceof String)) {
                                            dataType = SAStoExcelUtil.getDataType((Locale)locale, newRawValue.getClass(), (String)format);
                                            rawValue = newRawValue;
                                        }
                                    }
                                    catch (ParseException parseException) {
                                        // empty catch block
                                    }
                                }
                            }
                            String string = excelFormat = ((FormattedInterface)tm).isFormattedDataUsed() ? null : SAStoExcelUtil.getDefaultExcelFormat((int)dataType);
                            if (dataType == -1) {
                                renderer.setCustomAttributes(customAttributes != null ? customAttributes + SAStoExcelUtil.EXCEL_XML_TEXT_DIRECTIVE : SAStoExcelUtil.EXCEL_XML_TEXT_DIRECTIVE);
                                break block21;
                            }
                            ExcelDirectives excelDirectives = null;
                            if (formattedValue != null && !SAStoExcelUtil.isFormatSupported((String)format, (int)dataType)) {
                                if (treatNumericCustomFormattedValuesAsText) {
                                    excelDirectives = new ExcelDirectives();
                                    excelDirectives.getXmlDirectives().add(SAStoExcelUtil.EXCEL_XML_TEXT_DIRECTIVE.trim());
                                } else {
                                    excelFormat = SAStoExcelUtil.getFormattedValueAsExcelFormat((String)formattedValue);
                                    excelDirectives = SAStoExcelUtil.getExcelXMLNumericFormattingDirective((Object)rawValue, (String)format, (int)dataType, (Locale)locale, (String)excelFormat);
                                }
                            } else {
                                excelDirectives = SAStoExcelUtil.getExcelXMLNumericFormattingDirective((Object)rawValue, (String)format, (int)dataType, (Locale)locale, (String)excelFormat);
                            }
                            List xmlDirectives = excelDirectives.getXmlDirectives();
                            if (!xmlDirectives.isEmpty()) {
                                StringBuffer attrs = new StringBuffer(38);
                                if (customAttributes != null) {
                                    attrs.append(customAttributes);
                                }
                                Iterator i = xmlDirectives.iterator();
                                while (i.hasNext()) {
                                    attrs.append((String)i.next());
                                }
                                renderer.setCustomAttributes(attrs.toString());
                            }
                            formatDirective = excelDirectives.getFormatDirective();
                        }
                        catch (Exception e) {
                            formatDirective = SAStoExcelUtil.getMicrosoftOfficeNumberFormatXMLDirective((String)SAStoExcelUtil.EXCEL_TEXT_FORMAT);
                        }
                    } else {
                        renderer.setCustomAttributes(customAttributes != null ? customAttributes + SAStoExcelUtil.EXCEL_XML_TEXT_DIRECTIVE : SAStoExcelUtil.EXCEL_XML_TEXT_DIRECTIVE);
                    }
                } else {
                    formatDirective = SAStoExcelUtil.getMicrosoftOfficeNumberFormatXMLDirective((String)SAStoExcelUtil.EXCEL_TEXT_FORMAT);
                }
            }
            if (formatDirective != null) {
                Util.addFormatDirective(renderer, formatDirective);
            }
        }
    }

    @SASScope
    public static void addExcelXMLDirective(BaseTableCell renderer, TableModel tm, int rowNumber, int colModelIndex, Locale locale, String customAttributes) {
        Util.addExcelXMLDirective(renderer, tm, rowNumber, colModelIndex, locale, customAttributes, null, false);
    }

    public static BusinessQueryToTableModelAdapter createModelWithDisabledOfflineResultSets(BusinessQuery businessQuery, QueryConnectorInterface queryConnector, Boolean dualResultSets) {
        BusinessQueryToTableModelAdapter model = null;
        if (businessQuery != null) {
            OfflineResultSetConfiguration offlineResultSetConfiguration = new OfflineResultSetConfiguration();
            offlineResultSetConfiguration.setOfflineResultSetsEnabled(false);
            RetrievalPolicy retrievalPolicy = new RetrievalPolicy();
            retrievalPolicy.setOfflineResultSetConfiguration(offlineResultSetConfiguration);
            if (queryConnector == null) {
                queryConnector = new QueryConnector();
            }
            boolean useDualResultSets = !Boolean.FALSE.equals(dualResultSets);
            model = new BusinessQueryToTableModelAdapter(businessQuery, queryConnector, retrievalPolicy, useDualResultSets);
            boolean returnUnformattedData = businessQuery.getQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA);
            model.setFormattedDataReturned(!returnUnformattedData);
        }
        return model;
    }

    public static boolean isNumericMissingValue(BaseTableView table, String value) {
        TableModel tm;
        boolean isMissing = false;
        if (table != null && SAStoExcelUtil.isNumericMissingValue((String)value) && (tm = table.getModel()) instanceof FormattedInterface) {
            TableColumn column;
            TableColumnModel cModel = table.getColumnModel();
            int colModelIndex = Integer.MIN_VALUE;
            if (cModel != null && (column = cModel.getColumn(table.getCurrentColumn() - 1)) != null) {
                colModelIndex = column.getModelIndex() + 1;
            }
            isMissing = -1 != SAStoExcelUtil.getDataType((Locale)table.getLocale(), (Class)((FormattedInterface)tm).getUnformattedColumnClass(colModelIndex - 1), (String)((FormattedInterface)tm).getFormat(colModelIndex - 1));
        }
        return isMissing;
    }

    public static String[] getColumnsToExportAsTextIfCustomFormatted(String[] columnUniqueModelIdentifiers, DataItem[] dataItems) {
        String[] columnsToExportAsTextIfCustomFormatted = null;
        if (columnUniqueModelIdentifiers != null && dataItems != null) {
            List<String> candidateIntraModelIDs = Util.getIntraModelIdsCandidateToBeExportedAsText(dataItems);
            Vector<String> candidateColumns = new Vector<String>();
            for (String cumi : columnUniqueModelIdentifiers) {
                if (!candidateIntraModelIDs.contains(cumi)) continue;
                candidateColumns.add(cumi);
            }
            if (candidateColumns.size() != 0) {
                columnsToExportAsTextIfCustomFormatted = candidateColumns.toArray(new String[0]);
            }
        }
        return columnsToExportAsTextIfCustomFormatted;
    }

    private static List<String> getIntraModelIdsCandidateToBeExportedAsText(DataItem[] dataItems) {
        Vector<String> candidateIntraModelIDs = new Vector<String>();
        for (DataItem dataItem : dataItems) {
            int expressionType;
            if (dataItem == null || !StructureOfDataItem.STRUCTURE_COLUMN.equals(dataItem.getStructure()) || DataItemActionType.USAGE_AGGREGATE.equals(dataItem.getUsage()) || (expressionType = dataItem.getExpressionTypeIgnoringFormattingForced()) == 4 || expressionType == 5 || expressionType == 6) continue;
            candidateIntraModelIDs.add(dataItem.getIntraModelID());
        }
        return candidateIntraModelIDs;
    }

    public static String[] getColumnUniqueModelIdentifiers(Enumeration<TableColumn> columns) {
        String[] columnUniqueModelIdentifiers = null;
        if (columns != null) {
            TableColumn column = null;
            Vector<String> v = new Vector<String>();
            Object columnUniqueModelIdentifier = null;
            while (columns.hasMoreElements()) {
                column = columns.nextElement();
                if (column == null || (columnUniqueModelIdentifier = column.getUniqueModelIdentifier()) == null) continue;
                v.add(columnUniqueModelIdentifier.toString());
            }
            if (v.size() != 0) {
                columnUniqueModelIdentifiers = v.toArray(new String[0]);
            }
        }
        return columnUniqueModelIdentifiers;
    }

    public static DataItem[] getDataItemsInTableModel(TableModel tm) {
        DataItem[] dataItems = new DataItem[]{};
        if (tm instanceof BusinessQueryProviderInterface) {
            BusinessQueryProviderInterface bqProvider = (BusinessQueryProviderInterface)tm;
            BusinessQuery query = bqProvider.getBusinessQuery();
            dataItems = Util.getDataItemsInBusinessQuery(query);
        }
        return dataItems;
    }

    public static DataItem[] getDataItemsInBusinessQuery(BusinessQuery query) {
        Vector<DataItem> dataItems = new Vector<DataItem>();
        if (query != null) {
            List items = query.getSelectedItems();
            SelectedItem selectedItem2 = null;
            DataItem dataItem = null;
            for (SelectedItem selectedItem2 : items) {
                dataItem = selectedItem2.getItem();
                if (dataItem == null) continue;
                dataItems.add(dataItem);
            }
        }
        return dataItems.toArray(new DataItem[0]);
    }

    public static String encodeForExcel(String text) {
        String encodedText = text;
        if (text != null) {
            char[] special = new char[]{'&', '\"', '<', '>'};
            String[] replacements = new String[]{"&amp;", "&quot;", "&lt;", "&gt;"};
            encodedText = Strings.replace((String)text, (char[])special, (String[])replacements);
        }
        return encodedText;
    }

    public static String[] getColumnsToNotEncode(DataItem[] dataItems, String[] columnUniqueModelIdentifiers) {
        String[] columnsToNotEncode = null;
        if (dataItems != null && dataItems.length > 0 && columnUniqueModelIdentifiers != null) {
            if (columnUniqueModelIdentifiers != null) {
                ArrayList<String> candidateIntraModelIDs = new ArrayList<String>();
                for (DataItem dataItem : dataItems) {
                    if (dataItem == null || dataItem.getExtendedType() != DataItemExtendedType.HTML) continue;
                    candidateIntraModelIDs.add(dataItem.getIntraModelID());
                }
                ArrayList<String> candidateColumns = new ArrayList<String>();
                for (String cumi : columnUniqueModelIdentifiers) {
                    if (!candidateIntraModelIDs.contains(cumi)) continue;
                    candidateColumns.add(cumi);
                }
                if (candidateColumns.size() != 0) {
                    columnsToNotEncode = candidateColumns.toArray(new String[0]);
                }
            }
        } else {
            CommonLoggerInterface log = LoggerRepository2.getLogger((String)BaseTableView.class.getPackage().getName(), null);
            if (log != null && log.isWarnEnabled()) {
                log.warn("Received an invalid parameter");
            }
        }
        return columnsToNotEncode;
    }
}

