/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.commands.jdbc.export;

import com.sas.codepolicy.SASScope;
import com.sas.commands.dataselectors.ExportSelectorCommand;
import com.sas.dataselectors.export.HTMLExportCSSInfoInterface;
import com.sas.iquery.dataretrieval.QueryConnectorInterface;
import com.sas.servlet.commands.jdbc.export.BaseRelationalExportCommand;
import com.sas.servlet.commands.jdbc.export.RB;
import com.sas.servlet.commands.jdbc.export.Util;
import com.sas.servlet.tbeans.dataselectors.html.ActionProviderMenuBar;
import com.sas.servlet.tbeans.tableview.DefaultTableColumnModel;
import com.sas.servlet.tbeans.tableview.TableColumn;
import com.sas.servlet.tbeans.tableview.TableColumnModel;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.servlet.util.BaseUtil;
import com.sas.storage.iquery.BusinessQueryAdapter;
import com.sas.storage.iquery.BusinessQueryToTableModelAdapter;
import com.sas.table.FormattedInterface;
import com.sas.util.UncheckedException;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Locale;
import javax.swing.table.TableModel;

@SASScope(value="ALL")
public class ExportToHTMLCommand
extends BaseRelationalExportCommand {
    private boolean isViewerSettingsToBeRestored = false;
    private boolean isViewerAllActionsVisible;
    private int viewerStartRow;
    private int viewerEndRow;
    private int viewerRowPageSize;
    private int viewerStartColumn;
    private int viewerEndColumn;
    private int viewerColumnPageSize;
    private HttpServletRequest viewerRequest;
    private HttpServletResponse viewerResponse;
    private Locale viewerLocale;
    private boolean isFormattedDataUsed;
    @SASScope
    protected boolean isFlushEnabled;
    private TableColumnModel columnModel;
    private boolean isOfflineResultSetsEnabled;
    protected CommonLoggerInterface log = LoggerRepository2.getLogger((String)ExportSelectorCommand.class.getPackage().getName(), null);

    @Override
    public void execute(Object o, int startRow, int nRows, boolean isRawData) {
        this.execute(o, startRow, nRows, isRawData, null, null, null);
    }

    private TableView getViewer(TableModel model) {
        Object htmlTable = this.getAttribute("viewComponent");
        if (htmlTable == null) {
            htmlTable = new TableView(model);
        } else if (!(htmlTable instanceof TableView)) {
            if (htmlTable instanceof ActionProviderMenuBar) {
                if ((htmlTable = ((ActionProviderMenuBar)htmlTable).getViewer()) instanceof TableView) {
                    this.backupViewerSettings((TableView)htmlTable);
                } else {
                    htmlTable = new TableView(model);
                }
            } else {
                htmlTable = new TableView(model);
            }
        } else {
            this.backupViewerSettings((TableView)htmlTable);
        }
        ((TableView)htmlTable).setRequest((HttpServletRequest)this.getAttribute("request"));
        ((TableView)htmlTable).setResponse(this.response);
        ((TableView)htmlTable).setLocale((Locale)this.getAttribute("locale"));
        return (TableView)htmlTable;
    }

    private Writer getWriter(Object o, HttpServletResponse response) {
        Writer writer = null;
        writer = o instanceof Writer ? (Writer)o : (o instanceof ServletResponse ? BaseUtil.createOutputStreamWriter((ServletResponse)o) : BaseUtil.createOutputStreamWriter((ServletResponse)response));
        return writer;
    }

    private void backupViewerSettings(TableView htmlTable) {
        this.isViewerAllActionsVisible = htmlTable.isAllActionsVisible();
        this.viewerRowPageSize = htmlTable.getRowPageSize();
        this.viewerColumnPageSize = htmlTable.getColumnPageSize();
        this.viewerStartRow = htmlTable.getStartRow();
        this.viewerEndRow = htmlTable.getEndRow();
        this.viewerStartColumn = htmlTable.getStartColumn();
        this.viewerEndColumn = htmlTable.getEndColumn();
        this.isFlushEnabled = htmlTable.isFlushEnabled();
        this.viewerRequest = htmlTable.getRequest();
        this.viewerResponse = htmlTable.getResponse();
        this.viewerLocale = htmlTable.getLocale();
        Object model = this.getAttribute("model");
        if (model instanceof FormattedInterface) {
            this.isFormattedDataUsed = ((FormattedInterface)model).isFormattedDataUsed();
        }
        this.isViewerSettingsToBeRestored = true;
    }

    private void restoreViewerSettings(TableView htmlTable) {
        htmlTable.setExportToExcel(false);
        htmlTable.setColumnModel(this.columnModel);
        htmlTable.setAllActionsVisible(this.isViewerAllActionsVisible);
        htmlTable.setRowPageSize(this.viewerRowPageSize);
        htmlTable.setColumnPageSize(this.viewerColumnPageSize);
        htmlTable.setStartRow(this.viewerStartRow);
        htmlTable.setEndRow(this.viewerEndRow);
        htmlTable.setStartColumn(this.viewerStartColumn);
        htmlTable.setEndColumn(this.viewerEndColumn);
        htmlTable.setFlushEnabled(this.isFlushEnabled);
        htmlTable.setRequest(this.viewerRequest);
        htmlTable.setResponse(this.viewerResponse);
        htmlTable.setLocale(this.viewerLocale);
        Object model = this.getAttribute("model");
        if (model instanceof FormattedInterface) {
            ((FormattedInterface)model).setFormattedDataUsed(this.isFormattedDataUsed);
        }
        this.isViewerSettingsToBeRestored = false;
    }

    private void configureViewerForExport(TableView htmlTable, int startRow, int nRows, boolean isRawData, int[] columns) {
        TableModel model = htmlTable.getModel();
        htmlTable.setExportToExcel(true);
        if (model instanceof BusinessQueryAdapter) {
            this.isOfflineResultSetsEnabled = ((BusinessQueryAdapter)model).isOfflineResultSetsEnabled();
            if (this.isOfflineResultSetsEnabled) {
                BusinessQueryToTableModelAdapter tempModel = Util.createModelWithDisabledOfflineResultSets(((BusinessQueryAdapter)model).getBusinessQuery(), (QueryConnectorInterface)this.getAttribute("HTMLExport_QueryConnector"), (Boolean)this.getAttribute("Use_ds"));
                htmlTable.setModel((TableModel)tempModel);
                htmlTable.setColumnModel(this.columnModel);
            }
        }
        htmlTable.setAllActionsVisible(false);
        this.configureColumnModel(htmlTable, columns);
        htmlTable.setColumnPageSize(-1);
        htmlTable.setStartColumn(0);
        htmlTable.setEndColumn(htmlTable.getColumnCount() - 1);
        htmlTable.setRowPageSize(nRows);
        htmlTable.setStartRow(startRow);
        if (nRows == -1) {
            nRows = 999999999;
        }
        htmlTable.setEndRow(startRow + nRows - 1);
        htmlTable.setFlushEnabled(false);
        FormattedInterface fi = null;
        if (model instanceof FormattedInterface) {
            fi = (FormattedInterface)model;
            if (isRawData) {
                fi.setFormattedDataUsed(false);
            } else {
                fi.setFormattedDataUsed(true);
            }
        }
    }

    private void configureColumnModel(TableView htmlTable, int[] columns) {
        if (columns == null || columns.length == 0) {
            this.configureColumnModel(htmlTable);
        } else {
            TableColumnModel newTableColumnModel = this.newTableColumnModel(htmlTable, columns);
            if (newTableColumnModel != null) {
                htmlTable.setColumnModel(newTableColumnModel);
            }
        }
    }

    private TableColumnModel newTableColumnModel(TableView htmlTable, int[] columns) {
        TableColumnModel cModel = null;
        TableColumnModel newColumnModel = this.newTableColumnModel(htmlTable);
        if (newColumnModel != null) {
            if (columns != null && columns.length > 0) {
                cModel = new DefaultTableColumnModel();
                TableColumn column = null;
                TableColumn originalColumn = null;
                TableColumnModel originalColumnModel = this.columnModel != null ? this.columnModel : htmlTable.getColumnModel();
                for (int i = 0; i < columns.length; ++i) {
                    originalColumn = this.getColumn(originalColumnModel, columns[i]);
                    column = newColumnModel.getColumn(columns[i]);
                    if (originalColumn == null || column == null) continue;
                    this.copyColumnAttributes(originalColumn, column);
                    cModel.addColumn(column);
                }
            } else {
                cModel = newColumnModel;
            }
            if (cModel == null) {
                cModel = newColumnModel;
            }
        }
        return cModel;
    }

    private TableColumnModel newTableColumnModel(TableView htmlTable) {
        TableColumnModel tableColumnModel = null;
        if (htmlTable != null) {
            htmlTable.setColumnModel(new DefaultTableColumnModel());
            htmlTable.createDefaultColumnsFromModel();
            tableColumnModel = htmlTable.getColumnModel();
        }
        return tableColumnModel;
    }

    private void copyColumnAttributes(TableColumn fromColumn, TableColumn toColumn) {
        if (fromColumn != null && toColumn != null) {
            toColumn.setCellRenderer(fromColumn.getCellRenderer());
            toColumn.setHeaderRenderer(fromColumn.getHeaderRenderer());
            toColumn.setHeaderValue(fromColumn.getHeaderValue());
            toColumn.setIdentifier(fromColumn.getIdentifier());
            toColumn.setSize(fromColumn.getSize());
        }
    }

    private TableColumn getColumn(TableColumnModel columnModel, int columnIndex) {
        TableColumn column = null;
        if (columnModel != null && columnIndex >= 0) {
            TableColumn currentColumn = null;
            Enumeration columns = columnModel.getColumns();
            if (columns != null) {
                while (columns.hasMoreElements()) {
                    currentColumn = (TableColumn)columns.nextElement();
                    if (currentColumn == null || currentColumn.getModelIndex() != columnIndex) continue;
                    column = currentColumn;
                    break;
                }
            }
        }
        return column;
    }

    private void configureColumnModel(TableView htmlTable) {
        TableColumnModel newColumnModel = this.newTableColumnModel(htmlTable);
        if (newColumnModel != null && this.columnModel != null) {
            Enumeration originalColumns = this.columnModel.getColumns();
            boolean error = false;
            if (originalColumns != null) {
                TableColumn column = null;
                TableColumn originalColumn = null;
                while (originalColumns.hasMoreElements()) {
                    originalColumn = (TableColumn)originalColumns.nextElement();
                    if (originalColumn == null) {
                        error = true;
                        break;
                    }
                    int columnIndex = originalColumn.getModelIndex();
                    if (columnIndex < 0) continue;
                    column = newColumnModel.getColumn(columnIndex);
                    if (column == null) {
                        error = true;
                        break;
                    }
                    this.copyColumnAttributes(originalColumn, column);
                }
            } else {
                error = true;
            }
            if (error) {
                htmlTable.setColumnModel(new DefaultTableColumnModel());
                htmlTable.createDefaultColumnsFromModel();
            }
        }
    }

    @Override
    public void execute(Object o, int startRow, int nRows, boolean isRawData, int[] columns, String[] headers, String[] footers) {
        Object model = this.getAttribute("model");
        if (!(model instanceof TableModel)) {
            throw new IllegalStateException(RB.getStringResource("BaseRelationalExportCommand.", "invalidModel.txt", this.getLocale()));
        }
        this.response = (HttpServletResponse)this.getAttribute("response");
        String charset = (String)this.getAttribute("charset");
        String contentType = (String)this.getAttribute("content_type");
        String contentDisposition = (String)this.getAttribute("content_disposition");
        if (charset == null) {
            charset = this.response.getCharacterEncoding();
        }
        if (contentType == null) {
            contentType = com.sas.commands.export.Util.DEFAULT_EXCEL_HTML_CONTENT_TYPE;
        }
        if (contentDisposition == null) {
            contentDisposition = com.sas.commands.export.Util.getDefaultContentDisposition((String)"HTML");
        }
        this.response.setContentType(new StringBuffer(contentType).append("; charset=").append(charset).toString());
        this.response.setHeader("Content-disposition", contentDisposition);
        TableView htmlTable = this.getViewer((TableModel)model);
        this.columnModel = htmlTable.getColumnModel();
        this.configureViewerForExport(htmlTable, startRow, nRows, isRawData, columns);
        Writer writer = this.getWriter(o, this.response);
        this.writeHTML(writer, htmlTable, (TableModel)model, o instanceof Writer, headers, footers);
        if (this.isOfflineResultSetsEnabled) {
            htmlTable.setModel((TableModel)model);
            htmlTable.setColumnModel(this.columnModel);
        }
        if (this.isViewerSettingsToBeRestored) {
            this.restoreViewerSettings(htmlTable);
        }
    }

    private void writeHTML(Writer writer, TableView htmlTable, TableModel model, boolean isWriterToBeClosed, String[] headers, String[] footers) {
        HTMLExportCSSInfoInterface[] css = (HTMLExportCSSInfoInterface[])this.getAttribute("cssInfo");
        String styles = (String)this.getAttribute("styleDefinitions");
        try {
            String[] nameSpaces = new String[]{"xmlns:x=\"urn:schemas-microsoft-com:office:excel\""};
            writer.write(Util.getHTMLHeader(css, styles, nameSpaces));
        }
        catch (Exception e) {
            if (this.isOfflineResultSetsEnabled) {
                htmlTable.setModel(model);
                htmlTable.setColumnModel(this.columnModel);
            }
            htmlTable.setExportToExcel(false);
            throw new UncheckedException((Throwable)e, null);
        }
        if (headers != null) {
            try {
                for (int i = 0; i < headers.length; ++i) {
                    writer.write(Util.getHTMLNewLineSpan(headers[i]));
                }
            }
            catch (Exception e) {
                if (this.isOfflineResultSetsEnabled) {
                    htmlTable.setModel(model);
                    htmlTable.setColumnModel(this.columnModel);
                }
                htmlTable.setExportToExcel(false);
                throw new UncheckedException((Throwable)e, null);
            }
        }
        try {
            htmlTable.write(writer);
        }
        catch (IOException e) {
            if (this.isOfflineResultSetsEnabled) {
                htmlTable.setModel(model);
                htmlTable.setColumnModel(this.columnModel);
            }
            htmlTable.setExportToExcel(false);
            throw new UncheckedException((Throwable)e, null);
        }
        if (footers != null) {
            try {
                for (int i = 0; i < footers.length; ++i) {
                    writer.write(Util.getHTMLNewLineSpan(footers[i]));
                }
            }
            catch (Exception e) {
                if (this.isOfflineResultSetsEnabled) {
                    htmlTable.setModel(model);
                    htmlTable.setColumnModel(this.columnModel);
                }
                htmlTable.setExportToExcel(false);
                throw new UncheckedException((Throwable)e, null);
            }
        }
        try {
            writer.write(Util.getHTMLFooter());
            writer.flush();
            if (isWriterToBeClosed) {
                writer.close();
            }
        }
        catch (Exception e) {
            if (this.isOfflineResultSetsEnabled) {
                htmlTable.setModel(model);
                htmlTable.setColumnModel(this.columnModel);
            }
            htmlTable.setExportToExcel(false);
            throw new UncheckedException((Throwable)e, null);
        }
    }
}

