/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.components.webapp.visuals;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.IntegerType;
import com.sas.prompts.components.webapp.util.RB;
import com.sas.servlet.tbeans.BaseActionTransformation2;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.html.ValueListEditor;
import com.sas.servlet.tbeans.itemlistmanager.AbstractItemListManager;
import com.sas.servlet.tbeans.tableview.html.CellContentsLabelRenderer;
import com.sas.servlet.tbeans.tableview.html.DefaultTableCellRenderer;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.swing.models.ValueItemsToTableModelAdapter;
import com.sas.util.ListFactory;
import com.sas.util.ValueItem;
import com.sas.util.transforms.DataTypeToDisplayStringTransform;
import com.sas.util.transforms.TransformInterface;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.table.TableModel;

public class PromptValueListEditor
extends ValueListEditor {
    private static final long serialVersionUID = 1L;
    private Button applyButton;
    private DataTypeInterface dataType;
    public static final String PROMPT_RB_KEY = "PromptDefinitionComponentFactory.";
    private boolean applyButtonVisible;

    public PromptValueListEditor() {
        super((TransformationInterface)null);
    }

    public PromptValueListEditor(TransformationInterface editor, DataTypeInterface dataType, Locale locale) {
        super(editor);
        this.setTemplateKey("Prompt_Value_List_Editor");
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        CellContentsLabelRenderer contentsRenderer = new CellContentsLabelRenderer();
        contentsRenderer.setInputTransform((TransformInterface)new DataTypeToDisplayStringTransform(dataType, locale));
        renderer.setTableCellContentsRenderer(contentsRenderer);
        this.dataType = dataType;
        TableView tv = (TableView)this.getComponent("ITEMLISTMANAGER_TABLE");
        if (tv != null) {
            tv.setDefaultRenderer(renderer);
        }
        this.setApplyButtonVisible(true);
    }

    public DataTypeInterface getDataType() {
        return this.dataType;
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        this._setLocaleDependentProperties(locale);
    }

    private void _setLocaleDependentProperties(Locale locale) {
        this.applyButton = (Button)this.getComponent("VALUEPICKER_APPLY_BUTTON");
        if (this.applyButton != null) {
            this.applyButton.setLabel(RB.getStringResource(PROMPT_RB_KEY, "apply.txt", locale));
        }
    }

    @Override
    protected void createComponents() {
        super.createComponents();
        Button btn = (Button)this.getPredefinedButton(ValueListEditor.BUTTON_DELETE);
        if (btn != null) {
            btn.setWidthPercentage(-1);
        }
        if ((btn = (Button)this.getPredefinedButton(ValueListEditor.BUTTON_MOVE_DOWN)) != null) {
            btn.setWidthPercentage(-1);
        }
        if ((btn = (Button)this.getPredefinedButton(ValueListEditor.BUTTON_MOVE_UP)) != null) {
            btn.setWidthPercentage(-1);
        }
        if ((btn = (Button)this.getPredefinedButton(ValueListEditor.BUTTON_ADD)) != null) {
            btn.setWidthPercentage(-1);
        }
        this.applyButton = new Button();
        this.applyButton.setId(this.getId() + "_applyButton");
        this.applyButton.setEnabled(false);
        this.setComponent("VALUEPICKER_APPLY_BUTTON", this.applyButton);
    }

    @Override
    protected void prepareButtonsForWrite() {
        super.prepareButtonsForWrite();
        if (this.isApplyButtonVisible()) {
            this.applyButton.setOnClick(this.getId() + ".apply();");
        } else if (this.applyButton != null) {
            this.applyButton.setVisible(false);
        }
    }

    @Override
    protected void writeJavaScriptIncludes(PrintWriter out) throws IOException {
        super.writeJavaScriptIncludes(out);
        JavaScriptIncludeHandler.writeIncludes(out, "PROMPTVALUELISTEDITOR", this.getRequest());
    }

    @Override
    protected void writeConstructorJavaScript(PrintWriter out) {
        String ourID = this.getId();
        String edID = this.editorComp.getId();
        String tableId = ((BaseActionTransformation2)this.getComponent("ITEMLISTMANAGER_TABLE")).getContainerId();
        String fmt = " {0} = new sas_PromptValueListEditor(''{0}'', ''{1}'', ''{2}'');";
        out.println(MessageFormat.format(fmt, ourID, edID, tableId));
    }

    @Override
    public void setModel(TableModel tableModel) {
        if (tableModel == null) {
            ValueItemsToTableModelAdapter model = new ValueItemsToTableModelAdapter(new ArrayList());
            tableModel = model;
        }
        super.setModel(tableModel);
    }

    protected static Object[] getParameterValue(HttpServletRequest request) {
        Object[] values = null;
        String value = request.getParameter("ilmRowValue");
        if (value != null) {
            SpecialValues specialValue = SpecialValues.valueOf((String)value);
            AbstractItemListManager ilm = PromptValueListEditor.getItemListManager(request);
            if (specialValue != null) {
                values = new Object[]{specialValue};
            } else if (ilm instanceof PromptValueListEditor) {
                DataTypeInterface dataType = ((PromptValueListEditor)ilm).getDataType();
                try {
                    if (dataType.coerceValue((Object)value, ilm.getLocale()) == null) {
                        return null;
                    }
                }
                catch (Exception ex) {
                    return null;
                }
                MissingValues missingValue = null;
                missingValue = dataType instanceof IntegerType ? MissingValues.getNumericMissingValues((String)value) : MissingValues.getCharacterMissingValues((String)value);
                if (missingValue != null) {
                    values = new Object[]{missingValue};
                }
            }
        }
        if (values == null) {
            values = request.getParameterValues("ilmRowValue");
        }
        return values;
    }

    public static void ajax_AddRow(HttpServletRequest request, HttpServletResponse response) {
        Object[] value;
        if (request == null || response == null) {
            return;
        }
        AbstractItemListManager ilm = PromptValueListEditor.getItemListManager(request);
        if (ilm != null && ilm.getModel() != null && (value = PromptValueListEditor.getParameterValue(request)) != null) {
            PromptValueListEditor.commitUncommittedValues(ilm, request);
            PromptValueListEditor.refresh_AddRow(value, request, response);
        }
    }

    @Override
    public String getNavBarXML(String type, HttpServletRequest request, HttpServletResponse response) {
        return super.getNavBarXML(type, request, response);
    }

    public boolean isApplyButtonVisible() {
        return this.applyButtonVisible;
    }

    public void setApplyButtonVisible(boolean applyButtonVisible) {
        this.applyButtonVisible = applyButtonVisible;
    }

    @Override
    public void setSelectedValue(Object valueObj) {
        if (valueObj instanceof List) {
            List newList = ListFactory.newList();
            Object value = null;
            for (int i = 0; i < ((List)valueObj).size(); ++i) {
                value = ((List)valueObj).get(i);
                if (value instanceof String) {
                    newList.add(new ValueItem(value, value));
                    continue;
                }
                newList.add(value);
            }
            super.setSelectedValue(newList);
        } else {
            super.setSelectedValue(valueObj);
        }
    }

    static {
        JavaScriptIncludeHandler.addAlias(PromptValueListEditor.class, "PROMPTVALUELISTEDITOR");
    }
}

