/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.components.webapp.visuals;

import com.sas.prompts.components.webapp.util.Util;
import com.sas.prompts.components.webapp.visuals.PromptPropertiesPanel;
import com.sas.prompts.components.webapp.visuals.model.PromptComponentModelInterface;
import com.sas.prompts.components.webapp.visuals.model.PromptGroupPanelModelInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.models.JavaScriptNode;
import java.util.Iterator;
import java.util.List;

public class PromptJavaScriptNode
extends JavaScriptNode {
    private PromptPropertiesPanel propertyPanel;
    private PromptGroupPanelModelInterface groupModel;

    public PromptJavaScriptNode(PromptGroupPanelModelInterface groupModel, PromptPropertiesPanel propertyPanel) {
        this.propertyPanel = propertyPanel;
        this.groupModel = groupModel;
        this.setName(Util.getValidGroupName(groupModel) + "Node");
        this.setValue(propertyPanel.getId() + "_" + Util.getValidGroupName(groupModel));
        this.setEscapeSpecialCharacters(false);
        this.setAlternateText(groupModel.getLabel());
        this.setText(this.getPromptText(groupModel));
    }

    public String getPromptText(PromptGroupPanelModelInterface panelModel) {
        int totalRequiredCount = 0;
        int emptyRequiredCount = 0;
        List components = panelModel.getPromptComponentModels();
        Iterator itr = components.iterator();
        StyleInfo requiredStyle = (StyleInfo)this.propertyPanel.getStyleMap().get("PROMPTPROPERTIESPANEL_REQUIRED_GROUP_STYLE");
        StyleInfo requiredNumberStyle = (StyleInfo)this.propertyPanel.getStyleMap().get("PROMPTPROPERTIESPANEL_NUMBER_OF_REQUIRED_GROUP_STYLE");
        while (itr.hasNext()) {
            PromptComponentModelInterface pcm;
            PromptDefinitionInterface definition;
            Object item = itr.next();
            if (!(item instanceof PromptComponentModelInterface) || !(definition = (pcm = (PromptComponentModelInterface)item).getPromptDefinition()).isRequired()) continue;
            ++totalRequiredCount;
            if (pcm.getPromptValue() != null) continue;
            ++emptyRequiredCount;
        }
        String label = panelModel.getLabel();
        String groupId = Util.getValidGroupName(this.groupModel);
        int count = this.getRequiredPromptCount(this.groupModel);
        if (count > 0) {
            label = "<span id='" + groupId + "_label' class='" + requiredStyle.getClassid() + "'>" + label + "</span><span id='" + groupId + "_required' class='" + requiredNumberStyle.getClassid() + "'> (" + count + ")</span>";
        }
        if (totalRequiredCount > 0) {
            label = label + "<span class='" + requiredStyle.getClassid() + "'> *</span>";
        }
        return label;
    }

    private int getRequiredPromptCount(PromptGroupPanelModelInterface group) {
        int numRequired = 0;
        List promptComponentModels = group.getPromptComponentModels();
        if (promptComponentModels != null && promptComponentModels.size() > 0) {
            for (PromptComponentModelInterface pcModel : promptComponentModels) {
                if (pcModel.getPromptDefinition() == null || !pcModel.getPromptDefinition().isRequired() || pcModel.getPromptValue() != null) continue;
                ++numRequired;
            }
        }
        return numRequired;
    }

    private StringBuffer getGroupId(PromptGroupPanelModelInterface model, StringBuffer sb) {
        sb.append("\"").append(this.propertyPanel.getId()).append("_").append(Util.getValidGroupName(model)).append("\"");
        List subgroups = model.getSubGroupModels();
        for (PromptGroupPanelModelInterface subgroup : subgroups) {
            this.getGroupId(subgroup, sb.append(","));
        }
        return sb;
    }

    @Override
    public String getOnClick() {
        StringBuffer sb = new StringBuffer().append("[");
        StringBuffer s = this.getGroupId(this.groupModel, sb);
        s.append("]");
        return this.propertyPanel.getId() + "_Obj.switchGroup(" + s.toString() + "," + Util.isRequiredPromptPresent(this.groupModel) + ")";
    }

    public PromptGroupPanelModelInterface getPromptGroupModel() {
        return this.groupModel;
    }
}

