/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.components.webapp.visuals;

import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.components.webapp.util.PromptComponentFactory;
import com.sas.prompts.components.webapp.util.PromptComponentFactoryInterface;
import com.sas.prompts.components.webapp.util.PromptGroupPanelFactoryInterface;
import com.sas.prompts.components.webapp.util.Util;
import com.sas.prompts.components.webapp.visuals.PromptComponent;
import com.sas.prompts.components.webapp.visuals.PromptPropertiesPanel;
import com.sas.prompts.components.webapp.visuals.RB;
import com.sas.prompts.components.webapp.visuals.model.PromptComponentModelInterface;
import com.sas.prompts.components.webapp.visuals.model.PromptGroupPanelModelInterface;
import com.sas.prompts.definitions.HyperlinkDefinition;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.servlet.tbeans.BaseCompositeTransformation;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.valuepicker.ValuePicker;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.ListFactory;
import com.sas.util.Strings;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PromptGroupPanel
extends BaseCompositeTransformation {
    private static final long serialVersionUID = 1L;
    public static final String RB_KEY = "PromptGroupPanel.";
    private static final String PROMPT_GROUP_PREFIX = "PG";
    private static final String MODAL_GROUP_PREFIX = "PMG_";
    private static final String CONTAINER = "container";
    private static final String CONTAINER_ID = "CONTAINER_ID";
    public static final String RESET_TO_DEFAULT_LABEL = "RESET_TO_DEFAULT_LABEL";
    public static final String GROUP_LABEL = "GROUP_LABEL";
    public static final String PROMPT_DEFINITIONS = "PROMPT_DEFINITIONS";
    private PromptComponentFactoryInterface promptComponentFactory;
    private PromptGroupPanelModelInterface _panelModel;
    private boolean showOnlyRequired;
    private Map promptComponents;
    private boolean contentEmpty = true;
    private PromptPropertiesPanel propertyPanel;
    private Label groupLabel;
    private Label resetToDefaultLabel;
    private String containerId;
    private boolean modal;
    private List components;

    public PromptGroupPanel(PromptGroupPanelModelInterface panelModel, PromptPropertiesPanel propertyPanel) {
        this._panelModel = panelModel;
        this.propertyPanel = propertyPanel;
        this.showOnlyRequired = false;
        this.components = new ArrayList();
        this.promptComponents = new HashMap();
        this.setTemplateKey("Prompt_Group_Panel");
        this.setTemplateDictionary(new HashMap());
        this.setId(propertyPanel.getId() + "_" + PROMPT_GROUP_PREFIX + propertyPanel.getPromptGroupPanels().size());
        this.containerId = this.getUniqueContainerId();
        this.getTemplateDictionary().put(CONTAINER_ID, this.containerId);
        this.setModal(false);
        this.addComponents();
        this.setLocale(propertyPanel.getLocale());
    }

    private boolean displayGroupHeader(PromptGroupPanelModelInterface groupModel) {
        if (groupModel != null && groupModel == this.getPromptPropertyPanel().getPanelModel().getRootGroupModel()) {
            List groups = groupModel.getSubGroupModels();
            if (groups.isEmpty()) {
                return groupModel.isTransparentGroup();
            }
            boolean allTransparent = false;
            for (PromptGroupPanelModelInterface group : groups) {
                if (group.isTransparentGroup()) continue;
                allTransparent = true;
            }
            return !allTransparent;
        }
        return false;
    }

    private void addComponents() {
        boolean display = this.displayGroupHeader(this.getPanelModel());
        if (this.getPanelModel().isGroupLabelVisible() || display) {
            this.groupLabel = new Label();
            this.setComponent(GROUP_LABEL, this.groupLabel);
        }
        if (this.getPanelModel().isResetToDefaultsOptionVisible() || display) {
            this.resetToDefaultLabel = new Label();
            this.setComponent(RESET_TO_DEFAULT_LABEL, this.resetToDefaultLabel);
        }
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        this._setLocaleDependentProperties(locale);
    }

    private void _setLocaleDependentProperties(Locale currentLocale) {
        if (this.resetToDefaultLabel != null && this.resetToDefaultLabel.getText() == null) {
            this.resetToDefaultLabel.setText(RB.getStringResource(RB_KEY, "resetToDefault.txt", currentLocale));
        }
        if (this.groupLabel != null && this.groupLabel.getText() == null) {
            this.groupLabel.setText(this.getPromptGroupLabel(this.getPromptPropertyPanel().getPanelModel().getRootGroupModel(), this.getPanelModel(), currentLocale));
        }
    }

    private String getUniqueContainerId() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.propertyPanel.getId()).append("_");
        sb.append(PROMPT_GROUP_PREFIX);
        Integer hc = new Integer(this.getPanelModel().hashCode());
        String hcVal = hc.toString();
        if (hc < 0) {
            hcVal = hcVal.replace('-', '_');
        }
        sb.append(hcVal);
        if (this.getPanelModel().isModalChoiceGroup()) {
            sb.append("_").append(MODAL_GROUP_PREFIX);
        } else {
            sb.append("_");
        }
        sb.append(CONTAINER);
        return sb.toString();
    }

    private PromptComponent addPrompt(PromptComponentModelInterface pcModel) throws IOException, PromptValueNotFoundException {
        PromptDefinitionInterface def = pcModel.getPromptDefinition();
        PromptComponent promptComponent = (PromptComponent)this.promptComponents.get(pcModel);
        if (promptComponent == null && !def.isHidden()) {
            TransformationInterface tbean;
            promptComponent = this.getPromptComponentFactory().createComponent(pcModel, pcModel.getDynamicPromptValuesContext(), this);
            promptComponent.setRequest(this.getRequest());
            promptComponent.setResponse(this.getResponse());
            if (!this.getLocale().equals(this.getRequest().getLocale())) {
                promptComponent.setLocale(this.getLocale());
            }
            if ((tbean = promptComponent.getComponent("PROMPT_COMPONENT")) instanceof ValuePicker && this.getPromptPropertyPanel().getFormObject() != null) {
                ((ValuePicker)tbean).setFormObject(this.getPromptPropertyPanel().getFormObject());
            }
            if (promptComponent == null) {
                return null;
            }
            this.promptComponents.put(pcModel, promptComponent);
        }
        promptComponent.setGroupPanel(this);
        return promptComponent;
    }

    public PromptGroupPanelModelInterface getPanelModel() {
        return this._panelModel;
    }

    private String getPromptGroupLabel(PromptGroupPanelModelInterface parentGroup, PromptGroupPanelModelInterface promptGroup, Locale locale) {
        String label = null;
        List path = this.getPathToPromptGroup(parentGroup, promptGroup);
        for (PromptGroupPanelModelInterface group : path) {
            if (label == null) {
                label = this.replaceNull(group.getLabel());
                continue;
            }
            label = label + " > " + this.replaceNull(group.getLabel());
        }
        return this.replaceNull(label);
    }

    private List getPathToPromptGroup(PromptGroupPanelModelInterface parentGroup, PromptGroupPanelModelInterface promptGroup) {
        ArrayList path = new ArrayList();
        this.getPathToPromptGroup(parentGroup, promptGroup, path);
        return path;
    }

    private void getPathToPromptGroup(PromptGroupPanelModelInterface parentGroup, PromptGroupPanelModelInterface promptGroup, List path) {
        if (com.sas.util.Util.equal((Object)parentGroup, (Object)promptGroup)) {
            path.add(promptGroup);
        } else {
            if (this.propertyPanel.isShowRootGroup() || !this.propertyPanel.isShowRootGroup() && com.sas.util.Util.unequal((Object)parentGroup, (Object)this.propertyPanel.getPanelModel().getRootGroupModel())) {
                path.add(parentGroup);
            }
            List groups = parentGroup.getSubGroupModels();
            for (PromptGroupPanelModelInterface childGroup : groups) {
                if (com.sas.util.Util.equal((Object)childGroup, (Object)promptGroup)) {
                    path.add(promptGroup);
                    return;
                }
                if (!this.hasPromptSubgroup(childGroup, promptGroup, true)) continue;
                this.getPathToPromptGroup(childGroup, promptGroup, path);
                return;
            }
        }
    }

    private void getAllSubgroups(PromptGroupPanelModelInterface panelModel, List listModel) {
        if (!panelModel.isModalChoiceGroup() && !panelModel.isModalGroup()) {
            listModel.addAll(panelModel.getSubGroupModels());
            this.addPromptGroupsToList(panelModel.getSubGroupModels(), listModel);
        }
    }

    private void addPromptGroupsToList(List groups, List listModel) {
        if (groups != null) {
            for (PromptGroupPanelModelInterface subPanelModel : groups) {
                this.getAllSubgroups(subPanelModel, listModel);
            }
        }
    }

    private boolean hasPromptSubgroup(PromptGroupPanelModelInterface parentGroup, PromptGroupPanelModelInterface promptGroup, boolean recursive) {
        if (null != promptGroup) {
            List subgroups = ListFactory.newList();
            this.getAllSubgroups(parentGroup, subgroups);
            Iterator iter = subgroups.iterator();
            while (iter.hasNext()) {
                if (!com.sas.util.Util.equal((Object)((PromptGroupPanelModelInterface)iter.next()), (Object)promptGroup)) continue;
                return true;
            }
        }
        return false;
    }

    private String replaceNull(String text) {
        if (text == null) {
            return "";
        }
        return text;
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        this.contentEmpty = true;
        if (!Util.isGroupVisible(this.getPanelModel())) {
            return;
        }
        if (this.resetToDefaultLabel != null) {
            this.resetToDefaultLabel.setURL("javascript:void( " + this.getPromptPropertyPanel().getId() + "_Obj.resetToDefault('" + this.getId() + "'))");
        }
        if (this.components.isEmpty()) {
            this.components = this.addComponents(this.getPanelModel());
        }
        StringBuffer componentsBuffer = new StringBuffer();
        StringBuffer jsParm = new StringBuffer().append("[");
        StringBuffer reqComponentsParm = new StringBuffer().append("[");
        int i = 0;
        int j = 0;
        for (PromptComponent component : this.components) {
            if (!component.isRequired()) {
                if (i != 0) {
                    jsParm.append(",");
                }
                jsParm.append("\"").append(component.getId()).append("\"");
                ++i;
            } else {
                if (j != 0) {
                    reqComponentsParm.append(",");
                }
                reqComponentsParm.append("\"").append(component.getId()).append("\"");
                ++j;
            }
            component.setRequest(this.getRequest());
            component.setResponse(this.getResponse());
            componentsBuffer.append(component.toString());
            List list = this.getPanelModel().getModalGroups(component.getPromptComponentModel());
            if (list == null) continue;
            for (Object modalGroupObj : list) {
                PromptGroupPanelModelInterface obj;
                if (!(modalGroupObj instanceof PromptGroupPanelModelInterface) || !(obj = (PromptGroupPanelModelInterface)modalGroupObj).isModalChoiceGroup() || obj.getModalChoiceGroupValue() == null || !obj.getModalChoiceGroupValue().equals(component.getPromptComponentModel().getPromptValue())) continue;
                Map groupPanels = this.getPromptPropertyPanel().getPromptGroupPanels();
                PromptGroupPanel panel = (PromptGroupPanel)groupPanels.get(obj);
                if (panel == null) {
                    panel = this.getPromptGroupPanelFactory().createGroupPanel(obj, this.getPromptPropertyPanel());
                    groupPanels.put(obj, panel);
                }
                panel.setRequest(this.getRequest());
                panel.setResponse(this.getResponse());
                componentsBuffer.append(panel.toString());
            }
        }
        reqComponentsParm.append("]");
        this.getTemplateDictionary().put(PROMPT_DEFINITIONS, componentsBuffer.toString());
        this.writeTemplate(this, null, out);
        jsParm.append("]");
        out.println(JavaScriptIncludeHandler.getStartScript());
        String jsObj = null;
        Integer hc = new Integer(this.getPanelModel().hashCode());
        String hcVal = hc.toString();
        if (hc < 0) {
            hcVal = hcVal.replace('-', '_');
        }
        jsObj = this.getPanelModel().isModalGroup() ? this.getPromptPropertyId() + "_PMG" + hcVal + "_Obj" : this.getPromptPropertyId() + "_PG" + hcVal + "_Obj";
        out.println(jsObj + " = new sas_PromptGroup('" + this.containerId + "','" + this.getPromptPropertyId() + "','" + Strings.escapeForJavaScript((String)this.getPanelModel().getLabel()) + "')");
        out.println(jsObj + ".setOptionalPromptComponents (" + jsParm.toString() + ");");
        out.println(jsObj + ".addComponents (" + jsParm.toString() + ");");
        out.println(jsObj + ".addComponents (" + reqComponentsParm.toString() + ");");
        List groups = this.getPanelModel().getSubGroupModels();
        jsParm = new StringBuffer().append("[");
        int size = groups.size();
        for (i = 0; i < size; ++i) {
            jsParm.append("\"").append(this.propertyPanel.getId()).append("_").append(Util.getValidGroupName((PromptGroupPanelModelInterface)groups.get(i))).append("\"");
            if (i >= groups.size() - 1) continue;
            jsParm.append(",");
        }
        jsParm.append("]");
        out.println(jsObj + ".setGroups (" + jsParm.toString() + ");");
        out.println(JavaScriptIncludeHandler.getEndScript(null));
        List subgroups = this.getPanelModel().getSubGroupModels();
        for (PromptGroupPanelModelInterface subgroup : subgroups) {
            PromptGroupPanel panel;
            if (!subgroup.isModalChoiceGroup() && !subgroup.isModalGroup()) {
                panel = (PromptGroupPanel)this.propertyPanel.getPromptGroupPanels().get(subgroup);
                if (panel == null) {
                    panel = this.getPromptGroupPanelFactory().createGroupPanel(subgroup, this.propertyPanel);
                    panel.setModal(this.isModal());
                    this.propertyPanel.getPromptGroupPanels().put(subgroup, panel);
                }
                panel.setRequest(this.getRequest());
                panel.setResponse(this.getResponse());
                panel.write(out);
                continue;
            }
            panel = (PromptGroupPanel)this.propertyPanel.getPromptGroupPanels().get(subgroup);
            if (panel != null || (panel = this.getPromptGroupPanelFactory().createGroupPanel(subgroup, this.propertyPanel)) == null) continue;
            panel.setModal(this.isModal());
            panel.setRequest(this.getRequest());
            panel.setResponse(this.getResponse());
            this.propertyPanel.getPromptGroupPanels().put(subgroup, panel);
        }
        this.cleanUpResources();
    }

    public List addComponents(PromptGroupPanelModelInterface panelModel) {
        Map groups = this.propertyPanel.getGroupsList();
        List componentModels = panelModel.getPromptComponentModels();
        for (Object item : componentModels) {
            PromptComponentModelInterface pcm;
            PromptDefinitionInterface definition;
            if (!(item instanceof PromptComponentModelInterface) || (definition = (pcm = (PromptComponentModelInterface)item).getPromptDefinition()).isHidden()) continue;
            try {
                if (definition instanceof HyperlinkDefinition) continue;
                PromptComponent component = this.addPrompt(pcm);
                this.components.add(component);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (PromptValueNotFoundException e) {
                e.printStackTrace();
            }
        }
        groups.put(this.getId(), this.promptComponents);
        return this.components;
    }

    public boolean isContentEmpty() {
        if (this.isShowOnlyRequired()) {
            return this.contentEmpty;
        }
        return false;
    }

    public void resetContent() {
        this.contentEmpty = false;
    }

    public boolean isShowOnlyRequired() {
        return this.showOnlyRequired;
    }

    public void setShowOnlyRequired(boolean showOnlyRequired) {
        this.showOnlyRequired = showOnlyRequired;
    }

    public String getPromptPropertyId() {
        return this.propertyPanel.getId();
    }

    protected PromptPropertiesPanel getPromptPropertyPanel() {
        return this.propertyPanel;
    }

    public Map getPromptComponents() {
        return this.promptComponents;
    }

    public void setModal(boolean modal) {
        this.modal = modal;
    }

    public boolean isModal() {
        if (this.getPanelModel().isModalChoiceGroup()) {
            return true;
        }
        return this.modal;
    }

    public PromptComponentFactoryInterface getPromptComponentFactory() {
        if (this.promptComponentFactory == null) {
            this.promptComponentFactory = this.propertyPanel.getPromptComponentFactory();
            if (this.promptComponentFactory == null) {
                this.promptComponentFactory = new PromptComponentFactory();
            }
        }
        return this.promptComponentFactory;
    }

    public void setPromptComponentFactory(PromptComponentFactoryInterface promptComponentFactory) {
        this.promptComponentFactory = promptComponentFactory;
    }

    protected PromptGroupPanelFactoryInterface getPromptGroupPanelFactory() {
        return this.getPromptPropertyPanel().getPromptGroupPanelFactory();
    }

    @Override
    public void cleanup(HttpServletRequest request) {
        this.cleanup(request.getSession());
    }

    @Override
    public void cleanup(HttpSession session) {
        super.cleanup(session);
        Map components = this.getPromptComponents();
        Iterator itr = components.keySet().iterator();
        while (itr.hasNext()) {
            PromptComponent component = (PromptComponent)components.get(itr.next());
            component.cleanup(session);
        }
        components.clear();
    }
}

