/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.components.webapp.visuals;

import com.sas.prompts.components.webapp.util.Util;
import com.sas.prompts.components.webapp.visuals.PromptJavaScriptNode;
import com.sas.prompts.components.webapp.visuals.PromptPropertiesPanel;
import com.sas.prompts.components.webapp.visuals.model.PromptGroupPanelModelInterface;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.form.html.ListBoxView;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;

public class PromptGroupList
extends BaseTransformation {
    private static final long serialVersionUID = 1L;
    private boolean showRootGroup;
    private ListBoxView listBoxView;
    private PromptPropertiesPanel propertyPanel;
    private PromptGroupPanelModelInterface groupModel;
    private DefaultListModel listModel;

    public PromptGroupList(PromptGroupPanelModelInterface groupModel, PromptPropertiesPanel propertyPanel) {
        this.groupModel = groupModel;
        this.propertyPanel = propertyPanel;
        this.listBoxView = new ListBoxView();
        this.listBoxView.setId(this.getId() + "_pgl");
        this.listModel = new DefaultListModel();
        StyleInfo defaultHighlightStyle = (StyleInfo)this.listBoxView.getStyleMap().get("LISTBOXVIEW_ROW_HIGHLIGHT");
        this.listBoxView.getStyleMap().put("LISTBOXVIEW_ROW_HIGHLIGHT", new StyleInfo(defaultHighlightStyle.getClassid() + " promptGroupSelectedNode"));
        if (!propertyPanel.isAutoSize()) {
            this.listBoxView.setSize(30);
        }
        this.showRootGroup = false;
    }

    @Override
    public void setId(String id) {
        String previousId = this.getId();
        super.setId(id);
        if (this.listBoxView != null) {
            String lId = this.listBoxView.getId();
            if (previousId == null || lId.startsWith(previousId)) {
                this.listBoxView.setId(id + "_pgl");
            }
        }
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        this.setListModel();
        this.listBoxView.setRequest(this.getRequest());
        this.listBoxView.setResponse(this.getResponse());
        this.listBoxView.setSelectedIndex(0);
        this.listBoxView.write(out);
    }

    public ListBoxView getListBoxView() {
        return this.listBoxView;
    }

    private void setListModel() {
        if (this.listModel.size() == 0) {
            if (this.showRootGroup) {
                this.addPromptGroupToListModel(this.groupModel, this.listModel, 0);
            } else if (!this.groupModel.getPromptComponentModels().isEmpty()) {
                this.addPromptGroupToListModel(this.groupModel, this.listModel, 0);
            } else if (!this.groupModel.isTransparentGroup()) {
                this.addPromptGroupsToListModel(this.groupModel, this.groupModel.getSubGroupModels(), this.listModel, 0);
            }
            if (this.propertyPanel.isAutoSize()) {
                this.listBoxView.setSize(this.listModel.size());
            }
            this.listBoxView.setModel(this.listModel);
            try {
                this.listBoxView.setSelectedIndex(0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void addPromptGroupToListModel(PromptGroupPanelModelInterface panelModel, DefaultListModel listModel, int level) {
        if (!panelModel.isModalChoiceGroup() && !panelModel.isModalGroup() && Util.isGroupVisible(panelModel) && !panelModel.isTransparentGroup()) {
            PromptJavaScriptNode node = new PromptJavaScriptNode(panelModel, this.propertyPanel);
            node.setIndentionLevel(level * 2);
            listModel.addElement(node);
            this.addPromptGroupsToListModel(panelModel, panelModel.getSubGroupModels(), listModel, level + 1);
        }
    }

    private void addPromptGroupsToListModel(PromptGroupPanelModelInterface panelModel, List groups, DefaultListModel listModel, int level) {
        if (groups != null) {
            for (PromptGroupPanelModelInterface subPanelModel : groups) {
                this.addPromptGroupToListModel(subPanelModel, listModel, level);
            }
        }
    }

    public ListModel getListModel() {
        return this.listBoxView.getModel();
    }

    public boolean isShowRootGroup() {
        return this.showRootGroup;
    }

    public void setShowRootGroup(boolean showRootGroup) {
        this.showRootGroup = showRootGroup;
    }
}

