/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.components.webapp.visuals;

import com.sas.actionprovider.HttpActionProviderInterface;
import com.sas.datatypes.DateType;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptViewInterface;
import com.sas.prompts.components.webapp.util.PromptDefinitionComponentFactory;
import com.sas.prompts.components.webapp.util.PromptValueComponentFactory;
import com.sas.prompts.components.webapp.util.Util;
import com.sas.prompts.components.webapp.visuals.PromptGroupPanel;
import com.sas.prompts.components.webapp.visuals.PromptPropertiesPanel;
import com.sas.prompts.components.webapp.visuals.PromptValuePicker;
import com.sas.prompts.components.webapp.visuals.model.DefaultPromptGroupPanelModel;
import com.sas.prompts.components.webapp.visuals.model.PromptComponentModelInterface;
import com.sas.prompts.components.webapp.visuals.model.PromptGroupPanelModelInterface;
import com.sas.prompts.definitions.BaseDefinitionRange;
import com.sas.prompts.definitions.DataSourceColumnDefinition;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.SelectableDefinitionInterface;
import com.sas.prompts.definitions.TextDefinitionInterface;
import com.sas.prompts.definitions.shared.SharedBaseDefinitionRange;
import com.sas.prompts.groups.ModalChoiceGroup;
import com.sas.servlet.tbeans.AJAXControllerURLInterface;
import com.sas.servlet.tbeans.BaseCompositeTransformation;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.JavaScriptEventHandlerInterface;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.TemplateSupport;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.datasource.DataSourceColumnPicker;
import com.sas.servlet.tbeans.datasource.DataSourcePicker;
import com.sas.servlet.tbeans.datasource.IFilePicker;
import com.sas.servlet.tbeans.datasource.directoryfile.DirectoryFilePicker;
import com.sas.servlet.tbeans.form.BaseChoiceBox;
import com.sas.servlet.tbeans.form.JavaScriptObjectCreationInterface;
import com.sas.servlet.tbeans.form.html.ChoiceBox;
import com.sas.servlet.tbeans.form.html.ComboBoxView;
import com.sas.servlet.tbeans.form.html.Password;
import com.sas.servlet.tbeans.form.html.TextArea;
import com.sas.servlet.tbeans.form.html.TextEntry;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.html.DateIntervalPicker;
import com.sas.servlet.tbeans.html.DatePicker;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.html.TimePicker;
import com.sas.servlet.tbeans.html.TimeStampPicker;
import com.sas.servlet.tbeans.html.ValueListEditor;
import com.sas.servlet.tbeans.models.JavaScriptNode;
import com.sas.servlet.tbeans.range.BaseRange;
import com.sas.servlet.tbeans.range.html.TimePickerRange;
import com.sas.servlet.tbeans.range.html.TimeStampPickerRange;
import com.sas.servlet.tbeans.valuepicker.TargetValueListEditor;
import com.sas.servlet.tbeans.valuepicker.ValuePicker;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.MapWithDefaults;
import com.sas.util.Strings;
import com.sas.util.log.LoggerRepository2;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.table.TableModel;

public class PromptComponent
extends BaseCompositeTransformation {
    private static final long serialVersionUID = 1L;
    private PromptComponentModelInterface _promptComponentModel;
    protected String promptName;
    protected boolean cascadedPrompt;
    private boolean enabled;
    private PromptGroupPanel groupPanel;
    private String jsObjName;
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "PromptCompositeComponent.html";
    public static final String PROMPT_REQUIRED = "PROMPT_REQUIRED";
    public static final String PROMPT_DESCRIPTION = "PROMPT_DESCRIPTION";
    public static final String PROMPT_LABEL = "PROMPT_LABEL";
    public static final String PROMPT_COMPONENT = "PROMPT_COMPONENT";
    public static final String PROMPT_COMPONENT_ID = "PROMPT_COMPONENT_ID";
    public static final String PROMPT_HINT = "PROMPT_HINT";
    public static final String PROMPT_ERROR = "PROMPT_ERROR";
    private static final String PROMPT_COMPONENT_RANGE_TYPE = "sas_PromptComponent.RANGE";
    private static final String PROMPT_COMPONENT_SINGLE_TYPE = "sas_PromptComponent.SINGLE";
    private static final String PROMPT_COMPONENT_MULTIPLE_TYPE = "sas_PromptComponent.MULTIPLE";
    public static final String PROMPT_DESCRIPTION_STYLE = "PROMPT_DESCRIPTION_STYLE";
    public static final String PROMPT_TEXTAREA_STYLE = "PROMPT_TEXTAREA_STYLE";
    public static final String PROMPT_HINT_STYLE = "PROMPT_HINT_STYLE";
    private static final String CONTAINER = "_container";
    private static final ImmutableStyleInfo descriptionStyle = new ImmutableStyleInfo("promptDescription");
    private static final ImmutableStyleInfo textAreaStyle = new ImmutableStyleInfo("promptTextArea");
    private static final ImmutableStyleInfo hintStyle = new ImmutableStyleInfo("promptHint");
    private static final HashMap defaultStyleMap = new HashMap();
    private DynamicPromptValueContextInterface dynamicPromptValueContext;
    private PromptValueComponentFactory promptValueComponentFactory;
    private PromptDefinitionInterface promptDefinition;
    private static char[] SPECIAL_CHARS = new char[]{'\'', '\\', '\b', '\n', '\t', '\f', '\r'};
    private static String[] REPLACEMENT_ELEMENTS = new String[]{"\\'", "\\\\", "\\b", "\\n", "\\t", "\\f", "\\r"};

    public PromptComponent(PromptComponentModelInterface promptComponentModel, DynamicPromptValueContextInterface dynamicPromptValueContext, PromptGroupPanel groupPanel, PromptValueComponentFactory factory) {
        String hint;
        PromptComponent.setupDefaultStyleMap();
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap((Map)defaultStyleMap);
        this.setId(groupPanel.getId() + "_PC" + groupPanel.getPromptComponents().size());
        this.jsObjName = this.getId() + "_Obj";
        Locale locale = groupPanel.getLocale();
        this._promptComponentModel = promptComponentModel;
        this.groupPanel = groupPanel;
        this.promptValueComponentFactory = factory;
        this.setLocale(locale);
        this.promptDefinition = promptComponentModel.getPromptDefinition();
        this.promptName = this.promptDefinition.getPromptName();
        this.dynamicPromptValueContext = dynamicPromptValueContext;
        this.setEnabled(true);
        this.setTemplateKey("Prompt_Composite_Component");
        Label requiredLabel = null;
        if (this.promptDefinition.isRequired()) {
            requiredLabel = new Label();
            requiredLabel.setText("*");
            requiredLabel.setEncodeText(false);
            requiredLabel.setStyleInfo(new StyleInfo(null, "font-weight: bold;"));
        }
        if (requiredLabel != null) {
            this.setComponent(PROMPT_REQUIRED, requiredLabel);
        }
        if (this.promptDefinition instanceof TextDefinitionInterface && (hint = ((TextDefinitionInterface)this.promptDefinition).getHint(locale)) != null) {
            this.setComponent(PROMPT_HINT, new Label(hint));
        }
        this.setComponent(PROMPT_LABEL, new Label(this.promptDefinition.getPromptLabel(locale)));
        if (this.promptDefinition.getPromptDescription(locale) != null) {
            this.setComponent(PROMPT_DESCRIPTION, new Label(this.promptDefinition.getPromptDescription(locale)));
        }
        TransformationInterface tbean = this.promptValueComponentFactory.createComponent(promptComponentModel, groupPanel.getPanelModel(), this.getId(), dynamicPromptValueContext, this.isApplyVisible(), locale);
        if (!this.promptDefinition.isFixed()) {
            this.initValueComponent(tbean);
        } else if (tbean instanceof TextArea) {
            ((TextArea)tbean).setStyleInfo((StyleInfo)this.getStyleMap().get(PROMPT_TEXTAREA_STYLE));
        }
        this.setComponent(PROMPT_COMPONENT, tbean);
        this.setDescription(this.promptDefinition.getPromptLabel(locale));
        HashMap<String, String> templateMap = this.getTemplateDictionary();
        if (templateMap == null) {
            templateMap = new HashMap<String, String>();
        }
        templateMap.put(PROMPT_COMPONENT_ID, this.getId() + CONTAINER);
        this.setTemplateDictionary(templateMap);
    }

    protected PromptDefinitionInterface getPromptDefinition() {
        return this._promptComponentModel.getPromptDefinition();
    }

    public PromptComponentModelInterface getPromptComponentModel() {
        return this._promptComponentModel;
    }

    public boolean isModified() {
        int selection;
        PromptComponentModelInterface pcm = this.getPromptComponentModel();
        BaseTransformation valueComponent = (BaseTransformation)this.getComponent(PROMPT_COMPONENT);
        if (this.promptDefinition.isDefaultValueSet() && !this.promptDefinition.getDefaultValue().equals(pcm.getPromptValue())) {
            return true;
        }
        if (!this.promptDefinition.isDefaultValueSet() && pcm.getPromptValue() != null) {
            return true;
        }
        if (valueComponent instanceof BaseRange || valueComponent instanceof ValueListEditor) {
            return true;
        }
        if (valueComponent instanceof PromptValuePicker && ((selection = ((ValuePicker)valueComponent).getSelectionMode()) == 301 || selection == 302)) {
            TargetValueListEditor vle;
            Object m;
            return this.promptDefinition.isDefaultValueSet() || !((m = (vle = (TargetValueListEditor)((ValuePicker)valueComponent).getComponent(ValuePicker.VALUEPICKER_TARGET_COMPONENT)).getModel()) instanceof TableModel) || ((TableModel)m).getRowCount() != 0;
        }
        return false;
    }

    public void reset() {
        if (this.getPromptDefinition().isFixed()) {
            return;
        }
        try {
            this.getPromptComponentModel().resetToDefaultValues();
        }
        catch (InvalidPromptValueException e) {
            e.printStackTrace();
        }
        BaseTransformation valueComponent = (BaseTransformation)this.getComponent(PROMPT_COMPONENT);
        if (this.promptDefinition.isDefaultValueSet()) {
            valueComponent.setObjectData(this.promptDefinition.getDefaultValue());
        } else {
            valueComponent.setObjectData(null);
        }
    }

    public void initValueComponent(TransformationInterface tbean) {
        if (tbean != null) {
            BaseCompositeTransformation minTimeStamp;
            TextEntry te;
            Button btn;
            try {
                this.setComponentValue(tbean.getLocale());
            }
            catch (PromptValueNotFoundException e) {
                LoggerRepository2.getLogger((String)PromptComponent.class.getName(), null).error(e.getMessage(), (Throwable)e);
            }
            if (tbean instanceof AJAXControllerURLInterface) {
                ((AJAXControllerURLInterface)((Object)tbean)).setAJAXControllerURL(this.groupPanel.getPromptPropertyPanel().getAJAXControllerURL());
            }
            if (tbean instanceof HttpActionProviderInterface) {
                ((HttpActionProviderInterface)((Object)tbean)).setActionProvider(this.groupPanel.getPromptPropertyPanel().getActionProvider());
            }
            if (tbean instanceof JavaScriptObjectCreationInterface) {
                ((JavaScriptObjectCreationInterface)((Object)tbean)).setJavaScriptObjectCreationEnabled(true);
            }
            tbean.setDescription(this.getDescription());
            tbean.setId(this.getId() + "_pv");
            if (tbean instanceof BaseRange && (btn = (Button)((BaseRange)tbean).getComponent(PromptDefinitionComponentFactory.APPLY_BUTTON)) != null) {
                btn.setOnClick(tbean.getId() + "_Obj.apply();");
            }
            if (tbean instanceof TextEntry) {
                ((TextEntry)tbean).setOnKeyPress("return " + this.jsObjName + ".onKeyPress(event)");
            } else if (tbean instanceof Password) {
                ((Password)tbean).setOnKeyPress("return " + this.jsObjName + ".onKeyPress(event)");
            } else if (tbean instanceof IFilePicker) {
                te = (TextEntry)((IFilePicker)tbean).getComponent(DataSourcePicker.DATASOURCE_TEXT);
                te.setOnKeyPress("return " + this.jsObjName + ".onKeyPress(event)");
            } else if (tbean instanceof DataSourcePicker) {
                te = (TextEntry)((DataSourcePicker)tbean).getComponent(DataSourcePicker.DATASOURCE_TEXT);
                te.setOnKeyPress("return " + this.jsObjName + ".onKeyPress(event)");
            } else if (tbean instanceof DirectoryFilePicker) {
                te = (TextEntry)((DirectoryFilePicker)tbean).getComponent(DataSourcePicker.DATASOURCE_TEXT);
                te.setOnKeyPress("return " + this.jsObjName + ".onKeyPress(event)");
            } else if (tbean instanceof ValuePicker) {
                ((ValuePicker)tbean).setNumberOfListValuesDisplayed(this.getPromptPropertiesPanel().getNumberOfListValuesDisplayed());
            } else if (tbean instanceof TimePicker) {
                ((TimePicker)tbean).setHonor24HourLocale(this.getPromptPropertiesPanel().isHonor24HourLocale());
            } else if (tbean instanceof TimeStampPicker) {
                ((TimeStampPicker)tbean).setHonor24HourLocale(this.getPromptPropertiesPanel().isHonor24HourLocale());
            } else if (tbean instanceof TimeStampPickerRange) {
                minTimeStamp = (TimeStampPicker)((TimeStampPickerRange)tbean).getMinimumRangeComponent();
                TimeStampPicker maxTimeStamp = (TimeStampPicker)((TimeStampPickerRange)tbean).getMaximumRangeComponent();
                ((TimeStampPicker)minTimeStamp).setHonor24HourLocale(this.getPromptPropertiesPanel().isHonor24HourLocale());
                maxTimeStamp.setHonor24HourLocale(this.getPromptPropertiesPanel().isHonor24HourLocale());
            } else if (tbean instanceof TimePickerRange) {
                minTimeStamp = (TimePicker)((TimePickerRange)tbean).getMinimumRangeComponent();
                TimePicker maxTimeStamp = (TimePicker)((TimePickerRange)tbean).getMaximumRangeComponent();
                ((TimePicker)minTimeStamp).setHonor24HourLocale(this.getPromptPropertiesPanel().isHonor24HourLocale());
                maxTimeStamp.setHonor24HourLocale(this.getPromptPropertiesPanel().isHonor24HourLocale());
            }
            if (tbean instanceof DataSourceColumnPicker) {
                ((JavaScriptEventHandlerInterface)((Object)tbean)).setOnChange("if (window." + this.jsObjName + ") " + this.jsObjName + ".onChange(this)");
            } else if (tbean instanceof JavaScriptEventHandlerInterface) {
                ((JavaScriptEventHandlerInterface)((Object)tbean)).setOnChange("if (window." + this.jsObjName + ") " + this.jsObjName + ".onChange(this)");
            } else if (!(tbean instanceof Label)) {
                LoggerRepository2.getLogger((String)PromptPropertiesPanel.class.getName(), null).error(tbean.getId() + "(" + this.getPromptDefinition().getPromptLabel(this.getLocale()) + ") does not implement JavaScriptEventHandlerInterface.");
            }
            if (tbean instanceof ValuePicker && this.groupPanel != null) {
                if (!this.getPromptPropertiesPanel().isApplyOnFocus() && !this.getPromptPropertiesPanel().isApplyButtonVisible()) {
                    ((ValuePicker)tbean).setEnableLostFocusEvent(false);
                }
                if (this.groupPanel.getPromptPropertyPanel().getFormObject() != null) {
                    ((ValuePicker)tbean).setFormObject(this.groupPanel.getPromptPropertyPanel().getFormObject());
                }
            }
            if (tbean instanceof TextArea) {
                ((TextArea)tbean).setStyleInfo((StyleInfo)this.getStyleMap().get(PROMPT_TEXTAREA_STYLE));
            }
            this.configureApplyOnFocus(tbean);
        }
    }

    private void configureApplyOnFocus(TransformationInterface tbean) {
        if (this.getPromptPropertiesPanel().isApplyButtonVisible()) {
            if (tbean instanceof ValuePicker) {
                ((ValuePicker)tbean).setOnUpdate(this.jsObjName + ".onFocusEvent();");
            } else if (tbean instanceof ValueListEditor) {
                ((ValueListEditor)tbean).setOnUpdate(this.jsObjName + ".onFocusEvent();");
            } else if (tbean instanceof BaseRange) {
                ((BaseRange)tbean).setOnUpdate(this.jsObjName + ".onFocusEvent();");
            } else if (tbean instanceof JavaScriptEventHandlerInterface) {
                ((JavaScriptEventHandlerInterface)((Object)tbean)).setOnFocus("if (window." + this.jsObjName + ") " + this.jsObjName + ".onFocusEvent()");
            }
        } else {
            if (tbean instanceof JavaScriptEventHandlerInterface) {
                // empty if block
            }
            if (tbean instanceof ValuePicker) {
                ((ValuePicker)tbean).setOnUpdate(this.jsObjName + ".onUpdateEvent();");
            } else if (tbean instanceof ValueListEditor) {
                ((ValueListEditor)tbean).setOnUpdate(this.jsObjName + ".onUpdateEvent();");
            } else if (tbean instanceof BaseRange) {
                ((BaseRange)tbean).setOnUpdate(this.jsObjName + ".onUpdateEvent();");
            } else if (tbean instanceof JavaScriptEventHandlerInterface) {
                // empty if block
            }
        }
    }

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put(PROMPT_DESCRIPTION_STYLE, descriptionStyle);
            defaultStyleMap.put(PROMPT_TEXTAREA_STYLE, textAreaStyle);
            defaultStyleMap.put(PROMPT_HINT_STYLE, hintStyle);
        }
    }

    public void setComponentValue(Locale locale) throws PromptValueNotFoundException {
        TransformationInterface tbean = this.getComponent(PROMPT_COMPONENT);
        if (tbean instanceof BaseTransformation) {
            ((BaseTransformation)tbean).setObjectData(this.getPromptComponentModel().getPromptValue());
        }
    }

    private boolean isApplyVisible() {
        return this.getPromptPropertiesPanel().isApplyButtonVisible();
    }

    public void updatePromptValue(HttpServletRequest request) throws PromptValueNotFoundException, InvalidPromptValueException {
        Object value = request.getParameterValues("sas_promptValue");
        String index = request.getParameter("sas_selectedIndex");
        int selectedIndex = -1;
        if (index != null && (selectedIndex = Integer.parseInt(index)) > -1) {
            Object v = this.getComboBoxSelectedValue(selectedIndex);
            if (v instanceof JavaScriptNode) {
                v = ((JavaScriptNode)v).getValue();
            }
            this.updatePromptValue(request, v);
            return;
        }
        if (value != null) {
            if (((String[])value).length == 1) {
                value = value[0];
            }
            if (value != null && value.equals("")) {
                value = null;
            }
        }
        if ("_VALUES.NONE_".equals(value)) {
            value = null;
        }
        this.getPromptComponentModel().setPromptValue(value);
        this.setComponentValue(this.getPromptComponentModel().getLocale());
    }

    private Object getComboBoxSelectedValue(int index) {
        TransformationInterface srcComponent;
        BaseTransformation tbean = (BaseTransformation)this.getComponent(PROMPT_COMPONENT);
        if (tbean instanceof ValuePicker) {
            srcComponent = ((ValuePicker)tbean).getComponent(ValuePicker.VALUEPICKER_SOURCE_COMPONENT);
            if (srcComponent instanceof DateIntervalPicker) {
                srcComponent = ((DateIntervalPicker)srcComponent).getComponent("COMBOBOX_COMPONENT");
            } else if (srcComponent instanceof DatePicker) {
                srcComponent = ((DatePicker)srcComponent).getComponent("COMBO_COMPONENT");
            }
        } else {
            srcComponent = tbean instanceof DatePicker ? ((DatePicker)tbean).getComponent("COMBO_COMPONENT") : (tbean instanceof DateIntervalPicker ? ((DateIntervalPicker)tbean).getComponent("COMBOBOX_COMPONENT") : tbean);
        }
        if (srcComponent instanceof BaseChoiceBox) {
            return ((BaseChoiceBox)srcComponent).getItem(index);
        }
        return null;
    }

    public void updatePromptValue(HttpServletRequest request, Object value) throws PromptValueNotFoundException, InvalidPromptValueException {
        this.getPromptComponentModel().setPromptValue(value);
        this.setComponentValue(this.getPromptComponentModel().getLocale());
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        try {
            boolean depVisible = this.getPromptPropertiesPanel().isShowInvalidDependentPrompts();
            StringBuffer sb = new StringBuffer();
            if (this.isVisible() || depVisible) {
                JavaScriptIncludeHandler.writeIncludes(out, PromptComponent.class, this.getRequest());
                TemplateSupport.writeTemplate(this, null, out);
                sb.append("<span").append(">").append("&#160;").append("</span>");
                sb.append(JavaScriptIncludeHandler.getStartScript());
                sb.append(this.jsObjName).append("= new sas_PromptComponent(").append(this.getJSParameters()).append(");\n");
                TransformationInterface component = this.getComponent(PROMPT_COMPONENT);
                if (component instanceof DataSourceColumnPicker || component instanceof DataSourcePicker) {
                    sb.append(this.jsObjName).append(".serverValueUpdate = true;\n");
                } else if (component instanceof ValuePicker) {
                    TransformationInterface sourceComponent = ((ValuePicker)component).getComponent(ValuePicker.VALUEPICKER_SOURCE_COMPONENT);
                    if (sourceComponent instanceof ChoiceBox || sourceComponent instanceof ComboBoxView || sourceComponent instanceof DatePicker || sourceComponent instanceof DateIntervalPicker) {
                        sb.append(this.jsObjName).append(".serverValueUpdate = false;\n");
                    } else {
                        sb.append(this.jsObjName).append(".serverValueUpdate = true;\n");
                    }
                } else if (component instanceof ValueListEditor) {
                    sb.append(this.jsObjName).append(".serverValueUpdate = true;\n");
                }
                sb.append(JavaScriptIncludeHandler.getEndScript(null));
            } else {
                sb.append("<div").append(" id=\"").append(this.getId()).append("_container\">").append("</div>");
            }
            out.println(sb.toString());
            List modalGroups = this.groupPanel.getPanelModel().getModalGroups(this.getPromptComponentModel());
            if (modalGroups != null) {
                for (PromptGroupPanelModelInterface modalGroup : modalGroups) {
                    if (!modalGroup.isModalChoiceGroup() || modalGroup.getModalChoiceGroupValue() == null || modalGroup.getModalChoiceGroupValue().equals(this.getPromptComponentModel().getPromptValue())) continue;
                    StringBuffer sbCont = new StringBuffer();
                    sbCont.append("<div").append(" id=\"").append(this.groupPanel.getPromptPropertyPanel().getId()).append("_").append(Util.getValidGroupName(modalGroup)).append("_PMG").append("_container\" style=\"display:none;\">").append("</div>");
                    out.println(sbCont.toString());
                }
            }
        }
        catch (Exception e) {
            LoggerRepository2.getLogger((String)PromptComponent.class.getName(), null).error(e.getMessage(), (Throwable)e);
        }
    }

    private boolean isRequired(PromptGroupPanelModelInterface group) {
        List components = group.getPromptComponentModels();
        for (int i = 0; i < components.size(); ++i) {
            if (!((PromptComponentModelInterface)components.get(i)).getPromptDefinition().isRequired()) continue;
            return true;
        }
        return false;
    }

    public boolean isRequired() {
        boolean required = this.getPromptComponentModel().getPromptDefinition().isRequired();
        List modalGroups = this.groupPanel.getPanelModel().getModalGroups(this.getPromptComponentModel());
        if (modalGroups != null) {
            for (PromptGroupPanelModelInterface modalGroup : modalGroups) {
                DefaultPromptGroupPanelModel obj;
                if (!(modalGroup instanceof DefaultPromptGroupPanelModel) || !((obj = (DefaultPromptGroupPanelModel)modalGroup).getGroup() instanceof ModalChoiceGroup) || required || !(required = this.isRequired(obj))) continue;
                return true;
            }
        }
        return required;
    }

    @Override
    public boolean isVisible() {
        if (this.isCascadedPrompt() && !this.isValueSetForAllDependentPromptViews(this.getPromptComponentModel())) {
            return false;
        }
        return super.isVisible();
    }

    private String getJSPromptType() {
        if (this.getPromptDefinition() instanceof BaseDefinitionRange || this.getPromptDefinition() instanceof SharedBaseDefinitionRange) {
            return PROMPT_COMPONENT_RANGE_TYPE;
        }
        if (this.isMultipleSelection()) {
            return PROMPT_COMPONENT_MULTIPLE_TYPE;
        }
        return PROMPT_COMPONENT_SINGLE_TYPE;
    }

    private boolean isMultipleSelection() {
        SelectableDefinitionInterface selectable;
        PromptDefinitionInterface promptDefinition = this.getPromptDefinition();
        if (promptDefinition instanceof DataSourceColumnDefinition) {
            return false;
        }
        return promptDefinition instanceof SelectableDefinitionInterface && ((selectable = (SelectableDefinitionInterface)promptDefinition).getSelectionType() == 302 || selectable.getSelectionType() == 301);
    }

    private String getJSParameters() {
        StringBuffer sb = new StringBuffer();
        sb.append("{promptName:'").append(this.promptName).append("', promptType:").append(this.getJSPromptType()).append(", componentId: '").append(this.getId() + "_pv").append("'");
        sb.append(", promptPropertyId: '").append(this.getPromptPropertiesPanel().getId()).append("'");
        sb.append(", groupName: '").append(this.getGroupPanel().getId()).append("'");
        sb.append(", uniqueId: '").append(this.getId()).append("'");
        sb.append(", required: ").append(this.promptDefinition.isRequired());
        boolean enabled = true;
        enabled = this.isVisible() || !this.getPromptPropertiesPanel().isShowInvalidDependentPrompts();
        sb.append(", enabled: ").append(enabled);
        sb.append("}");
        return sb.toString();
    }

    public static String getJSValue(Object obj, Locale locale) {
        if (obj instanceof String) {
            String value = Strings.replace((String)obj.toString(), (char[])SPECIAL_CHARS, (String[])REPLACEMENT_ELEMENTS);
            return "\"" + Strings.escapeForJavaScript((String)value) + "\"";
        }
        if (obj instanceof String[]) {
            return "[\"" + Strings.escapeForJavaScript((String)((String[])obj)[0]) + "\", \"" + Strings.escapeForJavaScript((String)((String[])obj)[1]) + "\"]";
        }
        if (obj instanceof Double[]) {
            return "[" + ((Double[])obj)[0] + ", " + ((Double[])obj)[1] + "]";
        }
        if (obj instanceof Integer[]) {
            return "[" + ((Integer[])obj)[0] + ", " + ((Integer[])obj)[1] + "]";
        }
        if (obj instanceof Date[]) {
            DateType dateType = new DateType();
            return "[\"" + dateType.getDisplayString((Object)((Date[])obj)[0], locale) + "\", \"" + dateType.getDisplayString((Object)((Date[])obj)[1], locale) + "\"]";
        }
        if (obj instanceof Integer) {
            return obj.toString();
        }
        return null;
    }

    private boolean isValueSetForAllDependentPromptViews(PromptViewInterface promptView) {
        Collection dependentViews = this.getPromptComponentModel().getDynamicPromptValuesContext().getDependentPromptViews(promptView);
        if (dependentViews != null) {
            for (PromptViewInterface view : dependentViews) {
                if (view.getPromptValue() != null && view.getPromptDefinition().isPromptValueValid(view.getPromptValue())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isCascadedPrompt() {
        PromptComponentModelInterface pcModel = this.getPromptComponentModel();
        DynamicPromptValueContextInterface pvContext = pcModel.getDynamicPromptValuesContext();
        if (pvContext != null) {
            Collection pvDependencies = pvContext.getDependentPromptViews((PromptViewInterface)pcModel);
            return pvDependencies != null && pvDependencies.size() > 0;
        }
        return false;
    }

    public void handleDependentPromptValueChange(PromptComponentModelInterface promptComponentModel, Locale locale) throws PromptValueNotFoundException {
        TransformationInterface tbean = this.promptValueComponentFactory.createComponent(promptComponentModel, this.groupPanel.getPanelModel(), this.getId(), this.dynamicPromptValueContext, this.isApplyVisible(), locale);
        PromptDefinitionInterface promptDefinition = promptComponentModel.getPromptDefinition();
        if (tbean instanceof JavaScriptObjectCreationInterface) {
            ((JavaScriptObjectCreationInterface)((Object)tbean)).setJavaScriptObjectCreationEnabled(true);
        }
        if (tbean != null) {
            tbean.setDescription(promptDefinition.getPromptLabel(locale));
        }
        this.initValueComponent(tbean);
        this.setComponent(PROMPT_COMPONENT, tbean);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected PromptGroupPanel getGroupPanel() {
        return this.groupPanel;
    }

    protected void setGroupPanel(PromptGroupPanel groupPanel) {
        this.groupPanel = groupPanel;
    }

    protected PromptPropertiesPanel getPromptPropertiesPanel() {
        PromptGroupPanel groupPanel = this.getGroupPanel();
        if (groupPanel == null) {
            return null;
        }
        return groupPanel.getPromptPropertyPanel();
    }

    static {
        JavaScriptIncludeHandler.addAlias(PromptComponent.class, "PROMPTCOMPONENT");
    }
}

