/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.components.webapp.util;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptViewInterface;
import com.sas.prompts.components.webapp.util.RB;
import com.sas.prompts.components.webapp.visuals.model.PromptComponentModelInterface;
import com.sas.prompts.definitions.ColorDefinitionInterface;
import com.sas.prompts.definitions.DataSourceColumnDefinitionInterface;
import com.sas.prompts.definitions.DataSourceDefinitionInterface;
import com.sas.prompts.definitions.DateDefinitionInterface;
import com.sas.prompts.definitions.DateRangeDefinitionInterface;
import com.sas.prompts.definitions.DoubleDefinitionInterface;
import com.sas.prompts.definitions.DoubleRangeDefinitionInterface;
import com.sas.prompts.definitions.InputFileDefinitionInterface;
import com.sas.prompts.definitions.IntegerDefinitionInterface;
import com.sas.prompts.definitions.IntegerRangeDefinitionInterface;
import com.sas.prompts.definitions.OutputFileDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.SASLibraryDefinitionInterface;
import com.sas.prompts.definitions.StringRangeDefinitionInterface;
import com.sas.prompts.definitions.TextDefinition;
import com.sas.prompts.definitions.TextDefinitionInterface;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.servlet.tbeans.BaseCompositeTransformation;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.datasource.DataSourceColumnItemListManager;
import com.sas.servlet.tbeans.datasource.DataSourceColumnPicker;
import com.sas.servlet.tbeans.datasource.DataSourcePicker;
import com.sas.servlet.tbeans.datasource.IFilePicker;
import com.sas.servlet.tbeans.datasource.SASLibraryPicker;
import com.sas.servlet.tbeans.datasource.directoryfile.DirectoryFilePicker;
import com.sas.servlet.tbeans.form.BaseFormElement;
import com.sas.servlet.tbeans.form.html.ComboBoxView;
import com.sas.servlet.tbeans.form.html.Password;
import com.sas.servlet.tbeans.form.html.TextArea;
import com.sas.servlet.tbeans.form.html.TextEntry;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.html.ColorPicker;
import com.sas.servlet.tbeans.html.DateIntervalPicker;
import com.sas.servlet.tbeans.html.DatePicker;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.html.TimePicker;
import com.sas.servlet.tbeans.html.TimeStampPicker;
import com.sas.servlet.tbeans.itemlistmanager.ItemListManagerTableView;
import com.sas.servlet.tbeans.models.Item;
import com.sas.servlet.tbeans.range.BaseRange;
import com.sas.servlet.tbeans.range.html.DateIntervalPickerRange;
import com.sas.servlet.tbeans.range.html.DatePickerRange;
import com.sas.servlet.tbeans.range.html.DoubleRange;
import com.sas.servlet.tbeans.range.html.IntegerRange;
import com.sas.servlet.tbeans.range.html.StringRange;
import com.sas.servlet.tbeans.range.html.TimePickerRange;
import com.sas.servlet.tbeans.range.html.TimeStampPickerRange;
import com.sas.servlet.tbeans.tableview.html.CellContentsLabelRenderer;
import com.sas.servlet.tbeans.util.validators.ServerSideInputValidator;
import com.sas.servlet.tbeans.valuepicker.ValuePickerTableCellRenderer;
import com.sas.util.DateTypes;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.SupportedSpecialValuesInterface;
import com.sas.util.ValueItem;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.transforms.ObjectToStringTransform;
import com.sas.util.transforms.TransformInterface;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;

public class PromptDefinitionComponentFactory {
    public static final String RB_KEY = "PromptDefinitionComponentFactory.";
    private static int entryFieldSize = 50;
    private static TimeZone GMT_TIMEZONE = TimeZone.getTimeZone("GMT");
    public static String APPLY_BUTTON = "APPLY_BUTTON";
    public static String RANGE_LABEL = "RANGE_LABEL";
    public static String PROMPT_RANGE_CONTAINER_STYLE = "PROMPT_RANGE_CONTAINER_STYLE";
    private static final ImmutableStyleInfo rangeStyle = new ImmutableStyleInfo("promptRangeContainer");

    private static ComboBoxModel getSpecialValuesComboModel(SupportedSpecialValues values, Locale locale, boolean intDefinition) {
        ValueItem node;
        DefaultComboBoxModel<ValueItem> model = new DefaultComboBoxModel<ValueItem>();
        if (values.isAllSupported()) {
            node = new ValueItem();
            node.setLabel(SpecialValues.toDisplayString((SpecialValues)SpecialValues.ALL, (Locale)locale));
            node.setValue((Object)SpecialValues.ALL);
            model.addElement(node);
        }
        if (values.isOtherSupported()) {
            node = new ValueItem();
            node.setLabel(SpecialValues.toDisplayString((SpecialValues)SpecialValues.OTHER, (Locale)locale));
            node.setValue((Object)SpecialValues.OTHER);
            model.addElement(node);
        }
        if (!values.isMissingValuesHiddenIfSupported() && values.isMissingValuesSupported()) {
            node = new ValueItem();
            if (intDefinition) {
                node.setLabel(MissingValues.toDisplayString((MissingValues)MissingValues.Dot, (Locale)locale));
                node.setValue((Object)".");
            } else {
                node.setLabel(MissingValues.toDisplayString((MissingValues)MissingValues._BLANK_, (Locale)locale));
                node.setValue((Object)MissingValues._BLANK_.toString());
            }
            model.addElement(node);
        }
        return model;
    }

    private static ComboBoxView getSpecialValuesComboBoxView(SupportedSpecialValuesInterface definition, Locale locale) {
        ComboBoxView comboBox = new ComboBoxView();
        comboBox.setEditable(true);
        comboBox.setRenderUsingIFrame(true);
        comboBox.setModel(PromptDefinitionComponentFactory.getSpecialValuesComboModel(definition.getSupportedSpecialValues(), locale, !(definition instanceof TextDefinition)));
        return comboBox;
    }

    public static TransformationInterface createComponent(PromptComponentModelInterface promptComponentModel, String componentId, DataProvider dataProvider, boolean applyVisible, Locale locale) {
        TransformationInterface promptValueComponent = null;
        PromptDefinitionInterface promptDefinition = promptComponentModel.getPromptDefinition();
        if (promptDefinition instanceof TextDefinitionInterface) {
            TextDefinitionInterface textDefinition = (TextDefinitionInterface)promptDefinition;
            if (textDefinition.isAllowMultipleLines()) {
                TextArea textArea = new TextArea();
                textArea.setRows(textDefinition.getDisplayedLines());
                textArea.setColumns(50);
                promptValueComponent = textArea;
            } else if (textDefinition.isMasked()) {
                Password password = new Password();
                password.setSize(entryFieldSize);
                if (textDefinition.getMaximumLength() > -1) {
                    password.setMaximumLength(textDefinition.getMaximumLength());
                }
                promptValueComponent = password;
            } else if (textDefinition.getValueProvider() == null && PromptUtil.isSpecialValuesAvailable((SupportedSpecialValues)textDefinition.getSupportedSpecialValues())) {
                promptValueComponent = PromptDefinitionComponentFactory.getSpecialValuesComboBoxView((SupportedSpecialValuesInterface)textDefinition, locale);
            } else {
                TextEntry textEntry = PromptDefinitionComponentFactory.createTextEntry();
                if (textDefinition.getMaximumLength() > -1) {
                    textEntry.setMaximumLength(textDefinition.getMaximumLength());
                }
                promptValueComponent = textEntry;
            }
        } else if (promptDefinition instanceof IntegerDefinitionInterface) {
            IntegerDefinitionInterface integerDefinition = (IntegerDefinitionInterface)promptDefinition;
            if (PromptUtil.isSpecialValuesAvailable((SupportedSpecialValues)integerDefinition.getSupportedSpecialValues())) {
                promptValueComponent = PromptDefinitionComponentFactory.getSpecialValuesComboBoxView((SupportedSpecialValuesInterface)integerDefinition, locale);
            } else {
                TextEntry intTextEntry = new TextEntry();
                intTextEntry.setSize(entryFieldSize);
                promptValueComponent = intTextEntry;
                intTextEntry.setPreValidationFunction(componentId + "_Obj.preValidation()");
                intTextEntry.setPostValidationFunction(componentId + "_Obj.postValidation()");
            }
            if (promptValueComponent instanceof BaseFormElement && integerDefinition.getSelectionType() != 300) {
                BaseFormElement element = promptValueComponent;
                element.setValidator(new ServerSideInputValidator("INTEGER"));
                element.setJavaScriptObjectCreationEnabled(true);
            }
        } else if (promptDefinition instanceof DoubleDefinitionInterface) {
            DoubleDefinitionInterface doubleDefinition = (DoubleDefinitionInterface)promptDefinition;
            if (PromptUtil.isSpecialValuesAvailable((SupportedSpecialValues)doubleDefinition.getSupportedSpecialValues())) {
                promptValueComponent = PromptDefinitionComponentFactory.getSpecialValuesComboBoxView((SupportedSpecialValuesInterface)doubleDefinition, locale);
            } else {
                TextEntry doubleTextEntry = new TextEntry();
                doubleTextEntry.setSize(entryFieldSize);
                promptValueComponent = doubleTextEntry;
                doubleTextEntry.setPreValidationFunction(componentId + "_Obj.preValidation()");
                doubleTextEntry.setPostValidationFunction(componentId + "_Obj.postValidation()");
            }
            if (promptValueComponent instanceof BaseFormElement && doubleDefinition.getSelectionType() != 300) {
                BaseFormElement element = promptValueComponent;
                element.setValidator(new ServerSideInputValidator("DOUBLE"));
                element.setJavaScriptObjectCreationEnabled(true);
            }
            if (promptValueComponent instanceof BaseTransformation) {
                ObjectToStringTransform transform = new ObjectToStringTransform(locale);
                transform.setNullString(null);
                ((BaseTransformation)promptValueComponent).setInputTransform((TransformInterface)transform);
            }
        } else if (promptDefinition instanceof IntegerRangeDefinitionInterface) {
            IntegerRangeDefinitionInterface intRangeDefinition = (IntegerRangeDefinitionInterface)promptDefinition;
            IntegerRange intRange = new IntegerRange();
            intRange.setMinimumLabel(intRangeDefinition.getMinLabel(locale));
            intRange.setMaximumLabel(intRangeDefinition.getMaxLabel(locale));
            promptValueComponent = intRange;
        } else if (promptDefinition instanceof DoubleRangeDefinitionInterface) {
            DoubleRangeDefinitionInterface doubleRangeDefinition = (DoubleRangeDefinitionInterface)promptDefinition;
            DoubleRange doubleRange = new DoubleRange();
            ObjectToStringTransform transform = new ObjectToStringTransform(locale);
            transform.setNullString(null);
            doubleRange.setInputTransform((TransformInterface)transform);
            doubleRange.setMinimumLabel(doubleRangeDefinition.getMinLabel(locale));
            doubleRange.setMaximumLabel(doubleRangeDefinition.getMaxLabel(locale));
            promptValueComponent = doubleRange;
        } else if (promptDefinition instanceof StringRangeDefinitionInterface) {
            StringRangeDefinitionInterface stringRangeDefinition = (StringRangeDefinitionInterface)promptDefinition;
            StringRange stringRange = new StringRange();
            stringRange.setMinimumLabel(stringRangeDefinition.getMinLabel(locale));
            stringRange.setMaximumLabel(stringRangeDefinition.getMaxLabel(locale));
            promptValueComponent = stringRange;
        } else if (promptDefinition instanceof DateDefinitionInterface) {
            promptValueComponent = PromptDefinitionComponentFactory.createDateComponent((DateDefinitionInterface)promptDefinition, componentId, locale);
        } else if (promptDefinition instanceof DateRangeDefinitionInterface) {
            promptValueComponent = PromptDefinitionComponentFactory.createDateRangeComponent((DateRangeDefinitionInterface)promptDefinition, componentId, locale);
        } else if (promptDefinition instanceof ColorDefinitionInterface) {
            ColorPicker colorPicker = new ColorPicker();
            colorPicker.setAllowCustomEntry(true);
            colorPicker.setAutomaticVisible(false);
            List defaultModel = colorPicker.getModel();
            Item color = colorPicker.getColorFromModel("transparent");
            int index = defaultModel.lastIndexOf(color);
            if (color != null && defaultModel.remove(index) == null) {
                System.out.println("Could not remove color 'transparent' from defaultModel.");
            }
            promptValueComponent = colorPicker;
        } else if (promptDefinition instanceof DataSourceDefinitionInterface) {
            if (dataProvider != null) {
                DataSourceDefinitionInterface dataSourceDefinition = (DataSourceDefinitionInterface)promptDefinition;
                promptValueComponent = new DataSourcePicker(dataProvider.getUserContext(), dataSourceDefinition.getAllowedDataSourceTypes());
            } else {
                LoggerRepository2.getLogger((String)PromptDefinitionComponentFactory.class.getName(), null).error("Dataprovider required for DataSourceDefinitionInterface");
            }
        } else if (promptDefinition instanceof DataSourceColumnDefinitionInterface) {
            if (dataProvider != null) {
                DataSourceColumnDefinitionInterface dataSourceColumnDefinition = (DataSourceColumnDefinitionInterface)promptDefinition;
                DataSourceColumnPicker dataSourcePicker = new DataSourceColumnPicker(dataProvider.getUserContext(), dataSourceColumnDefinition.getAllowedDataSourceTypes(), dataSourceColumnDefinition.getAllowedColumnTypes(), dataSourceColumnDefinition.getSelectionType(), dataSourceColumnDefinition.getDataSources());
                TransformationInterface t = dataSourcePicker.getComponent("DATASOURCECOLUMN_ITEMLISTMANAGER");
                if (t instanceof DataSourceColumnItemListManager) {
                    ValuePickerTableCellRenderer renderer = new ValuePickerTableCellRenderer(promptDefinition.getPromptDataType());
                    CellContentsLabelRenderer contentsRenderer = new CellContentsLabelRenderer();
                    renderer.setTableCellContentsRenderer(contentsRenderer);
                    ItemListManagerTableView table = (ItemListManagerTableView)((DataSourceColumnItemListManager)t).getComponent("ITEMLISTMANAGER_TABLE");
                    table.setDefaultRenderer(renderer);
                }
                dataSourcePicker.setMaximumValueCount(dataSourceColumnDefinition.getMaximumValueCount());
                dataSourcePicker.setAllowMultipleDataSource(dataSourceColumnDefinition.isAllowMultipleDataSources());
                promptValueComponent = dataSourcePicker;
            } else {
                LoggerRepository2.getLogger((String)PromptDefinitionComponentFactory.class.getName(), null).error("Dataprovider required for DataSourceColumnDefinitionInterface");
            }
        } else if (promptDefinition instanceof InputFileDefinitionInterface) {
            if (dataProvider != null) {
                InputFileDefinitionInterface inputFileDefinition = (InputFileDefinitionInterface)promptDefinition;
                String logicalServerName = inputFileDefinition.getLogicalServerName();
                List fileTypes = inputFileDefinition.getFileTypes();
                if (inputFileDefinition.getFileSelectionMode() == 0) {
                    DirectoryFilePicker dsp = new DirectoryFilePicker(dataProvider.getUserContext(), logicalServerName, fileTypes);
                    dsp.setLogicalServerName(logicalServerName);
                    dsp.setType("INPUT_TYPE");
                    promptValueComponent = dsp;
                } else if (inputFileDefinition.getFileSelectionMode() == 2) {
                    DirectoryFilePicker dsp = new DirectoryFilePicker(dataProvider.getUserContext(), logicalServerName, fileTypes);
                    dsp.setDirectoriesOnlyCheckBoxVisible(false);
                    dsp.setDirectoriesOnly(true);
                    dsp.setType("INPUT_TYPE");
                    dsp.setLogicalServerName(logicalServerName);
                    promptValueComponent = dsp;
                } else {
                    IFilePicker filePicker = new IFilePicker(dataProvider.getUserContext(), logicalServerName, fileTypes);
                    filePicker.setLogicalServerName(logicalServerName);
                    filePicker.setType("INPUT_TYPE");
                    promptValueComponent = filePicker;
                }
            } else {
                LoggerRepository2.getLogger((String)PromptDefinitionComponentFactory.class.getName(), null).error("Dataprovider required for InputFileDefinitionInterface");
            }
        } else if (promptDefinition instanceof OutputFileDefinitionInterface) {
            if (dataProvider != null) {
                OutputFileDefinitionInterface outputFileDefinition = (OutputFileDefinitionInterface)promptDefinition;
                String logicalServerName = outputFileDefinition.getLogicalServerName();
                List fileTypes = outputFileDefinition.getFileTypes();
                if (outputFileDefinition.getFileSelectionMode() == 0) {
                    DirectoryFilePicker dsp = new DirectoryFilePicker(dataProvider.getUserContext(), logicalServerName, fileTypes);
                    dsp.setLogicalServerName(logicalServerName);
                    promptValueComponent = dsp;
                } else if (outputFileDefinition.getFileSelectionMode() == 2) {
                    DirectoryFilePicker dsp = new DirectoryFilePicker(dataProvider.getUserContext(), logicalServerName, fileTypes);
                    dsp.setDirectoriesOnlyCheckBoxVisible(false);
                    dsp.setDirectoriesOnly(true);
                    dsp.setLogicalServerName(logicalServerName);
                    promptValueComponent = dsp;
                } else {
                    IFilePicker filePicker = new IFilePicker(dataProvider.getUserContext(), logicalServerName, fileTypes);
                    filePicker.setLogicalServerName(logicalServerName);
                    promptValueComponent = filePicker;
                }
            } else {
                LoggerRepository2.getLogger((String)PromptDefinitionComponentFactory.class.getName(), null).error("Dataprovider required for OutputFileDefinitionInterface");
            }
        } else if (promptDefinition instanceof SASLibraryDefinitionInterface) {
            promptValueComponent = new SASLibraryPicker(dataProvider.getUserContext());
        }
        if (promptValueComponent instanceof BaseRange) {
            PromptDefinitionComponentFactory.setupRangeComponent((BaseRange)promptValueComponent, promptComponentModel, applyVisible, locale);
            ((BaseRange)promptValueComponent).setErrorHandlerFunctionName(componentId + "_Obj.reset()");
        }
        return promptValueComponent;
    }

    public static TextEntry createTextEntry() {
        TextEntry textEntry = new TextEntry();
        textEntry.setSize(entryFieldSize);
        return textEntry;
    }

    private static TransformationInterface createDateComponent(DateDefinitionInterface dateDefinition, String componentId, Locale locale) {
        BaseCompositeTransformation promptValueComponent = null;
        if (dateDefinition.getDateType() == DateTypes.DATE) {
            promptValueComponent = new DatePicker();
            ((DatePicker)promptValueComponent).setRelativeValuesIncluded(true);
            ((DatePicker)promptValueComponent).setTimeZone(GMT_TIMEZONE);
        } else if (dateDefinition.getDateType() == DateTypes.WEEKDAY) {
            promptValueComponent = new DateIntervalPicker();
            ((DateIntervalPicker)promptValueComponent).setType(DateTypes.WEEKDAY);
            ((DateIntervalPicker)promptValueComponent).setRelativeValuesIncluded(true);
        } else if (dateDefinition.getDateType() == DateTypes.WEEK) {
            promptValueComponent = new DateIntervalPicker();
            ((DateIntervalPicker)promptValueComponent).setType(DateTypes.WEEK);
            ((DateIntervalPicker)promptValueComponent).setRelativeValuesIncluded(true);
        } else if (dateDefinition.getDateType() == DateTypes.MONTH) {
            promptValueComponent = new DateIntervalPicker();
            ((DateIntervalPicker)promptValueComponent).setType(DateTypes.MONTH);
            ((DateIntervalPicker)promptValueComponent).setRelativeValuesIncluded(true);
        } else if (dateDefinition.getDateType() == DateTypes.QUARTER) {
            promptValueComponent = new DateIntervalPicker();
            ((DateIntervalPicker)promptValueComponent).setType(DateTypes.QUARTER);
            ((DateIntervalPicker)promptValueComponent).setRelativeValuesIncluded(true);
        } else if (dateDefinition.getDateType() == DateTypes.YEAR) {
            promptValueComponent = new DateIntervalPicker();
            ((DateIntervalPicker)promptValueComponent).setType(DateTypes.YEAR);
            ((DateIntervalPicker)promptValueComponent).setRelativeValuesIncluded(true);
        } else if (dateDefinition.getDateType() == DateTypes.TIME) {
            promptValueComponent = new TimePicker();
            ((TimePicker)promptValueComponent).setRelativeValuesIncluded(true);
            ((TimePicker)promptValueComponent).setTimeZone(GMT_TIMEZONE);
        } else if (dateDefinition.getDateType() == DateTypes.TIMESTAMP) {
            promptValueComponent = new TimeStampPicker();
            ((TimeStampPicker)promptValueComponent).setRelativeValuesIncluded(true);
            ((TimeStampPicker)promptValueComponent).setTimeZone(GMT_TIMEZONE);
        }
        if (promptValueComponent != null && dateDefinition.isDefaultValueSet()) {
            promptValueComponent.setObjectData(dateDefinition.getDefaultValue());
        }
        if (PromptUtil.isSpecialValuesAvailable((SupportedSpecialValues)dateDefinition.getSupportedSpecialValues())) {
            if (promptValueComponent instanceof DatePicker) {
                ((DatePicker)promptValueComponent).setModel(PromptDefinitionComponentFactory.getSpecialValuesComboModel(dateDefinition.getSupportedSpecialValues(), locale, true));
            } else if (promptValueComponent instanceof DateIntervalPicker) {
                ((DateIntervalPicker)promptValueComponent).setModel(PromptDefinitionComponentFactory.getSpecialValuesComboModel(dateDefinition.getSupportedSpecialValues(), locale, true));
            } else if (promptValueComponent instanceof TimePicker) {
                ((TimePicker)promptValueComponent).setModel(PromptDefinitionComponentFactory.getSpecialValuesComboModel(dateDefinition.getSupportedSpecialValues(), locale, true));
            } else if (promptValueComponent instanceof TimeStampPicker) {
                ((TimeStampPicker)promptValueComponent).setModel(PromptDefinitionComponentFactory.getSpecialValuesComboModel(dateDefinition.getSupportedSpecialValues(), locale, true));
            }
        }
        return promptValueComponent;
    }

    private static void setupRangeComponent(BaseRange rangeComponent, PromptComponentModelInterface promptComponentModel, boolean applyVisible, Locale locale) {
        rangeComponent.setTemplateKey("Prompt_Range");
        rangeComponent.getStyleMap().put(PROMPT_RANGE_CONTAINER_STYLE, rangeStyle);
        boolean hasDependent = false;
        if (promptComponentModel.getDynamicPromptValuesContext() != null) {
            hasDependent = promptComponentModel.getDynamicPromptValuesContext().hasDependent((PromptViewInterface)promptComponentModel);
        }
        if (applyVisible || hasDependent) {
            Button btn = new Button();
            btn.setLabel(RB.getStringResource(RB_KEY, "apply.txt", locale));
            btn.setEnabled(false);
            btn.setId(rangeComponent.getId() + "_applyButton");
            rangeComponent.setComponent(APPLY_BUTTON, btn);
        }
        Label label = new Label();
        label.setText(RB.getStringResource(RB_KEY, "range.txt", locale));
        rangeComponent.setComponent(RANGE_LABEL, label);
    }

    private static TransformationInterface createDateRangeComponent(DateRangeDefinitionInterface dateRangeDefinition, String componentId, Locale locale) {
        if (dateRangeDefinition.getDateType() == DateTypes.DATE) {
            DatePickerRange datePickerRange = new DatePickerRange();
            datePickerRange.setTimeZone(GMT_TIMEZONE);
            datePickerRange.setErrorHandlerFunctionName(componentId + "_Obj.reset()");
            datePickerRange.setMinimumLabel(dateRangeDefinition.getMinLabel(locale));
            datePickerRange.setMaximumLabel(dateRangeDefinition.getMaxLabel(locale));
            return datePickerRange;
        }
        if (dateRangeDefinition.getDateType() == DateTypes.WEEKDAY) {
            DateIntervalPickerRange dateIntervalRange = new DateIntervalPickerRange();
            dateIntervalRange.setErrorHandlerFunctionName(componentId + "_Obj.reset()");
            dateIntervalRange.setType(DateTypes.WEEKDAY);
            dateIntervalRange.setMinimumLabel(dateRangeDefinition.getMinLabel(locale));
            dateIntervalRange.setMaximumLabel(dateRangeDefinition.getMaxLabel(locale));
            return dateIntervalRange;
        }
        if (dateRangeDefinition.getDateType() == DateTypes.WEEK) {
            DateIntervalPickerRange dateIntervalRange = new DateIntervalPickerRange();
            dateIntervalRange.setErrorHandlerFunctionName(componentId + "_Obj.reset()");
            dateIntervalRange.setType(DateTypes.WEEK);
            dateIntervalRange.setMinimumLabel(dateRangeDefinition.getMinLabel(locale));
            dateIntervalRange.setMaximumLabel(dateRangeDefinition.getMaxLabel(locale));
            return dateIntervalRange;
        }
        if (dateRangeDefinition.getDateType() == DateTypes.MONTH) {
            DateIntervalPickerRange dateIntervalRange = new DateIntervalPickerRange();
            dateIntervalRange.setErrorHandlerFunctionName(componentId + "_Obj.reset()");
            dateIntervalRange.setType(DateTypes.MONTH);
            dateIntervalRange.setMinimumLabel(dateRangeDefinition.getMinLabel(locale));
            dateIntervalRange.setMaximumLabel(dateRangeDefinition.getMaxLabel(locale));
            return dateIntervalRange;
        }
        if (dateRangeDefinition.getDateType() == DateTypes.QUARTER) {
            DateIntervalPickerRange dateIntervalRange = new DateIntervalPickerRange();
            dateIntervalRange.setErrorHandlerFunctionName(componentId + "_Obj.reset()");
            dateIntervalRange.setType(DateTypes.QUARTER);
            dateIntervalRange.setMinimumLabel(dateRangeDefinition.getMinLabel(locale));
            dateIntervalRange.setMaximumLabel(dateRangeDefinition.getMaxLabel(locale));
            return dateIntervalRange;
        }
        if (dateRangeDefinition.getDateType() == DateTypes.YEAR) {
            DateIntervalPickerRange dateIntervalRange = new DateIntervalPickerRange();
            dateIntervalRange.setErrorHandlerFunctionName(componentId + "_Obj.reset()");
            dateIntervalRange.setType(DateTypes.YEAR);
            dateIntervalRange.setMinimumLabel(dateRangeDefinition.getMinLabel(locale));
            dateIntervalRange.setMaximumLabel(dateRangeDefinition.getMaxLabel(locale));
            return dateIntervalRange;
        }
        if (dateRangeDefinition.getDateType() == DateTypes.TIME) {
            TimePickerRange timePickerRange = new TimePickerRange();
            timePickerRange.setErrorHandlerFunctionName(componentId + "_Obj.reset()");
            timePickerRange.setTimeZone(GMT_TIMEZONE);
            timePickerRange.setMinimumLabel(dateRangeDefinition.getMinLabel(locale));
            timePickerRange.setMaximumLabel(dateRangeDefinition.getMaxLabel(locale));
            return timePickerRange;
        }
        if (dateRangeDefinition.getDateType() == DateTypes.TIMESTAMP) {
            TimeStampPickerRange timeStampPickerRange = new TimeStampPickerRange();
            timeStampPickerRange.setErrorHandlerFunctionName(componentId + "_Obj.reset()");
            timeStampPickerRange.setTimeZone(GMT_TIMEZONE);
            timeStampPickerRange.setMinimumLabel(dateRangeDefinition.getMinLabel(locale));
            timeStampPickerRange.setMaximumLabel(dateRangeDefinition.getMaxLabel(locale));
            return timeStampPickerRange;
        }
        return null;
    }
}

