/*
 * Decompiled with CFR 0.152.
 */
package com.sas.entities.edit.visuals.servlet;

import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeGroup;
import com.sas.entities.AttributeGroupInterface;
import com.sas.entities.AttributeSetException;
import com.sas.entities.AttributeTypeInterface;
import com.sas.entities.RemoteEntityInterface;
import com.sas.entities.edit.visuals.AttributeValueEditorInterface;
import com.sas.entities.edit.visuals.EntityEditors;
import com.sas.entities.edit.visuals.LabelTextInterface;
import com.sas.entities.edit.visuals.ObjectDataMethodInterface;
import com.sas.entities.edit.visuals.servlet.DualListSelectorEditor;
import com.sas.entities.edit.visuals.servlet.StringValueEditor;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.dualselector.html.DualSelector;
import com.sas.servlet.tbeans.form.html.Form;
import com.sas.servlet.tbeans.form.html.FormViewInterface;
import com.sas.servlet.tbeans.form.html.Hidden;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.Classes;
import com.sas.util.Util;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public class EntityPromptPagePropertySheet
extends BaseTransformation
implements FormViewInterface {
    public static final String RB_KEY = "EntityPromptPagePropertySheet.";
    protected static final String DEFAULT_EDITOR = EntityEditors.getEditorClassName((String)EntityEditors.STRING_EDITOR, (String)"Servlet");
    protected static final String LABEL_EDITOR = EntityEditors.getEditorClassName((String)EntityEditors.STATIC_STRING_EDITOR, (String)"Servlet");
    protected RemoteEntityInterface model;
    protected AttributeGroup attributeGroup;
    private Locale locale;
    private boolean displaySubgroups;
    protected HashMap nameMappings;
    protected HashMap editorMappings;
    private Form formObject;
    private String styleClassPrefix;
    private HashMap additionalParameters;
    private boolean resetSubmitButtonsVisible;
    private String dualSelectorName;
    private String submitFunction;
    private boolean formEnabled;
    private CommonLoggerInterface log = null;
    private static final String NAME_PREFIX = "eppps";

    public EntityPromptPagePropertySheet() {
        this.setId(Util.getName((String)NAME_PREFIX));
        this.log = LoggerRepository2.getLogger((String)EntityPromptPagePropertySheet.class.getPackage().getName(), null);
        this.formObject = null;
        this.initialize();
        this.submitFunction = "sas_EntityFormPropertySheet_validateAttributes('" + this.getFormObject().getName() + "')";
    }

    public EntityPromptPagePropertySheet(Locale locale) {
        this.setId(Util.getName((String)NAME_PREFIX));
        this.log = LoggerRepository2.getLogger((String)EntityPromptPagePropertySheet.class.getPackage().getName(), null);
        this.setLocale(locale);
        this.initialize();
        this.submitFunction = "sas_EntityFormPropertySheet_validateAttributes('" + this.getFormObject().getName() + "')";
    }

    protected void initialize() {
        this.setFormEnabled(true);
    }

    public RemoteEntityInterface getModel() {
        return this.model;
    }

    public void setModel(RemoteEntityInterface entityModel) {
        this.model = entityModel;
        try {
            this.attributeGroup = (AttributeGroup)entityModel.getAttributeGroup();
            if (this.model != null && this.attributeGroup != null) {
                this.createAttributeEditors();
                super.setLocale(this.locale);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createAttributeEditors() {
        this.editorMappings = new HashMap();
        String[] al = this.attributeGroup.getAttributeDescriptorNames(true);
        int listSize = al.length;
        AttributeValueEditorInterface editor = null;
        Class editorClass = null;
        String editorName = null;
        for (int i = 0; i < listSize; ++i) {
            AttributeDescriptorInterface adi = this.attributeGroup.getAttributeDescriptor(al[i], true);
            String attributeName = adi.getName();
            if (attributeName.equals("entityKey") || attributeName.equals("prototype")) continue;
            editorName = adi == null ? null : (!adi.isModifiable() ? LABEL_EDITOR : adi.getEditor("Servlet"));
            try {
                if (editorName == null) {
                    editorClass = Classes.loadClass((String)DEFAULT_EDITOR, null, (Object)this);
                    editor = this.createDefaultEditor();
                    continue;
                }
                editorClass = Classes.loadClass((String)editorName, null, (Object)this);
                editor = (AttributeValueEditorInterface)editorClass.newInstance();
                ((BaseTransformation)editor).setName(adi.getName());
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                String className = EntityEditors.getEditorClassName((String)editorName, (String)"Servlet");
                if (className != null) {
                    try {
                        editorClass = Classes.loadClass((String)className, null, (Object)this);
                        editor = (AttributeValueEditorInterface)editorClass.newInstance();
                        ((BaseTransformation)editor).setName(adi.getName());
                    }
                    catch (Exception e) {
                        editor = this.createDefaultEditor();
                    }
                    continue;
                }
                editor = this.createDefaultEditor();
                continue;
            }
            catch (InstantiationException ie) {
                editor = this.createDefaultEditor();
                continue;
            }
            catch (IllegalAccessException ie) {
                editor = this.createDefaultEditor();
                continue;
            }
            catch (ExceptionInInitializerError eie) {
                editor = this.createDefaultEditor();
                continue;
            }
            catch (SecurityException se) {
                editor = this.createDefaultEditor();
                continue;
            }
            catch (Exception ee) {
                editor = this.createDefaultEditor();
                continue;
            }
            finally {
                if (this.getStyleClassPrefix() != null) {
                    if (editor instanceof DualListSelectorEditor) {
                        ((DualListSelectorEditor)editor).setStyleClassPrefix(this.styleClassPrefix);
                    } else if (editor instanceof StringValueEditor) {
                        ((StringValueEditor)editor).setStyleInfo(new StyleInfo(this.styleClassPrefix + "textEditor"));
                    }
                }
                editor.setEditInfo(this.model, al[i]);
                if (adi.isVisible()) {
                    this.editorMappings.put(adi, editor);
                }
            }
        }
    }

    protected AttributeValueEditorInterface createDefaultEditor() {
        AttributeValueEditorInterface editor = null;
        try {
            Class editorClass = Classes.loadClass((String)DEFAULT_EDITOR, null, (Object)this);
            editor = (AttributeValueEditorInterface)editorClass.newInstance();
            return editor;
        }
        catch (ClassNotFoundException classNotFoundException) {}
        catch (InstantiationException instantiationException) {}
        catch (IllegalAccessException illegalAccessException) {}
        catch (Exception exception) {}
        finally {
            return editor;
        }
    }

    @Override
    public void setFormObject(Form form) {
        this.formObject = form;
    }

    @Override
    public Form getFormObject() {
        if (this.formObject == null) {
            this.formObject = this.getDefaultFormObject();
        }
        this.formObject.setRequest(this.getRequest());
        this.formObject.setResponse(this.getResponse());
        this.formObject.setLocale(this.getLocale());
        return this.formObject;
    }

    @Override
    public Form getDefaultFormObject() {
        if (this.formObject == null) {
            HttpServletResponse response;
            this.formObject = new Form(this.getId() + "_Form");
            this.formObject.setValidationEnabled(true);
            String action = "";
            this.formObject.setMethod("post");
            HttpServletRequest request = this.getRequest();
            if (request != null) {
                action = request.getRequestURI();
            }
            if ((response = this.getResponse()) != null) {
                String string = response.encodeURL(action);
            }
        }
        return this.formObject;
    }

    public void writeFormHeader(Writer out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.writeFormHeader(o);
        o.flush();
    }

    public void writeFormHeader(OutputStream out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.writeFormHeader(o);
        o.flush();
    }

    public void writeFormHeader(PrintWriter out) throws IOException {
        this.getFormObject().writeHeader(out);
    }

    public void writeFormFooter(Writer out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.writeFormFooter(o);
        o.flush();
    }

    public void writeFormFooter(OutputStream out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.writeFormFooter(o);
        o.flush();
    }

    public void writeFormFooter(PrintWriter out) throws IOException {
        this.getFormObject().writeFooter(out);
    }

    protected void writeHeader(PrintWriter out) throws IOException {
        out.println("<table >");
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        Object editor = null;
        Set keySet = this.editorMappings.keySet();
        Iterator iter = keySet.iterator();
        AttributeDescriptorInterface ad = null;
        AttributeTypeInterface at = null;
        while (iter.hasNext()) {
            ad = (AttributeDescriptorInterface)iter.next();
            editor = this.editorMappings.get(ad);
            String[] val = this.getRequest().getParameterValues(((BaseTransformation)editor).getName());
            if (val == null) continue;
            try {
                at = ad.getType();
                if (at == null) continue;
                if (at.getSQLType() != 2003) {
                    this.model.setAttribute(ad.getName(), (Object)val[0]);
                } else {
                    this.model.setAttribute(ad.getName(), (Object)val);
                }
                ((ObjectDataMethodInterface)editor).setObjectDataMethod(val);
            }
            catch (AttributeSetException ase) {
                this.log.error("", (Throwable)ase);
            }
        }
        if (this.isFormEnabled()) {
            this.writeFormHeader(out);
        }
        this.writeHeader(out);
        HashMap map = this.getAdditionalParameters();
        if (map != null) {
            Set keys = map.keySet();
            for (String name : keys) {
                String value = (String)map.get(name);
                Hidden.writeElement(out, null, name, value, true);
            }
        }
        AttributeGroupInterface[] agi = this.attributeGroup.getAttributeGroups();
        int groupSize = agi.length;
        int colspan = 2;
        Label label = null;
        for (int i = 0; i < groupSize; ++i) {
            out.println("<tr><td valign=\"top\">" + (i + 1) + ".</td>");
            out.println("<td colspan=\"2\" >");
            label = new Label(agi[i].getLabel(this.getLocale()));
            label.setResponse(this.getResponse());
            label.setRequest(this.getRequest());
            label.setLocale(this.getLocale());
            label.write(out);
            out.println("</td></tr>");
            AttributeDescriptorInterface[] adi = agi[i].getAttributeDescriptors(false);
            int attributeSize = adi.length;
            for (int j = 0; j < attributeSize; ++j) {
                if (!adi[j].isVisible()) continue;
                out.println("<tr>");
                editor = this.editorMappings.get(adi[j]);
                if (editor instanceof BaseTransformation) {
                    ((BaseTransformation)editor).setRequest(this.getRequest());
                    ((BaseTransformation)editor).setResponse(this.getResponse());
                    ((BaseTransformation)editor).setLocale(this.getLocale());
                }
                if (editor instanceof TransformationInterface) {
                    this.getFormObject().addComponent(editor);
                }
                out.println("<td>&#160;</td>");
                if (editor instanceof DualListSelectorEditor) {
                    ((DualListSelectorEditor)editor).setFormObject(this.getFormObject());
                    this.dualSelectorName = ((DualSelector)editor).getName();
                }
                if (editor instanceof LabelTextInterface) {
                    String text = ((LabelTextInterface)editor).getLabelText();
                    if (text != null) {
                        out.println("<td nowrap=\"nowrap\">" + text + "</td>");
                    } else {
                        out.println("<td>&#160;</td>");
                    }
                } else {
                    out.println("<td>&#160;</td>");
                }
                out.println("<td width=\"100%\" >");
                ((BaseTransformation)editor).write(out);
                out.println("</td>");
                out.println("</tr>");
            }
        }
        out.println("</table>");
        if (this.isFormEnabled()) {
            this.writeFormFooter(out);
        }
        this.writeJavaScript(out);
        this.cleanUpResources();
    }

    public String getSubmitFunction() {
        return this.submitFunction;
    }

    public void writeJavaScript(PrintWriter out) {
        StringBuffer javaScript = new StringBuffer();
        javaScript.append(JavaScriptIncludeHandler.getStartScript());
        javaScript.append("<!--//\n");
        javaScript.append("function sas_EntityFormPropertySheet_validateAttributes(formName)\n");
        javaScript.append("{\n");
        String onSubmit = this.getFormObject().getOnSubmitFunctionCall();
        if (onSubmit == null) {
            javaScript.append("document.forms[formName].submit();\n");
        } else {
            javaScript.append("if (" + onSubmit + ")\n ");
            javaScript.append("document.forms[formName].submit();\n");
        }
        javaScript.append("}\n");
        javaScript.append("//-->\n");
        javaScript.append(JavaScriptIncludeHandler.getEndScript(null));
        out.println(javaScript.toString());
    }

    @Override
    public HashMap getAdditionalParameters() {
        return this.additionalParameters;
    }

    @Override
    public void setAdditionalParameters(HashMap map) {
        this.additionalParameters = map;
    }

    @Override
    public void setAdditionalParameter(String name, String value) {
        if (this.additionalParameters == null) {
            this.additionalParameters = new HashMap();
        }
        this.additionalParameters.put(name, value);
    }

    @Override
    public boolean isFormEnabled() {
        return this.formEnabled;
    }

    @Override
    public void setFormEnabled(boolean value) {
        this.formEnabled = value;
    }

    public String getStyleClassPrefix() {
        return this.styleClassPrefix;
    }

    public void setStyleClassPrefix(String value) {
        this.styleClassPrefix = value;
    }
}

