/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.dataselectors.exceptionhighlighting;

import com.sas.codepolicy.SASScope;
import com.sas.commands.dataselectors.exceptionhighlighting.RuleExtension;
import com.sas.dataselectors.exceptionhighlighting.ExceptionHighlightingOLAPRuleInterface;
import com.sas.dataselectors.exceptionhighlighting.ExceptionHighlightingRuleInterface;
import com.sas.dataselectors.exceptionhighlighting.ExceptionHighlightingSelectorInterface;
import com.sas.rpf.Context;
import com.sas.rpf.RuleInterface;
import com.sas.rpf.TargetInterface;
import com.sas.rpf.exception.ParseException;
import com.sas.servlet.tbeans.olaptableview.html.OLAPTableView;
import com.sas.servlet.tbeans.tableview.AbstractBaseTableView;
import com.sas.servlet.tbeans.tableview.TableCellRenderer;
import com.sas.servlet.tbeans.tableview.TableColumn;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.servlet.tbeans.tableview.rpf.ActionLocation;
import com.sas.servlet.tbeans.tableview.rpf.html.ConditionTableCellRenderer;
import com.sas.servlet.tbeans.tableview.rpf.html.ImageAction;
import com.sas.servlet.tbeans.tableview.rpf.html.StyleAction;
import com.sas.servlet.tbeans.tableview.rpf.html.TextAction;
import com.sas.storage.iquery.BusinessQueryToTableModelAdapter;
import com.sas.swing.visuals.olaptableview.OLAPTableFormatArea;
import com.sas.swing.visuals.tableview.TableFormatAreaInterface;
import com.sas.swing.visuals.tableview.UniqueIDTableFormatArea;
import com.sas.table.TableException;
import com.sas.util.log.LoggerRepository2;
import java.util.Enumeration;
import java.util.Map;

@SASScope
public class ExceptionHighlightingSelectorToRulesContextAdapter {
    public static Context getRulesContext(ExceptionHighlightingSelectorInterface ehsModel) {
        Context context = new Context();
        Map ehsRules = ehsModel.getRules();
        for (String ruleKey : ehsRules.keySet()) {
            ExceptionHighlightingRuleInterface ehsRule = (ExceptionHighlightingRuleInterface)ehsRules.get(ruleKey);
            context.addRule(ExceptionHighlightingSelectorToRulesContextAdapter.convertRule(ehsRule, context));
        }
        return context;
    }

    public static Context getRulesContext(ExceptionHighlightingSelectorInterface ehsModel, AbstractBaseTableView table) {
        Context context = new Context();
        Map ehsRules = ehsModel.getRules();
        for (String ruleKey : ehsRules.keySet()) {
            ExceptionHighlightingRuleInterface ehsRule = (ExceptionHighlightingRuleInterface)ehsRules.get(ruleKey);
            context.addRule(ExceptionHighlightingSelectorToRulesContextAdapter.convertRule(ehsRule, table, context));
        }
        return context;
    }

    public static RuleInterface convertRule(ExceptionHighlightingRuleInterface ehsRule, Context context) {
        RuleExtension rpfRule = null;
        boolean isMeasure = ehsRule.isMeasure();
        try {
            rpfRule = new RuleExtension(ehsRule.getExpression());
            rpfRule.setExceptionHighlightingRule(ehsRule);
            StyleAction style = new StyleAction();
            if (ehsRule.getFillColor() != null && !"".equals(ehsRule.getFillColor())) {
                style.setActionAttribute("BACKGROUND-COLOR", ehsRule.getFillColor());
            }
            if (ehsRule.getFontColor() != null && !"".equals(ehsRule.getFontColor())) {
                style.setActionAttribute("COLOR", ehsRule.getFontColor());
            }
            if (ehsRule.getFont() != null && !ehsRule.getFont().equals("DEFAULT")) {
                style.setActionAttribute("FONT-FAMILY", ehsRule.getFont());
            }
            if (ehsRule.getFontSize() != null && !ehsRule.getFontSize().equals("DEFAULT")) {
                style.setActionAttribute("FONT-SIZE", ehsRule.getFontSize());
            }
            if (ehsRule.isBold()) {
                style.setActionAttribute("FONT-WEIGHT", "bold");
            }
            if (ehsRule.isItalic()) {
                style.setActionAttribute("FONT-STYLE", "italic");
            }
            if (ehsRule.isUnderline()) {
                style.setActionAttribute("TEXT-DECORATION", "underline");
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage());
        }
        return rpfRule;
    }

    public static RuleInterface convertRule(ExceptionHighlightingRuleInterface ehsRule, AbstractBaseTableView table, Context context) {
        RuleExtension rpfRule = null;
        boolean isMeasure = ehsRule.isMeasure();
        try {
            rpfRule = new RuleExtension(ehsRule.getExpression());
            rpfRule.setExceptionHighlightingRule(ehsRule);
            StyleAction style = new StyleAction();
            if (ehsRule.getFillColor() != null && !"".equals(ehsRule.getFillColor())) {
                style.setActionAttribute("BACKGROUND-COLOR", ehsRule.getFillColor());
            }
            if (ehsRule.getFontColor() != null && !"".equals(ehsRule.getFontColor())) {
                style.setActionAttribute("COLOR", ehsRule.getFontColor());
            }
            if (ehsRule.getFont() != null && !ehsRule.getFont().equals("DEFAULT")) {
                style.setActionAttribute("FONT-FAMILY", ehsRule.getFont());
            }
            if (ehsRule.getFontSize() != null && !ehsRule.getFontSize().equals("DEFAULT")) {
                style.setActionAttribute("FONT-SIZE", ehsRule.getFontSize());
            }
            if (ehsRule.isBold()) {
                style.setActionAttribute("FONT-WEIGHT", "bold");
            }
            if (ehsRule.isItalic()) {
                style.setActionAttribute("FONT-STYLE", "italic");
            }
            if (ehsRule.isUnderline()) {
                style.setActionAttribute("TEXT-DECORATION", "underline");
            }
            String ass = ehsRule.getAssignment();
            if (table instanceof TableView && "rowBased".equals(ass)) {
                ExceptionHighlightingSelectorToRulesContextAdapter.applyWholeRowRule((TableView)table, rpfRule, style);
            } else {
                ConditionTableCellRenderer target = ExceptionHighlightingSelectorToRulesContextAdapter.determineTarget(context, ehsRule);
                rpfRule.setTarget(target);
                ExceptionHighlightingSelectorToRulesContextAdapter.attachTargetToViewer(target, table, ehsRule);
                ExceptionHighlightingSelectorToRulesContextAdapter.addActions(rpfRule, style, target);
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage());
        }
        return rpfRule;
    }

    private static void applyWholeRowRule(TableView relTable, RuleExtension rpfRule, StyleAction style) {
        rpfRule.setWholeRow(true);
        int columnCount = relTable.getColumnModel().getColumnCount();
        RuleExtension wholeRowRule = ExceptionHighlightingSelectorToRulesContextAdapter.findWholeRowRule(relTable.getRulesContext());
        TargetInterface[] targets = null;
        if (wholeRowRule != null) {
            targets = wholeRowRule.getTargets();
        }
        for (int col = 0; col < columnCount; ++col) {
            ConditionTableCellRenderer target = null;
            if (targets != null && col < targets.length) {
                target = targets[col];
            } else {
                target = new ConditionTableCellRenderer();
                relTable.setCellRenderer(1, -1, 1, col + 1, col + 1, 1, target);
            }
            ExceptionHighlightingSelectorToRulesContextAdapter.addActions(rpfRule, style, target);
        }
    }

    private static RuleExtension findWholeRowRule(Context context) {
        if (context == null) {
            return null;
        }
        for (RuleExtension rule : context.getRules()) {
            if (!rule.isWholeRow()) continue;
            return rule;
        }
        return null;
    }

    private static void addActions(RuleExtension rpfRule, StyleAction style, TargetInterface target) {
        rpfRule.add(target, style);
        ExceptionHighlightingSelectorToRulesContextAdapter.addImageAction(rpfRule, target);
        ExceptionHighlightingSelectorToRulesContextAdapter.addTextAction(rpfRule, target);
    }

    protected static ConditionTableCellRenderer determineTarget(Context context, ExceptionHighlightingRuleInterface ehsRule) {
        ConditionTableCellRenderer target = null;
        for (RuleExtension rule : context.getRules()) {
            if (!rule.getExceptionHighlightingRule().getMeasure().equals(ehsRule.getMeasure())) continue;
            target = rule.getTarget();
            break;
        }
        if (target == null) {
            target = new ConditionTableCellRenderer();
        }
        return target;
    }

    protected static void addImageAction(RuleExtension rpfRule, TargetInterface target) {
        ExceptionHighlightingRuleInterface ehsRule = rpfRule.getExceptionHighlightingRule();
        if (ehsRule.isAddImage()) {
            ImageAction imageAction = new ImageAction();
            imageAction.setImage(ehsRule.getImage());
            if (ehsRule.getImageTextPosition().equals("LEFT")) {
                imageAction.setLocation(ActionLocation.LEFT);
            } else if (ehsRule.getImageTextPosition().equals("RIGHT")) {
                imageAction.setLocation(ActionLocation.RIGHT);
            } else {
                imageAction.setLocation(ActionLocation.REPLACEMENT);
            }
            rpfRule.add(target, imageAction);
        }
    }

    protected static void addTextAction(RuleExtension rpfRule, TargetInterface target) {
        ExceptionHighlightingRuleInterface ehsRule = rpfRule.getExceptionHighlightingRule();
        if (ehsRule.isAddText()) {
            TextAction textAction = new TextAction();
            textAction.setText(ehsRule.getText());
            if (ehsRule.getImageTextPosition().equals("LEFT")) {
                textAction.setLocation(ActionLocation.LEFT);
            } else if (ehsRule.getImageTextPosition().equals("RIGHT")) {
                textAction.setLocation(ActionLocation.RIGHT);
            } else {
                textAction.setLocation(ActionLocation.REPLACEMENT);
            }
            StyleAction style = new StyleAction();
            style.setActionAttribute("COLOR", ehsRule.getTextFontColor());
            if (!ehsRule.getTextFont().equals("DEFAULT")) {
                style.setActionAttribute("FONT-FAMILY", ehsRule.getTextFont());
            }
            if (!ehsRule.getTextFontSize().equals("DEFAULT")) {
                style.setActionAttribute("FONT-SIZE", ehsRule.getTextFontSize());
            }
            if (ehsRule.isTextBold()) {
                style.setActionAttribute("FONT-WEIGHT", "bold");
            } else {
                style.setActionAttribute("FONT-WEIGHT", "normal");
            }
            if (ehsRule.isTextItalic()) {
                style.setActionAttribute("FONT-STYLE", "italic");
            } else {
                style.setActionAttribute("FONT-STYLE", "normal");
            }
            if (ehsRule.isTextUnderline()) {
                style.setActionAttribute("TEXT-DECORATION", "underline");
            } else {
                style.setActionAttribute("TEXT-DECORATION", "none");
            }
            textAction.setStyleInfo(style.getStyleInfo());
            rpfRule.add(target, textAction);
        }
    }

    protected static void attachTargetToViewer(ConditionTableCellRenderer target, AbstractBaseTableView viewer, ExceptionHighlightingRuleInterface ehsRule) {
        if (viewer instanceof TableView) {
            TableView relationalTable = (TableView)viewer;
            Enumeration columns = relationalTable.getColumnModel().getColumns();
            BusinessQueryToTableModelAdapter bqAdapter = null;
            if (relationalTable.getModel() instanceof BusinessQueryToTableModelAdapter) {
                bqAdapter = (BusinessQueryToTableModelAdapter)relationalTable.getModel();
            }
            int count = -1;
            while (columns.hasMoreElements()) {
                TableColumn column = (TableColumn)columns.nextElement();
                ExceptionHighlightingSelectorToRulesContextAdapter.applyCellRendererIfMatches(column, ehsRule, relationalTable, target, bqAdapter, ++count);
            }
        } else if (viewer instanceof OLAPTableView) {
            ExceptionHighlightingOLAPRuleInterface rule = (ExceptionHighlightingOLAPRuleInterface)ehsRule;
            OLAPTableView olapTable = (OLAPTableView)viewer;
            OLAPTableFormatArea area = new OLAPTableFormatArea();
            String[] selectedLevels = rule.getSelectedLevels();
            if (selectedLevels != null) {
                for (int i = 0; i < selectedLevels.length; ++i) {
                    area.setLevel(ExceptionHighlightingSelectorToRulesContextAdapter.getDimensionName(selectedLevels[i]), ExceptionHighlightingSelectorToRulesContextAdapter.getHierarchyName(selectedLevels[i]), ExceptionHighlightingSelectorToRulesContextAdapter.getLevelName(selectedLevels[i]));
                }
            }
            if (rule.isMeasure()) {
                area.setMeasure(rule.getMeasure());
            }
            olapTable.setCellRenderer(area, (TableCellRenderer)target);
        }
    }

    private static boolean applyCellRendererIfMatches(TableColumn column, ExceptionHighlightingRuleInterface ehsRule, TableView relationalTable, ConditionTableCellRenderer target, BusinessQueryToTableModelAdapter bqAdapter, int count) {
        Object uniqueColumnId = ExceptionHighlightingSelectorToRulesContextAdapter.findColumnId(column, ehsRule, relationalTable, target, bqAdapter, count);
        if (uniqueColumnId == null) {
            return false;
        }
        int columnIndex = column.getModelIndex() + 1;
        ExceptionHighlightingSelectorToRulesContextAdapter.applyCellRenderer(uniqueColumnId, columnIndex, relationalTable, target);
        return true;
    }

    public static String findColumnName(TableColumn column, BusinessQueryToTableModelAdapter bqAdapter) {
        if (bqAdapter != null) {
            try {
                return (String)bqAdapter.getColumnInfo(column.getModelIndex() + 1, "NAME");
            }
            catch (TableException e) {
                LoggerRepository2.getLogger((String)ExceptionHighlightingSelectorToRulesContextAdapter.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        } else {
            return (String)column.getIdentifier();
        }
        return null;
    }

    public static Object findColumnId(TableColumn column, ExceptionHighlightingRuleInterface ehsRule, TableView relationalTable, ConditionTableCellRenderer target, BusinessQueryToTableModelAdapter bqAdapter, int count) {
        Object uniqueColumnId = null;
        String colName = ExceptionHighlightingSelectorToRulesContextAdapter.findColumnName(column, bqAdapter);
        if (colName == null) {
            return null;
        }
        if (ehsRule != null && !colName.equals(ehsRule.getMeasure())) {
            return null;
        }
        uniqueColumnId = ExceptionHighlightingSelectorToRulesContextAdapter.uniqueId(column, count, bqAdapter);
        return uniqueColumnId;
    }

    private static Object uniqueId(TableColumn column, int count, BusinessQueryToTableModelAdapter bqAdapter) {
        Object uniqueColumnId = bqAdapter != null ? bqAdapter.getColumnUniqueID(count) : column.getUniqueModelIdentifier();
        return uniqueColumnId;
    }

    public static void applyCellRenderer(Object uniqueColumnId, int columnIndex, TableView relationalTable, ConditionTableCellRenderer target) {
        if (columnIndex != -1) {
            if (uniqueColumnId != null) {
                UniqueIDTableFormatArea area = new UniqueIDTableFormatArea(uniqueColumnId);
                relationalTable.setCellRenderer((TableFormatAreaInterface)area, target);
            } else {
                relationalTable.setCellRenderer(1, -1, 1, columnIndex, columnIndex, 1, target);
            }
        }
    }

    public static void attachTargetsToViewer(Context context, AbstractBaseTableView table) {
        if (context != null && table != null) {
            for (RuleExtension rule : context.getRules()) {
                ExceptionHighlightingSelectorToRulesContextAdapter.attachTargetToViewer(rule.getTarget(), table, rule.getExceptionHighlightingRule());
            }
        }
    }

    public static String getLevelName(String uniqueLevelName) {
        int index1 = uniqueLevelName.indexOf(93, 1);
        String dim = uniqueLevelName.substring(1, index1);
        int index2 = uniqueLevelName.indexOf(93, index1 + 1);
        String hierarchy = uniqueLevelName.substring(index1 + 3, index2);
        int index3 = uniqueLevelName.indexOf(93, index2 + 1);
        String level = null;
        level = index3 < 0 ? hierarchy : uniqueLevelName.substring(index2 + 3, index3);
        return level;
    }

    public static String getHierarchyName(String uniqueLevelName) {
        int index1 = uniqueLevelName.indexOf(93, 1);
        String dim = uniqueLevelName.substring(1, index1);
        int index2 = uniqueLevelName.indexOf(93, index1 + 1);
        String hierarchy = uniqueLevelName.substring(index1 + 3, index2);
        int index3 = uniqueLevelName.indexOf(93, index2 + 1);
        String level = null;
        if (index3 < 0) {
            level = hierarchy;
            hierarchy = null;
        } else {
            level = uniqueLevelName.substring(index2 + 3, index3);
        }
        return hierarchy;
    }

    public static String getDimensionName(String uniqueLevelName) {
        int index1 = uniqueLevelName.indexOf(93, 1);
        String dim = uniqueLevelName.substring(1, index1);
        return dim;
    }
}

