/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.util.relational;

import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.ActionStatusKeysInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.BaseAction;
import com.sas.actionprovider.CommandSupportedInterface;
import com.sas.actionprovider.refresh.PartialRefreshActionsInterface;
import com.sas.actionprovider.support.tableview.TableViewAreaInterface;
import com.sas.actionprovider.util.relational.ColumnAreaInterface;
import com.sas.actionprovider.util.relational.RB;
import com.sas.actionprovider.util.relational.RelationalActionUtil;
import com.sas.actionprovider.util.relational.RelationalDynamicValueKeys;
import com.sas.codepolicy.SASScope;
import com.sas.commands.CompositeDynamicAttributeCommand;
import com.sas.commands.DynamicAttributeCommandInterface;
import com.sas.commands.relational.CommitCommand;
import com.sas.commands.relational.DeleteCommand;
import com.sas.entities.AttributeSetException;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.tableview.BaseTableView;
import com.sas.servlet.tbeans.tableview.HttpEditController;
import com.sas.servlet.tbeans.tableview.TableColumn;
import com.sas.servlet.tbeans.tableview.TableViewActionSupportFilter;
import com.sas.servlet.tbeans.tableview.html.HtmlTableViewUtil;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.table.SortableInterface;
import com.sas.util.SimpleTemplate;
import com.sas.util.log.LoggerRepository2;
import java.util.List;
import java.util.Locale;
import javax.swing.table.TableModel;

@SASScope(value="ALL")
public class HttpRelationalActionUtil
extends RelationalActionUtil
implements TableViewAreaInterface,
RelationalDynamicValueKeys,
ActionStatusKeysInterface {
    static final String RB_KEY = "RelationalDynamicValuesUtil.";
    public static final String EDIT_URL_TEMPLATE = "javascript: void(sas_TableView_PromptForChanges('%formName','%CMDID','%APNAME','%DYNAMICATTRS','%deleteAutoCommit','%deletePromptOnDelete'))";
    public static final String EDIT_URL_TEMPLATE_PPR = "javascript: void(sas_TableView_PromptForChanges('%formName','%CMDID','%APNAME','%DYNAMICATTRS','%deleteAutoCommit','%deletePromptOnDelete','%AJAX_CONTROLLER_URL%QUERYSTRING&CLASS_PARAMETER=com.sas.actionprovider.refresh.PartialRefreshActionHandler&refreshViewerId=%REFRESHVIEWERID&_referringURI=%REFERRINGURI'))";
    public static final String ROW_EDIT_URL_TEMPLATE_FOR_DELETE = "javascript: void(sas_TableView_PromptForChanges('%formName','%CMDID','%APNAME','%DYNAMICATTRS','%autoCommit','%promptOnDelete'))";
    public static final String ROW_EDIT_URL_TEMPLATE_FOR_DELETE_PPR = "javascript: void(sas_TableView_PromptForChanges('%formName','%CMDID','%APNAME','%DYNAMICATTRS','%autoCommit','%promptOnDelete','%AJAX_CONTROLLER_URL%QUERYSTRING&CLASS_PARAMETER=com.sas.actionprovider.refresh.PartialRefreshActionHandler&refreshViewerId=%REFRESHVIEWERID&_referringURI=%REFERRINGURI'))";
    public static final String ROW_EDIT_URL_TEMPLATE = "javascript: void(sas_TableView_PromptForChanges('%formName','%CMDID','%APNAME','%DYNAMICATTRS','%autoCommit','false'))";
    public static final String ROW_EDIT_URL_TEMPLATE_PPR = "javascript: void(sas_TableView_PromptForChanges('%formName','%CMDID','%APNAME','%DYNAMICATTRS','%autoCommit','false','%AJAX_CONTROLLER_URL%QUERYSTRING&CLASS_PARAMETER=com.sas.actionprovider.refresh.PartialRefreshActionHandler&refreshViewerId=%REFRESHVIEWERID&_referringURI=%REFERRINGURI'))";

    public static Object getAreaValue(ActionSupportFilter filter) {
        Object areaValue;
        block6: {
            Object model;
            areaValue = null;
            String areaType = filter.getAreaType();
            if (areaType.equals("COLUMN_HEADER_AREA")) {
                areaValue = filter.getAttribute("columnName");
            } else if (areaType.equals("DATA_CELL_AREA") && (model = filter.getAttribute("model")) != null && model instanceof TableModel) {
                Object cellValue = null;
                int row = ((TableViewActionSupportFilter)filter).getModelRow();
                int column = ((TableViewActionSupportFilter)filter).getModelColumn();
                try {
                    Object o = ((TableModel)model).getValueAt(row, column);
                    if (o != null) {
                        areaValue = o.toString();
                    }
                }
                catch (Exception e) {
                    if (column < 0) break block6;
                    LoggerRepository2.getLogger((String)HttpRelationalActionUtil.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return areaValue;
    }

    public Object getCustomAttributeValue(String attributeName, ActionSupportFilter filter) {
        Object object = filter.getAttribute("model");
        if (object instanceof TableModel) {
            Object o;
            TableModel model = (TableModel)object;
            int row = ((TableViewActionSupportFilter)filter).getModelRow();
            if (filter.getAreaType() == "COLUMN_HEADER_AREA" && row < 0) {
                return attributeName;
            }
            int count = model.getColumnCount();
            int col = -1;
            for (int i = 0; i < count; ++i) {
                if (!attributeName.equalsIgnoreCase(model.getColumnName(i))) continue;
                col = i;
                break;
            }
            if (col >= 0 && (o = model.getValueAt(row, col)) != null) {
                return o.toString();
            }
        }
        return null;
    }

    public Object getColumnHeaderShortDescription(ActionSupportFilter filter) {
        String rb_key = "RelationalStrategy.";
        ComponentPropertyManager cpm = null;
        TransformationInterface tBean = null;
        Locale locale = filter.getLocale();
        if (filter.getViewer() instanceof TransformationInterface) {
            tBean = (TransformationInterface)filter.getViewer();
        }
        if (tBean != null && locale == null) {
            locale = tBean.getLocale();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String shortDescription = com.sas.actionprovider.strategies.relational.RB.getStringResource((String)rb_key, (String)"rightClickForOptions.txt", (Locale)locale);
        if (tBean != null) {
            cpm = ComponentPropertyManager.getInstance(tBean.getRequest());
            if (cpm.getContextMenuLaunchEvent(tBean) != null) {
                if (cpm.getContextMenuLaunchEvent(tBean) != "oncontextmenu") {
                    shortDescription = com.sas.actionprovider.strategies.relational.RB.getStringResource((String)rb_key, (String)"clickForOptions.txt", (Locale)locale);
                }
            } else if (cpm.getContextMenuLaunchEvent() != "oncontextmenu") {
                shortDescription = com.sas.actionprovider.strategies.relational.RB.getStringResource((String)rb_key, (String)"clickForOptions.txt", (Locale)locale);
            }
        }
        return shortDescription;
    }

    @SASScope
    public Object getColumnHeaderSortImageKey(ActionSupportFilter filter) {
        int sortStatus = ((TableViewActionSupportFilter)filter).getSortStatus();
        if (sortStatus == 2) {
            return null;
        }
        String imageKey = null;
        if (sortStatus == 0) {
            imageKey = "SortAscending";
        } else if (sortStatus == 1) {
            imageKey = "SortDescending";
        }
        return imageKey;
    }

    @SASScope
    public static Object getEditURLTemplate(ActionSupportFilter filter) {
        ActionProviderViewInterface viewer = filter.getViewer();
        if (viewer instanceof PartialRefreshActionsInterface && ((PartialRefreshActionsInterface)viewer).isPartialRefreshActionsEnabled()) {
            return HttpRelationalActionUtil.getSimpleTemplate(filter, EDIT_URL_TEMPLATE_PPR);
        }
        return HttpRelationalActionUtil.getSimpleTemplate(filter, EDIT_URL_TEMPLATE);
    }

    @SASScope
    public static Object getRowEditURLTemplateForDelete(ActionSupportFilter filter) {
        ActionProviderViewInterface viewer = filter.getViewer();
        if (viewer instanceof PartialRefreshActionsInterface && ((PartialRefreshActionsInterface)viewer).isPartialRefreshActionsEnabled()) {
            return HttpRelationalActionUtil.getSimpleTemplate(filter, ROW_EDIT_URL_TEMPLATE_FOR_DELETE_PPR);
        }
        return HttpRelationalActionUtil.getSimpleTemplate(filter, ROW_EDIT_URL_TEMPLATE_FOR_DELETE);
    }

    @SASScope
    public static Object getRowEditURLTemplate(ActionSupportFilter filter) {
        ActionProviderViewInterface viewer = filter.getViewer();
        if (viewer instanceof PartialRefreshActionsInterface && ((PartialRefreshActionsInterface)viewer).isPartialRefreshActionsEnabled()) {
            return HttpRelationalActionUtil.getSimpleTemplate(filter, ROW_EDIT_URL_TEMPLATE_PPR);
        }
        return HttpRelationalActionUtil.getSimpleTemplate(filter, ROW_EDIT_URL_TEMPLATE);
    }

    @SASScope
    public static Object getSimpleTemplate(ActionSupportFilter filter, String key) {
        Object template = filter.getAttribute(key);
        if (template != null) {
            return template;
        }
        SimpleTemplate newTemplate = new SimpleTemplate(key);
        try {
            filter.setAttribute(key, (Object)newTemplate);
        }
        catch (AttributeSetException ase) {
            LoggerRepository2.getLogger((String)HttpRelationalActionUtil.class.getPackage().getName(), null).error(ase.getMessage(), (Throwable)ase);
        }
        return newTemplate;
    }

    public Object getSortAscendingImage(ActionSupportFilter filter) {
        return this.getSortImage(filter, 0);
    }

    public Object getSortDescendingImage(ActionSupportFilter filter) {
        return this.getSortImage(filter, 1);
    }

    private Object getSortImage(ActionSupportFilter filter, int direction) {
        if (!filter.getAreaType().equals("COLUMN_HEADER_AREA")) {
            return null;
        }
        int sortStatus = ((TableViewActionSupportFilter)filter).getSortStatus();
        if (sortStatus == 2 || sortStatus != direction) {
            return null;
        }
        String image = null;
        if (sortStatus == 0) {
            image = RB.getStringResource((String)RB_KEY, (String)"sortAscending.image", (Locale)filter.getLocale());
        } else if (sortStatus == 1) {
            image = RB.getStringResource((String)RB_KEY, (String)"sortDescending.image", (Locale)filter.getLocale());
        }
        return image;
    }

    @SASScope
    public Object getSortAscendingImageKey(ActionSupportFilter filter) {
        return this.getSortImageKey(filter, 0);
    }

    @SASScope
    public Object getSortDescendingImageKey(ActionSupportFilter filter) {
        return this.getSortImageKey(filter, 1);
    }

    private Object getSortImageKey(ActionSupportFilter filter, int direction) {
        if (!filter.getAreaType().equals("COLUMN_HEADER_AREA")) {
            return null;
        }
        int sortStatus = ((TableViewActionSupportFilter)filter).getSortStatus();
        if (sortStatus == 2 || sortStatus != direction) {
            return null;
        }
        String imageKey = null;
        if (sortStatus == 0) {
            imageKey = "SortAscending";
        } else if (sortStatus == 1) {
            imageKey = "SortDescending";
        }
        return imageKey;
    }

    public int getViewerDisabledIfEditDisabledOrNotSortable(ActionSupportFilter filter, int currentStatus) {
        if ((Boolean)filter.getAttribute("editEnabled") == Boolean.FALSE || !(((BaseTableView)filter.getViewer()).getModel() instanceof SortableInterface)) {
            currentStatus = 32;
        }
        return currentStatus;
    }

    public int getViewerDisabledIfSingleRowEditEnabled(ActionSupportFilter filter, int currentStatus) {
        HttpEditController editController = ((BaseTableView)filter.getViewer()).getEditController();
        if (editController.isEditEnabled() && editController.isSingleRowEditingEnabled()) {
            currentStatus = 32;
        }
        return currentStatus;
    }

    public int getCommitDeleteStatus(ActionSupportFilter filter, int currentStatus, BaseAction action) {
        DynamicAttributeCommandInterface cmd = action.getCommand();
        HttpEditController editController = ((BaseTableView)filter.getViewer()).getEditController();
        if (!editController.isEditEnabled() || editController.isSingleRowEditingEnabled() || !(cmd instanceof CompositeDynamicAttributeCommand)) {
            return 32;
        }
        boolean eitherSupported = false;
        CompositeDynamicAttributeCommand command = (CompositeDynamicAttributeCommand)cmd;
        List commands = command.getCommands();
        int size = commands.size();
        for (int i = 0; i < size; ++i) {
            Object scmd = commands.get(i);
            if (!(scmd instanceof DeleteCommand) && !(scmd instanceof CommitCommand) || !((CommandSupportedInterface)scmd).isSupported(filter)) continue;
            eitherSupported = true;
            break;
        }
        if (!eitherSupported) {
            return 128;
        }
        return currentStatus;
    }

    public int getSortAscendingActionStatus(ActionSupportFilter filter, int currentStatus) {
        Object model = filter.getAttribute("model");
        if (!(model instanceof SortableInterface)) {
            currentStatus |= 1;
        } else {
            int sortStatus = ((TableViewActionSupportFilter)filter).getSortStatus();
            if (sortStatus == 0) {
                currentStatus |= 8;
            }
        }
        return currentStatus;
    }

    public int getSortDescendingActionStatus(ActionSupportFilter filter, int currentStatus) {
        Object model = filter.getAttribute("model");
        if (!(model instanceof SortableInterface)) {
            currentStatus |= 1;
        } else {
            int sortStatus = ((TableViewActionSupportFilter)filter).getSortStatus();
            if (sortStatus == 2) {
                currentStatus |= 2;
            } else if (sortStatus == 1) {
                currentStatus |= 8;
            }
        }
        return currentStatus;
    }

    public static int validateColumnHeaderArea(TableViewActionSupportFilter filter) {
        if (!filter.getAreaType().equals("COLUMN_HEADER_AREA")) {
            return 64;
        }
        List validValues = filter.getValidAreaValues();
        if (validValues == null || validValues.isEmpty()) {
            return 0;
        }
        return HttpRelationalActionUtil.validateColumn(filter, validValues);
    }

    public static int validateDataCellArea(TableViewActionSupportFilter filter) {
        if (!filter.getAreaType().equals("DATA_CELL_AREA")) {
            return 64;
        }
        List validValues = filter.getValidAreaValues();
        if (validValues == null || validValues.isEmpty()) {
            return 0;
        }
        return HttpRelationalActionUtil.validateColumn(filter, validValues);
    }

    private static int validateColumn(TableViewActionSupportFilter filter, List validValues) {
        int modelColumnNumber = filter.getModelColumn();
        String columnName = HttpRelationalActionUtil.getColumnName(filter, modelColumnNumber);
        String columnIdentifier = null;
        String columnHeaderValue = null;
        int viewerColumnNumber = filter.getColumn();
        BaseTableView table = (BaseTableView)filter.getAttribute("table");
        if (table != null) {
            TableColumn c = table.getColumnModel().getColumn(viewerColumnNumber - 1);
            columnIdentifier = c.getIdentifier().toString();
            columnHeaderValue = c.getHeaderValue();
        }
        if (columnName == null && columnIdentifier == null && columnHeaderValue == null) {
            return 64;
        }
        int num = validValues.size();
        for (int i = 0; i < num; ++i) {
            Object value = validValues.get(i);
            if (!(value instanceof ColumnAreaInterface)) {
                // empty if block
            }
            if (value == null) continue;
            String colId = ((ColumnAreaInterface)value).getColumnId();
            if (colId != null) {
                if (!colId.equals(columnName) && !colId.equals(columnIdentifier) && !colId.equals(columnHeaderValue)) continue;
                return 0;
            }
            int colModelIndex = ((ColumnAreaInterface)value).getModelIndex();
            if (colModelIndex != -999 && colModelIndex == modelColumnNumber) {
                return 0;
            }
            int colViewerIndex = ((ColumnAreaInterface)value).getViewerIndex();
            if (colViewerIndex == -999 || colViewerIndex != viewerColumnNumber) continue;
            return 0;
        }
        return 64;
    }

    private static String getColumnName(TableViewActionSupportFilter filter, int modelColumnNumber) {
        String columnName = null;
        TableModel model = (TableModel)filter.getAttribute("model");
        if (model != null && modelColumnNumber >= 0) {
            columnName = HtmlTableViewUtil.getColumnName((TableModel)model, (int)modelColumnNumber);
        }
        return columnName;
    }
}

