/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.support.olapgraphics;

import com.sas.actionprovider.ActionOrderList;
import com.sas.actionprovider.ActionProviderMapPool;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.Area;
import com.sas.actionprovider.BaseAction;
import com.sas.actionprovider.HttpAction;
import com.sas.actionprovider.support.graphics.GraphValueResolver;
import com.sas.actionprovider.support.graphics.ResizeCommand;
import com.sas.actionprovider.support.olapgraphics.BaseOLAPGraphSupport;
import com.sas.actionprovider.support.olapgraphics.DefaultOlapGraphValueResolver;
import com.sas.codepolicy.SASScope;
import com.sas.commands.DynamicAttributeCommandInterface;
import com.sas.commands.olap.CollapseCommand;
import com.sas.commands.olap.DrillDownCommand;
import com.sas.commands.olap.DrillUpCommand;
import com.sas.commands.olap.ExpandCommand;
import com.sas.commands.olap.SortCommand;
import com.sas.commands.relational.RB;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.storage.olap.embedded.OLAPDataSet;
import com.sas.swing.visuals.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@SASScope(value="ALL")
public class HttpOLAPGraphSupport
extends BaseOLAPGraphSupport {
    static final String RB_KEY = "HttpOLAPGraphSupport.";
    public static final String CATEGORIZATION_VALUE_ACTION = "CATEGORIZATION_VALUE_ACTION";
    public static final String CATEGORIZATION_LABEL_ACTION = "CATEGORIZATION_LABEL_ACTION";
    public static final String ANALYSIS_LABEL_ACTION = "ANALYSIS_LABEL_ACTION";
    public static final String RESIZE_GRAPH_ACTION = "RESIZE_GRAPH_ACTION";
    private GraphValueResolver _valueResolver = new DefaultOlapGraphValueResolver();

    public HttpOLAPGraphSupport(Class actionClass) {
        super(actionClass);
        this.addAreaType("DATA_VALUE_AREA");
    }

    protected BaseAction defineActionAttributes(BaseAction action, String actionType, String areaType) {
        if (action != null) {
            action.setActionType(actionType);
            if (actionType.equals("DRILL_DOWN_ACTION") || actionType.equals("EXPAND_ACTION") || actionType.equals("COLLAPSE_ACTION") || areaType == "ANALYSIS_LABEL_AREA" && (actionType.equals("ASCENDING_SORT_ACTION") || actionType.equals("DESCENDING_SORT_ACTION"))) {
                try {
                    action.setAttribute("model", null);
                    AttributeDescriptorInterface descriptor = action.getAttributeDescriptor("model");
                    descriptor.setType(BaseAction.getAttributeTypeFactory().createAttributeType(null, 2000, "com.sas.storage.olap.OLAPDataSetInterface"));
                    descriptor.setVisible(false);
                    action.setAttribute("tupleElementIndex", null);
                    descriptor = action.getAttributeDescriptor("tupleElementIndex");
                    descriptor.setVisible(true);
                    action.setAttribute("tupleElement", null);
                    descriptor = action.getAttributeDescriptor("tupleElement");
                    descriptor.setType(BaseAction.getAttributeTypeFactory().createAttributeType(null, 2000, "com.sas.storage.olap.TupleElementInterface"));
                    descriptor.setVisible(false);
                    action.setAttribute("dataItem", null);
                    descriptor = action.getAttributeDescriptor("dataItem");
                    descriptor.setVisible(false);
                    action.setAttribute("tupleIndex", null);
                    descriptor = action.getAttributeDescriptor("tupleIndex");
                    descriptor.setVisible(true);
                    action.setAttribute("axisIndex", null);
                    descriptor = action.getAttributeDescriptor("axisIndex");
                    descriptor.setVisible(true);
                }
                catch (Exception descriptor) {}
            } else if (actionType.equals("DRILL_UP_ACTION") || actionType.equals("ASCENDING_SORT_ACTION") || actionType.equals("DESCENDING_SORT_ACTION")) {
                try {
                    action.setAttribute("model", null);
                    AttributeDescriptorInterface descriptor = action.getAttributeDescriptor("model");
                    descriptor.setType(BaseAction.getAttributeTypeFactory().createAttributeType(null, 2000, "com.sas.storage.olap.OLAPDataSetInterface"));
                    descriptor.setVisible(false);
                    action.setAttribute("uniqueLevelName", null);
                    descriptor = action.getAttributeDescriptor("uniqueLevelName");
                    descriptor.setVisible(true);
                    action.setAttribute("dataItem", null);
                    descriptor = action.getAttributeDescriptor("dataItem");
                    descriptor.setVisible(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return action;
    }

    public BaseAction newActionInstance(String actionType) {
        return this.newActionInstance(null, actionType);
    }

    public BaseAction newActionInstance(String areaType, String actionType) {
        HttpAction action = null;
        Class _actionClass = this.getActionClass();
        if (this.debug) {
            System.out.println("Class for " + actionType + " is " + _actionClass.getName());
        }
        if (_actionClass != null) {
            try {
                action = (HttpAction)((Object)_actionClass.newInstance());
            }
            catch (InstantiationException ie) {
                return null;
            }
            catch (IllegalAccessException ie) {
                return null;
            }
            if (this.debug) {
                System.out.println("instantiated the action");
            }
            if (actionType == "DRILL_DOWN_ACTION") {
                String name = com.sas.actionprovider.support.olaptableview.RB.getStringResource((String)"BaseOLAPTableViewSupport.", (String)"drillDown.txt", (Locale)this.getLocale());
                action.setCommand((DynamicAttributeCommandInterface)new DrillDownCommand(name, false));
                action.putValue("ImageKey", "Drill_Down_Default");
                action.putValue("RolloverImageKey", "Drill_Down_Rollover");
                action.putValue("ShortDescription", name);
                action.putValue("AlternateText", com.sas.actionprovider.support.olaptableview.RB.getStringResource((String)"BaseOLAPTableViewSupport.", (String)"drillDownMember.txt", (Locale)this.getLocale()));
            } else if (actionType == "DRILL_UP_ACTION") {
                String name = com.sas.actionprovider.support.olaptableview.RB.getStringResource((String)"BaseOLAPTableViewSupport.", (String)"upToLabel.txt", (Locale)this.getLocale());
                action.setCommand((DynamicAttributeCommandInterface)new DrillUpCommand(com.sas.actionprovider.support.olaptableview.RB.getStringResource((String)"BaseOLAPTableViewSupport.", (String)"drillUp.txt", (Locale)this.getLocale()), false));
                action.putValue("Name", name);
            } else if (actionType == "EXPAND_ACTION") {
                String name = com.sas.actionprovider.support.olaptableview.RB.getStringResource((String)"BaseOLAPTableViewSupport.", (String)"expand.txt", (Locale)this.getLocale());
                action.setCommand((DynamicAttributeCommandInterface)new ExpandCommand(name, false));
                action.putValue("ShortDescription", name);
                action.getAttributeDescriptor("ShortDescription").setSupplementalProperty("DYNAMIC", (Object)Boolean.FALSE);
                action.putValue("AlternateText", com.sas.actionprovider.support.olaptableview.RB.getStringResource((String)"BaseOLAPTableViewSupport.", (String)"expandMember.txt", (Locale)this.getLocale()));
            } else if (actionType == "COLLAPSE_ACTION") {
                String name = com.sas.actionprovider.support.olaptableview.RB.getStringResource((String)"BaseOLAPTableViewSupport.", (String)"collapse.txt", (Locale)this.getLocale());
                action.setCommand((DynamicAttributeCommandInterface)new CollapseCommand(name, false));
                action.putValue("ShortDescription", name);
                action.getAttributeDescriptor("ShortDescription").setSupplementalProperty("DYNAMIC", (Object)Boolean.FALSE);
                action.putValue("AlternateText", com.sas.actionprovider.support.olaptableview.RB.getStringResource((String)"BaseOLAPTableViewSupport.", (String)"collapseMember.txt", (Locale)this.getLocale()));
            } else if (actionType == CATEGORIZATION_VALUE_ACTION) {
                String name = com.sas.actionprovider.support.olaptableview.RB.getStringResource((String)"BaseOLAPTableViewSupport.", (String)"clickForOptions.txt", (Locale)this.getLocale());
                action.putValue("Name", "%areaValue");
                action.putValue("ShortDescription", name);
                action.setLink(false);
            } else if (actionType == CATEGORIZATION_LABEL_ACTION) {
                action.putValue("Name", "%areaValue");
                action.putValue("ShortDescription", com.sas.actionprovider.support.olaptableview.RB.getStringResource((String)"BaseOLAPTableViewSupport.", (String)"clickForOptions.txt", (Locale)this.getLocale()));
                action.setLink(false);
            } else if (actionType == ANALYSIS_LABEL_ACTION) {
                action.putValue("Name", "%areaValue");
                action.putValue("ShortDescription", com.sas.actionprovider.support.olaptableview.RB.getStringResource((String)"BaseOLAPTableViewSupport.", (String)"clickForOptions.txt", (Locale)this.getLocale()));
                action.setLink(false);
            } else if (actionType == "ASCENDING_SORT_ACTION") {
                String name = com.sas.actionprovider.support.olaptableview.RB.getStringResource((String)"BaseOLAPTableViewSupport.", (String)"sortAscending.txt", (Locale)this.getLocale());
                SortCommand sortCommand = new SortCommand(name, true);
                sortCommand.setSortType(2);
                if (areaType == "ANALYSIS_LABEL_AREA") {
                    sortCommand.setSortCategory(100);
                } else {
                    sortCommand.setSortCategory(200);
                }
                action.setReturnStatus(56);
                action.setCommand((DynamicAttributeCommandInterface)sortCommand);
                action.putValue("Name", name);
                if (areaType == "ANALYSIS_LABEL_AREA") {
                    action.putValue("ShortDescription", com.sas.actionprovider.support.graphics.RB.getStringResource("HttpGraphSupport.", "sortAscendingBy.txt", this.getLocale()));
                } else {
                    action.putValue("ShortDescription", Util.getLabelWithoutMnemonic((String)RB.getStringResource((String)"SortCommand.", (String)"sortAscending.txt", (Locale)this.getLocale())));
                }
            } else if (actionType == "DESCENDING_SORT_ACTION") {
                String name = com.sas.actionprovider.support.olaptableview.RB.getStringResource((String)"BaseOLAPTableViewSupport.", (String)"sortDescending.txt", (Locale)this.getLocale());
                SortCommand sortCommand = new SortCommand(name, true);
                sortCommand.setSortType(3);
                if (areaType == "ANALYSIS_LABEL_AREA") {
                    sortCommand.setSortCategory(100);
                } else {
                    sortCommand.setSortCategory(200);
                }
                action.setReturnStatus(56);
                action.setCommand((DynamicAttributeCommandInterface)sortCommand);
                action.putValue("Name", name);
                if (areaType == "ANALYSIS_LABEL_AREA") {
                    action.putValue("ShortDescription", com.sas.actionprovider.support.graphics.RB.getStringResource("HttpGraphSupport.", "sortDescendingBy.txt", this.getLocale()));
                } else {
                    action.putValue("ShortDescription", Util.getLabelWithoutMnemonic((String)RB.getStringResource((String)"SortCommand.", (String)"sortDescending.txt", (Locale)this.getLocale())));
                }
            } else if (actionType == RESIZE_GRAPH_ACTION) {
                ResizeCommand resizeCommand = new ResizeCommand();
                action.setCommand((DynamicAttributeCommandInterface)resizeCommand);
                action.putValue("resizedColumns", null);
                action.getAttributeDescriptor("resizedColumns").setVisible(false);
            } else {
                return null;
            }
            action.setActionType(actionType);
            action.putValue("TextAlignment", "SwingConstants.RIGHT");
            this.defineActionAttributes(action, actionType, areaType);
        }
        return action;
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        HttpAction categorizationLabelAction = (HttpAction)this.newActionInstance("CATEGORIZATION_LABEL_AREA", CATEGORIZATION_LABEL_ACTION);
        HttpAction categorizationValueAction = (HttpAction)this.newActionInstance("CATEGORIZATION_VALUE_AREA", CATEGORIZATION_VALUE_ACTION);
        HttpAction analysisLabelAction = (HttpAction)this.newActionInstance("ANALYSIS_LABEL_AREA", ANALYSIS_LABEL_ACTION);
        ActionOrderList categorizationValueOrderList = new ActionOrderList("ROOT_NAME", 1);
        categorizationValueOrderList.setActionType(CATEGORIZATION_VALUE_ACTION);
        categorizationValueOrderList.add((Object)"EXPAND_ACTION");
        categorizationValueOrderList.add((Object)"COLLAPSE_ACTION");
        categorizationValueOrderList.add((Object)"DRILL_DOWN_ACTION");
        this.setActionOrderList(categorizationValueOrderList, null, "CATEGORIZATION_VALUE_AREA");
        ActionOrderList categorizationLabelOrderList = new ActionOrderList("ROOT_NAME", 3);
        categorizationLabelOrderList.setActionType(CATEGORIZATION_LABEL_ACTION);
        categorizationLabelOrderList.add((Object)"DRILL_UP_ACTION");
        categorizationLabelOrderList.add((Object)"ASCENDING_SORT_ACTION");
        categorizationLabelOrderList.add((Object)"DESCENDING_SORT_ACTION");
        this.setActionOrderList(categorizationLabelOrderList, null, "CATEGORIZATION_LABEL_AREA");
        ActionOrderList analysisLabelOrderList = new ActionOrderList("ROOT_NAME", 3);
        analysisLabelOrderList.setActionType(ANALYSIS_LABEL_ACTION);
        analysisLabelOrderList.add((Object)"ASCENDING_SORT_ACTION");
        analysisLabelOrderList.add((Object)"DESCENDING_SORT_ACTION");
        this.setActionOrderList(analysisLabelOrderList, null, "ANALYSIS_LABEL_AREA");
        HttpAction valueDrillDownAction = (HttpAction)this.newActionInstance("CATEGORIZATION_VALUE_AREA", "DRILL_DOWN_ACTION");
        HttpAction valueExpandAction = (HttpAction)this.newActionInstance("CATEGORIZATION_VALUE_AREA", "EXPAND_ACTION");
        HttpAction valueCollapseAction = (HttpAction)this.newActionInstance("CATEGORIZATION_VALUE_AREA", "COLLAPSE_ACTION");
        this.addDefaultAction(categorizationValueAction, "CATEGORIZATION_VALUE_AREA");
        this.addDefaultAction(valueExpandAction, "CATEGORIZATION_VALUE_AREA");
        this.addDefaultAction(valueCollapseAction, "CATEGORIZATION_VALUE_AREA");
        this.addDefaultAction(valueDrillDownAction, "CATEGORIZATION_VALUE_AREA");
        HttpAction labelDrillUpAction = (HttpAction)this.newActionInstance("CATEGORIZATION_LABEL_AREA", "DRILL_UP_ACTION");
        HttpAction labelSortAscendingAction = (HttpAction)this.newActionInstance("CATEGORIZATION_LABEL_AREA", "ASCENDING_SORT_ACTION");
        HttpAction labelSortDescendingAction = (HttpAction)this.newActionInstance("CATEGORIZATION_LABEL_AREA", "DESCENDING_SORT_ACTION");
        this.addDefaultAction(categorizationLabelAction, "CATEGORIZATION_LABEL_AREA");
        this.addDefaultAction(labelDrillUpAction, "CATEGORIZATION_LABEL_AREA");
        this.addDefaultAction(labelSortAscendingAction, "CATEGORIZATION_LABEL_AREA");
        this.addDefaultAction(labelSortDescendingAction, "CATEGORIZATION_LABEL_AREA");
        HttpAction analysisLabelSortAscendingAction = (HttpAction)this.newActionInstance("ANALYSIS_LABEL_AREA", "ASCENDING_SORT_ACTION");
        HttpAction analysisLabelSortDescendingAction = (HttpAction)this.newActionInstance("ANALYSIS_LABEL_AREA", "DESCENDING_SORT_ACTION");
        this.addDefaultAction(analysisLabelAction, "ANALYSIS_LABEL_AREA");
        this.addDefaultAction(analysisLabelSortAscendingAction, "ANALYSIS_LABEL_AREA");
        this.addDefaultAction(analysisLabelSortDescendingAction, "ANALYSIS_LABEL_AREA");
        HttpAction resizeAction = (HttpAction)this.newActionInstance("DATA_VALUE_AREA", RESIZE_GRAPH_ACTION);
        this.addDefaultAction(resizeAction, "DATA_VALUE_AREA");
    }

    protected Map getAreaScopeAttributeMap(ActionSupportFilter filter) {
        HashMap<String, Object> areaScopeAttributeMap;
        block6: {
            areaScopeAttributeMap = new HashMap<String, Object>();
            String areaType = filter.getAreaType();
            if (areaType.equals("CATEGORIZATION_VALUE_AREA") || areaType.equals("CATEGORIZATION_LABEL_AREA") || areaType.equals("ANALYSIS_LABEL_AREA")) {
                try {
                    areaScopeAttributeMap.put("model", filter.getAttribute("model"));
                    areaScopeAttributeMap.put("dataItem", filter.getAttribute("dataItem"));
                    String uniqueLvlName = (String)filter.getAttribute("uniqueLevelName");
                    if (uniqueLvlName == null) {
                        TupleElementInterface tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement");
                        areaScopeAttributeMap.put("areaValue", tupleElement.getLabel());
                        int tupleElementIndex = tupleElement.getTupleElementIndex();
                        areaScopeAttributeMap.put("tupleElementIndex", String.valueOf(tupleElementIndex));
                        TupleInterface tuple = tupleElement.getTuple();
                        areaScopeAttributeMap.put("tupleElement", tupleElement);
                        int tupleIndex = tuple.getTupleIndex();
                        areaScopeAttributeMap.put("tupleIndex", String.valueOf(tupleIndex));
                        AxisInterface axis = tuple.getAxis();
                        int axisIndex = axis.getAxisNumber();
                        areaScopeAttributeMap.put("axisIndex", String.valueOf(axisIndex));
                        break block6;
                    }
                    areaScopeAttributeMap.put("uniqueLevelName", filter.getAttribute("uniqueLevelName"));
                    areaScopeAttributeMap.put("areaValue", filter.getAttribute("areaValue"));
                }
                catch (OLAPException oLAPException) {}
            } else if (areaType.equals("DATA_VALUE_AREA")) {
                areaScopeAttributeMap.put("resizedColumns", filter.getAttribute("resizedColumns"));
            }
        }
        return areaScopeAttributeMap;
    }

    protected Map getActionScopeAttributeMap(String actionType, ActionSupportFilter filter) {
        TupleElementInterface tupleElement;
        HashMap actionScopeAttributeMap = ActionProviderMapPool.getMap();
        if (actionType == "DRILL_UP_ACTION") {
            String uniqueLvlName = (String)filter.getAttribute("uniqueLevelName");
            if (uniqueLvlName != null) {
                OLAPDataSetInterface model = (OLAPDataSetInterface)filter.getAttribute("model");
                String upLevel = null;
                List labels = HttpOLAPGraphSupport.getAncestorAxisHeaders(uniqueLvlName, model);
                int levelDepth = HttpOLAPGraphSupport.getLevelDepth(uniqueLvlName, model) - 1;
                if (labels != null) {
                    if (labels.size() > levelDepth && levelDepth >= 0) {
                        upLevel = (String)labels.get(levelDepth);
                    } else if (labels.size() > 0) {
                        upLevel = (String)labels.get(0);
                    }
                }
                actionScopeAttributeMap.put("drillUpLevel", upLevel);
            }
        } else if ((actionType.equals("DRILL_DOWN_ACTION") || actionType.equals("EXPAND_ACTION") || actionType.equals("COLLAPSE_ACTION")) && (tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement")) != null) {
            try {
                actionScopeAttributeMap.put("tupleLabel", tupleElement.getLabel());
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return actionScopeAttributeMap;
    }

    protected int getActionStatus(BaseAction action, ActionSupportFilter filter) {
        int status = super.getActionStatus(action, filter);
        String areaType = filter.getAreaType();
        return status;
    }

    protected boolean isConverted() {
        return true;
    }

    protected BaseAction setActionAttributes(BaseAction action, ActionSupportFilter actionFilter) {
        return action;
    }

    protected boolean validArea(Area area, ActionSupportFilter filter) {
        return true;
    }

    private static int getLevelDepth(String uniqueLvlName, OLAPDataSetInterface model) {
        int depth = -1;
        if (uniqueLvlName != null && model != null) {
            try {
                String[] lvls;
                AxisInterface axis = HttpOLAPGraphSupport.getLevelAxis(model, uniqueLvlName);
                if (axis != null && (lvls = axis.getUniqueLevelNames()) != null) {
                    for (int i = 0; i < lvls.length; ++i) {
                        if (!lvls[i].equals(uniqueLvlName)) continue;
                        return i;
                    }
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return depth;
    }

    private static List getAncestorAxisHeaders(String uniqueLvlName, OLAPDataSetInterface model) {
        ArrayList<String> ancestorLabels = new ArrayList<String>();
        if (model != null && uniqueLvlName != null && !(model instanceof OLAPDataSet)) {
            try {
                MetadataInterface metadata = model.getDatabaseMetadata();
                String cubeName = model.getCubeName();
                if (cubeName != null && metadata != null) {
                    BusinessQuery bq;
                    if (model instanceof BusinessQueryProviderInterface && ((bq = ((BusinessQueryProviderInterface)model).getBusinessQuery()) == null || bq.getInputStructure().isRelational())) {
                        return ancestorLabels;
                    }
                    Filter filter = new Filter();
                    filter.setCubeName(cubeName);
                    filter.setUniqueLevelName(uniqueLvlName);
                    LevelInterface[] levels = metadata.getLevels(filter);
                    LevelInterface[] dimLevels = levels[0].getHierarchy().getLevels();
                    int depth = -1;
                    for (int i = 0; i < dimLevels.length; ++i) {
                        if (!dimLevels[i].getUniqueName().equals(levels[0].getUniqueName())) continue;
                        depth = i;
                    }
                    if (depth > 0 && depth < dimLevels.length) {
                        ancestorLabels.add(dimLevels[depth - 1].getLabel());
                    }
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return ancestorLabels;
    }

    private static AxisInterface getLevelAxis(OLAPDataSetInterface model, String uniqueLevelName) {
        try {
            int levelIndex = -1;
            if (uniqueLevelName != null) {
                ResultSetMetadataInterface rsm = model.getResultSetMetadata();
                AxisInterface[] axes = rsm.getAxes(0, -1);
                for (int i = 0; i < axes.length; ++i) {
                    String[] uniqueLevelNames = axes[i].getUniqueLevelNames();
                    for (int j = 0; j < uniqueLevelNames.length; ++j) {
                        if (!uniqueLevelName.equals(uniqueLevelNames[j])) continue;
                        levelIndex = j;
                        break;
                    }
                    if (levelIndex < 0) continue;
                    return axes[i];
                }
            }
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return null;
    }

    protected Map initializeShortActionTypeMap() {
        Map shortActionTypeMap = super.initializeShortActionTypeMap();
        shortActionTypeMap.put(ANALYSIS_LABEL_ACTION, "_AL");
        shortActionTypeMap.put(CATEGORIZATION_LABEL_ACTION, "_CL");
        shortActionTypeMap.put(CATEGORIZATION_VALUE_ACTION, "_CV");
        shortActionTypeMap.put("ASCENDING_SORT_ACTION", "_AS");
        shortActionTypeMap.put("DESCENDING_SORT_ACTION", "_DS");
        shortActionTypeMap.put("DRILL_DOWN_ACTION", "_DD");
        shortActionTypeMap.put("DRILL_UP_ACTION", "_DU");
        shortActionTypeMap.put("EXPAND_ACTION", "_EXP");
        shortActionTypeMap.put("COLLAPSE_ACTION", "_COL");
        return shortActionTypeMap;
    }

    protected Object getCustomAttributeValue(String attributeName, ActionSupportFilter filter) {
        Object object = filter.getAttribute("model");
        Object valueAt = null;
        if (object instanceof OLAPDataSetInterface) {
            String columnName = attributeName;
            valueAt = this._valueResolver.getValueAt(filter.getAttribute("imagemapinfo"), (Integer)filter.getAttribute("row"), columnName);
        }
        return valueAt;
    }
}

